;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: class-ext -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: some CL-like extensions for classes
-----------------------------------------------------------------------------------
File:    class-ext.em
Version: 1.6 (last modification on Mon Sep  6 07:09:06 1993)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/EulispModules/class-ext.em[1.6]:
  
[1.1] Wed Mar 10 13:11:07 1993 imohr@isst proposed
  [Mon Mar  8 14:33:51 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Tue Apr 13 17:07:39 1993 imohr@isst saved
  [Tue Apr 13 17:03:09 1993] Intention for change:
  + define-singleton-apply-class
  ok
[1.3] Tue Apr 13 17:17:58 1993 imohr@isst saved
  [Tue Apr 13 17:16:28 1993] Intention for change:
  remove init options in define-singleton-apply-class
  ok
[1.4] Wed Apr 14 16:33:05 1993 wheick@isst saved
  [Tue Apr 13 18:45:44 1993] Intention for change:
  import mapcar
  imports from cl: mapcar make-instance
[1.5] Wed Apr 14 17:04:40 1993 imohr@isst proposed
  + syntax import of apply-standard
[1.6] Mon Sep  6 07:09:23 1993 ukriegel@isst published
  [Mon Sep  6 06:59:34 1993] Intention for change:
  subclassp for cmucl
  subclassp for cmu defined

-----------------------------------------------------------------------------------
|#

#module-name class-ext
#module-import
((only (subtypep mapcar make-instance) common-lisp)
 (only (make-eulisp-class-id) apply-standard)
 level-1-eulisp)
#module-syntax-import 
(level-1-eulisp apply-standard)
#module-syntax-definitions

#module-header-end

(export subclassp define-singleton-apply-class)
(expose (only (defstandardclass make-eulisp-class-id make-eulisp-class-id) 
          apply-standard))

(defun subclassp (class1 class2)
  #-:cmu(subtypep class1 class2)
  #+:cmu (member class1(pcl::class-precedence-list class2)))

;;; -----------------------------------------------------------------------------------
#| Examples for defstandardclass
;;; -----------------------------------------------------------------------------------

(defstandardclass <foo> ()
  bar
  (baz :reader :initform 123)
  (foobar :reader :standard-options)
  (foobarbaz :initarg :accessor)
  :predicate)

(defstandardclass <bar> ()
  :default-slot-options (:reader :initarg)
  :slots
  foo
  (bar :accessor :standard-options))

|#

(defmacro define-singleton-apply-class (identifier supers . initial-values)
  (let ((class-id (make-eulisp-class-id identifier)))
    `(progn
       (defstandardclass ,class-id ,(mapcar #'make-eulisp-class-id supers))
       (defconstant ,identifier (make-instance ,class-id ,@initial-values))
       (export ,identifier ,class-id))))

#module-end



