/*
$__copyrigth
--------------------------------------------------------------------------------TITLE: xalloc user include file
--------------------------------------------------------------------------------File:    xalloc_user.h
Version: 1.11 (last modification on Mon Jan 31 16:02:32 1994)
State:   published


DESCRIPTION:
macros and prototypes of functions around xalloc / garbage collection

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
j.bimberg

CONTACT: 
j.bimberg
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/ApplyC/xalloc_user.h[1.11]:
  
[1.1] Fri Jul 16 13:28:06 1993 ukriegel@isst proposed
  [Thu Jul 15 11:56:33 1993] Intention for change:
  ansi
  done
[1.2] Mon Aug 23 08:51:09 1993 ukriegel@isst proposed
  [Mon Aug 23 08:49:49 1993] Intention for change:
  add xalloc_info
  done
[1.3] Thu Aug 26 14:32:18 1993 ukriegel@isst published
  [Thu Aug 26 14:30:40 1993] Intention for change:
[1.4] Fri Oct 15 16:37:24 1993 imohr@isst published
  [Fri Oct 15 16:35:48 1993] Intention for change:
  pointer to functions returning void -> returning void*
  to be compatible with predefined type %function of TAIL
[1.5] Fri Nov  5 14:28:16 1993 jbimberg@isst proposed
  [Fri Nov  5 14:27:20 1993] Intention for change:
  Prototyp mark_all_roots.
[1.6] Fri Nov 12 12:12:02 1993 jbimberg@isst proposed
  [Fri Nov 12 11:57:38 1993] Intention for change:
  enter allocate-stack-primitives
  added
[1.7] Mon Nov 15 08:42:12 1993 jbimberg@isst proposed
  [Mon Nov 15 08:39:22 1993] Intention for change:
  change prototypes for stack-allocation
  done
[1.8] Mon Nov 15 14:43:41 1993 jbimberg@isst proposed
  [Mon Nov 15 14:41:25 1993] Intention for change:
  change argument type of allocate-stack
  done, include setjmp.h !!
[1.9] Wed Dec  1 13:00:09 1993 jbimberg@isst saved
  [Wed Dec  1 11:18:47 1993] Intention for change:
  insert new thread-fctn's
  done
[1.10] Wed Dec  1 13:35:37 1993 jbimberg@isst proposed
  [Wed Dec  1 13:35:08 1993] Intention for change:
  fix a minor bug
[1.11] Mon Feb  7 09:45:41 1994 jbimberg@isst published
  [Mon Jan 31 11:52:03 1994] Intention for change:
  insert header, remove thread stuff
  done 

--------------------------------------------------------------------------------
*/
#ifndef xalloc_user_h
#define xalloc_user_h
#ifndef KRC
#define parameter1(a) (a)
#define parameter2(a, b) (a, b)
#define parameter3(a, b, c) (a, b, c)
#define parameter4(a, b, c, d) (a, b, c, d)
#else
#define parameter1(a) ()
#define parameter2(a, b) ()
#define parameter3(a, b, c) ()
#define parameter4(a, b, c, d) ()
#endif


typedef unsigned long int CardDscr;
typedef unsigned long int TypeDscr;

TypeDscr describe_type 
parameter2(
	unsigned long usertype, 
	void* (*mark_fcn)());

TypeDscr set_type_descriptor           /*1 <= td < lowest_type_descriptor*/
parameter3(
	TypeDscr td,			
	unsigned long usertype,
	void* (*mark_fcn)());

int set_lowest_type_descriptor        /*  1 <= lowest_type_descriptor */
parameter1(
	TypeDscr lowest_type_descriptor );


CardDscr describe_card
parameter3(
	char cardtype, 
	long size, 
	TypeDscr t_dscr );

CardDscr set_card_descriptor           /* 0 <= cd < lowest_card_descriptor */
parameter4(
	CardDscr cd,			
	char cardtype, 
	long size, 
	TypeDscr t_dscr);



int set_lowest_card_descriptor          /*	0 <= lowest_card_descriptor */
parameter1(CardDscr lowest_card_descriptor	);


TypeDscr get_type_descriptor
parameter1(long *ptr); 


unsigned long type_from_descriptor
parameter1(TypeDscr td );


unsigned long	get_type    /* previous two funcions at once */
parameter1(long *ptr );


unsigned long	safe_get_type   /*	returns NO_CONSISTENT_POINTER if so */
parameter1(long *ptr );



#define	NO_CONSISTENT_POINTER	0xffffffff



/* possible values for cardtype */
#define MTSS 	1
#define STMS 	2
#define STSS 	4

char get_card_type
parameter1(CardDscr cd); 

long get_object_size
parameter1(void *ptr);


void *xalloc_stss 
parameter1(CardDscr cd );

void *xalloc_mtss 
parameter2(CardDscr cd,	TypeDscr td );

void *xalloc_stms
parameter2(CardDscr cd, long size );

void *xalloc
parameter2(CardDscr cd, long possible_second_value );					

void trace_pointer
parameter1(long *ptr );

void force_garbage_collection();

long inc_heap_size
parameter1(int nb_of_cards );


void initialize_root_set();

void add_to_root_set
parameter1(void *pointer);

void delete_from_root_set
parameter1(void *pointer );


/* predefined mark_functions */

void trace_all /* trace from all locations inside the object */
parameter2(register long **ptr, register long length);	

void trace_nothing /* trace from nowhere inside this object */
parameter2(register long **ptr, register long length);	

void trace_first  /* assuming the first 4 byte to be a pointer */
parameter2(register long **ptr, register long length);	

void trace_second /* assuming the second 4 byte to be a pointer */
parameter2(register long **ptr, register long length);	

void trace_pair /* assuming the first 8 byte to be 2 pointers */
parameter2(register long **ptr, register long length);	


/* information about gc configuration */
void xalloc_info();

/* the following macro is required to be called in main() to tell the
   garbage collector about the highest possible stack address
*/
void set_stacktop
parameter1(void **p);

#define INITIALIZE_GC	{void *p; set_stacktop(&p);}


#undef parameter1
#undef parameter2
#undef parameter3
#undef parameter4
#endif /* ! xalloc_user_h */

