/*
$__copyrigth
--------------------------------------------------------------------------------TITLE: garbage collector
--------------------------------------------------------------------------------File:    trace.c
Version: 1.22 (last modification on Wed Feb  9 08:55:17 1994)
State:   proposed


DESCRIPTION:
xalloc functions concerning gc, rootset 

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
j.bimberg

CONTACT: 
j.bimberg
e.u.kriegel
HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/ApplyC/trace.c[1.22]:
  
[1.1] Wed Jun  9 12:06:43 1993 ukriegel@isst saved
  special treatment of sparc 10 stacl end
[1.2] Wed Jun  9 12:16:12 1993 ukriegel@isst saved
  
[1.3] Wed Jun  9 16:47:22 1993 ukriegel@isst saved
  sun_stacktop
[1.4] Mon Jun 21 11:41:58 1993 ukriegel@isst saved
  gc_count
[1.5] Mon Jun 21 11:45:13 1993 ukriegel@isst proposed
  
[1.6] Thu Jul 15 14:19:29 1993 ukriegel@isst saved
  last k&r version
[1.7] Fri Jul 16 09:19:27 1993 ukriegel@isst proposed
  ansiu compatible
[1.8] Mon Aug 23 08:48:43 1993 ukriegel@isst published
  [Mon Aug 23 08:28:14 1993] Intention for change:
  include info
  xalloc_info() added
[1.9] Wed Oct 13 13:27:04 1993 jbimberg@isst proposed
  [Wed Oct 13 12:55:46 1993] Intention for change:
  changing "sun_stacktop" to "stacktop"
  
[1.10] Thu Oct 14 09:16:37 1993 jbimberg@isst published
  [Thu Oct 14 09:07:40 1993] Intention for change:
  --- no intent expressed ---
  changed an int to long
  
[1.11] Fri Nov  5 14:30:29 1993 jbimberg@isst proposed
  [Fri Nov  5 14:29:36 1993] Intention for change:
  changes to make marking from thread-stacks possible
  
  made changes to enable multi-thread execution
[1.12] Fri Nov 12 12:11:54 1993 jbimberg@isst proposed
  [Fri Nov 12 10:39:43 1993] Intention for change:
  add thread-stacks
  added
[1.13] Mon Nov 15 08:42:04 1993 jbimberg@isst proposed
  [Mon Nov 15 08:13:56 1993] Intention for change:
  move alloc-stack-stuff from card.c to trace.c
  done
[1.14] Mon Nov 15 14:44:16 1993 jbimberg@isst proposed
  [Mon Nov 15 13:37:19 1993] Intention for change:
  fix a bug in mark-thread-stacks
  no bug, but trace gets jmpbuf now instead of sp-adress
[1.15] Mon Nov 15 15:30:40 1993 jbimberg@isst proposed
  [Mon Nov 15 15:28:43 1993] Intention for change:
  switch type in allocate-stack
  done
[1.16] Fri Nov 19 11:37:13 1993 ukriegel@isst proposed
  [Fri Nov 19 09:44:16 1993] Intention for change:
  xalloc_info in new file
  done
[1.17] Mon Nov 22 11:45:37 1993 jbimberg@isst saved
  [Mon Nov 22 11:40:28 1993] Intention for change:
  add hold-threads and cont-threads in force-gc
  done
[1.18] Wed Dec  1 12:56:54 1993 jbimberg@isst proposed
  [Mon Nov 22 14:07:05 1993] Intention for change:
  disabling alloc during collect
  done, furthermore we added stuff to sweep only on current-thread's cards
[1.19] Wed Dec  8 15:00:38 1993 jbimberg@isst proposed
  [Wed Dec  8 14:55:01 1993] Intention for change:
  fix a bug in sweeping large cards
  done
[1.20] Thu Jan  6 13:11:27 1994 jbimberg@isst saved
  [Thu Jan  6 13:10:21 1994] Intention for change:
  enabling alignment forcing for MTSS-cards
  done
[1.21] Mon Feb  7 09:43:14 1994 jbimberg@isst published
  [Mon Jan 31 12:25:47 1994] Intention for change:
  insert header, remove thread concerning stuff
  done, also create a xalloc_arch.h to contain all the architecture depent stuff
[1.22] Wed Feb  9 08:56:51 1994 jbimberg@isst proposed
  [Wed Feb  9 08:35:33 1994] Intention for change:
  changes required by Symantec C++
  done 

--------------------------------------------------------------------------------
*/
#include <stdio.h>
#include "xalloc_conf.h"
#include "xalloc_misc.h"
#include "xalloc_arch.h"

/*****************************************************************************/
/** some definitions only used by the collector -- instead of a header file **/
/*****************************************************************************/

#define	MS_MARK	0x80000000	/* is set in length word of MS-obj. to mark */

#define ms_ismarked(p)	(*(p) & MS_MARK)
#define ms_mark(p)	(*(p) |= MS_MARK)
#define ms_unmark(p)	(*(p) &= ~MS_MARK)

#define	stack_not_empty		(stkpointer != stktop)

static long	*stkpointer, *endofstack;

#ifdef	STACK_ON_HEAP
#define	STKSIZE		CARDSIZE

#if defined DOS386 || defined __NT__
/* brk is not available, therefor there's no chance to return a sbrk'ed chunk
   of memory to the system (in __NT__ there's not even a sbrk). therefor we 
   'allocate' the markstack statically with no chance to expand it. */
static long stktop[4096];	/* enough for 4096 pointers at once */

#define	init_gc_stack()		{stkpointer = stktop;}
#define	remove_gc_stack()
#define	inc_gc_stack(e)		{error("inc_gc_stack failed");}
#define	gcpop(p)		(long *)*(--p)
#define	gcpush(v,p,e)	{ if(p == e) inc_gc_stack(e);	\
				*p++ = (long)(v);}
#else
static long *stktop;

#define	init_gc_stack()		{stkpointer = stktop = (long *) sbrk(STKSIZE); \
					endofstack = (long *) sbrk(0);}
#define	remove_gc_stack()	brk(stktop)
				/* we must not be interrupted during mark !! */
#define	inc_gc_stack(e)		{sbrk(STKSIZE); e = (long *) sbrk(0);}
#define	gcpop(p)		(long *)*(--p)
#define	gcpush(v,p,e)	{ if(p == e) inc_gc_stack(e);	\
				*p++ = (long)(v);}
#endif
#else		/* stack on machine stack */
static long *stktop;

#define	init_gc_stack()		{int i; stktop = (long *)((long)&i - STACKGAP);\
					stkpointer = stktop;}
#define	remove_gc_stack()
#define gcpop(p)		(long *)*(++p)
#define	gcpush(v,p,e)	{*p-- = (long)(v);}

#endif		/* STACK_ON_HEAP */

#define	itrace(v,p,e)	if(p_in_heap(v)) gcpush(v,p,e)

#define	mark_card(c)		(c)->root = NULL
#define card_marked(c)		((c)->root == NULL)

/*****************************************************************************/
/*******************************  rootset  ***********************************/
/*****************************************************************************/
#ifdef ROOT_SET_IN_USE

long	ROOTSET[MAX_ROOT_SET_ENTRIES];
long	*ROOTSETEND = ROOTSET;

void
initialize_root_set()
{
	ROOTSETEND = ROOTSET;
}

void
add_to_root_set(p)
	void	*p;
{
#ifdef SECURITY_FIRST
	if(ROOTSETEND >= &ROOTSET[MAX_ROOT_SET_ENTRIES])
		error("Unable to insert root address");
	else
#endif
		*ROOTSETEND++ = (long)p;
}

void
delete_from_root_set(p)
	void	*p;
{
	long	*l;
	for(l = ROOTSET; ((l<ROOTSETEND) && (*l!=(long)p)); l++);
	if(l<ROOTSETEND)
		*l = *(--ROOTSETEND);
}
#else

extern	end, etext;	/* all locations of static data */

#endif

/*****************************************************************************/
/********************************  trace  ************************************/
/*****************************************************************************/

void trace_pointer(ptr)	/* to be called from user defined mark functions */
register long *ptr;
{ 
	itrace(ptr, stkpointer, endofstack);
}

/************************ predefined mark functions **************************/

void trace_all(ptr, length)
register long	**ptr;
register long	length;
{
	while(length > 0){
		length -= PTR_ALIGN;
		itrace((long *)*((long *)((long)ptr + length)),
			stkpointer,endofstack);
	}
}

void trace_nothing(ptr, length)
register long	**ptr;
register long	length;
{
	/* nothing to do */
}

void trace_first(ptr, length)
register long	**ptr;
register long	length;
{
	itrace(ptr[0],stkpointer,endofstack);
}

void trace_second(ptr, length)
register long	**ptr;
register long	length;
{
	itrace(ptr[1],stkpointer,endofstack);
}

void trace_pair(ptr, length)
register long	**ptr;
register long	length;
{
	itrace(ptr[0],stkpointer,endofstack);
	itrace(ptr[1],stkpointer,endofstack);
}


void trace_from_gc_stack();
void mark_all_roots();

#ifdef NB_REGS
long reg_safe[NB_REGS];	/* the space to put the register contents to */
#endif

#if defined DOS386 || defined __NT__
/* Symantec C++ allows no more than one asm statement per line, so we can't
   define the following as a macro in xalloc_arch.h */
static void save_registers()
{
	asm mov reg_safe,      eax
	asm mov reg_safe + 4,  ebx
	asm mov reg_safe + 8,  ecx
	asm mov reg_safe + 12, edx
	asm mov reg_safe + 16, esi
	asm mov reg_safe + 20, edi
}
#endif

static long * stacktop = NULL; /* 0xf0000000; /* tmp for SPARC 10 */

void set_stacktop(void **p){
	if (stacktop == NULL)
		stacktop = (long *)p;
}

void
marking()		/* first phase of our mark/sweep - collector */
{
	register long *p;
	register card *c;
	long i;

	SAVE_REGS();	/* look at xalloc_arch.h for definition */

#ifdef NOTHREADS		/* single-thread-version */
#ifdef STACK_GROWS_DOWN
		mark_all_roots(&i, stacktop);
#else
#ifdef STACK_GROWS_UP
		mark_all_roots(stacktop, &i);
#else
	--> where else does the stack grow ??
#endif
#endif
#else				/* multi-thread-version */
		m_thread_mark(mark_all_roots, stacktop);
#endif	

	/* trace from root set or from all globals resp. data pages */
#ifdef	ROOT_SET_IN_USE
	{
	  register long *rsp = stkpointer;
	  register long *reos = endofstack;
	  for(p = ROOTSET; p < ROOTSETEND; p++){
		register long *g = (long *)*p;
#ifdef SECURITY_FIRST
		if(!is_pointer(g)) 	/* did the user add something wrong
					 * to the root set ?
					 */
			error("mark: wrong root in root set");
#endif
		itrace((long *)*g,rsp,reos);

	  }
#ifdef NB_REGS		/* possibly some additional roots on register-safe */
		mark_all_roots(reg_safe, reg_safe + NB_REGS);
#endif
	  stkpointer = rsp;
	  endofstack = reos;
	}
	trace_from_gc_stack();
#else	/* ! ROOT_SET_IN_USE */
#ifdef DATASTART
	mark_all_roots(DATASTART, gcarraybegin);
	mark_all_roots(gcarrayend, (long *)&end);
	/* reg-safe is scanned through, too */
#else
	--> use ROOTSET or tell us where your data starts
#endif
#endif

	/* Now all locations reachable via registers, the stack or global
	 * variables are marked. We can return.
	 */
}


void mark_all_roots(from, to)
register long * from, * to;
{
	register long *rsp = stkpointer;
	register long *reos = endofstack;
	register long *p;

	/* We are trying to be a little faster when using two registers 
	 * for the stackpointer and the (possible) end of stack area.
	 */
	for(p = from; p < to; p = (long *)((char *)p + PTR_ALIGN))
		itrace((long *)*p,rsp,reos);

	stkpointer = rsp;
	endofstack = reos;
	trace_from_gc_stack();
}


void trace_from_gc_stack()
{
	register long * p;
	register card * c;
	/* trace from the just built gc_stack. unfortunately, we can't use
	 * registers to hold our markstackpointer, because it will be changed
	 * by called trace_functions, too */
	while(stack_not_empty){
		p = gcpop(stkpointer);
		c = CARD_ADDR(p);
		if(living_card(c)){	/* B/W - test */
#ifdef	USE_MTSS
		    if(mt_card(c)){
			long *ap = p - MT_ALIGN_WORDS;
			if(consistent_pointer(c,ap,get_size(c),get_mask(c)))
			  if(is_tdscr(*(p-1)))
			    if(!ismarked(c,ap)){
				    mark(c,ap);
				    (get_mark_fcn(*(p-1))(p, get_real_size(c)));
				}
		    	continue;
		    }
#endif
#ifdef	USE_STMS
		    if(ms_card(c)){
			if(consistent_ms_pointer(c,p))
			  if(!ms_ismarked(p-1)){
			    ms_mark(p-1);
			    (get_mark_fcn(get_tdscr(c)))(p,get_ms_real_size(p));
			  }
		        continue;
		    }
#endif
#ifdef	USE_STSS
		    if(consistent_pointer(c,p,get_size(c),get_mask(c)))
			if(!ismarked(c,p)){
			    mark(c,p);
			    (get_mark_fcn(get_tdscr(c)))(p, get_real_size(c));
		    	}
#endif
		}
	}
}

/*****************************************************************************/
/********************************  sweep  ************************************/
/*****************************************************************************/

/* remove mark bits for objects in free lists of card-descriptor cd */
void
clear_fsl_marks(cd)
	register CardDscr cd;
{
	register long *p;
	register card *c;
	p = (long *)get_freept_addr(cd);
	while(p = (long *) *p){
		c = CARD_ADDR(p);
		if(ismarked(c,p))
			unmark(c,p);
	}
}

long
ss_sweep(c, cd)
	register card  *c;
	register CardDscr cd;
{
	register long  step, used, *fsl;
	register long  *pt = c->mkarea;
	register long  *en = pt + NB_OF_MARK_WORDS;

	/* At first test, whether this card is empty. This works very fast by
	 * checking 32 bits at ones.
	 */
	for(; (pt < en) && (*pt == 0); pt++);
	if(pt == en)	return(0);

	/* There are some marked objects on this card, build a list of the 
	 * other ones
	 */
	step = get_size_d(cd);
	fsl = get_free_object(cd);
	used = 0;
	pt = (long *)c + byte2word(CARDSIZE) - step;
	en = c->userspace;

	while(pt >= en){
		if(ismarked(c,pt)){	/* skip all marked objects */
			pt -= step;
			used += step;
		} else {		/* connect the others */
			*pt = (long)fsl;
			fsl = pt;

#ifdef	OPTIMIZED_POINTER_TESTS
	/* we migth have increased the size of the objects, so the (possibly
	 * unused but traced) end of these objects must be set to zero */
			if(step == 4)
				pt[3] = 0;
			else 
				if(step == 8){ 
					pt[5] = 0;
					pt[6] = 0;
					pt[7] = 0;
				}
#endif

			pt -= step;
		}
	}	
	/* write internal fsl to free list */
	store_free_object(cd,fsl);
	clear_marks(c);
	return(word2byte(used));
}


#ifdef USE_STMS
long
ms_sweep(c,cd)	/* assumes c to be pointer to ms_card, sweeps card and builds a
		 * free list on it, storing its space to the free list of its
		 * card_dscr. if an unmarked large object is found on the card,
		 * and some small objects stay there, the 'continued' cards
		 * will be reclaimed explicitely, because clean_card_list is
		 * unable to do this job.
		 * function returns number of bytes still in use.
		 */
register card		*c;
register CardDscr	cd;
{
	register int		new = 1;
	register vobject	*ifsl = (vobject *)get_free_object(cd);
	register long		*ptr = c->userspace;
	register long		*e = (long *)(c + 1);
	register long		used = 0;

	while(ptr < e){
	    if(ismarked(c,ptr)){	/* begin of object */
		if(ms_ismarked(ptr)){	/* surviver */
		    ms_unmark(ptr);	/* reset mark bit */
		    new = 1;   		/* free space will start after this */
		    used += *ptr;	/* still in use */
		    ptr += *ptr;	/* behind this object */
		} else {		/* no pointer to this obj, reclaim it */
		    unmark(c,ptr);	/* no longer begin of obj */
#ifdef USE_LARGE
		    if(*ptr>USERSPACE){	/* large object found */
			/* as this is the last object on that card, we can
			 * test, whether we found any surviver before this
			 * and break otherwise
			 */
			if(used == 0) break;
			/* the card stays used, we must reclaim the tail of now
			 * unused 'continued' cards and decrement c->cardnum
			 */
			reclaim_card(e, get_cardnum(c) - 1);
			put_cardnum(c,1);
			/* the part of this object which is on the first card
			 * will become a part of the free list as below
			 */
			if(new){
			    ((vobject *)ptr)->vlength = e - ptr; /* length */
			    ((vobject *)ptr)->vnext = ifsl;
			    ifsl = (vobject *)ptr;	/* into free list */
			    ptr = e;			/* behind card */
			} else {		/* concat. with before space */
			    ifsl->vlength += (e - ptr);	/* increase before */
			    ptr = e;			/* behind card */
			}
		    } else
#endif 
		    {
			if(new){		/* start of space */
			    ((vobject *)ptr)->vlength = *ptr; /* length */
			    ((vobject *)ptr)->vnext = ifsl;
			    ifsl = (vobject *)ptr;	/* into free list */
			    ptr += ((vobject *)ptr)->vlength;/* behind this */
			    new = 0;
			} else {		/* connect with before space */
			    ifsl->vlength += *ptr; /* increase before space */
			    ptr += *ptr;	   /* behind this object */
			}
		    }
		}
	    } else {			/* found part of former free list */
		if(new){		/* start of space */
		    ((vobject *)ptr)->vnext = ifsl;
		    ifsl = (vobject *)ptr;
		    ptr += ((vobject *)ptr)->vlength;	/* behind this object */
		    new = 0;
		} else {		/* concat. with before space */
		    ifsl->vlength += ((vobject *)ptr)->vlength; /* inc before */
		    ptr += ((vobject *)ptr)->vlength;	/* behind this object */
		}
	    }
	}
	if(used > 0)		/* some bytes on that card are still in use */
		store_free_object(cd,(long *)ifsl);
	return(word2byte(used));
}
#endif

/************** remove marked cards, close holes in cardlist *****************/
void
clean_card_list()
{
	register card **ci = first_card_index;

	while(ci < last_card_index){
	    if(card_marked(*ci)){
#ifdef	USE_LARGE
		reclaim_card(*ci,get_cardnum(*ci)); /* call to heap.c */
#else
		reclaim_card(*ci);
#endif
		prev_card_index(last_card_index);
		while((ci < last_card_index) &&(card_marked(*last_card_index))){
#ifdef	USE_LARGE
		   reclaim_card(*last_card_index,get_cardnum(*last_card_index));
#else
		   reclaim_card(*last_card_index);
#endif
		   prev_card_index(last_card_index);
		}
		if(ci < last_card_index){
			*ci = *last_card_index;
			(*ci)->root = ci;
		}
	    }
	    next_card_index(ci);
	}
}


/*****************************************************************************/
/***************************  garbage collection  ****************************/
/*****************************************************************************/
static gc_count;

void
garbage_collection()
{
	register card	**ci, *c;
	register CardDscr	cd;
	register long used;
	register long bytes_in_use = 0;
	register int i;


        ++gc_count;
#ifdef GCREPORTS
	fprintf(stderr, "GC %D:",gc_count);
	fflush(stderr);
#endif

	init_gc_stack();
	marking();
	remove_gc_stack();

			/* inspect all cdscr's to sweep all cards,
			 * mark empty cards for later being removed */
	for(cd = 0; cd < last_used_card; cd++){
		ci = &Cards[cd];
#ifdef	USE_STMS
		if(ms_card_d(cd)){
			store_free_object(cd, NULL);/* clear free list of cd */
			while(c = *ci){			/* c becomes *last */
				if(used = ms_sweep(c,cd)){	/* not empty */
					bytes_in_use += used;
					ci = &(c->next);
				} else {		/* empty */
					*ci = c->next;	/* off_crd_lst*/
					mark_card(c);
				}
			}
		} else 
#endif
		{	/* ss_card */
#ifdef	USE_LARGE
		    if(basiccards(get_size_d(cd)) == 1){
#endif
			/* clear mark bits for objects in free list because
			 * if any object in the free list has been marked by
			 * default, all objects behind this in free list
			 * will have been marked, too
			 */
			clear_fsl_marks(cd);	
			store_free_object(cd, NULL);
			while(c = *ci){
				if(used = ss_sweep(c,cd)){	/* not empty */
					bytes_in_use += used;
					ci = &(c->next);
				} else {		/* empty */
					*ci = c->next;	/* off_crd_lst*/
					mark_card(c);
				}
			}
#ifdef	USE_LARGE
		    } else {	/* large cards in use on this carddscr. */
			while(c = *ci){
				if(ismarked(c,c->userspace)){ /* surviver */
					unmark(c,c->userspace);
					bytes_in_use += get_real_size(c);
					ci = &(c->next);
				} else {
					*ci = c->next;	/* off_card_lst */
					mark_card(c);
				}
			} /* end while */
		    } /* end if basiccards(...)==1 */
#endif
		} /* end if ms_card ... else ss_card */
	} /* end for each carddescriptor */

	clean_card_list();	/* may be inlined */

#ifdef  GCREPORTS
	fprintf(stderr, " %i of %i bytes reclaimed\n",
			CARDSIZE*curnumcard-bytes_in_use, CARDSIZE*curnumcard);
#endif
	if((GCDIFF * bytes_in_use) > (GCMULT * CARDSIZE * curnumcard))
		/* to few of our storage has been reclaimed, try to get more */
		inc_heap();
}

void force_garbage_collection()
{
	DISABLE_SCHEDULE();
	garbage_collection();
	ENABLE_SCHEDULE();
}


void xalloc_info()
{ /* print configuration and runtime info */
  fprintf(stderr,"\nNumber of Garbage Collections: %d",gc_count);
  fprintf(stderr,"\nInitial number of Cards %d",start_nb_of_cards);
  fprintf(stderr,"\nNumber of used Cards %d",curnumcard);
  fprintf(stderr,"\nLast heap increment %d",hincr);
  fprintf(stderr,"\nGCMULT %d GCDIFF %d HMULT %d HDIFF %d",GCMULT,GCDIFF,HMULT,HDIFF);
#ifdef ROOT_SET_IN_USE
  fprintf(stderr,"\nUserdefined root set was used");
#else
  fprintf(stderr,"\nAnonymous root set was used");
#endif
#ifdef STACK_ON_HEAP
  fprintf(stderr,"\nMarking stack was allocated on heap");
#else
  fprintf(stderr,"\nMarking stack was allocated on stack");
#endif
  fprintf(stderr,"\n");fflush(stderr);

}












