/*
$__copyrigth
--------------------------------------------------------------------------------TITLE: simple timer support
--------------------------------------------------------------------------------File:    timing.c
Version: 1.6 (last modification on Wed Feb  9 09:22:13 1994)
State:   proposed


DESCRIPTION:
	start_timer locally saves the current time 
	timer prints the used time since start_timer using a format string
	of the form "used time: %.2f user + %.2f system = %.2f full\n"
	since there are no different timers on ms-dos, the elapsed time
	is given as user time and the system time is given as 0.0
	furthermore timer calls xalloc_info to print garbage collector
	statistics

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
j.bimberg

CONTACT: 
j.bimberg
e.u.kriegel
HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/ApplyC/timing.c[1.6]:
  
[1.1] Thu Jun 24 13:18:56 1993 ukriegel@isst saved
  
[1.2] Fri Jul 16 08:47:50 1993 ukriegel@isst proposed
  ansi and K & R ok
[1.3] Mon Aug 23 09:27:40 1993 ukriegel@isst published
  [Mon Aug 23 09:26:06 1993] Intention for change:
  fflush
  done
[1.4] Thu Sep 16 12:55:33 1993 ukriegel@isst published
  [Thu Sep 16 11:43:43 1993] Intention for change:
[1.5] Wed Jan 12 14:31:54 1994 ukriegel@isst published
  [Thu Dec  9 09:27:22 1993] Intention for change:
  timer with xalloc_info
[1.6] Wed Feb  9 09:22:49 1994 jbimberg@isst proposed
  [Wed Feb  9 08:59:13 1994] Intention for change:
  dos386 support
  done 

--------------------------------------------------------------------------------
*/

#ifdef __unix__
#include <sys/types.h>
#include <sys/times.h>
#include <stdio.h>

#define	HZ	60.0

static struct tms tb;
static clock_t startutime, startstime;

void start_timer()
{
	(void)times(&tb);
	startutime = tb.tms_utime;
	startstime = tb.tms_stime;
}

void timer(char *string)
{
	(void)times(&tb);
	printf(string 
              ,((tb.tms_utime - startutime)/HZ)
              ,((tb.tms_stime - startstime)/HZ)
	      ,(tb.tms_utime - startutime 
              + tb.tms_stime - startstime)/HZ);
        xalloc_info();
	fflush(stdout);	/* what for ??? */
}

#else

#ifdef DOS386
#include <time.h>

static clock_t starttime;

void start_timer(){
	starttime = clock();
}

void timer(char * string){
	double usedtime = difftime(clock(), starttime)/(double)CLOCKS_PER_SEC;
	printf(string, usedtime, 0.0, usedtime);
}

#endif
#endif



