/*
$__copyrigth
--------------------------------------------------------------------------------TITLE: interface thread -- mm-system and thread -- Lisp
--------------------------------------------------------------------------------File:    thread.h
Version: 1.0 (last modification on Mon Feb  7 09:35:55 1994)
State:   published


DESCRIPTION:
   This file is included by both the memory management (if compiled for threads)
   and the eu2c generated c file (if it contains thread primitives)

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
j.bimberg

CONTACT: 
j.bimberg
HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/ApplyC/thread.h[1.0]:
  header file for threads to be included by mm and user programs 

--------------------------------------------------------------------------------
*/

#ifndef thread_h
#define thread_h

#ifndef NOTHREADS

#define PREEMPTIVE	/* preemptive scheduling */

typedef void * m_thread;

extern int thread_schedule;

#ifdef PREEMPTIVE
/* if preemptive scheduling is allowed, xalloc may be interrupted and 
   then multiple allocs of the same memory location are possible. Thus
   a mechanism to avoid this is necessary. the most simple thing is 
   setting and resetting a variable, which in turn is checked by the 
   scheduler. 
*/
#define ENABLE_SCHEDULE()	thread_schedule = 1
#define DISABLE_SCHEDULE()	thread_schedule = 0
#else
#define ENABLE_SCHEDULE()
#define DISABLE_SCHEDULE()
#endif

m_thread m_thread_init();

m_thread m_thread_create(m_thread (*fun)(), void * args);

void m_thread_yield(m_thread dest);

void m_thread_mark(void (*mark_range)(void *, void *), void * mainstack);

#else

#define ENABLE_SCHEDULE()
#define DISABLE_SCHEDULE()

#endif
#endif
