/*
$__copyrigth
--------------------------------------------------------------------------------TITLE: heap initialization
--------------------------------------------------------------------------------File:    heap-init.c
Version: 1.3 (last modification on Wed Feb  9 08:41:34 1994)
State:   proposed


DESCRIPTION:
contains only the heap initialization function to be recompiled with
 -DSTART_NUM_OF_CARDS=nnn if necessary

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel
j.bimberg
HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/ApplyC/heap-init.c[1.3]:
  done
[1.1] Fri Nov 19 13:00:13 1993 ukriegel@isst proposed
  [Fri Nov 19 12:59:44 1993] Intention for change:
[1.2] Mon Feb  7 09:42:49 1994 jbimberg@isst published
  [Mon Jan 31 15:12:40 1994] Intention for change:
  replace brk with sbrk
  done, added header
[1.3] Wed Feb  9 08:56:29 1994 jbimberg@isst proposed
  [Wed Feb  9 08:35:06 1994] Intention for change:
  changes required by Symantec C++
  done 

--------------------------------------------------------------------------------
*/
#ifndef __NT__	/* there's a special heap-nt.c for this arch/os */

#include <stdio.h>
#include "xalloc_conf.h"
#include "xalloc_misc.h"

extern long *FCL;	/* free card list , used only here and in heap.c */

extern void * sbrk(int);

void
initialize_heap()		/* get first part of heap */
{
	void * current_break;
	curnumcard = 0;
	hincr = START_NUM_OF_CARDS;
        start_nb_of_cards = START_NUM_OF_CARDS;
	/* ensure that heap starts above 64 K boundary.
	   unfortunately, brk() is not available on some arch's */
	if ((current_break = sbrk(0)) < (void *)MINHEAPBEGIN)
		sbrk(MINHEAPBEGIN - (int)current_break);
	inc_heap();		/* expanded to inc_heap_size(hincr) */
	HEAPBEGIN = FCL;	/* set HEAPBEGIN to the address of the first
				 * Card in the free card list */
}

#endif
