;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: WHC-DEFINITIONS -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: module for the definition of tail data types
-----------------------------------------------------------------------------------
File:    whc-definitions.em
Version: 1.35 (last modification on Fri Feb  4 12:12:24 1994)
State:   published

DESCRIPTION:
the definition functions for tail data types

DOCUMENTATION:
see in the APPLY-paper TAIL:eine getypte implementationssprache fuer APPLY

NOTES:
the new types %pointer-to-struct, %pointer-to-vector, ???
are are not contained

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking, e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/whc-definitions.em[1.35]:
  
[1.1] Tue Mar 23 10:54:22 1993 wheick@isst saved
  new for ingos initialize
[1.2] Tue Mar 23 12:48:38 1993 wheick@isst saved
  
[1.3] Tue Mar 23 13:16:39 1993 wheick@isst saved
  
[1.4] Mon Mar 29 17:19:11 1993 wheick@isst saved
  
[1.5] Thu Apr  1 08:14:19 1993 wheick@isst saved
  
[1.6] Fri Apr  2 13:35:28 1993 wheick@isst proposed
  
[1.7] Mon Apr  5 08:32:36 1993 wheick@isst proposed
  with new mm-type
[1.8] Mon Apr  5 11:23:20 1993 wheick@isst proposed
  
[1.9] Mon Apr  5 11:28:10 1993 wheick@isst proposed
  + import of warn from CL
[1.10] Wed Apr  7 15:34:52 1993 wheick@isst saved
  add method for generate-intern-name from whc-gen-code
[1.11] Thu Apr  8 10:36:09 1993 wheick@isst saved
  
[1.12] Tue Apr 13 16:38:37 1993 wheick@isst saved
  [Thu Apr  8 15:18:09 1993] Intention for change:
   remove all wrong characters for label
[1.13] Tue Apr 13 16:46:06 1993 imohr@isst proposed
  [Tue Apr 13 16:41:24 1993] Intention for change:
  error in compute-representation
  removed
[1.14] Mon Apr 19 12:58:17 1993 wheick@isst proposed
  new function function-direct for representation direct
[1.15] Tue Apr 20 14:23:33 1993 wheick@isst saved
  error in type-direct removed
[1.16] Tue Apr 20 14:45:29 1993 wheick@isst saved
  
[1.17] Tue Apr 20 16:09:16 1993 wheick@isst proposed
  
[1.18] Wed Apr 28 09:09:14 1993 wheick@isst saved
  new intern labels
[1.19] Thu Apr 29 09:08:16 1993 wheick@isst saved
  new methods for generate-intern-name
[1.20] Fri Apr 30 16:00:50 1993 wheick@isst saved
  
[1.21] Tue May  4 09:21:55 1993 wheick@isst proposed
  
[1.22] Wed May  5 13:45:08 1993 wheick@isst proposed
  
[1.23] Wed May 12 16:34:52 1993 wheick@isst published
  
[1.24] Tue Oct 12 13:05:56 1993 ukriegel@isst saved
  [Mon Oct 11 10:43:14 1993] Intention for change:
  .length* for <pointer-to-vector>
  cleaned
[1.25] Tue Oct 12 15:36:13 1993 ukriegel@isst published
  [Tue Oct 12 13:19:11 1993] Intention for change:
  typing error
[1.26] Fri Nov  5 14:48:45 1993 ukriegel@isst proposed
  comment method compute-byte-length* (len (rep <pointer-to-vector>)
[1.27] Mon Nov  8 11:56:00 1993 ukriegel@isst proposed
  [Mon Nov  8 11:32:53 1993] Intention for change:
  new machine description, ~vector-class-instance-lengt ~vector-class-instance-length-literal
[1.28] Mon Nov 22 15:25:49 1993 ukriegel@isst saved
  [Mon Nov 22 05:56:14 1993] Intention for change:
  ?byte-length
  ?byte-length replaced by ?byte-length-of-instance. from mod. representation
[1.29] Tue Nov 23 12:58:20 1993 ukriegel@isst saved
  [Tue Nov 23 06:14:15 1993] Intention for change:
  byte-length
[1.30] Wed Nov 24 11:08:04 1993 ukriegel@isst proposed
  [Wed Nov 24 09:07:42 1993] Intention for change:
  clean up
[1.31] Tue Jan  4 11:20:04 1994 ukriegel@isst saved
  [Mon Jan  3 13:16:25 1994] Intention for change:
  size-of-instance
  class size and alignment
[1.32] Thu Jan  6 12:10:05 1994 ukriegel@isst proposed
  
[1.33] Thu Feb  3 08:36:03 1994 ukriegel@isst saved
  [Wed Feb  2 17:39:07 1994] Intention for change:
  remove mm-initialize and fill representation with raw values
  done
[1.34] Fri Feb  4 11:47:54 1994 ukriegel@isst saved
  [Fri Feb  4 11:20:27 1994] Intention for change:
  ~compute-representation
  copyies representation if none is given
[1.35] Fri Feb  4 12:12:39 1994 ukriegel@isst published
  [Fri Feb  4 11:51:51 1994] Intention for change:
  --- no intent expressed ---improved construction of representation

-----------------------------------------------------------------------------------
|#
;;;begin module whc-definitions

#module whc-definitions


(import
( representation
 accessors
 level-1-eulisp
 lzs
 mzs
 mm-initialize
 lzs-mop
 machine-description; for the whole machine-description
 debugging

 (only (
        assoc
        case
        cadr
        cerror
        mapcan
        dolist
        make-instance
        dotimes
        ;elt
        reverse
        setf
        ;typecase
        ;gentemp
        ;mapcan
        warn
        format
                ) common-lisp)
)

syntax

(level-1-eulisp apply-standard debugging)


export 

 (
  %pointer
  %pointer-to-struct
  %pointer-to-vector
  ))




;;;%define-type like TAIL
;;;similar to the basic data types a new class for each data type is
;;;created. The one and only instance of this class is holded in
;;;the table table-of-class-instances


;(defgeneric ?byte-length (obj))





(defmethod ?byte-length-as-component ((pobj <class-def>))
  (if (?representation pobj)
    (?byte-length-as-component1 (?representation pobj))
    (progn 
      (cl:error "error ~a von <class-def> hat keine representation" pobj)
      4)))

(defmethod ?byte-length-as-component ((pobj <%representation>))
  (?byte-length-as-component1 pobj))

(defmethod ?byte-length-as-component ((pobj t))
  ;(print 'actually-byte-length-t)
  ;(print pobj)
  (if (expand-literal pobj)
    (if (?class (expand-literal pobj))
      (?byte-length-as-component (?class (expand-literal pobj)))
      4)
    4))

(defgeneric ?byte-length-as-component1 (pobj))

(defmethod ?byte-length-as-component1 ((pobj <%pointer>))
  ;(print 'actually-byte-length1)(print pobj)
  (?byte-length (?representation %signed-word-integer))
  )

(defmethod ?byte-length-as-component1 ((pobj t))
  ;(print 'actually-byte-length1)(print pobj)
  (?byte-length pobj)
  )

 
(defmethod ?byte-length-of-instance ((obj <%representation>))
  (?byte-length obj))
(defmethod ?byte-length-of-instance (obj)
  (cl:error "?byte-length-of representation called for a
non-representation-object ~s" obj))


;-------------------------------------------------------------
;!!!!!
;
(defmethod ~compute-representation ((class-object <class-def>)
                                    representation-spec
                                    allocation-spec
                                    mm-type)
;  ; representation-spec (symbol) = %pointer-to-struct | %pointer-to-void ...
;  ; if representation-spec is () then take the value from the superclass
  (let (representation-object)
    (setq representation-object 
          (if representation-spec
            (funcall (case representation-spec
                       (es::pointer-to-struct #'make-pointer-to-struct) 
                       (es::pointer-to-vector #'make-pointer-to-vector)
                       (es::pointer-to-void #'make-pointer-to-void) 
                       (es::direct #'make-direct) 
                       (t (lambda ignore 
                            (warn "unknown representation: ~S " representation-spec))))
                     class-object )
            (copy-representation 
             (~class-representation (cadr (~class-precedence-list
                                           class-object))) class-object )))
    ;;the following step is necessary in order to solve a cycle with
    ;;class initialization and creation of constructors
    ;;set raw data in representation slots
    ;;~compute-runtime-initialization will  retrieve that values
    ;;and call mm-initialize
    (setf (?mm-type representation-object) mm-type)
    (setf (?allocation representation-object) allocation-spec)
    representation-object))


(defgeneric copy-representation (representation class ))

(defmethod copy-representation 
           ((representation <%pointer-to-struct>) class)
  (make-pointer-to-struct class ))

(defmethod copy-representation 
           ((representation <%pointer-to-vector>) class)
  (make-pointer-to-vector class ))


(defmethod copy-representation 
           ((representation <%pointer-to-void>) class)
  (make-pointer-to-void class ))

(defmethod copy-representation 
           ((representation <%direct>) class)
  (make-direct class ))

(defun make-pointer-to-struct (class-obj)
  (let* ((slot-descr-list (~class-slot-descriptions class-obj))
        (first-type (?type (car slot-descr-list)))
        (byte-length 0)
        (maximum-alignment 0)
        (nb-of-slots 0)
        slot-and-type-names
        offsets)
; *UK* 03.01.94
    (dolist (slot-descr slot-descr-list)
      (when (> (?alignment (?representation (?type slot-descr)))
               maximum-alignment)
        (setq maximum-alignment (?alignment (?representation (?type
                                                              slot-descr)))))
      (setq nb-of-slots (+ 1 nb-of-slots)))
     (setq byte-length (* nb-of-slots maximum-alignment)); *UK* 03.01.94

    (make-instance
      <%pointer-to-struct>
      :byte-length byte-length
      :alignment maximum-alignment; *UK* 03.01.94
     ) 
    ))



(defun make-pointer-to-void (class-obj) 
;      ------------ 
  (make-instance
            <%pointer-to-void>
    )
  )

(defun make-direct (class-obj) 
;      ------------
  (let ((type (?type (car (~class-slot-descriptions class-obj))))) 
    (make-instance
      <%direct>
      :alignment (?alignment (?representation %unsigned-word-integer))
      :type type
      :byte-length (?byte-length (?representation type))
      )
    ))


(defun make-pointer-to-vector (class-obj)
  (let* ((type (~vector-class-element-type class-obj))
         (length-slot (~vector-class-instance-length class-obj))
         (length  (if length-slot
                    length-slot
		    0)))
    (make-instance
      <%pointer-to-vector>
      :alignment (?alignment (?representation %signed-word-integer))
      :byte-length (compute-byte-length* length (?representation type))
      :type type
      :length-of-vector length
      )))


(defgeneric compute-byte-length* (length representation))


(defmethod compute-byte-length* (length (representation <%pointer>))
  (* length (?byte-length (?representation %unsigned-word-integer))))


(defmethod compute-byte-length* (length (representation <%machine-type>))
  (* length (?byte-length representation)))



(defmethod compute-byte-length* ((length <null>) representation)
  nil)






;(defmethod compute-byte-length (bytes (representation <%pointer>))
;  (+ bytes (?byte-length (?representation %unsigned-word-integer))))
;
;(defmethod compute-byte-length (bytes representation)
;  (+ bytes (?byte-length representation)))






#module-end
