;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: whc-basic-data-types -*-
#|
-----------------------------------------------------------------------------------
TITLE: macros and aux functions to read in the basic data types
-----------------------------------------------------------------------------------
File:    whc-basic-data-types.em
Version: 1.8 (last modification on Fri Apr  2 13:50:45 1993)
State:   save

DESCRIPTION:
macros and aux functions to read in the basic data types

DOCUMENTATION:
see in the APPLY-paper TAIL:eine getypte implementationssprache fuer APPLY

NOTES:
here with define-tail for the aux-data-types too

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 

-----------------------------------------------------------------------------------
|#
;;; begin  whc-basic-data-types.em
;;; -----------------------------------------------------------------------------------
;;; functions for Building up the machine data types and basic data types
;;; 


;first the machine data types of the machine, 
;define-machine-data-types reads in the list of machine data types 
;(from the machine-file) 
;and set these to the Constant machine-dates


#module-name whc-basic-data-types


#module-import
(;accessors
 representation
 lzs
 level-1-eulisp
 (only (get-option)option-lists)
 (only (<tail-class-def>) lzs-mop)
 (only (dolist assoc cadr make-instance mapcan intern setf) common-lisp)
 ;whc-classes
 class-ext
 whc-aux)

#module-syntax-import 
(level-1-eulisp 
 apply-standard
 (only (setf) common-lisp)
 el2lzs       ; only define-tail is needed
; class-ext
 )

#module-syntax-definitions

#module-header-end

;(expose class-ext)

(export 
  <basic-class-def>
  <%integer>
  <%signed>
  <%unsigned>
  <%float>
;  <%prestruct>
;  <%struct>
;  <%vector>
;  <%union>
  <%pointer>
  <%pointer-to-struct>
  <%pointer-to-vector>
  <%pointer-to-void>
  <%aux-type>
  <%representation>
  <%machine-type>
  <%direct>
 ; <%STRING-ASCIZ>
 ; <address-expr>

  ;table-of-class-instances  ;;our table


  )

(export-syntax 
  define-machine-data-types 
  ;define-basic-data-types ;data types with export
  define-aux-data-types   ;data types whithout export
  define-tail-sys-functions ;tail functions with export
  define-tail-aux-sys-functions;tail aux functions without export
)





(defmacro define-machine-data-types  machine-datas 
  (let (classes)
    (setq classes 
          (mapcan (lambda (li)
                    (list
                     `(setq ,(car li) 
                            (make-instance <%machine-type>                                      
                              :byte-length ,(get-option :byte-length (cdr li) ())
                            :alignment ,(get-option :alignment (cdr li) ())
                            ))))
          machine-datas))
  `(progn ,@classes)))
;the list of these machine data types is used by the definition of 
;basic data types 
;the basic data types are in the machine-file also
 

     
;define-basic-data-types takes the predifined basic-data-types from
;the machine file, generates for each data type a class (there are the
;classes %unsigned-word-integer) and makes for this class one
;instance. This instance is set to value of the class name (the value
;%unsigned-word-integer is a instance of the class %unsigned-word-integer)  

;define-basic-data-types like in TAIL


;;;read-in the tail functions like %ref... 
;;;in define-tail with export export (like the real data types)

(defun make-instance-symbol (sym) 
  (intern (string-append "$" (symbol-name sym))))

(defmacro define-tail-sys-functions funs
  (let (progbody)
    (dolist (fun funs)
      (setq progbody 
                  (cons
                   `(define-tail ,fun 
                      export; wh 
                      (special-sys-fun)
                      :protocol-type nil; wh
                      :arg-num nil; wh
                      :match-list nil; wh
                      :inline nil; wh
                      )
                   progbody))
      )
     `(progn ,@progbody)))


(defmacro define-tail-aux-sys-functions funs
  (let (progbody)
    (dolist (fun funs)
;;entry in our table?? I dont think so!!
;      (setq progbody 
;            (cons `(type-instance-put-with-test ',fun ,fun)
;                  progbody))
      (setq progbody 
                  (cons
                   `(define-tail ,fun 
                      nil; wh 
                      (special-sys-fun)
                      :protocol-type nil; wh
                      :arg-num nil; wh
                      :match-list nil; wh
                      :inline nil; wh
                      )
                   progbody))
      )
     `(progn ,@progbody)))



(defmacro define-basic-data-types  basic-data-types 
  (let (classes)
    (setq classes 
          (mapcan (lambda (li)
                    (list
                     `(define-tail ,(car li) 
                        export (basic-class-def)
                        :representation ,(get-option :machine-type (cdr li) ())
                        )
                     `(type-instance-put-with-test ',(car li) ,(car li))
                     )) 
                  basic-data-types))
    `(progn ,@classes)))



#module-end

;;; eof machine data types and basic data types