;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-------------------------------------------------------------------------------
TITLE: Auxiliary Functions and Parameters for Type Inference
-------------------------------------------------------------------------------
File:    ti.em
Version: 1.33 (last modification on Mon Jan 31 14:00:58 1994)
State:   published

DESCRIPTION:
Auxiliary functions for formatting, error signaling, collections, and
statistics.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/ti.em[1.33]:
  
[1.1] Wed May  5 11:26:18 1993 akind@isst saved
  
[1.2] Thu May  6 17:28:22 1993 akind@isst saved
  
[1.3] Fri May  7 12:10:28 1993 akind@isst proposed
  
[1.4] Fri May  7 21:23:01 1993 akind@isst proposed
  
[1.5] Mon May 24 12:09:22 1993 akind@isst proposed
  
[1.6] Tue May 25 11:08:48 1993 akind@isst proposed
  
[1.7] Wed May 26 10:34:55 1993 akind@isst proposed
  
[1.8] Tue Jul  6 16:13:43 1993 akind@isst proposed
  
[1.9] Tue Jul  6 16:14:39 1993 akind@isst proposed
  
[1.10] Wed Aug 11 10:04:53 1993 akind@isst proposed
  
[1.11] Wed Aug 18 16:10:25 1993 akind@isst proposed
  
[1.12] Thu Aug 19 10:20:23 1993 akind@isst proposed
  
[1.13] Fri Aug 20 14:21:23 1993 akind@isst proposed
  
[1.14] Tue Aug 24 16:26:20 1993 akind@isst proposed
  
[1.15] Tue Aug 24 16:34:36 1993 akind@isst proposed
  
[1.16] Tue Aug 24 17:10:00 1993 akind@isst proposed
  
[1.17] Wed Aug 25 17:39:28 1993 akind@isst proposed
  
[1.18] Fri Aug 27 17:30:21 1993 akind@isst published
  
[1.19] Tue Sep 14 12:41:11 1993 akind@isst saved
  
[1.20] Thu Sep 23 14:34:08 1993 akind@isst proposed
  
[1.21] Fri Sep 24 09:10:56 1993 akind@isst saved
  [Fri Sep 24 09:09:40 1993] Intention for change:
[1.22] Fri Sep 24 09:12:52 1993 akind@isst proposed
  
[1.23] Fri Oct  1 14:42:29 1993 akind@isst saved
  
[1.24] Mon Oct 11 10:31:31 1993 akind@isst saved
  
[1.25] Tue Oct 12 10:32:59 1993 akind@isst proposed
  
[1.26] Tue Oct 12 12:55:26 1993 akind@isst proposed
  
[1.27] Tue Oct 12 17:15:59 1993 akind@isst proposed
  
[1.28] Wed Oct 13 09:01:49 1993 akind@isst proposed
  
[1.29] Wed Oct 13 17:15:09 1993 akind@isst published
  
[1.30] Tue Nov  2 16:25:28 1993 akind@isst saved
  
[1.31] Tue Nov  9 17:31:08 1993 akind@isst proposed
  
[1.32] Mon Jan 31 09:43:28 1994 akind@isst proposed
  [Tue Nov 16 13:11:04 1993] Intention for change:
[1.33] Mon Jan 31 14:01:28 1994 akind@isst published
  [Mon Jan 31 10:38:37 1994] Intention for change:
  --- no intent expressed ---

-------------------------------------------------------------------------------
|#


#module ti
(import (level-0-eulisp level-1-eulisp apply-standard debugging
	 (only (format cerror float member-if dotimes
		       clrhash gethash make-hash-table) common-lisp))
 syntax (level-0-eulisp level-1-eulisp debugging)
 export (member-with-args dovector
	ti-format ti-format2
	set-ti-verbose0 set-ti-verbose1 set-ti-verbose2
	ti-error ti-statistics initialize-ti-statistics ti-print-statistics
	*max-call-descrs* *max-signature-descrs* *use-compound-types*
	*ti-short-print* *use-global-optimization*
	*fun-call-key* *inferred-signature-key* *inferred-classes-key*
	*joined-call-descrs-key* *joined-signature-descrs-key*
	*inferred-abstract-classes-key* *%setf-select-key*)
 expose (level-0-eulisp
	level-1-eulisp
	accessors
	apply-standard
	simple-programming
	debugging
	(only (append dolist mapc mapcar maphash) common-lisp)))

;;; ---------------------------------------------------------------------------
;;; TYPE INFERENCE PARAMETERS
;;; --------------------------------------------------------------------------

;; Determines whether a short output for error notification satisfies.
(deflocal *ti-short-print* t)

;; Maximal number of descriptors used for a function call; if acceeded 
;; descritors are joind.
(deflocal *max-call-descrs* 6)
(setq  *max-call-descrs* 4)

;; Maximal number of descriptors used in function signatures; if acceeded 
;; descritors are joind.
(deflocal *max-signature-descrs* 4)

;; Flag that determines whether all compound types are converted to 
;; non-compound super types.
(deflocal *use-compound-types* ())
;(setq *use-compound-types* t)

;; Format level; level 0: quiet mode; level 1: major warnings; level 2: all
;; outputs are displayed.
(setq *ti-verbose* 0)

;; Break level; level 0: ignore break points; level 1: stop at break points.
(setq *ti-break* ())

;;; ---------------------------------------------------------------------------
;;; BASIC COLLECTION FUNCTIONS
;;; ---------------------------------------------------------------------------

(defun member-with-args (pred list . args)
  (member-if (lambda (x) (apply pred x args)) list))

;;; Same as dolist for vector objects.
(defmacro dovector ((elem index vector-form) . body)
  `(dotimes (i (length ,vector-form) 1)
     (let ((,elem (vector-ref ,vector-form i))
	   (,index i))
       ,@body)))

;;; ---------------------------------------------------------------------------
;;; TYPE INFERENCE FORMAT/ERROR
;;; --------------------------------------------------------------------------

;;; Toggable format function for type-inference.
(defmacro ti-format args
  (let ((ok (if (numberp *ti-verbose*)
		(> *ti-verbose* 0)
	      *ti-verbose*)))
    (if ok
	`(format ,@args))))
      
;;; Second toggable format function for type-inference.
(defmacro ti-format2 args
  (if (and (numberp *ti-verbose*)
	   (> *ti-verbose* 1))
      `(format ,@args)))

(defun set-ti-verbose0 ()
  (setq *ti-verbose* 0))

(defun set-ti-verbose1 ()
  (setq *ti-verbose* 1))

(defun set-ti-verbose2 ()
  (setq *ti-verbose* 2))

(defmacro ti-error args
  (let ((ok (if (numberp *ti-break*)
		(> *ti-break* 0)
	      *ti-break*)))
    (if ok
	`(cerror "Try to continue" "Break from type inference!"))))

;;; --------------------------------------------------------------------------
;;; Type inference statistics.
;;; --------------------------------------------------------------------------

(deflocal *the-statistics* (make-hash-table))

(deflocal *fun-call-key* 'fun-call)
(deflocal *inferred-signature-key* 'inferred-signature)
(deflocal *inferred-classes-key* 'inferred-classes)
(deflocal *joined-call-descrs-key* 'joined-call-descrs)
(deflocal *joined-signature-descrs-key* 'joined-signature-descrs)
(deflocal *inferred-abstract-classes-key* 'inferred-abstact-classes)

;; Interesting for treating compound lattice types thus %setf-select may 
;; destroy information about compound types.
(deflocal *%setf-select-key* '%setf-select)

(defun initialize-ti-statistics ()
  (clrhash *the-statistics*))

(defun ti-statistics (key)
  (if (null key) (ti-error))
  (let ((value (get-ti-statistics key)))
    (if value
	(setf (gethash key *the-statistics*) (+ value 1))
      (setf (gethash key *the-statistics*) 0))))

(defun get-ti-statistics (key)
  (gethash key *the-statistics*))

(defun ti-print-statistics ()
  (let ((classes (or (get-ti-statistics *inferred-classes-key*) 0))
	(abstract-classes (or (get-ti-statistics *inferred-abstract-classes-key*) 0))
	(calls (or (get-ti-statistics *fun-call-key*) 0))
	(joined-calls (or (get-ti-statistics *joined-call-descrs-key*) 0))
	(signatures (or (get-ti-statistics *inferred-signature-key*) 0))
	(joined-signatures (or (get-ti-statistics *joined-signature-descrs-key*) 0))
	(select (or (get-ti-statistics *%setf-select-key*) 0)))
    (format t "~%Total number of analysed function calls: ~A" calls)
    (format t "~%Total number of joined function call descriptors: ~A (~,2F %)"
	    joined-calls
	    (if (zerop calls) 0
	      (* (/ (float joined-calls) (float calls)) 100)))
    (ti-format t "~%Total number of analysed %setf-select calls: ~A" select)
    (format t "~2%Total number of inferred function type schemes: ~A" signatures)
    (format t "~%Total number of joined type scheme descriptors: ~A (~,2F %)"
	    joined-signatures
	    (if (zerop signatures) 0
	      (* (/ (float joined-signatures) (float signatures)) 100)))
    (format t "~2%Total number of inferred classes: ~A" classes)
    (format t "~%Total number of inferred abstract classes: ~A (~,2F %)"
	    abstract-classes
	    (if (zerop classes) 0
	      (* (/ (float abstract-classes) (float classes)) 100)))))

#module-end