;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-meet-join -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-------------------------------------------------------------------------------
TITLE: Operations on Type Expressions for Type Inference
-------------------------------------------------------------------------------
File:    ti-meet-join.em
Version: 1.26 (last modification on Fri Jan 28 16:23:16 1994)
State:   published

DESCRIPTION:
This module includes functions to compute the least upper bound (join) and
greatest lower boun (meet) of type expressions.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/ti-meet-join.em[1.26]:
  
[1.1] Wed Apr  7 09:06:15 1993 akind@isst proposed
  
[1.2] Fri Apr 16 18:18:15 1993 akind@isst proposed
  
[1.3] Mon Apr 19 18:04:41 1993 akind@isst proposed
  
[1.4] Tue Apr 20 17:37:34 1993 akind@isst proposed
  
[1.5] Wed Apr 21 16:38:43 1993 akind@isst proposed
  
[1.6] Wed May  5 11:25:42 1993 akind@isst saved
  
[1.7] Thu May  6 17:27:49 1993 akind@isst proposed
  
[1.8] Wed May 19 11:10:44 1993 akind@isst saved
  
[1.9] Wed May 19 13:10:56 1993 akind@isst proposed
  
[1.10] Tue Jun  1 17:45:05 1993 akind@isst proposed
  
[1.11] Wed Jun  2 17:11:25 1993 akind@isst proposed
  
[1.12] Thu Jun  3 11:17:53 1993 akind@isst proposed
  
[1.13] Tue Aug  3 11:47:13 1993 akind@isst proposed
  
[1.14] Mon Aug  9 16:11:44 1993 akind@isst proposed
  
[1.15] Wed Aug 11 13:35:05 1993 akind@isst proposed
  
[1.16] Wed Aug 18 16:16:28 1993 akind@isst proposed
  
[1.17] Fri Aug 20 14:21:04 1993 akind@isst proposed
  
[1.18] Wed Aug 25 17:39:05 1993 akind@isst proposed
  
[1.19] Fri Aug 27 17:30:00 1993 akind@isst proposed
  
[1.20] Mon Aug 30 09:13:17 1993 akind@isst published
  
[1.21] Thu Sep 23 14:33:27 1993 akind@isst proposed
  
[1.22] Fri Oct  1 14:41:38 1993 akind@isst saved
  [Thu Sep 23 15:44:26 1993] Intention for change:
[1.23] Mon Oct 11 10:30:37 1993 akind@isst published
  
[1.24] Tue Jan  4 11:41:13 1994 akind@isst saved
  [Mon Dec 13 14:35:22 1993] Intention for change:
[1.25] Wed Jan 19 13:19:16 1994 akind@isst saved
  
[1.26] Mon Jan 31 09:35:04 1994 akind@isst published
  [Mon Jan 10 15:09:30 1994] Intention for change:
  --- no intent expressed ---


-------------------------------------------------------------------------------
|#


#module ti-meet-join
 (import (ti ti-codes ti-lattice ti-exprs
	  (only (format) common-lisp))
  syntax (ti)
  export (meet-type-exprs-p subtype-expr-p true-subtype-expr-p eq-expr-p
	  meet-type-exprs join-type-exprs joined-type-exprs
	  eval-to-expr compute-to-atom normalize-atomic-type
	  complement-type-expr-of-lattice-type
	  not-%false-type))

;;; ---------------------------------------------------------------------------
;;; MEET TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------

(defgeneric meet-type-exprs (expr1 expr2))

(defmethod meet-type-exprs ((expr1 <type-expr>)
			    (expr2 <type-expr>))
  (ti-format t "~%Warning: subclass responsibility")
  (ti-error)
  (general-type))
	 
(defmethod meet-type-exprs ((expr1 <atomic-type>)
			    (expr2 <atomic-type>))
  (let ((code1 (?code expr1))
	(code2 (?code expr2)))
    (cond ((general-type-p expr1) expr2)
	  ((general-type-p expr2) expr1)
	  ((complement-codes-p code1 code2) nil)
	  ((subcode-p code1 code2) expr1)
	  ((subcode-p code2 code1) expr2)
	  (t 
	   (let ((new-code (meet-codes (?code expr1) (?code expr2))))
	     (if (bottom-code-p new-code)
		 nil
	       (make <atomic-type>
		     :code new-code
		     :name (list ^and (?name expr1) (?name expr2))
		     :comp-name (or (?comp-name expr1) (?comp-name expr2)))))))))

(defmethod meet-type-exprs ((expr1 <slot-id>)
			    (expr2 <slot-id>))
  (if (eq (?slot-name expr1) (?slot-name expr2))
      expr1
    nil))
	 
(defmethod meet-type-exprs ((expr1 <slot-id>)
			    (expr2 <atomic-type>))
  (if (or (general-type-p expr2)
	  (%object-type-p expr2))
      expr1 nil))
	 
(defmethod meet-type-exprs ((expr1 <atomic-type>)
			    (expr2 <slot-id>))
  (meet-type-exprs expr2 expr1))

;;; ---------------------------------------------------------------------------
;;; Answer whether a type expr meets another.
;;; ---------------------------------------------------------------------------

(defgeneric meet-type-exprs-p (expr1 expr2))
	 
(defmethod meet-type-exprs-p ((expr1 <type-expr>)
			      (expr2 <type-expr>))
  (meet-type-exprs expr1 expr2))
	 
(defmethod meet-type-exprs-p ((expr1 <atomic-type>)
			      (expr2 <atomic-type>))
  (meet-codes-p (?code expr1) (?code expr2)))

;;; ---------------------------------------------------------------------------
;;; Answer whether a type expr is subtype of another.
;;; ---------------------------------------------------------------------------

(defgeneric subtype-expr-p (expr1 expr2))

(defmethod subtype-expr-p ((expr1 <type-expr>)
			   (expr2 <type-expr>))
  nil)

(defmethod subtype-expr-p ((expr1 <atomic-type>)
			   (expr2 <atomic-type>))
  (subcode-p (?code expr1) (?code expr2)))

(defmethod subtype-expr-p ((expr1 <slot-id>)
			   (expr2 <slot-id>))
  (eq (?slot-name expr1) (?slot-name expr2)))

;;; ---------------------------------------------------------------------------
;;; Answer whether a type expr is a true subtype of another.
;;; ---------------------------------------------------------------------------

(defgeneric true-subtype-expr-p (expr1 expr2))

(defmethod true-subtype-expr-p ((expr1 <type-expr>)
				(expr2 <type-expr>))
  nil)

(defmethod true-subtype-expr-p ((expr1 <atomic-type>)
				(expr2 <atomic-type>))
  (let ((code1 (?code expr1))
	(code2 (?code expr2)))
    (and (subcode-p code1 code2)
	 (null (eq-code-p code1 code2)))))

;;; ---------------------------------------------------------------------------
;;; Answer whether a type expr is equal to another.
;;; ---------------------------------------------------------------------------

(defgeneric eq-expr-p (expr1 expr2))

(defmethod eq-expr-p ((expr1 <type-expr>)
		      (expr2 <type-expr>))
  nil)

(defmethod eq-expr-p ((expr1 <atomic-type>)
		      (expr2 <atomic-type>))
  (eq-code-p (?code expr1) (?code expr2)))

(defmethod eq-expr-p ((expr1 <slot-id>)
		      (expr2 <slot-id>))
  (eq (?slot-name expr1) (?slot-name expr2)))

;;; ---------------------------------------------------------------------------
;;; Join type expressions
;;; ---------------------------------------------------------------------------

(defgeneric join-type-exprs (expr1 expr2))

(defmethod join-type-exprs ((expr1 <type-expr>)
			    (expr2 <type-expr>))
  (ti-format t "~%Warning: subclass responsibility")
  (ti-error)
  (general-type))
	 
(defmethod join-type-exprs ((expr1 <atomic-type>)
			    (expr2 <atomic-type>))
  (let ((code1 (?code expr1))
	(code2 (?code expr2)))
    (cond ((or (general-type-p expr1) (general-type-p expr2)) (general-type))
	  ((complement-codes-p code1 code2) (general-type))
	  ((subcode-p code1 code2) expr2)
	  ((subcode-p code2 code1) expr1)
	  (t
	   (let ((new-code (join-codes code1 code2)))
	     (make <atomic-type>
		   :code new-code
		   :name (list ^or (?name expr1) (?name expr2))
		   :comp-name (or (?comp-name expr1) (?comp-name expr2))))))))

(defmethod join-type-exprs ((expr1 <slot-id>)
			    (expr2 <type-expr>))
  (if (or (general-type-p expr2)
	  (%object-type-p expr2))
      expr1 expr2))
  
(defmethod join-type-exprs ((expr1 <type-expr>)
			    (expr2 <slot-id>))
  (join-type-exprs expr2 expr1))

(defmethod join-type-exprs ((expr1 <slot-id>)
			    (expr2 <slot-id>))
  (cond ((eq (?slot-name expr1) (?slot-name expr2))
	 expr1)
	(t 
	 (ti-format t "~%Warning: can't join different slot names")
	 (ti-error)
	 expr1)))

(defun joined-type-exprs (exprs)
  (let ((result (car exprs)))
    (dolist (expr (cdr exprs))
      (setq result (join-type-exprs expr result)))
    result))

;;; ---------------------------------------------------------------------------
;;; Creating type expressions.
;;; ---------------------------------------------------------------------------

(defun eval-to-expr (def-list)
  (let ((op-symbol (car def-list))
	(arg-def (cdr def-list)))
    (cond ((eq ^var op-symbol)		; VAR
	   (make <type-var> :id (car arg-def)))
	  ((eq ^atom op-symbol)		; ATOM
	   (eval-to-atom (car arg-def)))
	  (t				; undefined
	   (format t "~%Warning: no correct definition of a type expression")
	   (ti-error)
	   (general-type)))))

;;; Convert lists like ^(and (not <integer>) <null>) to atoms.
(defun eval-to-atom (def-list)
  (compute-to-atom (convert-def-list-to-expr-name def-list)))

;;; Convet lists like ^(and (not <integer>) <null>) to (^and (^not #..) #..).
(defun convert-def-list-to-expr-name (def-list)
  (if (consp def-list)
      (cons (car def-list)
	    (mapcar #'convert-def-list-to-expr-name (cdr def-list)))
    (get-lattice-type def-list)))

;;; Convert lists like (^and (^not #..) #..) to atoms.
(defun compute-to-atom (name)
  (if (consp name)			; nested?
      (let ((op-symbol (car name)))
	(if (eq ^not op-symbol)		; NOT
	    (complement-type-expr-of-lattice-type (car (cdr name)))
	  (let ((subatom1 (compute-to-atom (car (cdr name))))
		(subatom2 (compute-to-atom (car (cdr (cdr name))))))
	    (cond ((eq ^and op-symbol)	; AND
		   (meet-type-exprs subatom1 subatom2))
		  ((eq ^or op-symbol)	; OR
		   (join-type-exprs subatom1 subatom2))
		  (t
		   (format t "~%Warning: no correct definition of an atomic type")
		   (general-type))))))
    (lattice-type-to-atomic-type name)))

;; Answer a a corresponding complement type expr of a lattice type.
(defun complement-type-expr-of-lattice-type (name)
  (if (consp name)			;nested?
      (progn
	(format t "~%Warning: operator NOT only defined on atomic types! ~A" name)
	(ti-error)
	(general-type))			; continue with general type
    (make <atomic-type>
	  :code (complement-code (?code name))
	  :name (list ^not name)
	  :comp-name (?compound name))))

;;; ---------------------------------------------------------------------------

(defun not-%false-type ()
  (compute-to-atom (list ^not *%false*)))


#module-end