;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: representation -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    representation.em
Version: 1.7 (last modification on Thu Feb  3 11:52:03 1994)
State:   published

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/representation.em[1.7]:
  accessors for representation.
[1.1] Tue Nov 23 12:56:14 1993 ukriegel@isst saved
  [Tue Nov 23 06:23:59 1993] Intention for change:
  byte-length
[1.2] Wed Nov 24 11:07:37 1993 ukriegel@isst proposed
  [Tue Nov 23 14:05:10 1993] Intention for change:
  clean up
[1.3] Thu Jan 13 11:25:30 1994 ukriegel@isst proposed
  [Wed Jan  5 13:25:47 1994] Intention for change:
  add default values for alignment
  done
[1.4] Wed Feb  2 17:38:43 1994 ukriegel@isst saved
  [Wed Feb  2 17:34:05 1994] Intention for change:
  [Wed Feb  2 17:19:30 1994] Intention for change:
  remove mm-initialize and fill representation with raw values
  only Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


  ,.
[1.5] Thu Feb  3 09:44:06 1994 ukriegel@isst saved
  [Thu Feb  3 09:34:22 1994] Intention for change:
  default values for allocation mm-type
  done
[1.6] Thu Feb  3 11:03:54 1994 ukriegel@isst saved
  [Thu Feb  3 11:02:51 1994] Intention for change:
  --- no intent expressed ---
[1.7] Thu Feb  3 11:52:41 1994 ukriegel@isst published
  [Thu Feb  3 11:50:38 1994] Intention for change:
  --- no intent expressed ---

-----------------------------------------------------------------------------------
|#

#module representation

(import
 (level-1-eulisp
  lzs
  (only (<tail-class-def>) lzs-mop)
  ;accessors
  )
 
 syntax
 (level-1-eulisp 
  (only (defstandardclass) apply-standard)
  )
 
 export 
 
 (  <basic-class-def>
    <%integer>
    <%signed>
    <%unsigned> 
    <%float> ;new name
    <%aux-type>
    <%representation>
    <%machine-type>
    <%pointer> ;superclass of all pointer representations
    <%pointer-to-struct>
    <%pointer-to-vector>
    <%pointer-to-void>
    <%direct>
    <address-expr>
    ?alignment
    ?allocation
    ?byte-length
    ?byte-length-of-instance 
    ?byte-length-as-component
    ?mm-type
    ?mm-card

    )
 )
(defgeneric ?alignment (obj))
(defgeneric ?allocation (obj))
(defgeneric ?byte-length (obj))
(defgeneric ?byte-length-as-component (pobj))
(defgeneric ?byte-length-of-instance (obj))
(defgeneric ?mm-type (obj))
(defgeneric ?mm-card(obj))




(defstandardclass <%representation> ()
  :default-slot-options (:accessor :initarg)
  :slots
   alignment    ;alignment (of all types)

   byte-length  ;length (in bytes) of all types

   (allocation :accessor :initarg :initform ())  ;slots
   (mm-type  :accessor :initarg :initform ())      ;for the
   mm-card      ;memory management


   )  

;make a new class for %machine-type
;%bit ...%quad-word are instances from this class and are holded
;on the corresponding constants 
(defstandardclass <%machine-type> (<%representation>) ())


(defstandardclass <%aux-type> (<%representation>) ())

;;;the basic-data-type = basic-class-def takes informations 
;;;from %types = tail-class-def
;;;and from %representation
;;;!!!the old one!!!



;;;but I think it is better to cut the representation from the 
;;;eulisp hierarchy and take
;;;!!!the new one!!!

(defstandardclass <basic-class-def> (<tail-class-def>))

(defstandardclass <%integer> (<basic-class-def>) ())

(defstandardclass <%float> (<basic-class-def>) ())


;;; take <%signed> and <%unsigned> as mixin and not as subclass
;;; from <%integer-def>

;;; mixins for <%signed> and <%unsigned>
(defstandardclass <%signed> () ())

(defstandardclass <%unsigned> () ())



(defstandardclass <%pointer> (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  type                     ;type of the data to which the pointer points
  offset)                  ;not used

(defstandardclass <%pointer-to-struct> (<%pointer>)
  ;;;the old one                       (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  slot-and-type-names  ; see %struct: like an a-list ((slot type) ...)
  label-for-struct  ; this is the label for the real struct
  offset)

(defstandardclass <%pointer-to-vector> (<%pointer>)
  ;;;the old one                       (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  type    ;type of the data to which the pointer points
  length-of-vector
  label-for-vector  ; this is the label for the real vector
  offset)

(defstandardclass <%pointer-to-void> (<%pointer>)
  ;;;the old one                     (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  (alignment :initform 4)
  (byte-length :initform 4)
  ;(bit-length :initform 32); *UK* 03.02.94
  slot1  
  slot2  
  offset)

(defstandardclass <%direct> (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  type) 






;;;class of address-expressions
(defstandardclass <address-expr> ()
  :default-slot-options (:accessor :initarg)
  :slots
  address         ;label
  offset          ;offset
  type            ;type of the data
  slot            ;used for intern usage
  top-type-name)  ;contains the (rest) ini-list

#module-end
