;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: predicates -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    predicates.em
Version: 1.1 (last modification on Tue Feb  8 15:30:37 1994)
State:   published

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/predicates.em[1.1]:
  some general predicates
[1.1] Tue Feb  8 16:10:43 1994 akind@isst published
  [Tue Feb  8 10:12:01 1994] Intention for change:
  unknown-applications-p should be exported

-----------------------------------------------------------------------------------
|#

#module predicates
(import (eulisp0
	 (only (special-sys-fun-p) lzs)
	 (only (?exported ?expanded-literal) accessors))
 syntax (eulisp0)
 expose ()
 export (*compilation-type*  ; set by function compile in module apply-compiler
	 signature-needed-for-code-generation-p
         exported-for-lisp-p 
         exported-p
         class-sealed-p
         generic-function-sealed-p
	 unknown-applications-p
         ))

(deflocal *compilation-type* nil) 
; actually the following values are supported: 
; :application :basic-system

(defun signature-needed-for-code-generation-p (fun)
  ;answer whether the type scheme can be set to nil
  (or (null (eq *compilation-type* :application))
      (null (special-sys-fun-p fun))))

;;; -----------------------------------------------------------------------------------
;;; the following functions may be used after mark-as-exported was called (in
;;; compile[apply-compiler] 
;;; -----------------------------------------------------------------------------------

(defun exported-for-lisp-p (obj)
  (and (?exported obj)
       (eq *compilation-type* :basic-system)))

(defun exported-p (obj)
  (?exported obj))

(defun class-sealed-p (class)
  ; returns true if it is impossible to create an additional subclass for class
  ; outside the compilation unit (i.e in using modules or at runtime)
  (or (null (?exported class))
      (eq *compilation-type* :application)))

(defun generic-function-sealed-p (gf)
  ; returns true if it is impossible to add additional methods outside the
  ; compilation unit (i.e in using modules or at runtime) 
  (or (null (?exported gf))
      (eq *compilation-type* :application)))

;;; -----------------------------------------------------------------------------------
;;; the following functions may be called after side effect analysis
;;; -----------------------------------------------------------------------------------

(defun unknown-applications-p (fun)
  (or (?exported fun)
      (?expanded-literal fun)))

#module-end
