;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: option-lists -*-
#|
-----------------------------------------------------------------------------------
TITLE: Functions to work with option lists
-----------------------------------------------------------------------------------
File:    option-lists.em
Version: 1.2 (last modification on Fri Mar 26 17:48:48 1993)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/option-lists.em[1.2]:
  accessor functions for option lists of EuLisp
[1.1] Thu Mar 25 11:53:07 1993 imohr@isst proposed
  + check-options replace-option-value
[1.2] Fri Mar 26 17:53:40 1993 imohr@isst published
  + mapl-option-list

-----------------------------------------------------------------------------------
|#

#module-name option-lists
#module-import
(level-0-eulisp
 pair-ext
 list-ext
 (only (warn find remove) common-lisp))
#module-syntax-import 
(level-0-eulisp
 (only (when) level-1-eulisp))
#module-syntax-definitions

#module-header-end

(export map-option-list find-option get-option replace-option-value
        check-options mapl-option-list)

(defun map-option-list (function option-list)
  (cond ((null option-list) nil)
        ((atom (cdr option-list))
         (warn "option list with uneven number of elements; last one was ~A"
               (car option-list)))
        (t (funcall function (car option-list) (cadr option-list))
           (map-option-list function (cddr option-list)))))

(defun mapl-option-list (function option-list)
  (cond ((null option-list) nil)
        ((atom (cdr option-list))
         (warn "option list with uneven number of elements; last one was ~A"
               (car option-list)))
        (t (funcall function option-list)
           (mapl-option-list function (cddr option-list)))))

(defun find-option (key option-list error-if-not-found?)
  (cond ((null option-list) 
         (when error-if-not-found?
           (warn "option ~A not found in option list ~A" key option-list))
         nil)
        ((atom (cdr option-list))
         (warn "option list with uneven number of elements; last one was ~A"
               (car option-list))
         nil)
        ((eq key (car option-list))
         (cdr option-list))
        (t (find-option key (cddr option-list) error-if-not-found?))))

(defun get-option (key option-list default)
  (let ((entry (find-option key option-list nil)))
    (if entry 
      (car entry)
      default)))

(defun replace-option-value (function key option-list)
  ;function is applied to the old value and must return the new
  ;value for the specified option
  ; the changed option-list is returned
  (let ((entry (find-option key option-list nil)))
    (when entry
      (setf (car entry) (funcall function (car entry))))
    option-list))

(defun check-options (required-options facultative-options multiple-options 
                                       option-list)
  (cond ((null option-list) 
         (if (null required-options)
           t
           (progn (warn "missing options: ~A " 
                        required-options)
                  nil)))
        ((atom (cdr option-list))
         (warn "option list with uneven number of elements; last one was ~A"
               (car option-list))
         nil)
        ((find (car option-list) required-options)
         (check-options (remove (car option-list) required-options) 
                        facultative-options multiple-options
                        (cddr option-list)))
        ((find (car option-list) facultative-options)
         (check-options required-options 
                        (remove (car option-list) facultative-options) 
                        multiple-options
                        (cddr option-list)))
        ((find (car option-list) multiple-options)
         (check-options required-options facultative-options multiple-options
                        (cddr option-list)))
        (t 
         (warn "undefined option: ~A" (car option-list))
         (check-options required-options facultative-options multiple-options
                        (cddr option-list))
         nil)))

#module-end
