;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: mm-initialize-syntax -*-
#|
-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    mm-initialize-syntax.em
Version: 1.3 (last modification on Wed Nov 24 10:45:26 1993)
State:   published

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/mm-initialize-syntax.em[1.3]:
  syntax-module for mm-initialize
[1.1] Mon Nov 22 15:24:57 1993 ukriegel@isst saved
  [Mon Nov 22 11:50:37 1993] Intention for change:
[1.2] Tue Nov 23 12:52:55 1993 ukriegel@isst saved
  [Tue Nov 23 07:10:11 1993] Intention for change:
  unbound value
  macros
[1.3] Wed Nov 24 11:07:28 1993 ukriegel@isst published
  [Wed Nov 24 10:44:42 1993] Intention for change:

-----------------------------------------------------------------------------------
|#

#module mm-initialize-syntax
(import
 (representation
  tail-module
  (only (get-option check-options) option-lists)
  level-0-eulisp
  expand-literal
  )
 syntax 
(level-0-eulisp
 (rename ((incf cl:incf)
          (push cl:push))
  (only (incf push ) common-lisp)))
 export (last-used-type-descriptor last-used-card-descriptor create-runtime-cdscr-initform)
)
(deflocal last-used-type-descriptor 0)
(deflocal last-used-card-descriptor 0)
;;; -----------------------------------------------------------------------------------
;;; define a dummy generic function to solve package problems 
;;; -----------------------------------------------------------------------------------

(defgeneric create-runtime-cdscr-initform (class cdscr cardtype size tdscr))

(defmacro canonize-multiple-card-descriptors
          (class representation-object size mm-type card-type key descriptor-list )
  `(let ((cds (get-option ,key ,descriptor-list ())))
     (if cds 
       ;;use existing card descriptor, no need for initialization form
       (setf(?mm-card ,representation-object) 
            (literal-instance %signed-word-integer cds))
       ;;add new cds to list of descriptors and create run-time
       ;;initialization form
       (progn
         (cl:incf last-used-card-descriptor)
         (cl:push last-used-card-descriptor
                  ,descriptor-list)
         (cl:push ,key ,descriptor-list)
         (setf (?mm-card ,representation-object) 
               (literal-instance
                %signed-word-integer last-used-card-descriptor))
         (create-runtime-cdscr-initform ,class last-used-card-descriptor ,card-type ,size ,mm-type)))))

(defmacro literal-instance
          (type . values )
  `(make-literal-instance ,type
                          (list ,@values)))



#module-end
