;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: generate-def-file -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: generation of interface files
-----------------------------------------------------------------------------------
File:    generate-def-file.em
Version: 1.6 (last modification on Wed Feb  2 10:52:17 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind, Ingo Mohr

CONTACT: 
a.kind

HISTORY: 

Log for /export/home/saturn/ukriegel/Dist/Apply/generate-def-file.em[1.6]:
  Generating interface files.
[1.1] Thu May 27 12:55:57 1993 akind@isst proposed
  [Thu May 27 12:53:48 1993] Intention for change:
[1.2] Thu Jun  3 13:15:05 1993 akind@isst published
  [Thu Jun  3 13:13:36 1993] Intention for change:
  Add newline to output file.
[1.3] Tue Sep 21 16:10:04 1993 akind@isst saved
  [Tue Sep 21 16:08:35 1993] Intention for change:
  map-with-fun -> mapc
[1.4] Tue Sep 21 16:11:15 1993 akind@isst published
  [Tue Sep 21 16:10:46 1993] Intention for change:
[1.5] Wed Nov 24 08:47:57 1993 imohr@isst proposed
  
[1.6] Mon Feb  7 08:26:26 1994 imohr@isst proposed
  [Fri Nov 26 11:05:54 1993] Intention for change:
  --- no intent expressed ---new slot access and imported classes ok

-----------------------------------------------------------------------------------
|#

#module generate-def-file
(import (level-1-eulisp
         accessors
         el2lzs
         lzs
         tail-module
         ti-write
         (only (format dolist) common-lisp))
 syntax (level-1-eulisp
         (only (with-open-file) common-lisp))
;;exports
 export (generate-def-file 
         generate-def-file-for-module) 
 )

;;; -----------------------------------------------------------------------------------
;;; main functions
;;; -----------------------------------------------------------------------------------
;;requires a module-name
(defun generate-def-file-for-module (module)
  (generate-def-file (find-module module)))

;;requires a module
(defun generate-def-file-for-runtime-system (rts-module)
  (with-open-file (out (format nil "~(~a~).def" id)
                       :direction :output :if-exists :supersede
                       :if-does-not-exist :create)
    (generate-module-def rts-module)
    ))

(defun if-module-def (module stream)
  (let ((exports (?exports main))
        (id (?identifier main)))
    (format stream "~%(defmodule ~a~
                    ~% (import %tail~
                    ~%  syntax %tail)"
            id)
    (generate-interface exports stream)
    (def-write-remaining-strategic-lattice-types stream)
    (format stream "~%); end of interface definition for ~a"
            id)
    ))

;;; -----------------------------------------------------------------------------------
;;; functions, classes and variables
;;; -----------------------------------------------------------------------------------

(defun generate-interface (objects stream)
  (unless (null objects)
    (gen-interface (car objects) stream)
    (generate-interface (cdr objects) stream)))

(defgeneric gen-interface (object stream))

(defmethod gen-interface (object stream)
  ; generate only an interface for specific objects
  nil)

;;; -----------------------------------------------------------------------------------
;;; constants and variables
;;; -----------------------------------------------------------------------------------

(defmethod gen-interface ((var <global-static>) stream)
  (format stream "~2%(%declare-external-variable ~A ~A~
                   ~% external-name |~A|)"
          (if-identifier var)
          (if-identifier (?type var))
          (?code-identifier var)
          ))

(defmethod gen-interface ((const <named-const>) stream)
  (format stream "~2%(%declare-external-constant ~A ~A~
                   ~% external-name |~A|)"
          (if-identifier var)
          (if-identifier (?type var))
          (?code-identifier var)))

;;; -----------------------------------------------------------------------------------
;;; symbols
;;; -----------------------------------------------------------------------------------

(defmethod gen-interface ((sym <sym>) stream)
  (format stream "~2%(%declare-external-symbol ~A |~A|)"
          (if-identifier sym)
          (?code-identifier sym)))

;;; -----------------------------------------------------------------------------------
;;; simple functions
;;; -----------------------------------------------------------------------------------

(defmethod gen-interface ((fun <simple-fun>) stream)
  (format stream "~2%(%declare-external-function (~A ~A)~
                   ~% ~A~
                   ~% external-name |~A|)"
          (if-identifier fun)
          (if-identifier (range fun))
          (specialized-parameters fun)
          (?code-identifier fun))
  (ti-def-write stream fun))

(defun range (fun)
  (svref (?range-and-domain fun) 0))

(defun specialized-parameters (fun)
  (spec-params (?var-list (?params fun))
               (?rest (?params fun))
               (?range-and-domain fun)
               1))

(defun spec-params (vars rest range-and-domain type-idx)
  (cond (vars
         (cons (list (?identifier (car vars))
                     (if-identifier (svref range-and-domain type-idx)))
               (spec-args (cdr vars) rest range-and-domain (+ type-idx 1))))
        (rest (?identifier rest))
        (t nil)))

;;; -----------------------------------------------------------------------------------
;;; generic functions
;;; -----------------------------------------------------------------------------------

(defmethod gen-interface ((fun <generic-fun>) stream)
  (format stream "~2%(%declare-external-generic (~A ~A)~
                  ~% ~A~
                  ~% external-name |~A|~
                  ~% methods (~{~A~
                  ~^~%          ~})"
          (if-identifier fun)
          (if-identifier (range fun))
          (specialized-parameters fun)
          (?code-identifier fun)
          (mapcar (lambda (method)
                    (if-identifier (~method-function method)))
                  (~generic-function-methods fun))
          ))

;;; -----------------------------------------------------------------------------------
;;; classes
;;; -----------------------------------------------------------------------------------

(defmethod gen-interface ((class <class-def>) stream)
  (let ((super-strategic-lattice-types 
         (def-write-super-strategic-lattice-types stream class)))
    (format stream "~2%(%declare-external-class ~A ~A~
                     ~% external-name |~A|~
                  ~@[~% direct-super-lattice-types ~A~]
                  ~@[~% converter ~])"
            (if-identifier class)
            (mapcar #'if-identifier (?supers class))
            (?code-identifier class)
            super-strategic-lattice-types
            (and (?converter class) (if-identifier class)))))

;;; -----------------------------------------------------------------------------------
;;; interface identifiers
;;; -----------------------------------------------------------------------------------

(defun if-identifier (object)
  ; returns the interface identifier of an object: the identifier in
  ; the module which is the compilation unit
  (or (?exported object)
      (export-implicitely object)) 
  )

#module-end