;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: The interface of the Eulisp-to-LZS-Transformer
-----------------------------------------------------------------------------------
File:    el2lzs.em
Version: 1.6 (last modification on Mon Jan 31 08:32:25 1994)
State:   published

DESCRIPTION:
This module provides a common interface for the transformation from EuLisp to LZS.

DOCUMENTATION:

NOTES:
The module lzs-modules should be included into this module and should then
deleted. 

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/el2lzs.em[1.6]:
  Provides the common interface of the frontend for the other parts
  of the APPLY-compiler.
[1.1] Mon Mar 29 13:32:06 1993 imohr@isst saved
  [Wed Mar 24 17:00:11 1993] Intention for change:
  --- no intent expressed ---
[1.2] Wed Mar 31 10:39:10 1993 imohr@isst proposed
  literals for structures, literal expanders and expose ok
[1.3] Tue May 11 13:40:51 1993 imohr@isst saved
  error when marking exported things removed
[1.4] Tue May 11 14:51:40 1993 imohr@isst published
  expose -> export 
[1.5] Thu Jan 13 15:04:04 1994 wheick@isst saved
  done
[1.6] Mon Jan 31 08:44:17 1994 wheick@isst published
  [Thu Jan 13 14:53:57 1994] Intention for change:
  eulisp0
  done

-----------------------------------------------------------------------------------
|#

#module el2lzs
(import
 (eulisp0 el2lzs-main)
 
 syntax
 (eulisp0 dynamic)

 export					; for interactive use
(load-module				;(module-id | path | "") loads and translates a module
  find-module
  module-env  ; the list of all modules needed for compilation 
  mark-as-exported
  get-identifier-and-object
  )

expose 
(lzs-modules)
)

(defun make-lzs-expression (form environment)
  (dynamic-let ((lex-env environment))
     (trans form)))

#module-end

