;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-error -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: Signalling errors, warnings and infos for specific situations detected by
       the frontend
-----------------------------------------------------------------------------------
File:    el2lzs-error.em
Version: 1.15 (last modification on Mon Feb  7 11:30:43 1994)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/el2lzs-error.em[1.15]:
  errors for the frontend
[1.1] Wed Oct 20 14:23:57 1993 imohr@isst proposed
  
[1.2] Wed Oct 20 18:45:34 1993 imohr@isst published
  
[1.3] Thu Oct 21 15:00:42 1993 imohr@isst saved
  
[1.4] Tue Nov  9 11:34:46 1993 imohr@isst proposed
  [Thu Oct 21 15:33:28 1993] Intention for change:
  --- no intent expressed ---
[1.5] Tue Nov 30 13:55:52 1993 imohr@isst proposed
  [Mon Nov 29 11:36:28 1993] Intention for change:
  error "specification of non-existent binding in interface" for el2lzs-main
[1.6] Tue Dec  7 17:06:29 1993 imohr@isst proposed
  [Tue Dec  7 14:20:35 1993] Intention for change:
  move definition of <binding> to el2lzs-basic
[1.7] Tue Dec 14 17:18:27 1993 imohr@isst proposed
  [Tue Dec 14 13:14:46 1993] Intention for change:
[1.8] Thu Jan 13 15:49:53 1994 imohr@isst saved
  [Thu Jan 13 14:22:33 1994] Intention for change:
  --- no intent expressed ---errors for eval
[1.9] Thu Jan 13 16:09:59 1994 wheick@isst saved
  done
[1.10] Mon Jan 31 08:51:09 1994 wheick@isst proposed
  [Thu Jan 13 16:05:32 1994] Intention for change:
  eulisp0
  done
[1.11] Wed Feb  2 09:19:00 1994 imohr@isst saved
  [Tue Feb  1 15:23:44 1994] Intention for change:
  --- no intent expressed ---
[1.12] Wed Feb  2 13:58:28 1994 imohr@isst proposed
  [Wed Feb  2 13:13:12 1994] Intention for change:
  + error for double defined initargs
[1.13] Wed Feb  2 14:01:25 1994 imohr@isst proposed
  [Wed Feb  2 14:01:00 1994] Intention for change:
  eval-error-special-form-not-implemented
[1.14] Wed Feb  2 14:06:49 1994 imohr@isst proposed
  [Wed Feb  2 14:06:28 1994] Intention for change:
  --- no intent expressed ---
[1.15] Mon Feb  7 11:31:31 1994 imohr@isst published
  [Mon Feb  7 08:43:39 1994] Intention for change:
  make old-style-warning a bit more noticeable

-----------------------------------------------------------------------------------
|#

#module el2lzs-error
(import (eulisp1
         lzs accessors
         configuration; only to get initialization of dynamic *[system-]info-level*
         binding
         debugging
         (only (error warn format
                      floor length string
                      first second third fourth)
           common-lisp))
 syntax (eulisp1
         apply-standard)
 export (*frontend-errors*
         new-frontend-error
         reset-frontend-errors)
 ; ---- stuff for bindings ; should be temporary
 export (<binding>
         finally-refered-object
         get-lzs-object
         )
 )

;;; -----------------------------------------------------------------------------------
;;; 
;;; -----------------------------------------------------------------------------------
(export
  *frontend-errors*
  new-frontend-error
  reset-frontend-errors)

(deflocal *frontend-errors* 0)

(defun new-frontend-error ()
  (setq *frontend-errors* (+ 1 *frontend-errors*)))

(defun reset-frontend-errors ()
  (setq *frontend-errors* 0))

(defvar current-defining-form nil)

;;; -----------------------------------------------------------------------------------
;;; general
;;; -----------------------------------------------------------------------------------

(deflocal *line-length* 75)

(defun write-message (key message . args)
  (when (eq key ^error) (new-frontend-error))
  (when key
    (let ((header 
           (format nil "~A~@[ in module '~(~A~)'~]"
                   key
                   (if (dynamic *current-module*)
                     (?identifier (dynamic *current-module*))
                     nil))))
      (format t "~%--- ~A ~V{-~}~%~
                 ~@[--- in form ~((~2{~A ~} ...)~)~%~]"
              header
              (- *line-length* (length header) 5)
              '(())
              (dynamic current-defining-form)
              )))
  (format t "~?" message args)
  (when key (format t "~%~V{-~}" *line-length* '(()))))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-main
;;; -----------------------------------------------------------------------------------

(export 
  error-bad-c-import-spec
  error-bad-module-directive 
  error-no-lexical-binding
  error-name-clash
  error-bad-old-style-syntax-import 
  info-old-style-module-header
  error-invalid-syntax
  error-redefinition-of-top-lexical
  error-redefinition-of-imported-lexical
  warning-non-existent-binding-in-interface
  warning-binding-in-import-and-syntax
  )

(defvar error-if-no-lexical-found t)

(defun error-no-lexical-binding (id)
  (when (dynamic error-if-no-lexical-found)
    (write-message ^error "no lexical binding found for ~A" id)) 
  nil)

(defun error-bad-c-import-spec (file)
  (write-message ^error "bad filespec in c-import directive: ~S" file))

(defun error-bad-module-directive (key value)
  (write-message ^error "bad module directive: ~A ~@[~A~]" key value))

(defun error-bad-old-style-syntax-import (import-spec)
  (write-message ^error "bad old style syntax import specification: ~A" import-spec))

(defgeneric error-name-clash (binding1 binding2))
(defmethod error-name-clash (binding1 binding2)
  (write-message ^error "name clash: attempt to import ~A ~@
                         from modules ~A and ~A"
                 (?identifier binding1)
                 (?module-id binding1)
                 (?module-id binding2)))
(defmethod error-name-clash ((binding1 <binding>) (binding2 <binding>))
  (write-message ^error "name clash: attempt to import under ~A~@
                         ~A from ~A and ~@
                         ~A from ~A"
                 (?identifier binding2)
                 (?identifier (finally-refered-object binding1))
                 (?module-id (finally-refered-object binding1))
                 (?identifier (finally-refered-object binding2))
                 (?module-id (finally-refered-object binding2))
                 ))
(defmethod error-name-clash ((binding1 <binding>) binding2)
  (write-message ^error "name clash: attempt to import under ~A~@
                         ~A from ~A and ~@
                         ~A from ~A"
                 (?identifier binding2)
                 (?identifier (finally-refered-object binding1))
                 (?module-id (finally-refered-object binding1))
                 (?identifier binding2)
                 (?module-id binding2)
                 ))
(defmethod error-name-clash (binding1 (binding2 <binding>))
  (error-name-clash binding2 binding1))

(defun warning-non-existent-binding-in-interface (identifier import-spec)
  (write-message ^warning
                 "~A is not available in interface specification:~%~A"
                 identifier import-spec))

(defun warning-binding-in-import-and-syntax (identifier import-spec)
  (write-message ^warning
                 "~A is both import and syntax in interface specification:~
                  ~%~A~
                  ~%using import only"
                 identifier import-spec))

(defmethod info-old-style-module-header (module-def)
  (write-message ^warning "old style module header: ~A"
                 (list (first module-def)
                       (second module-def) ^|...|)))

(defun error-invalid-syntax (syntax expr)
  (write-message ^error "invalid syntax for '~(~A~)' in~%~(~A~)" 
                 (car syntax) expr))

(defun error-redefinition-of-top-lexical (object)
  (write-message ^error 
                 "redefinition of top lexical binding: ~A"
                 (?identifier object)))

(defun error-redefinition-of-imported-lexical (object)
  (write-message ^error 
                 "redefinition of imported lexical binding: ~A"
                 (?identifier object)))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-rules
;;; -----------------------------------------------------------------------------------

(export 
  error-invalid-assignment
  error-invalid-slot-name)

(defun error-invalid-assignment (location)
  (write-message ^error
                 "invalid destination for assignment: ~A" location))

(defun error-invalid-slot-name (class-id slot-id)
  (write-message ^error
                 "invalid slot name ~A for accessing class ~A"
                 slot-id class-id))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-load
;;; -----------------------------------------------------------------------------------
(export 
  error-invalid-module-definition
  warning-differing-names-for-module-and-file
  info-loading-module
  info-module-loaded
  error-cannot-find-file
  error-cannot-load-file
  error-cannot-open-file)

(defun error-invalid-module-definition (object path)
  (write-message ^error "invalid module definition in ~A" path))

(defun warning-differing-names-for-module-and-file (module-name path)
  (write-message ^warning "modulename ~A differs from filename ~A" 
               module-name
               path))

(defvar *load-level* 0)

(defun info-loading-module (path)
  (write-message nil 
                 "~[~;.~:;~%;~V@{.~}loading module ~A~]" 
                 (dynamic *info-level*)
                 (- (dynamic *load-level*) 1) path))

(defun info-module-loaded (module-name)
  (write-message nil
                 "~[~;~;~;~%;~V@{.~}apply module ~A loaded~]" 
                 (dynamic *info-level*)
                 (- (dynamic *load-level*) 1) 
                 module-name))

(defun error-cannot-find-file (name)
  (write-message ^error "can't find Apply module ~A" name))

(defun error-cannot-load-file (path)
  (write-message ^error "can't load Apply module ~A" path))

(defun error-cannot-open-file (path)
  (write-message ^error "can't open Apply module ~A" path))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-classes
;;; -----------------------------------------------------------------------------------

(export 
  error-bad-class-options
  error-mm-type-unknown-at-compile-time
  error-invalid-mm-type
  error-class-equal-lattice-type 
  error-neither-class-nor-lattice-type
  error-redefinition-of-inherited-initarg
  error-invalid-gf-for-add-method)

(defun error-bad-class-options (options)
  (write-message ^error "bad class option in ~A" options))

(defun error-mm-type-unknown-at-compile-time (value)
  (write-message ^error 
                 "Value of ~A must be known at compile time ~
                  when used for class option 'mm-type'" value))

(defun error-invalid-mm-type (value)
  (write-message ^error 
                 "Bad value for class option 'mm-type': ~A" value))

(defun error-class-equal-lattice-type (id)
  (write-message ^error 
                 "A class and a lattice type with the name ~A are found.~
                  Using the class." id))

(defun error-neither-class-nor-lattice-type (id)
  (write-message 
   ^error 
   "Neither a class nor a lattice type with the name ~A are found."
   id))

(defun error-redefinition-of-inherited-initarg (slot inherited-slot initarg)
  (write-message ^error
                 "Attempt to add ~A as new initarg~
                  for slot ~A of class ~A.~
                  The inherited initarg is ~A from class ~A."
                 initarg
                 (~slot-description-name slot)
                 (~class-name (?slot-of slot))
                 (?initarg inherited-slot)
                 (~class-name (?slot-of inherited-slot))
                 ))

(defun error-invalid-gf-for-add-method (x)
  (write-message ^error
                 "~A was given to add-method instead of a generic function"
                 x))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-generic
;;; -----------------------------------------------------------------------------------

(export 
  warn-defgeneric-options-not-analyzed
  error-no-converter 
  error-no-setter
  error-class-required-in-converter-spec
  error-function-required-in-setter-spec
  error-invalid-generic-function-spec
  error-converter-redefinition
  error-setter-redefinition
  )

(defun warn-defgeneric-options-not-analyzed (options)
  (write-message ^warn 
                 "options in defgeneric not yet analyzed: ~A" 
                 options))

(defun error-no-converter (class-def)
  (write-message ^error 
                 "no converter available for class ~(~A [~A]~)" 
                 (?identifier class-def)
                 (?module-id class-def)))

(defun error-no-setter (fun)
  (write-message ^error 
                 "no converter available for function ~(~A [~A]~)" 
                 (?identifier fun)
                 (?module-id fun)))

(defun error-class-required-in-converter-spec (gf-spec)
  (write-message ^error 
                 "a class is required in converter specification ~(~A~)" 
                 gf-spec))

(defun error-function-required-in-setter-spec (gf-spec)
  (write-message ^error 
                 "a function is required in setter specification ~(~A~)" 
                 gf-spec))

(defun error-invalid-generic-function-spec (gf-spec)
  (write-message ^error 
                 "invalid key in generic function specification ~(~A~)" 
                 gf-spec))

(defun error-converter-redefinition (class-def)
  (write-message ^error 
                 "attempt to redefine previously defined converter for ~(~A [~A]~)" 
                 (?identifier class-def)
                 (?module-id class-def)))

(defun error-setter-redefinition (fun)
  (write-message ^error 
                 "attempt to redefine previously defined setter for ~(~A [~A]~)" 
                 (?identifier fun)
                 (?module-id fun)))

;;; -----------------------------------------------------------------------------------
;;; used by eval
;;; -----------------------------------------------------------------------------------

(export
  eval-error-expecting-function
  eval-error-cannot-interpret-function
  eval-error-variable-without-value 
  eval-error-too-few-arguments 
  eval-error-too-many-arguments
  eval-error-undefined-interpreter
  eval-error-special-form-not-implemented)

(defun eval-error-expecting-function (obj)
  (write-message ^error
                 "a function must be given instead of ~A~%during evaluation of~%~A"
                 obj
                 (eval-expr))
  nil)

(defun eval-error-cannot-interpret-function (fun)
  (write-message ^error
                 "cannot interpret function ~A~%during evaluation of~%~A"
                 (?identifier fun)
                 (eval-expr))
  nil)

(defun eval-error-variable-without-value (var)
  (write-message ^error
                 "global binding ~A has an expression as initial value~%during evaluation of~%~A"
                 (?identifier var)
                 (eval-expr))
  nil)

(defun eval-error-too-few-arguments ()
  (write-message ^error "too few arguments~%during evaluation of~%~A"
                 (eval-expr)))

(defun eval-error-too-many-arguments ()
  (write-message ^error "too many arguments~%during evaluation of~%~A"
                 (eval-expr)))

(defun eval-error-undefined-interpreter (identifier)
  (write-message ^error
                 "undefined interpreter ~A"
                 identifier))

(defun eval-error-special-form-not-implemented (id)
  (write-message ^error
                 "Special form '~A' not yet implemented.~
                  (Occured during evaluation of ~A)"
                 id
                 (eval-expr)))

(defun eval-expr ()
  (cons (if (fun-p (dynamic eval-fun))
          (?identifier (dynamic eval-fun))
          (dynamic eval-fun))
        (dynamic eval-args)))

#module-end
