;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: c-typing -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    c-typing.em
Version: 1.5 (last modification on Wed Feb  2 09:13:18 1994)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/c-typing.em[1.5]:
  ensures right typing for C
[1.1] Mon Aug 30 13:52:08 1993 imohr@isst proposed
  collection of GC root addresses simplified
  collection of literals ok
[1.2] Fri Sep  3 12:57:11 1993 imohr@isst proposed
  a hack for %function for funcall
[1.3] Mon Oct 18 13:08:23 1993 imohr@isst published
  [Mon Oct 18 12:57:59 1993] Intention for change:
  correct typing for function applications
[1.4] Wed Jan 19 16:14:22 1994 imohr@isst proposed
  get/set-slot-value
[1.5] Wed Feb  2 09:16:20 1994 imohr@isst published
  [Fri Jan  7 09:21:19 1994] Intention for change:
  + get/set-slot-value

-----------------------------------------------------------------------------------
|#

#module-name c-typing
#module-import
(level-0-eulisp
 list-ext
 lzs
 accessors
 whc-classes
 lzs-mop
 expand-literal
 tail-module
 (only (<tempvar>) mzs) ; to avoid compiler errors
 (only (svref vector
        format 
        make-instance)
   common-lisp))
#module-syntax-import 
(level-0-eulisp
 dynamic
 class-ext)
#module-syntax-definitions

#module-header-end

(export 
  type-expr-for-c type-args-for-c
  <cast> ?expression
  get-type result-type function-signature
  global-var-type
  is-pointer)


(defstandardclass <cast> ()
  (type :reader :initarg)
  (expression :reader :initarg))

(defun type-expr-for-c (type expr)
  (let ((expr-type (get-type expr)))
    (cond ((and (eq type %function)             ; this must be removed if the type
                (eq expr-type %function))       ; specifier (%function <return>)
                                                ; is implemented
           (make-instance <cast> 
             :type type
             :expression expr))
          ((eq expr-type type) expr)
          ((and (dynamic *no-cast-if-compatible-representation*)
                (compatible-representation-p type (?representation type)
                                             expr-type (?representation expr-type)))
           expr)
          ((or (is-subclass expr-type type)
               (is-subclass type expr-type))
           ; this is the only case where different types are not a type error and where
           ; an explicit cast must be inserted because C has no subtypes/subclasses as
           ; in EL
           (make-instance <cast> :type type
                          :expression expr))
          
          (t (format cl:*terminal-io*
                     "~%Error~@[ in function ~A~]: ~
                      ~%mismatching types: required ~A, given ~A~
                      ~%trying a cast to ~A for ~/EXPR/"
                     (if (dynamic *function*)
                       (?identifier (dynamic *function*))
                       nil)
                     (?identifier type)
                     (?identifier expr-type)
                     (?identifier type)
                     expr)
             (make-instance <cast> :type type
                            :expression expr)
             ))))

(defun is-subclass (class superclass)
  (member class (~class-precedence-list superclass)))

(defgeneric compatible-representation-p (class1 rep1 class2 rep2))

(defmethod compatible-representation-p (class1 rep1 class2 rep2)
  nil)

(defmethod compatible-representation-p (class1 (rep1 <%direct>) 
                                        class2 rep2)
  (setq class1 
        (~slot-description-type (car (~class-slot-descriptions class1))))
  (compatible-representation-p class1 (?representation class1)
                               class2 rep2))

(defmethod compatible-representation-p (class1 rep1 
                                        class2 (rep2 <%direct>))
  (setq class2 
        (~slot-description-type (car (~class-slot-descriptions class2))))
  (compatible-representation-p class1 rep1
                               class2 (?representation class2)))

(defmethod compatible-representation-p (class1 (rep1 <%pointer>) 
                                        class2 (rep2 <%pointer-to-void>))
  t)

(defmethod compatible-representation-p (class1 (rep1 <%pointer-to-void>) 
                                        class2 (rep2 <%pointer>))
  t)

(defgeneric get-type (expr))

(defmethod get-type (expr)
  (?class (expand-literal expr)))

;*5*
(defmethod get-type ((var <static>))
  (var-type var))

(defmethod get-type ((var <tempvar>))
  ;!!! it is an error if a tempvar appears
  (var-type var))

(defmethod get-type ((var <var-ref>))
  (var-type (?var var)))

(defgeneric var-type (var))
(defmethod var-type (var) %object) ; handles bad and not yet recognized cases
(defmethod var-type ((var <var>)) 
  (or (?type var) %object))

(defmethod get-type ((call <app>))
  (if (special-sys-fun-p (?function call))
    (result-type call)                  ; use the inferred type because of
                                        ; overloading 
    (result-type (?function call))))    ; use the declared type

(defmethod get-type ((const <named-const>))
  (or (?type const) %object))

(defmethod get-type ((form <setq-form>))
  (get-type (?location form)))

(defmethod get-type ((form <get-slot-value>))
  (~slot-description-type (?slot form)))

(defmethod get-type ((form <set-slot-value>))
  (~slot-description-type (?slot form)))

(defun result-type (expr)
  (svref (or (?type-descr expr)
             (range-and-domain expr)
             (vector %object %object %object %object %object %object %object
                     %object %object)) 
         0))

(defun type-args-for-c (signature args)
  (type-args-1 signature args 1))

(defun type-args-1 (signature args i)
  (if (null args) nil
      (cons (type-expr-for-c (svref signature i)
                             (first args))
            (type-args-1 signature (rest args) (+ i 1)))))

(defun function-signature (fun)
  (or (?type-descr fun)
      ; if the type-descr is (), which is an error *9*
      (range-and-domain fun)
      (vector %object %object %object %object %object %object %object %object %object)))

(defun range-and-domain (fun) ;*9*
  (map (lambda (type)
         (if (named-const-p type) 
           (?value type)
           type))
       (?range-and-domain fun)))

(defun global-var-type (var)
  (or (?type var)
      (setf (?type var) 
            (if (and (named-const-p var)
                     (null (eq (?value var) ^unknown)))
              (~class-of (?value var))
              %object))))

(defgeneric is-pointer (representation-or-class))

(defmethod is-pointer ((class <class-def>))
  (is-pointer (?representation class)))

(defmethod is-pointer ((representation <%pointer>)) t)

(defmethod is-pointer (representation) nil)


#module-end
