;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: apply-compiler -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: The Main Part of the APPLY-Compiler
-----------------------------------------------------------------------------------
File:    apply-compiler.em
Version: 1.58 (last modification on Thu Feb  3 15:45:42 1994)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/apply-compiler.em[1.58]:
  compile-application
[1.1] Fri Apr  2 16:02:17 1993 imohr@isst proposed
  [Fri Apr  2 15:08:06 1993] Intention for change:
  + automatic load of standard-modules TAIL and APPLY
[1.2] Fri Apr  2 17:36:00 1993 hfried@isst proposed
  [Fri Apr  2 16:43:55 1993] Intention for change:
  Add MZS
  MZS added
[1.3] Mon Apr  5 14:47:56 1993 wheick@isst proposed
  [Mon Apr  5 14:27:41 1993] Intention for change:
  removing package qualifiers
[1.4] Tue Apr  6 13:33:29 1993 akind@isst saved
  [Tue Apr  6 12:12:25 1993] Intention for change:
  Initialization of the lattice included (*ak*).
[1.5] Wed Apr  7 09:38:36 1993 imohr@isst proposed
  [Wed Apr  7 09:16:24 1993] Intention for change:
  + initialize for predefined classes
[1.6] Wed Apr  7 15:54:09 1993 rrosen@isst saved
  [Wed Apr  7 15:23:12 1993] Intention for change:
  asm Anschluss
[1.7] Thu Apr 15 08:44:28 1993 imohr@isst saved
  [Thu Apr 15 08:24:57 1993] Intention for change:
  split dynamic initialization into apply and apply-level-1
  ok.
[1.8] Thu Apr 15 14:43:53 1993 wheick@isst saved
  [Thu Apr 15 14:17:31 1993] Intention for change:
  insert asm
[1.9] Fri Apr 16 17:14:49 1993 hfried@isst proposed
  [Fri Apr 16 15:02:22 1993] Intention for change:
  compile all modules
  compiled all modules
[1.10] Fri Apr 16 17:34:08 1993 akind@isst proposed
  [Fri Apr 16 17:31:04 1993] Intention for change:
  New initialization for type inference.
[1.11] Mon Apr 26 11:44:27 1993 rrosen@isst saved
  [Tue Apr 20 11:57:21 1993] Intention for change:
  stream fuer asm-ausgabe
[1.12] Tue Apr 27 13:54:29 1993 ukriegel@isst saved
  [Tue Apr 27 12:52:08 1993] Intention for change:
  add generate-header-file
  done
[1.13] Fri Apr 30 17:20:57 1993 imohr@isst saved
  [Fri Apr 30 16:28:20 1993] Intention for change:
  + collection of static instances for symbols
  ok, but collection not yet activated
[1.14] Mon May  3 07:40:05 1993 ukriegel@isst saved
  [Fri Apr 30 17:33:23 1993] Intention for change:
  level 2 included
[1.15] Mon May  3 13:40:45 1993 ukriegel@isst proposed
  [Mon May  3 10:40:50 1993] Intention for change:
  *print-circle*
  done
[1.16] Mon May  3 15:47:50 1993 imohr@isst proposed
  ok
[1.17] Wed May  5 11:23:33 1993 ukriegel@isst proposed
  [Wed May  5 11:12:54 1993] Intention for change:
  handle case og empty string
  done
[1.18] Thu May  6 06:56:02 1993 ukriegel@isst proposed
  [Thu May  6 06:54:10 1993] Intention for change:
  param for generate-header-file
  done
[1.19] Thu May  6 14:09:53 1993 wheick@isst proposed
  [Thu May  6 14:07:08 1993] Intention for change:
  new extension for asm file is .s (for cc)
[1.20] Tue May 11 13:41:45 1993 imohr@isst saved
  error when marking exported things removed
[1.21] Tue May 11 14:17:17 1993 imohr@isst saved
  now the result of compile-application is a list of modules in every case
[1.22] Tue May 11 16:28:20 1993 imohr@isst proposed
  importing marking-as-exported from el2lzs-main because import from el2lzs
  goes wrong
[1.23] Thu May 13 09:17:48 1993 ukriegel@isst saved
  [Thu May 13 09:14:28 1993] Intention for change:
  load-path for am-modules
[1.24] Wed May 19 15:46:41 1993 imohr@isst saved
  [Tue May 18 10:45:57 1993] Intention for change:
  + simple code generator
  ok
[1.25] Wed May 19 15:55:33 1993 ukriegel@isst proposed
  [Wed May 19 15:47:42 1993] Intention for change:
  reset-data-code-collectors
  done
[1.26] Thu May 27 10:09:57 1993 akind@isst proposed
  [Wed May 26 14:30:44 1993] Intention for change:
  Add generate-def-file.
  Added generate-def-file.
[1.27] Thu May 27 10:27:24 1993 ukriegel@isst saved
  [Thu May 27 10:20:37 1993] Intention for change:
  lower case file names
  done
[1.28] Thu May 27 13:25:28 1993 ukriegel@isst proposed
  [Thu May 27 11:45:48 1993] Intention for change:
[1.29] Wed Jun  2 13:37:44 1993 ukriegel@isst proposed
  [Wed Jun  2 13:31:10 1993] Intention for change:
  ini.label-index
  done
[1.30] Thu Jun  3 17:38:11 1993 imohr@isst proposed
  [Wed Jun  2 16:20:33 1993] Intention for change:
  right handling of symbols
[1.31] Fri Jun 25 08:27:58 1993 hfried@isst proposed
  [Wed Jun 23 15:02:35 1993] Intention for change:
  add mzs2lzs-module
  + mzs2lzs
[1.32] Fri Jun 25 13:45:29 1993 hfried@isst proposed
  [Fri Jun 25 13:23:50 1993] Intention for change:
[1.33] Tue Jul  6 11:42:50 1993 ukriegel@isst proposed
  initialization of mm-initialize added
[1.34] Thu Aug  5 09:37:15 1993 imohr@isst proposed
  [Mon Jul 19 08:33:07 1993] Intention for change:
  + c-code generation
  C-code generation
[1.35] Wed Aug 11 13:38:57 1993 akind@isst proposed
  [Wed Aug 11 10:42:22 1993] Intention for change:
  reset-funs-with-defined-signatures
[1.36] Wed Aug 18 16:11:35 1993 akind@isst proposed
  [Thu Aug 12 15:49:50 1993] Intention for change:
  print out ti statistics
[1.37] Fri Aug 20 08:18:37 1993 ukriegel@isst saved
  [Thu Aug 19 15:14:48 1993] Intention for change:
  unintern *code-cenereration* -> comment
  include apply-configuration
[1.38] Fri Aug 20 08:20:10 1993 ukriegel@isst proposed
  [Fri Aug 20 08:19:48 1993] Intention for change:
  wanted a fetch
[1.39] Wed Aug 25 15:35:47 1993 ukriegel@isst proposed
  [Wed Aug 25 08:42:46 1993] Intention for change:
  configuration?
  done
[1.40] Fri Aug 27 11:55:00 1993 imohr@isst proposed
  [Fri Aug 27 09:48:12 1993] Intention for change:
  move initialization of predefined standard classes after apply-level-1
[1.41] Fri Aug 27 17:11:51 1993 akind@isst proposed
  [Fri Aug 27 16:13:31 1993] Intention for change:
  
    (reset-lattice-type-values)
[1.42] Mon Aug 30 13:52:32 1993 imohr@isst saved
  [Mon Aug 30 09:23:21 1993] Intention for change:
  + reset-literals
[1.43] Wed Sep  1 18:07:35 1993 imohr@isst published
  [Tue Aug 31 08:38:25 1993] Intention for change:
  static initialization of basic classes
[1.44] Wed Sep 15 11:56:55 1993 imohr@isst proposed
  [Tue Sep 14 16:22:59 1993] Intention for change:
  + installing dispatch functions in generic functions (separate pass)
[1.45] Tue Sep 21 13:04:23 1993 rrosen@isst saved
  [Mon Sep 20 15:33:51 1993] Intention for change:
  funktional strukturieren fue statistik
  done
[1.46] Tue Sep 28 08:14:00 1993 imohr@isst proposed
  [Fri Sep 24 11:14:46 1993] Intention for change:
  deactivate asm-code generation
[1.47] Thu Sep 30 16:13:59 1993 imohr@isst proposed
  [Thu Sep 30 16:12:00 1993] Intention for change:
  deactivate generate-def/h-file
[1.48] Tue Oct  5 13:29:35 1993 akind@isst proposed
  [Tue Oct  5 13:26:43 1993] Intention for change:
  move ti-print-statistics
[1.49] Thu Oct  7 12:43:13 1993 ukriegel@isst proposed
  [Thu Oct  7 09:38:56 1993] Intention for change:
  load first tail-error.am
  done
[1.50] Wed Oct 13 15:02:10 1993 ukriegel@isst proposed
  [Wed Oct 13 15:00:36 1993] Intention for change:
  exclude load tail-error.am
  done
[1.51] Tue Oct 19 18:07:36 1993 hfried@isst proposed
  [Tue Oct 19 08:22:42 1993] Intention for change:
  ausschrift
[1.52] Wed Oct 20 14:02:11 1993 imohr@isst published
  [Wed Oct 20 09:28:47 1993] Intention for change:
  exit if frontend errors were detected
[1.53] Thu Nov 18 14:47:24 1993 ukriegel@isst saved
  [Thu Nov 18 14:36:29 1993] Intention for change:
  new module syntax
[1.54] Fri Nov 19 13:41:26 1993 ukriegel@isst proposed
  [Thu Nov 18 15:04:42 1993] Intention for change:
  new syntax
[1.55] Fri Nov 26 11:09:14 1993 ukriegel@isst proposed
  [Fri Nov 26 10:56:56 1993] Intention for change:
  call init-configuration-table
[1.56] Tue Dec  7 17:05:45 1993 imohr@isst proposed
  [Tue Dec  7 15:16:18 1993] Intention for change:
  frontend-info-level -> *info-level*
[1.57] Wed Jan 26 13:51:30 1994 akind@isst proposed
  [Fri Jan 21 09:21:10 1994] Intention for change:
  --- no intent expressed ---
[1.58] Mon Feb  7 08:24:43 1994 imohr@isst published
  [Wed Jan 26 13:57:36 1994] Intention for change:
  basic-system compilation
  new slot access and imported classes ok
 

-----------------------------------------------------------------------------------
|#

#module apply-compiler
(import (level-1-eulisp
         lzs
         generate-header-file
         generate-def-file
         mzs-to-lzs ; mzs2lzs-4-modules (modul-list), (dynamic *assembler-code-generated*)
         (only (configurationp init-configuration-table) configuration)
         (only (ti-initialize update-all-type-expr-codes) ti-init)
         (only (expand-all-lattice-type-literals) ti-lattice)
         (only (ti-print-statistics) ti)
         (only (module-env $tail-module find-module load-module) 
           el2lzs)
         (only (reset-%tail) 
           tail-module)
         (only (mark-as-exported reset-environments) 
           el2lzs-main) ; because importing from el2lzs doesn't function
         (only (reset-literals) expand-literal)
         (only (reset-literal-expanders) el2lzs-literals)
         (only (*frontend-errors* reset-frontend-errors) el2lzs-error)
         (only (initialize-predefined-standard-classes
                initialize-predefined-standard-classes-part-2
                initialize-static-instance-collectors 
                set-static-instance-collectors
                ) lzs-class-init)
         (only (reset-code-identifier) code-identifier)
         (only (init-mm-initialize) mm-initialize)
         (only (reset-generic-dispatch set-discriminating-functions) generic-dispatch)
         (only (set-apply-objects set-apply-level-1-objects set-apply-level-2-objects) 
           apply-funs)
         (only (*compilation-type*) predicates)
         (only (mapc format unintern import find-package intern funcall symbol-function 
                     find-symbol string find-package
                     *print-circle* *print-pretty* string-downcase) 
           common-lisp)
         
         ;;; lzs2mzs ; - is a comment, because Ingo will not always load all my files -
         ;;; (only (mzs2asm) mzs2asm) ; - is a comment, bcause Horst will not load all
         ;;; files from Rainer
         ;;; --- Horst 
         )
 syntax 
        (level-1-eulisp
         (only (return-from when make-pathname open) 
           common-lisp))
        
        
 export 
        (compile-application  compilation-state))

(deflocal compilation-state nil)

(defmacro call-module-function (module-name function-name . args)
  `(funcall (symbol-function (find-symbol ,(string function-name)
                                          (find-package ,(string module-name))))
            ,@args))

;;; -----------------------------------------------------------------------------------
;;; main function to compile
;;; -----------------------------------------------------------------------------------

(defun compile-application (module-name . basic-system)
  (when basic-system (setq basic-system (car basic-system)))
  (compile :application module-name basic-system))

(defun compile-basic-system (module-name . basic-system)
  (when basic-system (setq basic-system (car basic-system)))
  (compile :basic-system module-name basic-system))

(defun compile (compilation-type module-name basic-system)
  ; module-name may be a symbol, a string interpreted as a load path or the empty
  ; string (on Mac only) where a file dialog appears

  (setq *compilation-type* compilation-type)

  ;;initialize configuration-table 
  (init-configuration-table)
  
  (let (module)                         ;module contains the main module
    
    (format t "~2%--- resetting the compiler ---~%")
    (reset-compiler)
    
    (format t "~%--- loading basic modules ---~%")
    (load-basic-modules basic-system)

    (when (eq compilation-state ^init) 
      (return-from compile module-env))
    
    (format t "~%--- loading application modules ---~%")
    (setq module (load-application-modules module-name))
    
    (when (> *frontend-errors* 0)
      (return-from compile nil))

    (format t "~%--- marking all exported bindings ---~%")
    (mark-as-exported (?exports module))
    
    (when (eq compilation-state ^load) 
      (return-from compile module-env))
    
    (format t "~%--- computing discriminating functions ---~%")
    (computing-discriminating-functions module-env)

    ; now the deflocal-variable module-env (module el2lzs) contains the list of
    ; all direct or indirect loaded application modules
    
    (format t "~%--- converting to MZS ---~%")
    
    ;; Signatures are read in before all defined types are included into the
    ;; lattice. Thus before inference starts the type expression codes have to
    ;; be updated.
    (update-all-type-expr-codes)
    
    ;; After the literal expander are defined the collected literals in the 
    ;; lattice type definitions (%define-latticef-type ...) can be expanded.
    (expand-all-lattice-type-literals)
    
    (call-module-function lzs2mzs lzs2mzs module-env)
    
    (when (eq compilation-state ^mzs) 
      (return-from compile module-env))
    
    ; remember: now the variable module contains a list
    
    (format t "~%--- collecting static instances ---~%")
    (set-static-instance-collectors module-env)
    
    (format t "~%--- converting MZS to LZS ---~%")
    (mzs2lzs-4-modules module-env)
    ; (call-module-function mzs2lzs-4-modules mzs-to-lzs module-env)
    (format t "~%--- generating C-code ---~%")
    (call-module-function code-generator generate-code 
                          module module-env)
    
    #| deactivated because of an error for list identifiers
    (format t "~%--- generating .def- and .h-files ---~%")
    (generate-header-file module)
    (generate-def-file module)
    |#
    (format t "~%--- end of compilation ---~%")
    
    ;; Print out type inference statistics if debugging::ti-verbose is set.
    (ti-print-statistics)

    module-env
    "end of compilation"
    ))

;;; -----------------------------------------------------------------------------------
;;; 
;;; -----------------------------------------------------------------------------------

(defun reset-compiler ()
  (reset-frontend-errors)
  (reset-%tail)
  (ti-initialize)			; initialization of the type inference
  (reset-environments)
  (reset-literals)
  (reset-literal-expanders)
  (initialize-static-instance-collectors)
  (reset-code-identifier)
  (reset-generic-dispatch)
  (initialize-predefined-standard-classes)
  )

(defun load-basic-modules (basic-system)
  (dynamic-let ((*info-level* (dynamic *system-info-level*)))
    (if (null basic-system)
      (progn 
        (load-module ^apply-level-1)		; load the most basic things
        (set-apply-level-1-objects)		; provide basic things to the compiler
        
        (init-mm-initialize)
        (initialize-predefined-standard-classes-part-2)
        
        (load-module ^apply-level-2)		; load def of <cons>, now predicates can be constructed
        (set-apply-level-2-objects)		; provide secons layer of basic things
        (load-module ^tail)			; load modules apply and tail
        (set-apply-objects)			; binds some variables with objects
                                                ; available in apply.am)
        )
      (progn
        )
      )))

(defun load-application-modules (module-name)
  (load-module module-name))

(defun computing-discriminating-functions (module-env)
  (mapc #'set-discriminating-functions module-env))

#module-end





