;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-meet-join -*-
#|
-------------------------------------------------------------------------------
TITLE: Operations on Type Expressions for Type Inference
-------------------------------------------------------------------------------
File:    ti-meet-join.em
Version: 1.22 (last modification on Thu Sep 30 13:31:47 1993)
State:   save

DESCRIPTION:
This module includes functions to meet and join type expressions.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/akind/Lisp/ti-meet-join.em[1.0]
	Tue Apr  6 13:23:03 1993 akind@isst save $
 
ti-meet-join.em[1.1] Wed Apr  7 09:06:15 1993 akind@isst proposed $
 
ti-meet-join.em[1.2] Fri Apr 16 18:18:15 1993 akind@isst proposed $
 
ti-meet-join.em[1.3] Mon Apr 19 18:04:41 1993 akind@isst proposed $
 
ti-meet-join.em[1.4] Tue Apr 20 17:37:34 1993 akind@isst proposed $
 
ti-meet-join.em[1.5] Wed Apr 21 16:38:43 1993 akind@isst proposed $
 
ti-meet-join.em[1.6] Wed May  5 11:25:42 1993 akind@isst save $
 
ti-meet-join.em[1.7] Thu May  6 17:27:49 1993 akind@isst proposed $
 
ti-meet-join.em[1.8] Wed May 19 11:10:44 1993 akind@isst save $
 
ti-meet-join.em[1.9] Wed May 19 13:10:56 1993 akind@isst proposed $
 
ti-meet-join.em[1.10] Tue Jun  1 17:45:05 1993 akind@isst proposed $
 
ti-meet-join.em[1.11] Wed Jun  2 17:11:25 1993 akind@isst proposed $
 
ti-meet-join.em[1.12] Thu Jun  3 11:17:53 1993 akind@isst proposed $
 
ti-meet-join.em[1.13] Tue Aug  3 11:47:13 1993 akind@isst proposed $
 
ti-meet-join.em[1.14] Mon Aug  9 16:11:44 1993 akind@isst proposed $
 
ti-meet-join.em[1.15] Wed Aug 11 13:35:05 1993 akind@isst proposed $
 
ti-meet-join.em[1.16] Wed Aug 18 16:16:28 1993 akind@isst proposed $
 
ti-meet-join.em[1.17] Fri Aug 20 14:21:04 1993 akind@isst proposed $
 
ti-meet-join.em[1.18] Wed Aug 25 17:39:05 1993 akind@isst proposed $
 
ti-meet-join.em[1.19] Fri Aug 27 17:30:00 1993 akind@isst proposed $
 
ti-meet-join.em[1.20] Mon Aug 30 09:13:17 1993 akind@isst published $
 
ti-meet-join.em[1.21] Thu Sep 23 14:33:27 1993 akind@isst proposed $
 
ti-meet-join.em[1.22] Fri Oct  1 14:41:38 1993 akind@isst save $
 [Thu Sep 23 15:44:26 1993] Intention for change:
 

-------------------------------------------------------------------------------
|#


#module-name ti-meet-join
#module-import (ti ti-codes ti-lattice ti-exprs
		   (only (format) common-lisp))
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT meet-type-exprs
	meet-type-exprs-p
	subtype-expr-p
	join-type-exprs
	joined-type-exprs
	eval-to-expr
	eval-to-atom
	compute-to-atom
	normalize-atomic-type
	complement-type-expr-of-lattice-type
	not-%false-type)

;;; ---------------------------------------------------------------------------
;;; MEET TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------

(DEFGENERIC meet-type-exprs (expr1 expr2))

(DEFMETHOD meet-type-exprs ((expr1 <type-expr>)
			    (expr2 <type-expr>))
  (ti-format t "~%Warning: subclass responsibility")
  (ti-error)
  (general-type))
	 
(DEFMETHOD meet-type-exprs ((expr1 <atomic-type>)
			    (expr2 <atomic-type>))
  (let ((code1 (?code expr1))
	(code2 (?code expr2)))
    (cond ((general-type-p expr1) expr2)
	  ((general-type-p expr2) expr1)
	  ((complement-codes-p code1 code2) nil)
	  ((subcode-p code1 code2) expr1)
	  ((subcode-p code2 code1) expr2)
	  (t 
	   (let ((new-code (meet-codes (?code expr1) (?code expr2))))
	     (if (bottom-code-p new-code)
		 nil
	       (make <atomic-type>
		     :code new-code
		     :name (list ^and (?name expr1) (?name expr2))
		     :comp-name (or (?comp-name expr1) (?comp-name expr2)))))))))

(DEFMETHOD meet-type-exprs ((expr1 <slot-id>)
			    (expr2 <slot-id>))
  (if (eq (?slot-name expr1) (?slot-name expr2))
      expr1
    nil))
	 
(DEFMETHOD meet-type-exprs ((expr1 <slot-id>)
			    (expr2 <atomic-type>))
  (if (or (general-type-p expr2)
	  (%object-type-p expr2))
      expr1 nil))
	 
(DEFMETHOD meet-type-exprs ((expr1 <atomic-type>)
			    (expr2 <slot-id>))
  (meet-type-exprs expr2 expr1))

;;; ---------------------------------------------------------------------------
;;; Answer whether a type expr meets another.
;;; ---------------------------------------------------------------------------

(DEFGENERIC meet-type-exprs-p (expr1 expr2))
	 
(DEFMETHOD meet-type-exprs-p ((expr1 <type-expr>)
			      (expr2 <type-expr>))
  (meet-type-exprs expr1 expr2))
	 
(DEFMETHOD meet-type-exprs-p ((expr1 <atomic-type>)
			      (expr2 <atomic-type>))
  (meet-codes-p (?code expr1) (?code expr2)))

;;; ---------------------------------------------------------------------------
;;; Answer whether a type expr is subtype of another.
;;; ---------------------------------------------------------------------------

(DEFGENERIC subtype-expr-p (expr1 expr2))

(DEFMETHOD subtype-expr-p ((expr1 <type-expr>)
			   (expr2 <type-expr>))
  nil)

(DEFMETHOD subtype-expr-p ((expr1 <atomic-type>)
			   (expr2 <atomic-type>))
  (subcode-p (?code expr1) (?code expr2)))

(DEFMETHOD subtype-expr-p ((expr1 <slot-id>)
			   (expr2 <slot-id>))
  (eq (?slot-name expr1) (?slot-name expr2)))

;;; ---------------------------------------------------------------------------
;;; Join type expressions
;;; ---------------------------------------------------------------------------

(DEFGENERIC join-type-exprs (expr1 expr2))

(DEFMETHOD join-type-exprs ((expr1 <type-expr>)
			    (expr2 <type-expr>))
  (ti-format t "~%Warning: subclass responsibility")
  (ti-error)
  (general-type))
	 
(DEFMETHOD join-type-exprs ((expr1 <atomic-type>)
			    (expr2 <atomic-type>))
  (let ((code1 (?code expr1))
	(code2 (?code expr2)))
    (cond ((or (general-type-p expr1) (general-type-p expr2)) (general-type))
	  ((complement-codes-p code1 code2) (general-type))
	  ((subcode-p code1 code2) expr2)
	  ((subcode-p code2 code1) expr1)
	  (t
	   (let ((new-code (join-codes code1 code2)))
	     (make <atomic-type>
		   :code new-code
		   :name (list ^or (?name expr1) (?name expr2))
		   :comp-name (or (?comp-name expr1) (?comp-name expr2))))))))

(DEFMETHOD join-type-exprs ((expr1 <slot-id>)
			    (expr2 <type-expr>))
  (if (or (general-type-p expr2)
	  (%object-type-p expr2))
      expr1 expr2))
  
(DEFMETHOD join-type-exprs ((expr1 <type-expr>)
			    (expr2 <slot-id>))
  (join-type-exprs expr2 expr1))

(DEFMETHOD join-type-exprs ((expr1 <slot-id>)
			    (expr2 <slot-id>))
  (cond ((eq (?slot-name expr1) (?slot-name expr2))
	 expr1)
	(t 
	 (ti-format t "~%Warning: can't join different slot names")
	 (ti-error)
	 expr1)))

(DEFUN joined-type-exprs (exprs)
  (let ((result (car exprs)))
    (dolist (expr (cdr exprs))
      (setq result (join-type-exprs expr result)))
    result))

;;; ---------------------------------------------------------------------------
;;; Creating type expressions.
;;; ---------------------------------------------------------------------------

(DEFUN eval-to-expr (def-list)
  (let ((op-symbol (car def-list))
	(arg-def (cdr def-list)))
    (cond ((eq ^var op-symbol)		; VAR
	   (make <type-var> :id (car arg-def)))
	  ((eq ^atom op-symbol)		; ATOM
	   (eval-to-atom (car arg-def)))
	  (t				; undefined
	   (format t "~%Warning: no correct definition of a type expression")
	   (ti-error)
	   (general-type)))))

;;; Convert lists like ^(and (not <integer>) <null>) to atoms.
(DEFUN eval-to-atom (def-list)
  (compute-to-atom (convert-def-list-to-expr-name def-list)))

;;; Convet lists like ^(and (not <integer>) <null>) to (^and (^not #..) #..).
(DEFUN convert-def-list-to-expr-name (def-list)
  (if (consp def-list)
      (cons (car def-list)
	    (mapcar #'convert-def-list-to-expr-name (cdr def-list)))
    (find-lattice-type def-list)))

;;; Convert lists like (^and (^not #..) #..) to atoms.
(DEFUN compute-to-atom (name)
  (if (consp name)			; nested?
      (let ((op-symbol (car name)))
	(if (eq ^not op-symbol)		; NOT
	    (complement-type-expr-of-lattice-type (car (cdr name)))
	  (let ((subatom1 (compute-to-atom (car (cdr name))))
		(subatom2 (compute-to-atom (car (cdr (cdr name))))))
	    (cond ((eq ^and op-symbol)	; AND
		   (meet-type-exprs subatom1 subatom2))
		  ((eq ^or op-symbol)	; OR
		   (join-type-exprs subatom1 subatom2))
		  (t
		   (format t "~%Warning: no correct definition of an atomic type")
		   (general-type))))))
    (lattice-type-to-atomic-type name)))

;; Answer a a corresponding complement type expr of a lattice type.
(DEFUN complement-type-expr-of-lattice-type (name)
  (if (consp name)			;nested?
      (progn
	(format t "~%Warning: operator NOT only to atomic types! ~A" name)
	(ti-error)
	(general-type))			; continue with general type
    (make <atomic-type>
	  :code (complement-code (?code name))
	  :name (list ^not name)
	  :comp-name (?compound name))))

;;; ---------------------------------------------------------------------------

(DEFUN not-%false-type ()
  (compute-to-atom (list ^not *%false*)))

;;; ---------------------------------------------------------------------------
;;; EASY CHECK OF TYPE EXPRESSION OPERATIONS
;;; ---------------------------------------------------------------------------

;;(defun ti-and (expr1 expr2)
;;  (meet-type-exprs (compute-to-atom (get-lattice-type expr1))
;;		   (compute-to-atom (get-lattice-type expr2))))
;;
;;(defun ti-or (expr1 expr2)
;;  (join-type-exprs (compute-to-atom (get-lattice-type expr1))
;;		   (compute-to-atom (get-lattice-type expr2))))
;;
;;(defun ti-not (expr)
;;  (join-type-exprs (compute-to-atom (list ^not (get-lattice-type expr)))))

#module-end