;;;-*- Mode: Lisp; Package: quasiquote -*-
;;; -----------------------------------------------------------------------------------
;;; TITEL: backquote from feel for apply
;;; -----------------------------------------------------------------------------------
;;; FILENAME: quasiquote.em

;;; begin quasiquote.em

#module-name quasiquote

#module-import
(level-1-eulisp
 (only (CADAR
        CADR
        ERROR
        STRINGP
        append)
   common-lisp)
)

#module-syntax-import
(level-1-eulisp)

#module-syntax-definitions

#module-header-end

(export unquote-constructor)


;; Quasi-quoting

(defun unquote-constructor (x)
  (cond ((atom x) 
	 (cond ((or (null x) (numberp x) (stringp x) (eq x t)) x)
	       (t (mkquote x))))
	
	((eq (car x) ^unquote) (cadr x))
	((eq (car x) ^unquote-splicing) 
	 (error "Illegal use of ,@ marker"))
	((eqcar (car x) ^unquote-splicing)
	 (list ^append (cadar x) (unquote-constructor (cdr x))))
;;	((contains-no-unquote x) (mkquote x))
	(t (list ^cons 
		 (unquote-constructor (car x))
		 (unquote-constructor (cdr x))))))

(defun contains-no-unquote (x)
  (cond ((atom x) t)
	((or (eq (car x) ^unquote) (eq (car x) ^unquote-splicing))
	 nil)
	(t (and (contains-no-unquote (car x))
		(contains-no-unquote (cdr x))))))

(defun mkquote (x) (list ^quote x))

(defun eqcar (a b) (cond ((atom a) nil) ((eq (car a) b) t) (t nil)))

;; (defmacro quasiquote (dummy form) (unquote-constructor form))


;(defmacro quasiquote (skel) (unquote-constructor skel))
