;;;-*- Mode: Lisp; Package: COMMON-LISP-USER -*-

;;;To access the export-list of an eulisp-module use the function module-exports
;;;(package el-modules). Usage: see importation from module el2lzs.

(in-package 'user)

(import '(el-modules::module-exports ;(module-name)
          el-modules::module-syntax-exports ;(module-name)
          el-modules::describe-modules ;()
          el-modules::describe-module ;(module-name)
          el-modules::module-hierarchy ;(module-name [:used | :dependent])
          el-modules::find-eulisp-module ;(module-name)
          ))

(import (module-exports (find-eulisp-module 'el2lzs)))
; this provides:
;
; (find-module module-id)
; (find-lexical module-id binding-id)
; (load-module [module-id | path | ""])    {"" on Mac only}
; (pp-module module-id)
; module-env; variable containing all modules of the recently compiled application
;
; !!!attention: the module-id and the function-id must be Eulisp-Symbols, i.e.
; as constants they must be given as ^name

(shadowing-import (module-syntax-exports (find-eulisp-module ^dynamic)))
; this provides the dynamic-Special-Forms of Eulisp

(import (module-exports (find-eulisp-module 'apply-compiler)))

#+:APPLE
(require-eulisp-module 'pplzs)

