;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: generic-dispatch -*-
#|
-----------------------------------------------------------------------------------
TITLE: Computation of Method Lookup and Generic Dispatch at Compile Time
-----------------------------------------------------------------------------------
File:    generic-dispatch.em
Version: 1.13 (last modification on Wed Oct 20 10:17:01 1993)
State:   proposed

DESCRIPTION:


DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS: error methods and gf with no methods

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/hfried/Lisp/Apply/generic-dispatch.em[1.0]
	Wed Sep 15 11:58:47 1993 imohr@isst save $
 computation of dispatch functions and method lookup functions
 
generic-dispatch.em[1.1] Wed Sep 15 17:19:23 1993 imohr@isst save $
 [Wed Sep 15 14:43:10 1993] Intention for change:
 + discrimination-depth
 
generic-dispatch.em[1.2] Thu Sep 16 09:27:22 1993 imohr@isst proposed $
 minor errors removed in compute-discrimination-depth
 
generic-dispatch.em[1.3] Mon Sep 27 09:42:37 1993 hfried@isst proposed $
 [Wed Sep 22 09:15:03 1993] Intention for change:
 multiple Arguments
 
generic-dispatch.em[1.4] Tue Sep 28 08:13:51 1993 hfried@isst proposed $
 [Mon Sep 27 11:13:22 1993] Intention for change:
 add special disrc-function
 discr.-vars
 
generic-dispatch.em[1.5] Wed Sep 29 14:49:36 1993 hfried@isst proposed $
 [Tue Sep 28 10:29:35 1993] Intention for change:
 dispatch function for few arguments
 
generic-dispatch.em[1.6] Wed Sep 29 15:44:20 1993 hfried@isst proposed $
 [Wed Sep 29 15:42:01 1993] Intention for change:
 body error
 
generic-dispatch.em[1.7] Thu Sep 30 15:03:12 1993 imohr@isst proposed $
 [Thu Sep 30 11:13:03 1993] Intention for change:
 set identifiers right
 
generic-dispatch.em[1.8] Fri Oct  8 10:11:15 1993 hfried@isst proposed $
 [Fri Oct  1 10:37:48 1993] Intention for change:
 new tree
 
generic-dispatch.em[1.9] Mon Oct 11 16:31:12 1993 hfried@isst proposed $
 [Mon Oct 11 16:29:21 1993] Intention for change:
 signature of std
 
generic-dispatch.em[1.10] Fri Oct 15 07:41:46 1993 hfried@isst proposed $
 [Wed Oct 13 15:44:50 1993] Intention for change:
 + no-applicable-method-error
 
generic-dispatch.em[1.11] Mon Oct 18 17:48:18 1993 hfried@isst proposed $
 [Mon Oct 18 13:01:06 1993] Intention for change:
 call-next-method
 
generic-dispatch.em[1.12] Tue Oct 19 18:08:40 1993 hfried@isst proposed $
 [Tue Oct 19 17:06:33 1993] Intention for change:
 generic-function without methods
 
generic-dispatch.em[1.13] Wed Oct 20 10:51:50 1993 hfried@isst proposed $
 [Wed Oct 20 08:11:41 1993] Intention for change:
 one Method
 

-----------------------------------------------------------------------------------
|#

#module-name generic-dispatch
#module-import
(level-0-eulisp
 apply-standard
 accessors
 lzs
 lzs-mop
 el2lzs-rules
 tail-module ; %funcall
 apply-funs ; %class-of no-applicable-method-error
 inline-method
 ; expand-literal ; hack for method-errors !!!
 (only (stable-sort find-if nthcdr
        make-instance assoc format
        mapc mapcar append
        error)
   common-lisp))
#module-syntax-import 
(level-1-eulisp ; level-1 because of when which is actually in level-1
 dynamic)
#module-syntax-definitions

#module-header-end

(export 
  reset-generic-dispatch
  set-discriminating-functions
  set-std-discr-fun)

;;; -----------------------------------------------------------------------------------
;;; set-discriminating-functions and ~set-discriminating-function
;;; -----------------------------------------------------------------------------------

(defun set-discriminating-functions (module)
  (dynamic-let ((*current-module* module))
     (mapc #'~set-discriminating-function
           (?fun-list module))))

(defmethod ~set-discriminating-function ((fun <fun>))
  ;do nothing for non-generic functions
  nil)

(defmethod ~set-discriminating-function ((gf <generic-fun>))
  ;called after loading application modules and before analyzing functions
  ;this means that all statically collected methods are stored in the
  ;generic-fun, but a call of add-method at runtime may add additional methods
  ;
  ;ATTENTION: (dynamic *current-module*) must be set to the module where the
  ;generic function was defined
  ;
  (setf (?discrimination-arguments gf)
        (~compute-discrimination-arguments gf))
  (setf (?discrimination-depth gf)
        (~compute-discrimination-depth gf))
  (setf (?discriminating-fun gf)
        (~compute-discriminating-function 
         gf
         (~generic-function-domain gf)
         nil                            ; the lookup-fn is ignored in the
         ; default case
         (~generic-function-methods gf)))
  )

;the following method is not needed for the standard-level-0-case
;(defmethod ~compute-method-lookup-function (gf domain))

;;; -----------------------------------------------------------------------------------
;;; ~compute-discrimination-arguments
;;; -----------------------------------------------------------------------------------

(defmethod ~compute-discrimination-arguments ((gf <defined-generic-fun>))
  (let ((discr-arguments (null-list (~generic-function-domain gf)))
        (methods (~generic-function-methods gf)))
    (if methods
	(if (cdr methods)
	    (discr-args (~method-domain (car methods)) (cdr methods) 
			discr-arguments)
	  (discr-args (~generic-function-domain gf) methods
		      discr-arguments))
      discr-arguments)))

(defun null-list (dom)
  (if dom (cons () (null-list (cdr dom))) ()))
      
(defun discr-args (dom1 rest-methods d-args)
  (if rest-methods
    (let ((dom2 (~method-domain (car rest-methods))))
      (calc-d-args dom1 dom2 d-args)
      (discr-args dom2 (cdr rest-methods) d-args))
    d-args))

(defun  calc-d-args (dom1 dom2 d-args)
  (if dom1
    (if (eq (car dom1) (car dom2))
      (calc-d-args (cdr dom1) (cdr dom2) (cdr d-args))
      (progn
        (setf (car d-args) t)
        (calc-d-args (cdr dom1) (cdr dom2) (cdr d-args))))
    ()))

;;; -----------------------------------------------------------------------------------
;;; ~compute-discrimination-depth
;;; -----------------------------------------------------------------------------------

(defmethod ~compute-discrimination-depth ((gf <defined-generic-fun>))
  (discr-depth (?discrimination-arguments gf) 0))

(defun discr-depth (d-args count)
  (if d-args
    (if (car d-args)
      (discr-depth (cdr d-args) (+ count 1))
      (discr-depth (cdr d-args) count))
    count))

;;; -----------------------------------------------------------------------------------
;;; ~compute-discriminating-function
;;; -----------------------------------------------------------------------------------

(defmethod ~compute-discriminating-function 
           ((gf <generic-fun>) domain lookup-fn methods)
; methods may be empty !!!
  (let ((few-methods (few-methods-p gf methods))
        (closure (gf-with-closure-p gf methods))
        (next-method (gf-with-next-method-p gf methods))
        )
    (if methods
      (if few-methods
        (compute-std-discrfun-4-few-methods gf few-methods)
        (compute-std-discrfun gf closure next-method)
        )
    (add-function (?fun (mk-error-method gf))))))

;;; ------------------------------------------------------------------------
;;; few-methods-p  and  compute-decision-tree
;;; ------------------------------------------------------------------------

;(defun few-methods-p (gf domain methods) 
;  nil)

(defconstant $maximum-of-few-methods 8)
(defconstant $maximum-of-decisions 12)

(defvar error-methods ())

(defun few-methods-p (gf methods) ; *hf* domain removed
  (let ((da (?discrimination-arguments gf))
        (do (~generic-function-domain gf)))
    (if methods 
     ; (if (cdr methods) ; only one method
        (if (<= (length methods) $maximum-of-few-methods)
	    (progn
	      (dynamic-setq error-methods ())
	      (let ((tree
		     (compute-decision-tree da do methods
					;(sort-methods da do gf methods)
					    )))
		(if (< (length tree) $maximum-of-decisions)
		    (progn
		      (if (dynamic error-methods)
			  (dynamic-setq error-methods
					(mk-error-method gf))
			())
		      tree)
		  ())))
          ()) ; more than few method
        ; (car methods)) ; only one method
      ())) ; no methods
)


;(defun add-error-method (dom gf lst)
;  (nconcat lst (list (cons dom) 
;                     (mk-error-method dom gf)))
;  lst)

(defun mk-error-method (gf)
  (make-instance <method-def>
    :fun
    (make-instance <global-fun>
      :identifier (list (?identifier gf))
      :params (?params gf)
      :range-and-domain (?range-and-domain gf)
      :arg-num (compute-arg-descr (?params gf))
      :inline ()
      :body (error-body gf))))

; !!!! hack
(defun error-body (gf)
  (make-instance <app>
    :function no-applicable-method-error
    :arg-list (cons gf
                    (make-var-refs (?params gf))))
)


(defun compute-decision-tree (d-args gf-dom methods)
  (let ((tree (cons () ())))
    (if (compute-decision-tree1 0 d-args gf-dom methods tree)
      (cdr tree)
      ()))
)

(defun compute-decision-tree1 (arg-nr d-args gf-dom methods tree)
; find the next descriminating argument
; (if tree ; decition depth was to large
    (if d-args
      (if (car d-args)
        (progn 
          (compute-next-tree-level 
           methods arg-nr 
           (car gf-dom) 
           () ; methods with method-dom = gf-dom
           tree) ; with (cdr tree) = ()
          ; ? is the next level too large
          (if (cdr tree)
            (if (go-in-next-levels (cdr tree)
                                   (+ arg-nr 1)
                                   (cdr d-args)
                                   (cdr gf-dom))
              tree ())
            ()))
        (compute-decision-tree1 (+ arg-nr 1) (cdr d-args)
                                (cdr gf-dom) methods tree))
      (progn
        (setf (cdr tree)
              (select-the-most-specific-method methods))
        tree))
;    ())
)
 
(defun go-in-next-levels (tree arg-nr d-args gf-dom)
  (if tree
    (let* ((item (car tree))
           (methods (cdr item)))
      (if (eq methods ^error) t
	(progn
	  (setf (cdr item) ())
	  (if (compute-decision-tree1
	       arg-nr d-args gf-dom methods item)
	      (go-in-next-levels (cdr tree) arg-nr d-args gf-dom)
	    ()))))
    t))
    
 
;      -----------------------
(defun compute-next-tree-level 
;      -----------------------
       (methods arg-nr gf-dom gf-dom-meth tree)
  (if methods
    (let* ((meth (car methods))
           (m-dom (nth-method-domain arg-nr meth)))
      (if (eq m-dom gf-dom)
        ; oh, a general method found
        (compute-next-tree-level (cdr methods) arg-nr gf-dom
                                 (cons meth gf-dom-meth) 
                                 tree)
        (progn 
          (insert-method m-dom meth tree)
          (compute-next-tree-level (cdr methods)
                                   arg-nr gf-dom gf-dom-meth tree))))
    (if (< (length (cdr tree)) $maximum-of-decisions)
      (progn
        ; complete the tree with default or error methods
        (if (eq gf-dom %object) 
          (if gf-dom-meth
            (progn
              (insert-methods-in-all-subtrees
               gf-dom-meth (cdr tree))
              (setf (cdr tree)
                    (nconcat (cdr tree)
                             (list (cons t ; default-methods
                                         gf-dom-meth)))))
            (progn 
              (dynamic-setq error-methods t)
              (setf (cdr tree)
                    (nconcat (cdr tree)
                             (list (cons t ; default-methods
                                         ^error))))
            ))
          (if gf-dom-meth
            (progn 
              (insert-methods-in-all-subtrees
               gf-dom-meth (cdr tree))
              (if (are-all-subclasses-in-tree
                   gf-dom tree)
                (select-a-default-class tree)
                (setf (cdr tree)
                      (nconcat (cdr tree)
                               (list (cons t ; default-methods
                                           gf-dom-meth))))))
            (if (are-all-subclasses-in-tree
                 gf-dom tree)
              (select-a-default-class tree)
              (progn 
                (dynamic-setq error-methods t)
                (setf (cdr tree)
                      (nconcat (cdr tree)
                               (list (cons t ; default-methods
                                         ^error))))))))
        tree)
      (progn
        (setf (cdr tree) ())
        tree)))
)
;           -------------    
(defgeneric insert-method (m-dom meth tree))
;           -------------
(defmethod insert-method ((m-dom <standard-class-def>)
                          meth tree)
  (let ((item (assoc m-dom (cdr tree))))
    (if item
      (setf (cdr item)
            (cons meth (cdr item)))
      (setf (cdr tree)
            (cons (list m-dom meth)
                  (cdr tree))))
    (insert-method-loop (~class-subclasses m-dom) meth tree))
)

(defmethod insert-method ((m-dom <abstract-class-def>)
                          meth tree)
  (insert-method-loop (~class-subclasses m-dom) meth tree))

(defun insert-method-loop (dom-lst meth tree)
  (if dom-lst
    (progn
      (insert-method (car dom-lst)
                     meth tree)
      (insert-method-loop (cdr dom-lst) meth tree))
    tree))

;      ------------------------------
(defun insert-methods-in-all-subtrees (methods tree)
;      ------------------------------
  (if methods
    (progn 
      (insert-method-in-all-subtrees (car methods) tree)
      (insert-methods-in-all-subtrees (cdr methods) tree))
    tree))

(defun insert-method-in-all-subtrees (method tree)
  (if tree
    (let ((item (car tree)))
      (setf (cdr item)
            (cons method
                  (cdr item)))
      (insert-method-in-all-subtrees method (cdr tree)))
    ()))

;      --------------------------
(defun are-all-subclasses-in-tree (gf-dom tree)
;      --------------------------
  (let ((n (length (cdr tree))))
    (if (= (sum-of-all-subclasses gf-dom) n)
      t ())))

(defgeneric sum-of-all-subclasses (dom))

(defmethod sum-of-all-subclasses 
           ((dom <standard-class-def>))
    (+ 1 (sum-of-all-subclasses-list (~class-subclasses dom))))

(defmethod sum-of-all-subclasses
           ((dom <abstract-class-def>))
  (sum-of-all-subclasses-list (~class-subclasses dom)))

(defun sum-of-all-subclasses-list (lst)
  (if lst
    (sum-of-all-subclasses-list1 
     (cdr lst)
     (sum-of-all-subclasses (car lst)))
    0))

(defun sum-of-all-subclasses-list1 (lst count)
  (if lst
    (sum-of-all-subclasses-list1
     (cdr lst)
     (+ count (sum-of-all-subclasses (car lst))))
    count))

;      ----------------------
(defun select-a-default-class (tree)
;      ----------------------
  ; nothing specific known
  tree)


;      -----------------
(defun nth-method-domain (n method)
;      -----------------
  (nth-ele n (~method-domain method)))

(defun nth-ele (n li)
  (if (eq n 0) (car li)
    (nth-ele (- n 1) (cdr li))))

;      -------------------------------
(defun select-the-most-specific-method (ml)
;      -------------------------------
  (if (cdr ml)
      (s-m-s-m (car ml) (cdr ml))
    (car ml)))

(defun s-m-s-m (s-m ml)
  (if ml
      (let ((m (car ml)))
	(if (more-specific-p (~method-domain m) (~method-domain s-m))
	    (s-m-s-m m (cdr ml))
	  (s-m-s-m s-m (cdr ml))))
    s-m))

(defun nconcat (l1 l2)
  (if l1 (if l2 (if (cdr l1)
                  (progn
                    (nconcat1 (cdr l1) l2)
                    l1)
                  (progn 
                    (setf (cdr l1) l2)
                    l1))
             l1)
      l2))

(defun nconcat1 (l1 l2)
  (if (cdr l1)
    (nconcat1 (cdr l1) l2)
    (setf (cdr l1) l2)))

;;; ------------------------------------------------------------------------
;;; gf-with-closure-p
;;; ------------------------------------------------------------------------


(defun gf-with-closure-p (gf methods)
  nil)

(defun gf-with-next-method-p (gf methods)
  nil)

;;; ------------------------------------------------------------------------
;;; compute-std-discrfun
;;; ------------------------------------------------------------------------

(defun compute-std-discrfun-4-few-methods (gf few-methods)
  (if (method-def-p few-methods) (?fun few-methods)
      ; few-methods is a dedecision tree
      (dynamic-let ((in-generic-fun gf)
                    (next-method-params (?params gf)))
      (let* ((params (?params gf))
             (d-vars (?discrimination-arguments gf))
             (d-args (make-d-var-refs d-vars (?var-list params)))
             (args 
;              (if (?rest params)
;                     (make-var-refs-rest params)
;                     (make-var-refs params))
              (if (?rest params)
                (append (?var-list params) (list (?rest params)))
                (?var-list params)))
             (d-class-vars 
              (copy-to-class-vars d-args))
             (body (make-instance <let*-form>
                     :var-list (entrefs-var-list d-class-vars)
                     :init-list (add-class-of d-args)
                     :body (compute-if-cascade d-class-vars
                                               few-methods
                                               args)
                     )))
        (add-function
         (make-instance <global-fun>
           :identifier (list (?identifier gf))
           :params params
           :range-and-domain (?range-and-domain gf)
           :arg-num (compute-arg-descr params)
           :inline ()
           :body body
	   :signature (?signature gf)
           ))))))

(defun entrefs-var-list (ref-lst)
  (if ref-lst
    (cons (?var (car ref-lst))
          (entrefs-var-list (cdr ref-lst)))
    ()))

(defun copy-to-class-vars (var-ref-lst)
  (if var-ref-lst
    (cons (make-instance <var-ref> 
            :var (make-instance <local-static>
                   :identifier (list ^class-of 
                                     (?identifier (?var (car var-ref-lst))))))
          (copy-to-class-vars (cdr var-ref-lst)))
    ()))

(defun add-class-of (var-list)
  (if var-list
    (cons 
     (make-instance <app> :function %class-of
                    :arg-list (list (car var-list)))
     (add-class-of (cdr var-list)))
    ()))

(defun compute-if-cascade (cl-varl tree args)
  (if (consp tree)
    (if (cdr tree)
      (let* ((cl-m (car tree))
             (class (car cl-m))
             (pred (make-instance <app>
                     :function %eq ; ***test***
                     :arg-list (list (car cl-varl) class)))
             (then (compute-if-cascade (cdr cl-varl)
                                       (cdr cl-m)
                                       args))
             (else (compute-if-cascade cl-varl (cdr tree) args)))
        (make-instance <if-form>
          :pred pred
          :then then
          :else else))
      (compute-if-cascade (cdr cl-varl) (cdr (car tree)) args))
    (if (eq tree ^error)
	(inline-method (dynamic error-methods) args)
      (inline-method tree		; tree is a <method-def>
		     args))))
;    (let* ((fun (?fun tree)) ; tree is a <method-def>
;           (params (?params fun)))
;      (if (?rest params)
;        (progn 
;          (setf (?var-list params)
;                (nconcat (?var-list params)
;                         (list (?rest params))))
;          (setf (?rest params) ())
;          (setf (?arg-num fun) (compute-arg-descr params)))
;        ())
;      (make-instance <app>
;        :function fun 
;        :arg-list args)



;;; ------------------------------------------------------------------------
;;; compute-std-discrfun
;;; ------------------------------------------------------------------------

(defun compute-std-discrfun (gf closure next-method)
  (let* ((params (?params gf))
         (d-vars (?discrimination-arguments gf))
         (dd (?discrimination-depth gf))
         ; (args (make-var-refs (?params gf))
         (body 
          (make-instance <app>
            :function %funcall
            :arg-list
            (cons 
             (make-instance <app>
               :function (get-std-discr-fun dd next-method closure)
               :arg-list (cons gf (make-d-var-refs d-vars 
                                                   (?var-list params))))
             (if (?rest params)
               (make-var-refs-rest params)
               (make-var-refs params)))
            )))
;    (when (?rest params) 
;      (error "generic functions with rest parameter not yet implemented"))
    (add-function
     (make-instance <global-fun>
       :identifier (list (?identifier gf))
       :params params
       :range-and-domain (?range-and-domain gf)
       :arg-num (compute-arg-descr params)
       :inline t
       :body body
       :signature (?signature gf)
       ))))

(defun make-d-var-refs (d-vars varl)
  (if d-vars
    (if (car d-vars)
      (cons (make-instance <var-ref> :var (car varl))
            (make-d-var-refs (cdr d-vars) (cdr varl)))
      (make-d-var-refs (cdr d-vars) (cdr varl)))
    ()))

(defun make-var-refs (params)
  ;don't work for rest parameters
  (mapcar (lambda (req)
            (make-instance <var-ref> :var req))
          (?var-list params)))

(defun make-var-refs-rest (params)
  (make-var-refs-rest1 (?var-list params) 
                       (list 
                        (make-instance <var-ref> 
                          :var (?rest params)))))

(defun make-var-refs-rest1 (req-vars rest)
  (if req-vars
    (cons (make-instance <var-ref> :var (car req-vars))
          (make-var-refs-rest1 (cdr req-vars) rest))
    rest))

;;; -----------------------------------------------------------------------------------
;;; Installing and Finding Standard Discriminating Functions
;;; -----------------------------------------------------------------------------------

(defstandardclass <std-discr-fun-descr> ()
  (discr-fun :reader :initarg)
  (required :reader :initarg)
  (rst :reader :initarg)                ; 0 or 1 for 'no' resp. 'yes'
  (next-method :reader :initarg)        ; 0 or 1 for 'no' resp. 'yes'
  (closure :reader :initarg))           ; 0 or 1 for 'no' resp. 'yes'

(deflocal *std-discr-fun-table* nil)
;*std-discr-fun-table* is a sorted list of descriptions of standard dispatching
;functions; the order in this list is as follows:
;without closure before with closure
;without next-method before with next-method
;fewer required parameters first
;no rest parameter before rest parameter

(defun reset-generic-dispatch ()
  (setq *std-discr-fun-table* nil))

(defun get-std-discr-fun (req next-method closure)
  (setq next-method (if next-method 1 0))
  (setq closure (if closure 1 0))
  (let ((descr
         (find-if (lambda (descr)
                    (and
                     (or (= (?rst descr) 1)
                           (= req (?required descr)))
                     (<= next-method (?next-method descr))
                     (<= closure (?closure descr))
                     ))
                  *std-discr-fun-table*)))
    (if descr (?discr-fun descr)
        (error "standard discriminating function missing for ~
                ~A argument~:P, with~[out~;~] next-method, with~[out~;~] closure"
               (length req)
               next-method
               closure))))

(defun set-std-discr-fun (fun keyword description)
  (set-std-discr-fun1 fun 
                      (member ^next-method description)
                      (member ^closure description)))

(defun set-std-discr-fun1 (fun next-method closure)
  (setq *std-discr-fun-table*
        (stable-sort                    ; to make sure that replacing goes right
         (cons (make-instance <std-discr-fun-descr>
                 :discr-fun fun
                 :next-method (if next-method 1 0)
                 :closure (if closure 1 0)
                 :required (- (length (?var-list (?params fun))) 1)
                 ; the first argument is the generic function object which must
                 ; not considered here
                 :rst (if (?rest (?params fun)) 1 0))
               *std-discr-fun-table*)
         (lambda (descr1 descr2)
           (or 
             (and (< (?required descr1) (?required descr2))
                  (<= (?rst descr1) (?rst descr2))
                  (<= (?next-method descr1) (?next-method descr2))
                  (<= (?closure descr1) (?closure descr2)))
             (and (< (?rst descr1) (?rst descr2))
                  (<= (?next-method descr1) (?next-method descr2))
                  (<= (?closure descr1) (?closure descr2)))
             (and (< (?next-method descr1) (?next-method descr2))
                  (<= (?closure descr1) (?closure descr2)))
             (< (?closure descr1) (?closure descr2))
             )))))

;
;(defmethod ~compute-discrimination-depth ((gf <defined-generic-fun>))
;  (let ((methods (~generic-function-methods gf)))
;    (if methods
;      (let ((dom1 (~method-domain (car methods))))
;        (discr-depth ; (~generic-function-domain gf)
;         dom1 (cdr methods)
;         0 (length dom1)))
;      0)))
;
;(defun discr-depth (dom1 rest-methods depth leng)
;  (if rest-methods
;    (let* ((dom2 (~method-domain (car rest-methods)))
;           (new-depth (calc-depth dom1 dom2 depth 0)))
;      (if (> new-depth depth)
;        (if (= new-depth leng) leng
;            (discr-depth dom2 (cdr rest-methods) new-depth leng))
;        (discr-depth dom2 (cdr rest-methods) depth leng)))
;    depth))
;
;(defun calc-depth (dom1 dom2 d n)
;  (if dom1
;      (if (eq (car dom1) (car dom2))
;	  (calc-depth (cdr dom1) (cdr dom2) d (+ n 1))
;	(calc-depth (cdr dom1) (cdr dom2) (+ n 1) (+ n 1)))
;   d))
;;;; -----------------------------------------------------------------------------------
;;;; ~compute-discrimination-offset
;;;; -----------------------------------------------------------------------------------
;
;(defmethod ~compute-discrimination-offset ((gf <defined-generic-fun>))
;  (let ((methods (~generic-function-methods gf)))
;    (if methods
;      (if (cdr methods)
;        (discr-offset (~method-domain (car methods))
;                      (cdr methods) 999) ; a dummy number
;        0)
;      0)))
;
;(defun discr-offset (first-dom rest-methods offset)
;  (if rest-methods
;    (let* ((second-dom (~method-domain (car rest-methods)))
;           (new-offset (discr-offset1 first-dom second-dom 0 offset)))
;      (if (= new-offset 0) 0
;          (discr-offset second-dom (cdr rest-methods) new-offset)))
;    offset))
;
;(defun discr-offset1 (dom1 dom2 nr offset)
;  (if (>= nr offset) offset
;      (if dom1
;        (if (eq (car dom1) (car dom2))
;          (discr-offset1 (cdr dom1) (cdr dom2) (+ nr 1) offset)
;          nr)
;       nr)))



;(defun sort-methods (d-args gf-dom gf methods)
;; result: ((dom1 . specific-method) .... (domn . general-method))
;  (let* ((sortm (sort-methods1 (cdr methods) 
;                               (list (cons 
;                                      (~method-domain (car methods))
;                                      (car method)))))
;         (last (last-method sortm)))
;    (if (more-specific-p (car last)
;                         gf-dom)
;      (add-error-method gf-dom gf sortm)
;      sortm)))
;
;(defun sort-methods1 (ms lst)
;  (if (null ms) lst
;      (let* ((m (car ms))
;             (mdom (~method-domain m)))
;        (if (more-specific-p mdom (car (car lst)))
;          (sort-methods1 (cdr ms)
;                         (cons (cons mdom m) lst))
;          (progn 
;            (sort-methods2 mdom m lst)
;            (sort-methods1 (cdr ms) lst)))))
;)
;
;(defun sort-methods2 (mdom m lst)
;  (if (cdr lst)
;    (let ((nxdom (car (car (cdr lst)))))
;      (if (more-specific-p mdom nxdom)
;          (setf (cdr lst)
;                (cons (cons mdom m)
;                      (cdr lst)))
;          (sort-methods2 mdom m (cdr lst))))
;    (setf (cdr lst)
;          (cons (cons mdom m) ()))))
;
;(defun last-method (ml)
;  (if (cdr ml) (last-method (cdr ml))
;      (car ml)))
;(defun compute-decision-tree (d-args methods)
;  (let ((tree (cons () ())))
;    (if (compute-decision-tree1 d-args methods tree)
;      (cdr tree)
;      ()))
;)

;(defun calc-d-tree (d-args gf-dom dom method tree)
;  (if d-args
;    (if (car d-args)
;      (calc-d-tree1 (if (eq (car dom) (car gf-dom))
;                      t (car dom))
;                    (cdr dom)
;                    (cdr d-args)
;                    (cdr gf-dom)
;                    method tree)
;      (calc-d-tree (cdr d-args) (cdr gf-dom) (cdr dom) method tree))
;    (let ((method1 (cdr tree)))
;      (if (more-specific-p (~method-domain method) 
;                           (~method-domain method1))
;        (setf (cdr tree) method) ())
;      tree)))

;(defgeneric calc-d-tree1 (dom doml d-args gf-dom method tree))
;
;(defmethod calc-d-tree1 ((dom <standard-class-def>) 
;                         doml d-args gf-dom method tree)
;  (let ((item (assoc dom (cdr tree)))
;        (subcl (~class-subclasses dom)))
;    (if item
;      (calc-d-tree d-args gf-dom
;                   doml
;                   method item)
;      (nconcat (cdr tree)
;               (list 
;                (cons dom 
;                      (compute-subtree d-args gf-dom doml method)))))
;    (if subcl
;      (calc-d-list subcl doml d-args gf-dom method tree)
;      tree)))
;
;(defmethod calc-d-tree1 ((dom <abstract-class-def>)
;                         doml d-args gf-dom method tree)
;  (let ((subcl (~class-subclasses dom)))
;    (if subcl
;      (calc-d-list subcl doml d-args gf-dom method tree)
;      tree)))
;
;(defmethod calc-d-tree1 (dom doml d-args gf-dom method tree)
;  (let ((item (assoc dom (cdr tree))))
;    (if item 
;      (calc-d-tree d-args gf-dom
;                   doml
;                   method item)
;      (nconcat (cdr tree)
;               (list 
;                (cons dom 
;                      (compute-subtree d-args gf-dom doml method))))))
;)
;
;(defun calc-d-list (cl-list doml d-args gf-dom method tree)
;  (if cl-list
;    (progn 
;      (calc-d-tree1 (car cl-list) doml d-args gf-dom method tree)
;      (calc-d-list (cdr cl-list) doml d-args gf-dom method tree)
;      tree)
;    tree))
;
;(defun compute-subtree (d-args gf-dom doml method)
;; result: method | ((class . subtree) ...)
;  (if d-args
;    (if (car d-args)
;      (compute-subtree1 
;       (if (eq (car doml) (car gf-dom))
;         t (car doml))
;       (cdr d-args) (cdr gf-dom) (cdr doml) method)
;      (compute-subtree (cdr d-args) (cdr gf-dom) (cdr doml) method))
;    method))
;
;(defgeneric compute-subtree1 (dom d-args gf-dom doml method))
;
;(defmethod compute-subtree1 ((dom <standard-class-def>) 
;                             d-args gf-dom doml method)
;  (let ((item (cons dom 
;                    (compute-subtree d-args gf-dom doml method)))
;        (subcl (~class-subclasses dom)))
;    (if subcl
;      (cons item
;            (compute-subtree-list subcl d-args gf-dom doml method))
;      (cons item ()))))
;
;(defmethod compute-subtree1 ((dom <abstract-class-def>)
;                             d-args gf-dom doml method)
;  (let ((subcl (~class-subclasses dom)))
;    (if subcl (compute-subtree-list subcl d-args gf-dom doml method) ())))
;      
;
;(defun compute-subtree-list (cl-list d-args gf-dom doml method)
;  (if cl-list
;    (nconcat (compute-subtree1 (car cl-list)
;                               d-args gf-dom doml method)
;             (compute-subtree-list (cdr cl-list) d-args gf-dom doml method))
;    ()))

     
#module-end
