;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: generate-def-file -*-
#|
-----------------------------------------------------------------------------------
TITLE: generation of interface files
-----------------------------------------------------------------------------------
File:    generate-def-file.em
Version: 1.5 (last modification on Wed Nov 10 16:18:46 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind, Ingo Mohr

CONTACT: 
a.kind

HISTORY: 

Log for /export/home/saturn/imohr/Lisp/Apply/generate-def-file.em[1.0]
	Thu May 27 10:08:55 1993 akind@isst proposed $
 Generating interface files.
 
generate-def-file.em[1.1] Thu May 27 12:55:57 1993 akind@isst proposed $
 [Thu May 27 12:53:48 1993] Intention for change:
 
generate-def-file.em[1.2] Thu Jun  3 13:15:05 1993 akind@isst published $
 [Thu Jun  3 13:13:36 1993] Intention for change:
 Add newline to output file.
 
generate-def-file.em[1.3] Tue Sep 21 16:10:04 1993 akind@isst save $
 [Tue Sep 21 16:08:35 1993] Intention for change:
 map-with-fun -> mapc
 
generate-def-file.em[1.4] Tue Sep 21 16:11:15 1993 akind@isst published $
 [Tue Sep 21 16:10:46 1993] Intention for change:
 
generate-def-file.em[1.5] Wed Nov 24 08:47:57 1993 imohr@isst proposed $
 

-----------------------------------------------------------------------------------
|#

#module generate-def-file
(import (level-1-eulisp
         accessors
         el2lzs
         lzs
         tail-module
         type-inference
         (only (format dolist) common-lisp))
 syntax (level-1-eulisp
         (only (with-open-file) common-lisp))
;;exports
 export (generate-def-file 
         generate-def-file-for-module) 
 )

;;; -----------------------------------------------------------------------------------
;;; main functions
;;; -----------------------------------------------------------------------------------
;;requires a module-name
(defun generate-def-file-for-module (module)
  (generate-def-file (find-module module)))

;;requires a module
(defun generate-def-file (main)
  (let ((exports (?exports main))
        (id (?identifier main)))
    (with-open-file (out (format nil "~(~a~).def" id)
		     :direction :output :if-exists :supersede
		     :if-does-not-exist :create)
      (format out "\;\;\;-*- Mode: Lisp\; Syntax: Common-Lisp\; Base: 10\; ")
      (format out "Package: ~a-DEF -*-" id)
      (format out "~2%(defmodule ~a-DEF" id)
      (format out "~%  (tail)")
      (format out "~%  (syntax (tail))")
      (generate-type-schemes exports id out)
      (format out "~2%) \;end of module~%"))))

;;; -----------------------------------------------------------------------------------
;;; type schemes
;;; -----------------------------------------------------------------------------------
(defun generate-type-schemes (exports module-name stream)
  (format stream 
          "~2%\;\;\; Type schemes of exported identifiers of module ~a." 
          module-name)
  (dolist (obj exports) (ti-def-write stream obj)))

;;; -----------------------------------------------------------------------------------
;;; functions, classes and variables
;;; -----------------------------------------------------------------------------------

(defun generate-interface (object)
  (apply #'gen-interface (get-identifier-and-object object)))

(defgeneric gen-interface (identifier object))

(defmethod gen-interface (identifier object)
  ; generate only an interface for specific objects
  nil)

(defmethod gen-interface (identifier (class <class-def>))
  (format t "~2%(%declare-external-class ~A~
              ~% external-name |~A|)"
          (?identifier class)
          (?code-identifier class)))

(defmethod gen-interface (identifier (fun <fun>))
  (format t "~2%(%declare-external-function (~A ~A)~
              ~% (~{~})
              ~% external-name |~A|)"
          (?identifier fun)
          
          (?code-identifier fun)))

(defmethod gen-interface (identifier (var <global-static>))
  (format t "~2%(%declare-external-variable ~A ~A~
              ~% external-name |~A|)"
          (?identifier var)

          (?code-identifier var)))

(defmethod gen-interface (identifier (const <named-const>))
  (format t "~2%(%declare-external-constant ~A ~A~
              ~% external-name |~A|)"
          (?identifier var)

          (?code-identifier var)))

#module-end