;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: function-call-context -*-
#|
-----------------------------------------------------------------------------------
TITLE: all analyses in context function-call
-----------------------------------------------------------------------------------
File:    function-call-context.em
Version: 1.5 (last modification on Thu Mar 25 11:14:14 1993)
State:   published

DESCRIPTION: fill the var-vector of a statement
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/function-call-context.em[1.0]
	Fri Mar  5 13:01:26 1993 hfried@isst save $
 text
 
function-call-context.em[1.1] Thu Mar 18 08:59:56 1993 hfried@isst proposed $
 [Fri Mar  5 13:03:54 1993] Intention for change:
 
function-call-context.em[1.2] Wed Mar 24 13:48:23 1993 hfried@isst proposed $
 [Thu Mar 18 09:11:24 1993] Intention for change:
 + glob anna
 
function-call-context.em[1.3] Thu Mar 25 11:19:25 1993 hfried@isst proposed $
 [Wed Mar 24 14:53:19 1993] Intention for change:
 + gen-fun
 new head
 
function-call-context.em[1.4] Tue Apr 13 14:09:10 1993 hfried@isst proposed $
 [Thu Mar 25 11:54:01 1993] Intention for change:
 
function-call-context.em[1.5] Mon Jun 21 11:42:42 1993 hfried@isst published $
 [Tue Apr 13 14:15:22 1993] Intention for change:
 

-----------------------------------------------------------------------------------
|#

#module-name function-call-context
#module-import 
( level-1-eulisp
  SIMPLE-PROGRAMMING
  LZS 
  MZS 
  context 
  analyse-h
;  function-call
  vector) ; make-vector and vector-ref
;; typeinfernce

#module-syntax-import 
( level-1-eulisp )
#module-syntax-definitions

;--- defmacro forms

#module-header-end


;  exports

;       ########
(export l2m-call simple-constant-p)
;       ########

;------------------------------------------------------------------
; constants
;------------------------------------------------------------------

;          ########               
(defmethod l2m-call (con  arg-list)
;          ########        
   (l2m-function-call con arg-list 1 (dynamic *arg-context*)) 
    ; fill the var-vector
)

;      -----------------
(defun l2m-function-call (statement arg-list nr arg-context)
;      -----------------
   (if (null arg-list) ()
       (let ((var-or-constant (l2m-a arg-context (car arg-list))))
         (setf (vector-ref (?var-vec (?var-descr statement))
                           nr) var-or-constant)
         (if (simple-constant-p var-or-constant)
           (setf (?constant-counter 
                  (?var-descr statement))
                 (+ 1 (?constant-counter 
                       (?var-descr statement))))
           ())
         (l2m-function-call statement (cdr arg-list) 
                                 (+ nr 1) arg-context)
)))


(defgeneric simple-constant-p (lzs-object))

(defmethod simple-constant-p ((obj <named-const>))
   (simple-constant-p (?value obj)))

(defmethod simple-constant-p ((obj <structured-literal>))
   t)

(defmethod simple-constant-p ((obj <sym>))
   t)

(defmethod simple-constant-p ((obj <symbol>))
   t)

(defmethod simple-constant-p ((obj <spint>))
   t)

(defmethod simple-constant-p ((obj <double-float>))
   t)

(defmethod simple-constant-p ((obj <character>))
   t)

(defmethod simple-constant-p ((obj <null>))
   t)

(defmethod simple-constant-p ((obj <object>))
   #f)

#module-end