;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: eval-basic -*-
#|
-----------------------------------------------------------------------------------
TITLE: Syntax definitions and other basic definitions for eval
-----------------------------------------------------------------------------------
File:    eval-basic.em
Version: 1.0 (last modification on Mon Dec  6 12:36:29 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/apply-kunde/Lisp/Apply/eval-basic.em[1.0]
	Mon Dec  6 16:06:53 1993 imohr@isst proposed $
 basic stuff for eval (syntax, variable handling)
 

-----------------------------------------------------------------------------------
|#

#module eval-basic

(import (level-1-eulisp 
         lzs
         (only (find-module) el2lzs-main)
         (only (error warn mapcar mapc assoc rest first append char-code) 
           common-lisp))

 syntax (level-1-eulisp
         (only (push) common-lisp))

 export (get-value set-value
         eval evaluate
         initialize-variables)
 )

;;; -----------------------------------------------------------------------------------
;;; syntax for declaring system functions
;;; -----------------------------------------------------------------------------------

(defmacro declare-system-functions functions
  `(list ,@(mapcar (lambda (fun)
                     `(cons ',(make-eulisp-symbol fun)
                            #',fun))
                   functions)))

;;; -----------------------------------------------------------------------------------
;;; eval
;;; -----------------------------------------------------------------------------------

(defvar *eval* nil)

(defun eval (lzsobj)
  (dynamic-let ((*eval* lzsobj))
     (evaluate lzsobj)))

(defgeneric evaluate (lzsobj))

;;; -----------------------------------------------------------------------------------
;;; initialization, setting and retrieving values of variables
;;; -----------------------------------------------------------------------------------

(defvar variable-environment () )

;;; The forms in body are executed with variables in vars bound to the
;;; corresponding values of the LZS-forms in values (computed by eval) and the
;;; variable in rst (unless it is () ) bound to the list of values not used for
;;; the other variables. The macro can be used for handling function
;;; applications and let*-forms of the LZS.

(defmacro with-new-values (vars rst values . body)
  `(dynamic-let ((variable-environment (dynamic variable-environment)))
                (initialize-variables ,vars ,rst ,values)
                ,@body))

(defun initialize-variables (vars rst values)
(cond ((null vars) (initialize-rest rst values))
      ((null values) (error "too few arguments"))
      (t (push (cons (first vars) (eval (first values)))
               (dynamic variable-environment))
         (initialize-variables (rest vars) rst (rest values)))))

(defun initialize-rest (rst values)
  (cond ((and (null rst) values)
         (error "too many arguments"))
        ((null rst))
        (t (push (cons rst (mapcar #'eval values))
                 (dynamic variable-environment)))))

(defgeneric get-value (var))

(defmethod get-value ((var <static>))
 (cdr (assoc var (dynamic variable-environment))))

(defmethod get-value ((var <named-const>))
 (?eval-value var))

(defgeneric set-value (var-obj obj))

(defmethod set-value ((var <static>) obj)
 (setf (cdr (assoc var (dynamic variable-environment)))
       obj))

(defmethod set-value ((var <named-const>) obj)
 (setf (?eval-value var) obj))

#module-end
