;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-error -*-
#|
-----------------------------------------------------------------------------------
TITLE: Signalling errors, warnings and infos for specific situations detected by
       the frontend
-----------------------------------------------------------------------------------
File:    el2lzs-error.em
Version: 1.7 (last modification on Tue Dec 14 13:50:25 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /tmp_mnt/home/saturn/ukriegel/Dist/Apply/el2lzs-error.em[1.0]
	Wed Oct 20 14:04:17 1993 imohr@isst proposed $
 errors for the frontend
 
el2lzs-error.em[1.1] Wed Oct 20 14:23:57 1993 imohr@isst proposed $
 
el2lzs-error.em[1.2] Wed Oct 20 18:45:34 1993 imohr@isst published $
 
el2lzs-error.em[1.3] Thu Oct 21 15:00:42 1993 imohr@isst save $
 
el2lzs-error.em[1.4] Tue Nov  9 11:34:46 1993 imohr@isst proposed $
 [Thu Oct 21 15:33:28 1993] Intention for change:
 --- no intent expressed ---
el2lzs-error.em[1.5] Tue Nov 30 13:55:52 1993 imohr@isst proposed $
 [Mon Nov 29 11:36:28 1993] Intention for change:
 error "specification of non-existent binding in interface" for el2lzs-main
 
el2lzs-error.em[1.6] Tue Dec  7 17:06:29 1993 imohr@isst proposed $
 [Tue Dec  7 14:20:35 1993] Intention for change:
 move definition of <binding> to el2lzs-basic
 
el2lzs-error.em[1.7] Tue Dec 14 17:18:27 1993 imohr@isst proposed $
 [Tue Dec 14 13:14:46 1993] Intention for change:
 

-----------------------------------------------------------------------------------
|#

;#|
#module el2lzs-error
(import (level-1-eulisp
         lzs accessors
         configuration; only to get initialization of dynamic *[system-]info-level*
         binding
         debugging
         (only (error warn format
                      floor length string
                      second)
           common-lisp))
 syntax (level-1-eulisp
         apply-standard)
 export (*frontend-errors*
         new-frontend-error
         reset-frontend-errors)
 ; ---- stuff for bindings ; should be temporary
 export (<binding>
         finally-refered-object
         get-lzs-object
         )
 ; ---- for el2lzs-main 
 export (error-bad-c-import-spec
         error-bad-module-directive 
         error-no-lexical-binding
         error-name-clash
         error-bad-old-style-syntax-import 
         info-old-style-module-header
         error-invalid-syntax
         error-redefinition-of-top-lexical
         error-redefinition-of-imported-lexical
         warning-non-existent-binding-in-interface
         warning-binding-in-import-and-syntax
         )
 ; ---- for el2lzs-rules 
 export (error-invalid-assignment)
 ; ---- for el2lzs-load 
 export (error-invalid-module-definition
         warning-differing-names-for-module-and-file
         info-loading-module
         info-module-loaded
         error-connot-find-file
         error-connot-load-file
         error-connot-open-file)
 ; ---- for el2lzs-classes 
 export (error-bad-class-options
         error-mm-type-unknown-at-compile-time
         error-invalid-mm-type
         error-class-equal-lattice-type 
         error-neither-class-nor-lattice-type)
 ; ---- for el2lzs-generic 
 export (warn-defgeneric-options-not-analyzed
         error-no-converter 
         error-no-setter
         error-class-required-in-converter-spec
         error-function-required-in-setter-spec
         error-invalid-generic-function-spec
         error-converter-redefinition
         error-setter-redefinition
         )
 )
;|# (in-package el2lzs-error)

;;; -----------------------------------------------------------------------------------
;;; 
;;; -----------------------------------------------------------------------------------
(export
  *frontend-errors*
  new-frontend-error
  reset-frontend-errors)

(deflocal *frontend-errors* 0)

(defun new-frontend-error ()
  (setq *frontend-errors* (+ 1 *frontend-errors*)))

(defun reset-frontend-errors ()
  (setq *frontend-errors* 0))

(defvar current-defining-form nil)

;;; -----------------------------------------------------------------------------------
;;; general
;;; -----------------------------------------------------------------------------------

(deflocal *line-length* 75)

(defun write-message (key message . args)
  (when (eq key ^error) (new-frontend-error))
  (when key
    (let ((header 
           (format nil "~A~@[ in module '~(~A~)'~]~@[ in ~((~2{~A ~} ...)~)~]"
                   key
                   (if (dynamic *current-module*)
                     (?identifier (dynamic *current-module*))
                     nil)
                   (dynamic current-defining-form))))
      (format t "~%~3{-~} ~A ~V{-~}~%"
            '(())
            header
            (- *line-length* (length header) 5)
            '(())
            )))
  (format t "~?" message args)
  (when key (format t "~%~V{-~}" *line-length* '(()))))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-main
;;; -----------------------------------------------------------------------------------

(export 
  error-bad-c-import-spec
  error-bad-module-directive 
  error-no-lexical-binding
  error-name-clash
  error-bad-old-style-syntax-import 
  info-old-style-module-header
  error-invalid-syntax
  error-redefinition-of-top-lexical
  error-redefinition-of-imported-lexical
  warning-non-existent-binding-in-interface
  warning-binding-in-import-and-syntax
  )

(defvar error-if-no-lexical-found t)

(defun error-no-lexical-binding (id)
  (when (dynamic error-if-no-lexical-found)
    (write-message ^error "no lexical binding found for ~A" id)) 
  nil)

(defun error-bad-c-import-spec (file)
  (write-message ^error "bad filespec in c-import directive: ~S" file))

(defun error-bad-module-directive (key value)
  (write-message ^error "bad module directive: ~A ~@[~A~]" key value))

(defun error-bad-old-style-syntax-import (import-spec)
  (write-message ^error "bad old style syntax import specification: ~A" import-spec))

(defgeneric error-name-clash (binding1 binding2))
(defmethod error-name-clash (binding1 binding2)
  (write-message ^error "name clash: attempt to import ~A ~@
                         from modules ~A and ~A"
                 (?identifier binding1)
                 (?module-id binding1)
                 (?module-id binding2)))
(defmethod error-name-clash ((binding1 <binding>) (binding2 <binding>))
  (write-message ^error "name clash: attempt to import under ~A~@
                         ~A from ~A and ~@
                         ~A from ~A"
                 (?identifier binding2)
                 (?identifier (?refers-finally-to binding1))
                 (?module-id (?refers-finally-to binding1))
                 (?identifier (?refers-finally-to binding2))
                 (?module-id (?refers-finally-to binding2))
                 ))
(defmethod error-name-clash ((binding1 <binding>) binding2)
  (write-message ^error "name clash: attempt to import under ~A~@
                         ~A from ~A and ~@
                         ~A from ~A"
                 (?identifier binding2)
                 (?identifier (?refers-finally-to binding1))
                 (?module-id (?refers-finally-to binding1))
                 (?identifier binding2)
                 (?module-id binding2)
                 ))
(defmethod error-name-clash (binding1 (binding2 <binding>))
  (error-name-clash binding2 binding1))

(defun warning-non-existent-binding-in-interface (identifier import-spec)
  (write-message ^warning
                 "~A is not available in interface specification:~%~A"
                 identifier import-spec))

(defun warning-binding-in-import-and-syntax (identifier import-spec)
  (write-message ^warning
                 "~A is both import and syntax in interface specification:~
                  ~%~A~
                  ~%using import only"
                 identifier import-spec))

(defmethod info-old-style-module-header (module-def)
  (write-message nil "~[~;~:;[old style]~]" (dynamic *info-level*)))

(defun error-invalid-syntax (syntax expr)
  (write-message ^error "invalid syntax for '~(~A~)':~%~(~A~)" 
                 (car syntax) expr))

(defun error-redefinition-of-top-lexical (object)
  (write-message ^error 
                 "redefinition of top lexical binding: ~A"
                 (?identifier object)))

(defun error-redefinition-of-imported-lexical (object)
  (write-message ^error 
                 "redefinition of imported lexical binding: ~A"
                 (?identifier object)))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-rules
;;; -----------------------------------------------------------------------------------
(export 
  error-invalid-assignment)

(defun error-invalid-assignment (location)
  (write-message ^error
                 "invalid destination for assignment: ~A" location))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-load
;;; -----------------------------------------------------------------------------------
(export 
  error-invalid-module-definition
  warning-differing-names-for-module-and-file
  info-loading-module
  info-module-loaded
  error-connot-find-file
  error-connot-load-file
  error-connot-open-file)

(defun error-invalid-module-definition (object path)
  (write-message ^error "invalid module definition in ~A" path))

(defun warning-differing-names-for-module-and-file (module-name path)
  (write-message ^warning "modulename ~A differs from filename ~A" 
               module-name
               path))

(defvar *load-level* 0)

(defun info-loading-module (path)
  (write-message nil 
                 "~[~;.~:;~%;~V@{.~}loading module ~A~]" 
                 (dynamic *info-level*)
                 (- (dynamic *load-level*) 1) path))

(defun info-module-loaded (module-name)
  (write-message nil
                 "~[~;~;~;~%;~V@{.~}apply module ~A loaded~]" 
                 (dynamic *info-level*)
                 (- (dynamic *load-level*) 1) 
                 module-name))

(defun error-connot-find-file (name)
  (write-message ^error "can't find Apply module ~A" name))

(defun error-connot-load-file (path)
  (write-message ^error "can't load Apply module ~A" path))

(defun error-connot-open-file (path)
  (write-message ^error "can't open Apply module ~A" path))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-classes
;;; -----------------------------------------------------------------------------------
(export 
  error-bad-class-options
  error-mm-type-unknown-at-compile-time
  error-invalid-mm-type
  error-class-equal-lattice-type 
  error-neither-class-nor-lattice-type)

(defun error-bad-class-options (options)
  (write-message ^error "bad class option in ~A" options))

(defun error-mm-type-unknown-at-compile-time (value)
  (write-message ^error 
                 "Value of ~A must be known at compile time ~
                  when used for class option 'mm-type'" value))

(defun error-invalid-mm-type (value)
  (write-message ^error 
                 "Bad value for class option 'mm-type': ~A" value))

(defun error-class-equal-lattice-type (id)
  (write-message ^error 
                 "A class and a lattice type with the name ~A are found.~
                  Using the class." id))

(defun error-neither-class-nor-lattice-type (id)
  (write-message 
   ^error 
   "Neither a class nor a lattice type with the name ~A are found."
   id))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-generic
;;; -----------------------------------------------------------------------------------

(defun warn-defgeneric-options-not-analyzed (options)
  (write-message ^warn 
                 "options in defgeneric not yet analyzed: ~A" 
                 options))

(defun error-no-converter (class-def)
  (write-message ^error 
                 "no converter available for class ~(~A [~A]~)" 
                 (?identifier class-def)
                 (?module-id class-def)))

(defun error-no-setter (fun)
  (write-message ^error 
                 "no converter available for function ~(~A [~A]~)" 
                 (?identifier fun)
                 (?module-id fun)))

(defun error-class-required-in-converter-spec (gf-spec)
  (write-message ^error 
                 "a class is required in converter specification ~(~A~)" 
                 gf-spec))

(defun error-function-required-in-setter-spec (gf-spec)
  (write-message ^error 
                 "a function is required in setter specification ~(~A~)" 
                 gf-spec))

(defun error-invalid-generic-function-spec (gf-spec)
  (write-message ^error 
                 "invalid key in generic function specification ~(~A~)" 
                 gf-spec))

(defun error-converter-redefinition (class-def)
  (write-message ^error 
                 "attempt to redefine previously defined converter for ~(~A [~A]~)" 
                 (?identifier class-def)
                 (?module-id class-def)))

(defun error-setter-redefinition (fun)
  (write-message ^error 
                 "attempt to redefine previously defined setter for ~(~A [~A]~)" 
                 (?identifier fun)
                 (?module-id fun)))

#module-end
