;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-classes -*-
#|
-----------------------------------------------------------------------------------
TITLE: Transformation of class definitions into LZS
-----------------------------------------------------------------------------------
File:    el2lzs-classes.em
Version: 1.20 (last modification on Mon Nov  8 13:14:40 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/el2lzs-classes.em[1.0]
	Mon Mar 22 16:41:21 1993 imohr@isst save $
 transformation rules for class definitions to LZS
 
el2lzs-classes.em[1.1] Wed Mar 24 13:44:52 1993 imohr@isst proposed $
 classes and generic functions ok
 
el2lzs-classes.em[1.2] Wed Mar 24 16:49:36 1993 imohr@isst proposed $
 class options representation. ok
 
el2lzs-classes.em[1.3] Mon Mar 29 13:31:11 1993 imohr@isst proposed $
 [Wed Mar 24 16:51:17 1993] Intention for change:
 --- no intent expressed ---
el2lzs-classes.em[1.4] Fri Apr  2 15:59:49 1993 imohr@isst proposed $
 literal expansion for classes
 
el2lzs-classes.em[1.5] Tue Apr  6 16:10:30 1993 imohr@isst save $
 + stuff for lattice types
 
el2lzs-classes.em[1.6] Tue Apr  6 17:22:44 1993 imohr@isst save $
 
el2lzs-classes.em[1.7] Tue Apr  6 17:28:19 1993 imohr@isst proposed $
 
el2lzs-classes.em[1.8] Thu Apr  8 15:20:28 1993 imohr@isst proposed $
 code generation for classes ok
 
el2lzs-classes.em[1.9] Fri Apr 16 17:09:06 1993 imohr@isst proposed $
 error in my english removed
 
el2lzs-classes.em[1.10] Mon Apr 19 15:43:13 1993 imohr@isst proposed $
 without warning when searching for a class binding for lattice-types
 
el2lzs-classes.em[1.11] Thu May 27 08:55:35 1993 imohr@isst proposed $
 abstract classes with predicate
 
el2lzs-classes.em[1.12] Fri Aug 27 17:12:07 1993 akind@isst proposed $
 [Fri Aug 27 15:28:41 1993] Intention for change:
 change %define-lattice-type
 
el2lzs-classes.em[1.13] Tue Sep  7 17:15:42 1993 imohr@isst published $
 [Tue Sep  7 16:17:02 1993] Intention for change:
 set setter in readers
 
el2lzs-classes.em[1.14] Thu Sep 23 13:10:58 1993 imohr@isst proposed $
 [Tue Sep 21 15:59:22 1993] Intention for change:
 naming generated functions
 and install range-and-domain in slot init functions
 
el2lzs-classes.em[1.15] Thu Sep 30 15:06:27 1993 imohr@isst proposed $
 [Thu Sep 30 12:53:22 1993] Intention for change:
 naming of accessors
 
el2lzs-classes.em[1.16] Fri Oct  1 18:48:05 1993 imohr@isst proposed $
 [Fri Oct  1 15:46:34 1993] Intention for change:
 correcting naming of accessors
 
el2lzs-classes.em[1.17] Wed Oct 13 15:45:06 1993 imohr@isst proposed $
 [Mon Oct 11 13:34:35 1993] Intention for change:
 + initarg-option for slots
 
el2lzs-classes.em[1.18] Fri Oct 15 17:34:31 1993 imohr@isst proposed $
 [Fri Oct 15 08:27:45 1993] Intention for change:
 provide slot options reader, accessor and writer to initialize
 
el2lzs-classes.em[1.19] Wed Oct 20 18:44:28 1993 imohr@isst published $
 [Wed Oct 20 17:12:18 1993] Intention for change:
 improve error handling
 
el2lzs-classes.em[1.20] Tue Nov  9 11:36:19 1993 imohr@isst proposed $
 [Mon Nov  1 13:05:34 1993] Intention for change:
 

-----------------------------------------------------------------------------------
|#

#module el2lzs-classes
(import (level-1-eulisp 
         el2lzs-rules
         el2lzs-error
         option-lists
         pair-ext 
         list-ext
         tail-module
         lzs-mop
         quasiquote
         (only (set-interpreter call) eval)
         (only (get-defined-lattice-type add-lattice-type) ti-lattice)
         (only (mapcar nconc mapc warn list* reverse vector append) 
           common-lisp))
 syntax (level-1-eulisp 
         el2lzs-main
         (only (prog1) common-lisp))
 export (get-class-or-lattice-type)
 )

;;; -----------------------------------------------------------------------------------
;;; TS (transsyn)
;;; -----------------------------------------------------------------------------------

(deftranssyn (%define-standard-class class-spec superclass 
                                     slot-specs . class-options)
  (with-defining-form 
    (unless (check-options () 
                           ^(initargs representation allocation mm-type
                             direct-super-lattice-types)
                           ^(constructor predicate)
                           class-options)
      (error-bad-class-options class-options))
    (transsyn-slot-specs slot-specs)
    (whole-form)))

(deftranssyn (%define-tail-class class-spec 
                                 slot-specs . class-options)
  (with-defining-form 
    (unless (check-options () 
                           ^(initargs representation allocation mm-type
                             direct-super-lattice-types)
                           ^(constructor)
                           class-options)
      (error-bad-class-options class-options))
    (transsyn-slot-specs slot-specs)
    (whole-form)))

(deftranssyn (%define-abstract-class class-spec superclass
                                     slot-specs . class-options)
  (with-defining-form 
    (unless (check-options () 
                           ^(initargs direct-super-lattice-types)
                           ^(predicate)
                           class-options)
      (error-bad-class-options class-options))
    (transsyn-slot-specs slot-specs)
    (whole-form)))

(deftranssyn (%define-metaclass class-spec superclass
                                slot-specs . class-options)
  (with-defining-form 
    (unless (check-options () 
                           ^(initargs representation allocation mm-type
                             direct-super-lattice-types)
                           ^(constructor predicate)
                           class-options)
      (error-bad-class-options class-options))
    (transsyn-slot-specs slot-specs)
    (whole-form)))

(defun transsyn-slot-specs (slot-specs)
  (mapc (lambda (slot-spec)
          (check-options () ^(initform type initarg) ^(reader writer accessor)
                         (cdr slot-spec))
          (replace-option-value #'transsyn ^initform (cdr slot-spec)))
        slot-specs))

;;; -----------------------------------------------------------------------------------
;;; TM (transmod)
;;; -----------------------------------------------------------------------------------

(deftransmod (%define-standard-class class-spec superclass 
                                     slot-specs . class-options)
  (transmod-%define-class <standard-class-def> 
                          class-spec superclass 
                          slot-specs class-options))

(deftransmod (%define-tail-class class-spec 
                                 slot-specs . class-options)
  (transmod-%define-class <tail-class-def> 
                          class-spec () 
                          slot-specs class-options))

(deftransmod (%define-abstract-class class-spec superclass 
                                     slot-specs . class-options)
  (transmod-%define-class <abstract-class-def> 
                          class-spec superclass 
                          slot-specs class-options))

(deftransmod (%define-metaclass class-spec superclass 
                                slot-specs . class-options)
  (transmod-%define-class <metaclass-def> 
                          class-spec superclass 
                          slot-specs class-options))

(defun transmod-%define-class (compiler-class class-spec superclass
                               slot-specs class-options)
  (let* ((ID (first class-spec))
         (class (make-instance compiler-class :identifier ID)))
    (add-class class)
    (nconc (list class) 
           (transmod-slot-specs slot-specs)
           (transmod-class-options class-options))))

(defun transmod-slot-specs (slot-specs)
  (let ((accessor-bindings nil))
    (mapc (lambda (slot-spec)
            (map-option-list 
             (lambda (key value)
               (when (member key ^(reader writer accessor))
                 (push (add-const (make-instance <defined-named-const>
                                    :identifier value))
                       accessor-bindings))) 
             (cdr slot-spec)     ; the slot option list
             ))
          slot-specs)
    accessor-bindings))

(defun transmod-class-options (class-options)
  (let ((functions nil))
    (map-option-list 
     (lambda (key value)
       (cond ((eq key ^predicate)
              (push (add-const (make-instance <defined-named-const>
                                 :identifier value))
                    functions))
             ((eq key ^constructor)
              (push (add-const (make-instance <defined-named-const>
                                 :identifier (car value)))
                    functions))
             (t nil)))
     class-options)
    functions))

;;; -----------------------------------------------------------------------------------
;;; TD (transdef)
;;; -----------------------------------------------------------------------------------

(deftransdef (%define-standard-class class-spec superclass 
                                     slot-specs . class-options)
  (with-defining-form
    (transdef-%define-class class-spec superclass slot-specs class-options)))

(deftransdef (%define-tail-class class-spec
                                 slot-specs . class-options)
  (with-defining-form
    (transdef-%define-class class-spec () slot-specs class-options)))

(deftransdef (%define-abstract-class class-spec superclass 
                                     slot-specs . class-options)
  (with-defining-form 
    (transdef-%define-class class-spec superclass slot-specs class-options)))

(deftransdef (%define-metaclass class-spec superclass 
                                slot-specs . class-options)
  (with-defining-form
    (transdef-%define-class class-spec superclass slot-specs class-options)))

(defun transdef-%define-class (class-spec superclass slot-specs class-options)
  ; This function must fill the class definition and the function definitions
  ; for the predicate, the constructor and for all slot accessors
  (let* ((id (first class-spec))
         (metaclass (second class-spec))
         (class-def (find-in-lex-env id))
         (supers (if superclass 
                   (list (find-in-lex-env superclass))
                   nil)))
    (setf (?class class-def) (find-in-lex-env metaclass))
    (~initialize class-def
        (list ^name id
              ^direct-superclasses supers
              ^direct-slot-descriptions (mapcar (lambda (s)
                                                  (make-slot-spec class-def s))
                                                slot-specs)
              ^direct-initargs (append
                                (slot-initargs slot-specs)
                                (get-option ^initargs class-options nil))
              ^representation (get-option ^representation class-options nil)
              ^allocation (get-option ^allocation class-options nil)
              ^mm-type (compute-constant-value 
                        (trans (get-option ^mm-type class-options nil)))
              ^direct-super-lattice-types 
              (trans-lattice-type-list 
               (get-option ^direct-super-lattice-types class-options nil))
              ))
    (bind-slot-accessors class-def slot-specs)
    (bind-class-functions class-def class-options)
    (reverse (?initialization class-def))))

(defun bind-slot-accessors (class-def slot-specs)
  (mapc (lambda (slot-spec)
          (let ((slot (~find-slot-description class-def (car slot-spec))))
            (map-option-list 
             (lambda (key value)
               (bind-slot-accessor key value slot))
             (cdr slot-spec))
            (name-slot-accessors slot)))
        slot-specs))

(defun bind-slot-accessor (accessor-type name slot)
  (let ((accessor nil))
    (cond ((eq accessor-type ^reader)
           (setq accessor (~slot-description-slot-reader slot)))
          ((eq accessor-type ^accessor)
           (setq accessor (~slot-description-slot-reader slot))
           (setf (?setter accessor)
                 (~slot-description-slot-writer slot))
           (unless (?identifier (?setter accessor))
             (setf (?identifier (?setter accessor)) (list ^setter name))))
          ((eq accessor-type ^writer)
           (setq accessor (~slot-description-slot-writer slot))))
    (when accessor
      (setf (?value (find-in-lex-env name)) accessor)
      ; the following installs a listed identifier to avoid that two objects 
      ; have the same name 
      (unless (?identifier accessor)
        (setf (?identifier accessor) (list name)))
      )))

(defun name-slot-accessors (slot)
  ;installs default names for accessors not explicitely named
  (when (and (~slot-description-slot-reader slot)
             (null (?identifier (~slot-description-slot-reader slot))))
    (setf (?identifier (~slot-description-slot-reader slot))
          (list (~slot-description-name slot)
                ^of
                (?identifier (?slot-of slot))
                )))
  (when (and (~slot-description-slot-writer slot)
             (null (?identifier (~slot-description-slot-writer slot))))
    (setf (?identifier (~slot-description-slot-writer slot))
          (list ^setter
                (~slot-description-name slot)
                ^of
                (?identifier (?slot-of slot))
                )))
  )

(defun bind-class-functions (class-def class-options)
  (map-option-list
   (lambda (key value)
     (bind-class-function key value class-def))
   class-options))

(defun bind-class-function (function-type spec class)
  (let (function name)
    (cond ((eq function-type ^predicate)
           (setq function (~compute-predicate class))
           (setq name spec))
          ((eq function-type ^constructor)
           (setq function (~compute-constructor class (cdr spec)))
           (setq name (car spec))))
    (when function
      (setf (?value (find-in-lex-env name))
            function)
      ; the following installs a listed identifier to avoid that two objects 
      ; have the same name 
      (unless (?identifier function)
        (setf (?identifier function) (list name)))
      )))

(defgeneric compute-constant-value (lzs-object))
(defmethod compute-constant-value ((lzs-object <null>)) nil)
;(defmethod compute-constant-value ((lzs-object <integer>)) lzs-object)
(defmethod compute-constant-value ((lzs-object <literal-instance>)) lzs-object)
(defmethod compute-constant-value ((lzs-object <defined-named-const>))
  (if (eq (?value lzs-object) 'unknown)
    (error-mm-type-unknown-at-compile-time (?identifier lzs-object))
    (?value lzs-object)))
(defmethod compute-constant-value (lzs-object)
  (error-invalid-mm-type lzs-object))

(defun make-slot-spec (class slot-spec)
  (let* ((name (car slot-spec))
        (type-option (find-option ^type (cdr slot-spec) nil))
        (type (and type-option (find-in-lex-env (car type-option))))
        (initform-option (find-option ^initform (cdr slot-spec) nil))
        (initarg-option (find-option ^initarg (cdr slot-spec) nil))
        (reader-option (or (find-option ^reader (cdr slot-spec) nil)
                           (find-option ^accessor (cdr slot-spec) nil)))
        (writer-option (or (find-option ^writer (cdr slot-spec) nil)
                           (find-option ^accessor (cdr slot-spec) nil)))
        )
    (nconc (list ^name name
                 ^reader reader-option  ; used as a flag only for tail classes
                 ^writer writer-option) ; used as a flag only for tail classes
           (when type-option 
             (list ^type type)) 
           (when initform-option 
             (list ^initfunction 
                   (create-slot-init-function class name type
                                              (car initform-option))))
           (when initarg-option
             (list ^initarg
                   (car initarg-option))))))

(defun create-slot-init-function (class slot-name slot-type initform)
  (let ((init-fun 
         (make-instance <slot-init-fun>
           :identifier (list ^init slot-name ^of (?identifier class)))))
    (when slot-type
      (setf (?range-and-domain init-fun) (vector slot-type)))
    (add-function                         ; install it as a global function  
     (complete-function init-fun
                        ()
                        initform
                        (dynamic lex-env)))))

(defun slot-initargs (slot-specs)
  (if (null slot-specs) nil
      (let ((initarg-option (find-option ^initarg (cdar slot-specs) nil)))
        (if initarg-option
          (cons (car initarg-option)
                (slot-initargs (cdr slot-specs)))
          (slot-initargs (cdr slot-specs))))))

;;; -----------------------------------------------------------------------------------
;;; %define-lattice-type
;;; -----------------------------------------------------------------------------------

(deftranssyn (%define-lattice-type name supers subs . values)
  (whole-form))

; transmod is not necessary, because no global binding must be created

(deftransdef (%define-lattice-type name supers subs . values)
  (with-defining-form 
    (add-lattice-type name
                      (trans-lattice-type-list supers)
                      (trans-lattice-type-list subs)
		      values)
    nil))

(defun trans-lattice-type-list (lattice-types)
  (mapcar #'get-class-or-lattice-type lattice-types))

(defun get-class-or-lattice-type (identifier)
  (choose-class-or-lattice-type identifier
                                (dynamic-let ((error-if-no-lexical-found nil))
                                   (find-in-lex-env identifier))
                                (get-defined-lattice-type identifier)))

(defgeneric choose-class-or-lattice-type (identifier binding lattice-type))

(defmethod choose-class-or-lattice-type (identifier
                                         (class <class-def>) 
                                         (lattice-type <null>))
  class)

(defmethod choose-class-or-lattice-type (identifier (class <null>) lattice-type)
  lattice-type)

(defmethod choose-class-or-lattice-type (identifier (class <class-def>) lattice-type)
  (error-class-equal-lattice-type identifier)
  class)

(defmethod choose-class-or-lattice-type (identifier
                                         (class <null>) 
                                         (lattice-type <null>))
  (error-neither-class-nor-lattice-type identifier))


#module-end
