;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: configuration -*-
#|
-----------------------------------------------------------------------------------
TITLE: interface to configuration of apply
-----------------------------------------------------------------------------------
File:    configuration.em
Version: 1.4 (last modification on Tue Dec  7 15:22:44 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/configuration.em[1.0]
	Wed Aug 25 15:36:14 1993 ukriegel@isst published $
 aux. fcns and defs for configuration tool and #+
 
configuration.em[1.1] Thu Nov 18 14:47:42 1993 ukriegel@isst save $
 [Thu Nov 18 13:53:42 1993] Intention for change:
 read configuration-file from dir ApplyModules
 new module syntax , read eu2c.config
 
configuration.em[1.2] Fri Nov 19 13:42:24 1993 ukriegel@isst proposed $
 [Thu Nov 18 15:04:31 1993] Intention for change:
 new syntax
 
configuration.em[1.3] Fri Nov 26 10:56:00 1993 ukriegel@isst proposed $
 [Fri Nov 26 10:53:20 1993] Intention for change:
 read configuration file at compilation time
 done
 
configuration.em[1.4] Tue Dec  7 17:06:00 1993 imohr@isst proposed $
 [Mon Dec  6 16:19:40 1993] Intention for change:
 add extraction of special configuration variables
 add :inline
 

-----------------------------------------------------------------------------------
|#

#module configuration
(import (level-1-eulisp 
         (only (read-eulisp $eulisp-readtable) el-modules)
         (rename ((second cl:second)
                  (member cl:member)
                  (set-dispatch-macro-character cl::set-dispatch-macro-character)
                  (error cl:error)
                  (char= cl:char=)
                  (not cl:not)
                  (some cl:some)
                  (every cl:every)
                  (values cl:values)
                  (read cl:read)
                  (with-open-file cl:with-open-file)
                  (make-pathname cl:make-pathname))
           (only (values not some every make-pathname member second
                  read set-dispatch-macro-character error char= with-open-file) 
             common-lisp))
         )
 syntax (level-1-eulisp)
 export (?configuration 
         ?configuration-value
         ?configuration-values
         configurationp 
         init-configuration-table))

;;; -----------------------------------------------------------------------------------
;;; initialization of configuration
;;; -----------------------------------------------------------------------------------
(deflocal configuration-table  ())

(defun init-configuration-table ()
  (cl:with-open-file (s (cl:make-pathname 
                         :directory `(,@common-lisp-user::$applyroot "ApplyModules")
                         :name "eu2c.config") :direction :input)
    (setq configuration-table (read-eulisp s))
    (if (eq s configuration-table)
      (progn (cl:error "Error empty configuration file... Exit")
             (exit))
      (initialize-configuration-variables))))

;;; -----------------------------------------------------------------------------------
;;; interface functions
;;; -----------------------------------------------------------------------------------

(defun configurationp (key value)
  (if (cl:member value (car(cl:member key configuration-table :key #'car)))
    t
    ()))

(defun ?configuration (key)
  (let ((entry (cl:member key configuration-table :key #'car)))
    (and entry (car entry))))

(defun ?configuration-value (key)
  (cl:second (?configuration key)))

(defun ?configuration-values (key)
  (cdr (?configuration key)))

;;; -----------------------------------------------------------------------------------
;;; conditional reader macros for using configuration tests in applications
;;; -----------------------------------------------------------------------------------

(defun read-configuration-expression
       (s macro-char arg)
  (let ((conf (read-eulisp s))
        (expr (read-eulisp s)))
    (if (or (and (cl:char= macro-char #\+)
                 (check-configuration conf))
            (and (cl:char= macro-char #\-)
                 (cl:not (check-configuration conf))))
      expr
      (cl:values)
      )))

(defun check-configuration
       (conf)
  (if (consp conf)
      ()
      (error "~%Error wrong expression ~s for conditional read" conf))
  (let ((op (car conf)))
    (cond ((eq op 'eulisp-symbol::not)
           (cl:not (check-configuration (car (cdr conf)))))
          ((eq op 'eulisp-symbol::or)
           (cl:some #'check-configuration (cdr conf)))
          ((eq op 'eulisp-symbol::and)
           (cl:every #'check-configuration (cdr conf)))
          (t (configurationp (car conf) (car (cdr conf)))))))



(cl:set-dispatch-macro-character #\# #\+ #'read-configuration-expression
                              $eulisp-readtable)
(cl:set-dispatch-macro-character #\# #\- #'read-configuration-expression
                              $eulisp-readtable)
          
;;; -----------------------------------------------------------------------------------
;;; configuration variables
;;; -----------------------------------------------------------------------------------

(defvar *inline* nil) 
; used in function-call
; nil - no inlining at all
; 0   - only inlining of slot-accessors and slot-initfunctions if they meet the
;       requirement of (dynamic *inline*) = 1
; n   - inlining takes place if the "complexity" of the function is less than n 

(defvar *info-level* 2)
(defvar *system-info-level* 2)
; 0 no infos, very short warnings and errors
; 1 very short infos
; 2 some infos
; 3 all infos

(defun initialize-configuration-variables ()
  (dynamic-setq *inline* (?configuration-value ^inline))
  (dynamic-setq *info-level* (?configuration-value ^info-level))
  (dynamic-setq *system-info-level* (?configuration-value ^system-info-level))
  )

#module-end
