;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: code-generator -*-
#|
-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    code-generator.em
Version: 1.11 (last modification on Fri Dec 10 11:40:40 1993)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /tmp_mnt/home/saturn/imohr/Lisp/Apply/code-generator.em[1.0]
	Fri May 21 12:41:35 1993 imohr@isst save $
 general part of a simple code generator for SPARC
 
code-generator.em[1.1] Thu May 27 14:43:41 1993 hfried@isst proposed $
 [Thu May 27 12:57:29 1993] Intention for change:
 + code generation for functions oder so wat
 aaa
 done
 
code-generator.em[1.2] Thu Jun  3 09:10:08 1993 imohr@isst proposed $
 [Thu Jun  3 08:18:38 1993] Intention for change:
 code output on screen when debugging
 
code-generator.em[1.3] Thu Jun  3 10:28:11 1993 imohr@isst proposed $
 [Thu Jun  3 10:24:32 1993] Intention for change:
 close of .s-file only when not in debugging mode
 
code-generator.em[1.4] Thu Aug  5 09:36:58 1993 imohr@isst proposed $
 [Mon Jul 19 08:26:31 1993] Intention for change:
 + c-code generation
 C-code generation
 
code-generator.em[1.5] Tue Aug 17 14:24:14 1993 imohr@isst proposed $
 
code-generator.em[1.6] Fri Aug 20 07:57:40 1993 imohr@isst proposed $
 [Tue Aug 17 14:30:02 1993] Intention for change:
 --- no intent expressed ---import of apply-configuration
 
code-generator.em[1.7] Thu Aug 26 09:51:30 1993 imohr@isst proposed $
 [Tue Aug 24 11:40:26 1993] Intention for change:
 c-code for data
 ok
 
code-generator.em[1.8] Mon Aug 30 16:45:28 1993 imohr@isst published $
 [Mon Aug 30 13:58:15 1993] Intention for change:
 - reset-c-data
 + configuration
 configuration not yet included
 
code-generator.em[1.9] Mon Sep 27 11:17:49 1993 imohr@isst published $
 [Fri Sep 24 11:09:25 1993] Intention for change:
 deactivate asm-code generation
 
code-generator.em[1.10] Fri Nov 19 13:42:17 1993 ukriegel@isst proposed $
 [Fri Nov 19 06:38:58 1993] Intention for change:
 reset *generate-code* by configuratiop
 
code-generator.em[1.11] Mon Dec 13 11:55:50 1993 imohr@isst proposed $
 [Thu Dec  9 15:14:19 1993] Intention for change:
 + generation of h-file
 generation of h-file for modules with export interface
 

-----------------------------------------------------------------------------------
|#

#module code-generator
(import 
 (level-1-eulisp
  (only (?configuration configurationp) configuration)
 accessors lzs
 c-code
 c-data
 generate-header-file
 debugging
 (only (*print-circle* *print-pretty*
        open make-pathname string-downcase string format)
   common-lisp))

 syntax (level-1-eulisp)

 export (generate-code))

(defvar code-output t)

(defun generate-c-file (main-module modules)
    (dynamic-let ((code-output
                   (if (code-debug) t
                       (open (make-pathname :name (string-downcase 
                                                   (string 
                                                    (?identifier main-module)))
                                            :type "c")
                         :direction :output :if-exists :new-version)))
;                  (*label* nil)
;                  (*comment* nil)
;                  (*label-comment* nil)
;                  (*align* nil)
;                  (*alignment* 1)
                  )
       (unwind-protect 
         (generate-c-code main-module modules)
         (unless (eq (dynamic code-output) t) 
           (close (dynamic code-output))))))

(defun generate-inst-file (main-module modules)
    (dynamic-let ((code-output
                   (if (code-debug) t
                       (open (make-pathname :name (string-downcase 
                                                   (string 
                                                    (?identifier main-module)))
                                            :type "inst")
                         :direction :output :if-exists :new-version)))
;                  (*label* nil)
;                  (*comment* nil)
;                  (*label-comment* nil)
;                  (*align* nil)
;                  (*alignment* 1)
                  )
       (unwind-protect 
         (generate-c-data)
         (unless (eq (dynamic code-output) t) 
           (close (dynamic code-output))))))

(defun generate-h-file (main-module modules)
  (when (?exports main-module)
    (dynamic-let ((code-output
                   (if (code-debug) t
                       (open (make-pathname :name (string-downcase 
                                                   (string 
                                                    (?identifier main-module)))
                                            :type "h")
                         :direction :output :if-exists :new-version)))
;                  (*label* nil)
;                  (*comment* nil)
;                  (*label-comment* nil)
;                  (*align* nil)
;                  (*alignment* 1)
                  )
       (unwind-protect 
         (generate-header-file main-module)
         (unless (eq (dynamic code-output) t) 
           (close (dynamic code-output)))))))

(defun generate-code (main-module modules)
  (let ((*print-circle* nil)
        (*print-pretty* nil)
        )
    (format t "~%~(~A~).h" (?identifier main-module))
    (generate-h-file main-module modules)
    (format t "~%~(~A~).c" (?identifier main-module))
    (generate-c-file main-module modules)
    (format t "~%~(~A~).inst" (?identifier main-module))
    (generate-inst-file main-module modules)
    ))

#module-end ; code-generator
