;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: arg-context -*-
#|
-----------------------------------------------------------------------------------
TITLE: all analyses in context arg 
-----------------------------------------------------------------------------------
File:    arg-context.em
Version: 1.5 (last modification on Wed Apr  7 08:37:24 1993)
State:   proposed

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de

HISTORY: 
Log for /tmp_mnt/home/saturn/imohr/Lisp/Apply/arg-context.em[1.0]
	Fri Mar  5 12:04:38 1993 hfried@isst save $
 
arg-context.em[1.1] Fri Mar  5 13:00:57 1993 hfried@isst save $
 [Fri Mar  5 12:05:09 1993] Intention for change:
 test
 text
 
arg-context.em[1.2] Thu Mar 18 08:59:13 1993 hfried@isst proposed $
 [Fri Mar  5 13:03:07 1993] Intention for change:
 
arg-context.em[1.3] Wed Mar 24 13:47:55 1993 hfried@isst proposed $
 [Thu Mar 18 09:10:43 1993] Intention for change:
 + glob anna
 
arg-context.em[1.4] Thu Mar 25 11:18:51 1993 hfried@isst proposed $
 [Wed Mar 24 14:52:43 1993] Intention for change:
 + gen-fun
 new head
 
arg-context.em[1.5] Tue Apr 13 14:08:35 1993 hfried@isst proposed $
 [Thu Mar 25 11:53:44 1993] Intention for change:
 

-----------------------------------------------------------------------------------
|#

#module-name arg-context
#module-import 
( level-1-eulisp
  SIMPLE-PROGRAMMING
  LZS 
  MZS 
  context 
  analyse-h
  progn-context
  type-propagation
  (only (error) common-lisp)
  type-inference
  lzs-to-mzs-fun
  function-call-context
  vector
  function-call
  if-form
  letstar-form
  setq-form
  gutter) 

#module-syntax-import 
( level-1-eulisp )
#module-syntax-definitions

;--- defmacro forms

#module-header-end


;  exports

(defmethod finish-a ((con <arg>) form) form)

;--------------------------
; constants
;--------------------------

;          -----       -----        -------------
(defmethod l2m-a ((con <arg>) (form <named-const>))
;          -----       -----        -------------
;
; form = <defined-named-constant>, <imported-named-constant>
;
form)

;          -----       -----        -----
(defmethod l2m-a ((con <arg>) (form <sym>))
;          -----       -----        -----
;
; form = <defined-symbol>, <imported-symbol>
;
form)

;          -----       -----        -----
(defmethod l2m-a ((con <arg>) (form <symbol>))
;          -----       -----        -----
;
; form = slot-name
;
form)

;          -----       -----        ---------
(defmethod l2m-a ((con <arg>) (form <structured-literal>))
;          -----       -----        ---------
; 
; value = <vector>, <pair>, <string>, LITERAL-INSTANCE
;
form)

;          -----       -----        -------
(defmethod l2m-a ((con <arg>) (form <spint>))
;          -----       -----        -------
;
; <spint> - single precisition integer
;
form)

;          -----       -----        --------------
(defmethod l2m-a ((con <arg>) (form <double-float>))
;          -----       -----        --------------
form)

;          -----       -----        -----------
(defmethod l2m-a ((con <arg>) (form <character>))
;          -----       -----        -----------
form)

;          -----       -----        ----------
(defmethod l2m-a ((con <arg>) (form <class-def>))
;          -----       -----        -----------
;
;  form = <defined-class>, <imported-class>
;
form)

;          -----       -----        -------
(defmethod l2m-a ((con <arg>) (form <literal-instance>))
;          -----       -----        -------
form)

;          -----       -----        ------------
(defmethod l2m-a ((con <arg>) (form <global-fun>))
;          -----       -----        ------------
  (setf (?function-type form) $data)
form)

;          -----       -----        -----------
(defmethod l2m-a ((con <arg>) (form <local-fun>))
;          -----       -----        -----------
  (lzs2mzs-fun form)
  (if (eq (?function-type form) $closure)
    (make-a-closure-function form (dynamic block))
    form)
)

;          -----       -----        --------------
(defmethod l2m-a ((con <arg>) (form <imported-fun>))
;          -----       -----        --------------
  (setf (?function-type form) $data)
form)

;          -----       -----        ------
(defmethod l2m-a ((con <arg>) (form <special-sys-fun>))
;          -----       -----        ------
  (setf (?function-type form) $data)
form)

;          -----       -----        ---------
(defmethod l2m-a ((con <arg>) (form <global-generic-fun>))
;          -----       -----        ---------
  (setf (?function-type form) $data)
form)

;          -----       -----        --------
(defmethod l2m-a ((con <arg>) (form <local-generic-fun>))
;          -----       -----        --------
  (setf (?function-type form) $data)
form)

;          -----       -----        -----------
(defmethod l2m-a ((con <arg>) (form <imported-generic-fun>))
;          -----       -----        -----------
  (setf (?function-type form) $data)
form)

;          -----       -----        ------
(defmethod l2m-a ((con <arg>) (form <cont>))
;          -----       -----        ------
form)

;          -----       -----        ------
(defmethod l2m-a ((con <arg>) (form <null>))
;          -----       -----        ------
form)

;--------------------------
;   end of constans 
;--------------------------

;--------------------------
;   begin of variables 
;--------------------------
;          -----       -----        ---------
(defmethod l2m-a ((con <arg>) (form <var-ref>))
;          -----       -----        ---------
;
; var = <local-static>, <global-static>, <imported-static>, <dynamic>
;
  (let ((var (?var form)))
    (if (local-static-p var) (rename var)
        var))
)

;--------------------------
;   begin of function call 
;--------------------------

;          -----       -----        -----
(defmethod l2m-a ((con <arg>) (form <app>))
;          -----       -----        -----
;
  (let ((fun (?function form)))
    (if (cont-p fun) (error "continuation in argument position")
;        (if (eq (common-lisp::class-of fun) lzs-mop::<slot-accessor-fun>)
;          (let* ((arglist (?arg-list form))
;                    (arg-num (length arglist))
;                    (var-vec (make-vector (+ arg-num 1)))
;                    (call (make <call> 
;                                :function fun
;                                :arg-num arg-num
;                                :var-descr (make <var-descr>
;                                                 :var-vec var-vec
;                                                 :constant-counter 0))))
;            (lzs2mzs-fun fun)
;               (l2m-call call arglist)
;               (print "************************ Start inline ****************")
;               (inline::inline-a con fun var-vec))
          (call-a-function fun (?arg-list form) 
                           nil (?read-glocs form)))))
;)

;--------------------------
;   end of function call
;--------------------------

;          -----       -----        -----------
(defmethod l2m-a ((con <arg>) (form <setq-form>))
;          -----       -----        -----------
;
; location = <local-static>, <global-static>, <imported-static>, <dynamic>,
; <defined-named-const>, <imported-named-const>
;
  (setq-form-a con form)
)

;          -----       -----        ------------
(defmethod l2m-a ((con <arg>) (form <progn-form>))
;          -----       -----        ------------
   (l2m-progn con (?form-list form))
)

;          -----       -----        ---------
(defmethod l2m-a ((con <arg>) (form <if-form>))
;          -----       -----        ---------
   (if-form-a con form) 
)

;          -----       -----        -------------
(defmethod l2m-a ((con <arg>) (form <switch-form>))
;          -----       -----        -------------
   (print "<arg> <switch-form> not implemented") 
   ())

;          -----       -----        -----------
(defmethod l2m-a ((con <arg>) (form <let*-form>))
;          -----       -----        -----------
   (letstar-a con form) 
)

;          -----       -----        -------------
(defmethod l2m-a ((con <arg>) (form <labels-form>))
;          -----       -----        -------------
  (l2m-a con (?body form)))

;          -----       -----        -------------
(defmethod l2m-a ((con <arg>) (form <let/cc-form>))
;          -----       -----        -------------
   (print "<arg> <let/cc-form> not implemented") 
   ())

;
;(defmethod l2m-a ((con <arg>) (form <labeled-form>))
;   (print "<arg> <labeled-form> not implemented") 
;   ())
;
;
;(defmethod l2m-a ((con <arg>) (form <tagbody-form>))
;   (print "<arg> <tagbody-form> not implemented") 
;   ())
;
;
;(defmethod l2m-a ((con <arg>) (form <mv-lambda>))
;   (print "<arg> <mv-lambda> not implemented") 
;   ())
;

#module-end