;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: analyse-h -*-
#|
-----------------------------------------------------------------------------------
TITLE: definitions for the transformation from LZS to MZS
-----------------------------------------------------------------------------------
File:    analyse-h.em
Version: 1.11 (last modification on Thu Nov 25 08:55:53 1993)
State:   proposed

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/analyse-h.em[1.0]
	Fri Mar  5 12:03:47 1993 hfried@isst save $
 
analyse-h.em[1.1] Fri Mar  5 13:00:40 1993 hfried@isst save $
 [Fri Mar  5 12:04:16 1993] Intention for change:
 text
 text
 
analyse-h.em[1.2] Thu Mar 18 08:05:45 1993 hfried@isst save $
 text
 
analyse-h.em[1.3] Thu Mar 18 08:52:23 1993 hfried@isst proposed $
 
analyse-h.em[1.4] Wed Mar 24 13:47:41 1993 hfried@isst proposed $
 [Thu Mar 18 09:10:26 1993] Intention for change:
 + glob anna
 
analyse-h.em[1.5] Thu Mar 25 11:18:36 1993 hfried@isst proposed $
 [Wed Mar 24 14:52:30 1993] Intention for change:
 + gen-fun
 new head
 
analyse-h.em[1.6] Tue Apr 13 14:08:09 1993 hfried@isst proposed $
 [Thu Mar 25 11:53:38 1993] Intention for change:
 closures
 
analyse-h.em[1.7] Tue Apr 20 15:45:03 1993 hfried@isst proposed $
 [Tue Apr 13 14:14:48 1993] Intention for change:
 cast
 
analyse-h.em[1.8] Mon Jun 21 11:32:46 1993 hfried@isst published $
 [Tue Apr 20 15:53:51 1993] Intention for change:
 
analyse-h.em[1.9] Wed Oct  6 16:34:02 1993 hfried@isst save $
 [Wed Oct  6 16:13:37 1993] Intention for change:
 add *analyse-method-subset*
 
analyse-h.em[1.10] Tue Nov 16 11:52:33 1993 hfried@isst proposed $
 [Mon Nov 15 16:07:28 1993] Intention for change:
 actual-method-subset
 
analyse-h.em[1.11] Fri Nov 26 10:41:49 1993 imohr@isst proposed $
 [Wed Nov 24 14:50:27 1993] Intention for change:
 removing defclass, replace it by defstandardclass
 

-----------------------------------------------------------------------------------
|#

#module analyse-h

(import (level-1-eulisp 
         lzs
         mzs
         accessors
         (only (assoc format) common-lisp)) 

 syntax (level-1-eulisp
         apply-standard)

 export  (<cast>
          closure env pathes typepathes block 
          rec-calls calls tests moves
          $normal $data $closure
          $funcall warning
          *started-and-not-finished-functions* *counter* l2m-a 
          append-stat  cons-block a-number finish-a
	  *actual-method-subset*)
 )

(defstandardclass <cast> () 
  (type :accessor :initarg :initform ())
  )

;--- definitions, exportations, initialization forms

;;-----------------------------------------------------------------------------------
;; global-environments
;;-----------------------------------------------------------------------------------

;       -------
(defvar closure  ())
;       -------
(defvar env       ())
;       ------
(defvar pathes ())
;       ----------
(defvar typepathes ())
;       ----------
(defvar block ())
;       -----
;;-----------------------------------------------------------------------------------
;; annotations for the function
;;-----------------------------------------------------------------------------------

;       --------
(defvar rec-calls ())
;       --------
(defvar calls    ())
;       ------
(defvar tests ())
;       -----
(defvar moves ())
;       -----
; function types
;            -------
(defconstant $normal 0)
;            -------
(defconstant $data   1)
;            --------
(defconstant $closure 2)
;            --------
(defconstant $funcall -99)
;            --------
;;-----------------------------------------------------------------------------------
;; local variables
;;-----------------------------------------------------------------------------------

;         ------------------------------------
(defvar *started-and-not-finished-functions* ())
;         ------------------------------------
(defvar *counter*                               1)
;         ---------

(defun a-number ()
  (let ((n (dynamic *counter*)))
    (setf (dynamic *counter*) (+ (dynamic *counter*) 1))
    n))


;;-----------------------------------------------------------------------------------
;;  generic-function
;;-----------------------------------------------------------------------------------

;           -----
(defgeneric l2m-a (context lzs-object))
;           -----

;      #######
(defun warning (string . args)
;      #######
  (apply #'format t string args))

;      ###########
(defun append-stat (list ele)
;      ###########
  (if (null list) (list ele)
      (progn (append-stat1 list (list ele))
             list)))

;      ------------
(defun append-stat1 (list ele)
;      ------------ 
  (if (null (cdr list))
    (setf (cdr list) ele)
    (append-stat1 (cdr list) ele)))

;           ########
(defgeneric finish-a (con var-or-constant))
;           ########

;      ##########
(defun cons-block (block pathes)
;      ##########
  (if pathes 
    (cons (cons block (car pathes))
          (cons-block block (cdr pathes)))
    ()))

(deflocal *actual-method-subset* ())

#module-end
