;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: table -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: table
-----------------------------------------------------------------------------------
File:    table.em
Version: 1.2 (last modification on Thu Jun 17 15:27:42 1993)
State:   published

DESCRIPTION:


DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ulrich Kriegel

CONTACT: 


HISTORY:
 
revised 03/12/1992 by *wh*

Log for /export/home/saturn/imohr/Lisp/EulispModules/table.em[1.0]
	Fri Mar  5 15:40:37 1993 imohr@isst proposed $
 
table.em[1.1] Wed Mar 10 13:13:30 1993 imohr@isst proposed $
 [Mon Mar  8 14:36:49 1993] Intention for change:
 Log not inside comments
 - with new file header
 - Log-message inside balanced comment
 
table.em[1.2] Thu Jun 17 15:22:09 1993 imohr@isst published $
 [Thu Jun 17 15:18:25 1993] Intention for change:
 + #module-end
 

-----------------------------------------------------------------------------------
|#

#module-name table
#module-import

(eulisp-kernel
 (only (make-hash-table make-instance values gethash typep 
                        eql remhash clrhash maphash) 
   common-lisp)
 )

#module-syntax-import 
(eulisp-kernel
 (rename 
   ((defun cl:defun) (defmethod cl:defmethod))
   common-lisp)
 (only 
   (&optional 
    defclass
    setf
    defsetf
;    defmethod
    )
   common-lisp))
#module-syntax-definitions

#module-header-end

(export make-table table-ref tablep table-delete)

(defclass <table>
  ()
  ((hash-table :reader table-hash-table-reader
               :writer table-hash-table-writer)
   (comparator :initarg  :comparator)))

(cl:defun make-table
       (&optional (comparator #'eql))
  (let ((tbl (make-instance '<table> :comparator comparator))
        (htbl (make-hash-table :test comparator)))
    (table-hash-table-writer htbl tbl)
;    (setf (slot-value tbl 'comparator) comparator)
    tbl))

(cl:defmethod table-ref
           ((table <table>) key-obj &optional (no-entry-value ()))
  (values (gethash key-obj (table-hash-table-reader table) no-entry-value)))

(cl:defmethod setter-table-ref ((table <table>) key value)
  (setf (gethash key (table-hash-table-reader table)) value))

(defsetf table-ref (table key) (value)
  `(setter-table-ref ,table ,key ,value))

(defun tablep(o)
  (typep o '<table>))

(defmethod table-delete 
           ((table <table>) key)
  (remhash key (table-hash-table-reader table)))

(defmethod clear-table 
           ((table <table>))
  (clrhash (table-hash-table-reader table))table)

(defmethod map-table 
           (function (table <table>))
  (maphash function (table-hash-table-reader table)))

#module-end
