;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: eulisp-kernel -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: The kernel of EuLisp
-----------------------------------------------------------------------------------
File:    eulisp-kernel.em
Version: 1.6 (last modification on Tue Oct 12 11:31:30 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:
The commented pieces of code marked with "compile-during-load" should be
activated if compilation during load is needed for Franz Allegro on SUN.

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /tmp_mnt/home/saturn/wheick/Lisp/EulispModules/eulisp-kernel.em[1.0]
	Fri Mar  5 15:40:13 1993 imohr@isst proposed $
 
eulisp-kernel.em[1.1] Wed Mar 10 13:12:11 1993 imohr@isst proposed $
 [Mon Mar  8 14:35:01 1993] Intention for change:
 Log not inside comments
 - with new file header
 - Log-message inside balanced comment
 
eulisp-kernel.em[1.2] Wed May 12 18:31:01 1993 imohr@isst save $
 [Wed May 12 18:30:36 1993] Intention for change:
 compilation of defun and defmethod during load (for Franz Allegro needed)
 ok
 
eulisp-kernel.em[1.3] Fri May 14 11:46:45 1993 imohr@isst proposed $
 ok
 
eulisp-kernel.em[1.4] Fri May 14 15:40:34 1993 imohr@isst proposed $
 [Fri May 14 13:50:51 1993] Intention for change:
 compilation of defuns and defmethods only for franz allegro
 ok
 
eulisp-kernel.em[1.5] Mon May 24 09:55:46 1993 imohr@isst published $
 [Mon May 24 09:48:45 1993] Intention for change:
 - automatic compilation during load for franz allegro
 ok
 
eulisp-kernel.em[1.6] Tue Oct 12 13:07:10 1993 imohr@isst proposed $
 [Tue Oct 12 11:16:25 1993] Intention for change:
 using defvar and defparameter for global lexical bindings if the name starts with
 non alphanumeric characters (for franz allegro only, this make global bindings
 special in any case)
  

-----------------------------------------------------------------------------------
|#

#module-name eulisp-kernel
#module-import
((only
   (null symbolp first cons list rest
    t)
   common-lisp)
 (rename ((defun cl:defun)
          (defmacro cl:defmacro)) common-lisp)
 el-modules)
#module-syntax-import 
(el-modules
 (only (&rest
        cond progn setq
	defvar) 
   common-lisp)
 (rename ((lambda cl:lambda)
          (compile cl:compile))
   common-lisp))
#module-syntax-definitions

#module-header-end

(expose el-modules)
(expose 
  (only
   (t
    defconstant
    quote
    setq setf
    if cond and or progn
    let let* labels flet
    unwind-protect
    next-method-p call-next-method
    funcall apply)
   common-lisp))

;;; -----------------------------------------------------------------------------------
;;; <object>: the root of the inheritance tree
;;; -----------------------------------------------------------------------------------

(make-eulisp-class object t)

;;; -----------------------------------------------------------------------------------
;;; Defining Forms
;;; -----------------------------------------------------------------------------------

(export-syntax defmacro deflocalmacro defun lambda deflocal defgeneric defmethod)

(cl:defun make-cl-lambda-list (el-lambda-list)
(cond ((null el-lambda-list) ())
      ((symbolp el-lambda-list) (list '&rest el-lambda-list))
      (t (cons (first el-lambda-list)
               (make-cl-lambda-list (rest el-lambda-list))))))

(cl:defmacro defmacro (name lambda-list . body)
`(progn (export-syntax ,name)
        (cl:defmacro ,name ,(make-cl-lambda-list lambda-list) ,@body)))

(cl:defmacro deflocalmacro (name lambda-list . body)
`(cl:defmacro ,name ,(make-cl-lambda-list lambda-list) ,@body))

(cl:defmacro defun (name lambda-list . body)
`(cl:defun ,name ,(make-cl-lambda-list lambda-list) ,@body))

(cl:defmacro lambda (lambda-list . body)
`#'(cl:lambda ,(make-cl-lambda-list lambda-list),@body))

(cl:defmacro deflocal (name value)
  ;franz allegro makes global bindings (simple setq's) special in any
  ;case when compiling files
  ;the direct usage of defvar avoids unnecessary warnings by the compiler
  ;but this requires that no local binding has the same name as a global binding
  ;which would result in shadowing global lexical bindings by local ones!!!
  `(#+(and :allegro :franz-inc)defvar
    #-(and :allegro :franz-inc)setq 
      ,name ,value))

(cl:defmacro defgeneric (name lambda-list)
`(cl:defgeneric ,name ,(make-cl-lambda-list lambda-list)))

(cl:defmacro defmethod (name lambda-list . body)
  `(cl:defmethod ,name ,(make-cl-lambda-list lambda-list) ,@body))


#module-end

