;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el-conditions -*-
#|
-----------------------------------------------------------------------------------
TITLE: el-conditions in cl
-----------------------------------------------------------------------------------
File:    el-conditions.em
Version: 1.1 (last modification on Thu Sep  2 14:54:29 1993)
State:   published

DESCRIPTION:
fake of the EL-Condition system

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
system rised conditions cannot have a continuation
here one can only accept a condition
Error and cerror not exported because of package conflicts in n-1 files
AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/EulispModules/el-conditions.em[1.0]
	Thu Sep  2 14:39:52 1993 ukriegel@isst save $
 el-conditions because of name clash with cmucl
 
el-conditions.em[1.1] Thu Sep  2 14:55:01 1993 ukriegel@isst published $
 [Thu Sep  2 14:53:42 1993] Intention for change:
 

-----------------------------------------------------------------------------------
|#

#module-name el-conditions
#module-import
(eulisp-kernel
 el-conditions-0)
 
#module-syntax-import 
(eulisp-kernel el-conditions-0)

#module-syntax-definitions

#module-header-end

(expose (only (defcondition with-handled-conditions let/cc) el-conditions-0))
(export 
        condition-message
        <condition>
        <execution-condition>
        <invalid-operator>
        <bad-apply-argument>
        <cannot-update-setter>
        <no-setter> 
        <improper-unquote-splice>
        <environment-condition>
        <arithmetic-condition> 
        <division-by-zero> 
        <conversion-condition> 
        <no-converter>
        <stream-condition> 
        <syntax-error> 
        <thread-condition> 
        <telos-condition>
        <no-next-method> 
        <no-congruent-lambda-list>
        <incompatible-method-signature> 
        <no-applicable-method>)


;;definitions and init-forms



;;; -----------------------------------------------------------------------------------
;;; Definition of EL level-0-condition classes
;;; -----------------------------------------------------------------------------------

(defcondition <condition>
  ()
  ((continuation :accessor   condition-continuation 
                 :initarg :continuation)
   (message :accessor condition-message :initarg message)))

(defcondition <execution-condition>(<condition>)())
(defcondition <invalid-operator>(<execution-condition>)())
(defcondition <bad-apply-argument>(<execution-condition>)())
(defcondition <cannot-update-setter>(<execution-condition>)())
(defcondition <no-setter>(<execution-condition>)())
(defcondition <improper-unquote-splice>(<execution-condition>)())
(defcondition <environment-condition>(<condition>)())
(defcondition <arithmetic-condition>(<condition>)())
(defcondition <division-by-zero> (<arithmetic-condition>)())
(defcondition <conversion-condition>(<condition>)())
(defcondition <no-converter>(<conversion-condition>)())
(defcondition <stream-condition>(<condition>)())
(defcondition <syntax-error>(<condition>)())
(defcondition <thread-condition>(<condition>)())
(defcondition <telos-condition>(<condition>)())
(defcondition <no-next-method>(<telos-condition>)())
(defcondition <no-congruent-lambda-list>(<telos-condition>)())
(defcondition <incompatible-method-signature>(<telos-condition>)())
(defcondition <no-applicable-method>(<telos-condition>)())




#module-end



