#ifndef xalloc_user_h
#define xalloc_user_h
#ifndef KRC
#define parameter1(a) (a)
#define parameter2(a, b) (a, b)
#define parameter3(a, b, c) (a, b, c)
#define parameter4(a, b, c, d) (a, b, c, d)
#else
#define parameter1(a) ()
#define parameter2(a, b) ()
#define parameter3(a, b, c) ()
#define parameter4(a, b, c, d) ()
#endif


typedef unsigned long int CardDscr;
typedef unsigned long int TypeDscr;

TypeDscr describe_type 
parameter2(
	unsigned long usertype, 
	void* (*mark_fcn)());

TypeDscr set_type_descriptor           /*1 <= td < lowest_type_descriptor*/
parameter3(
	TypeDscr td,			
	unsigned long usertype,
	void* (*mark_fcn)());

int set_lowest_type_descriptor        /*  1 <= lowest_type_descriptor */
parameter1(
	TypeDscr lowest_type_descriptor );


CardDscr describe_card
parameter3(
	char cardtype, 
	long size, 
	TypeDscr t_dscr );

CardDscr set_card_descriptor           /* 0 <= cd < lowest_card_descriptor */
parameter4(
	CardDscr cd,			
	char cardtype, 
	long size, 
	TypeDscr t_dscr);



int set_lowest_card_descriptor          /*	0 <= lowest_card_descriptor */
parameter1(CardDscr lowest_card_descriptor	);


TypeDscr get_type_descriptor
parameter1(long *ptr); 


unsigned long type_from_descriptor
parameter1(TypeDscr td );


unsigned long	get_type    /* previous two funcions at once */
parameter1(long *ptr );


unsigned long	safe_get_type   /*	returns NO_CONSISTENT_POINTER if so */
parameter1(long *ptr );



#define	NO_CONSISTENT_POINTER	0xffffffff



/* possible values for cardtype */
#define MTSS 	1
#define STMS 	2
#define STSS 	4

char mtss_card, stms_card, stss_card;	 /* will be set to above values*/

char get_card_type
parameter1(CardDscr cd); 


long get_object_size
parameter1(void *ptr);


void *xalloc_stss 
parameter1(CardDscr cd );

void *xalloc_mtss 
parameter2(CardDscr cd,	TypeDscr td );

void *xalloc_stms
parameter2(CardDscr cd, long size );

void *xalloc
parameter2(CardDscr cd, long possible_second_value );					

void trace_pointer
parameter1(long *ptr );

void force_garbage_collection();

long inc_heap_size
parameter1(int nb_of_cards );


void initialize_root_set();

void add_to_root_set
parameter1(void *pointer);

void delete_from_root_set
parameter1(void *pointer );


/* predefined mark_functions */

void trace_all /* trace from all locations inside the object */
parameter2(register long **ptr, register long length);	

void trace_nothing /* trace from nowhere inside this object */
parameter2(register long **ptr, register long length);	

void trace_first  /* assuming the first 4 byte to be a pointer */
parameter2(register long **ptr, register long length);	

void trace_second /* assuming the second 4 byte to be a pointer */
parameter2(register long **ptr, register long length);	

void trace_pair /* assuming the first 8 byte to be 2 pointers */
parameter2(register long **ptr, register long length);	


/* information about gc configuration */
void xalloc_info();


#undef parameter1
#undef parameter2
#undef parameter3
#undef parameter4
#endif /* ! xalloc_user_h */

