#ifndef	xalloc_conf_h
#define	xalloc_conf_h

#include <stdio.h>

		/* for definition of stderr */


#include "xalloc_user.h"	/* for typedefs, prototypes, some constants */

/* don't define any machine type 'cause cc does this job better
 * currently supported: 
 *	sparc
 *	__hp9000s700
 */


/* set a boundary for minimal heap address to reduce the chance of a wrong 
   pointer identification . the value is only used to set the brk. The actual
   heap begin will be aligned at card boundary */

#define MINHEAPBEGIN 0x10000


/* dimensions of some needed arrays and our heap, some constants */

		/* Smallest value to be returned by describe_type. Values
		 * between 1 and (SMALLEST_TYPEDSCR - 1) may be used for other
		 * purposes, usage of TypeDscr 0 is not allowed.
		 */
#define SMALLEST_TYPEDSCR	1

		/* Highest value to be returned by describe_type, dimension of
		 * internal type-array.
		 */
#define	HIGHEST_TYPEDSCR	4096

		/* same for cardtypes to be described by describe_card
		 */
#define SMALLEST_CARDDSCR	0
#define HIGHEST_CARDDSCR	4096

		/* There's no reason to set the size of the used Cards
		 * to the machines page size (as to get by get_page_size()),
		 * but it must be a power of 2 at least
		 */
#define	CARDSIZE	0x1000

		/* Maximum Heap size (in cards of CARDSIZE byte)
		 * including static cards
		 */
#define	MAX_NUM_OF_CARDS	1000

		/* Heapsize at begin of program execution. Negative or zero
		 * value will be set to 1 by the initialization function
		 */
#define	START_NUM_OF_CARDS	16
		/* we increase our heap, if - after a garbage collection -
		 * more than GCMULT/GCDIFF of the current heap is still in use 
		 */
#define GCMULT	1
#define GCDIFF	3
	
		/* When our heap becomes to small we increase it by HMULT/HDIFF 
		 * of the current heap size (but at most up to MAX_NUM_OF_CARDS)
		 */
#define HMULT	1
#define HDIFF	1

/* ---------- how to deal with root addresses on static variables ---------- */

		/* define ROOT_SET_IN_USE, if you want to add each global or
		 * static variable to the root set yourself
		 * undefine it, when tracer should scan over all data
		 */
#define	ROOT_SET_IN_USE
#define	MAX_ROOT_SET_ENTRIES	8192	/* size of rootset */

/* ------- shall we test array-dimensions and function parameters ? -------- */

		/* it is recommended to define SECURITY_FIRST when you first
		 * test a new program, but the memory management works much
		 * faster without this (can be undefined in each single file)
		 */
#define	SECURITY_FIRST

/* --------------- shall we use optimized pointer tests ? ------------------ */

		/* Use this, when your favorite objects are small single_sized
		 * ones. Otherwise, optimized pointer tests have no positive
		 * effect, because normal pointer test will be done after this.
		 */
/*#define	OPTIMIZED_POINTER_TESTS

/* ---------------- where shall we put our mark stack ? -------------------- */
		/* when putting mark stack below the stack pointer
		 *	- program will exit on stack overflow
		 *	- mark functions are forbidden to call other functions
		 * when putting it above the current break
		 *	- program will crash when heap is exhausted
		 *	- marking works a bit faster
		 */
#define	STACK_ON_HEAP

		/* we leave a gap of STACKGAP bytes below the machines
		 * stack pointer when using stacksegment for our mark stack
		 */
#define	STACKGAP	1024

/* ----------------- usage of different kinds of cards --------------------- */

		/* undefine unused cardtypes here, memory management will be
		 * built to work as fast as possible by leaving conditions;
		 * but, of course, all sorts of cards can be used simultaneously
		 */
		
#define	USE_STSS	/* one card for any size/type-pair */

#define	USE_MTSS	/* one card for different types but same size */

#define	USE_STMS	/* one card for different sizes but same type */

#define	FAST_STMS	/* prefer gc to extensive search in free lists on stms*/

		/* Undefine USE_LARGE, if any used object may be put onto one
		 * card of CARDSIZE byte. Note, that we actually need 32 byte
		 * on any card for header information, and one bit per long_word
		 * for the mark area. Here are some examples for maximum size
		 * of objects to be put on one single card:
		 *	CARDSIZE	HEAD+MARKBITS	Max. Objectsize
		 *	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		 *	8192		288		7904
		 *	4096		160		3936
		 *	2048		 96		1952
		 *	1024		 64		 960
		 *	 512		 48		 464
		 *	 256		 40		 216
		 * Note, that we increase object sizes by 4 byte
		 * on MTSS and STMS-cards
		 */
#define	USE_LARGE

/*  are we interested in printing heapsize to stderr (when we increase heap)? */

/*#define PRINTSIZES


/* are we interested in gc-reports ? */

/*#define GCREPORTS

 
/* ------------------- what to do on internal errors ? --------------------- */

#define	error(m) 	(fprintf(stderr,"%s Good bye!\n",m), exit(0))
#define error1(format,value) (fprintf(stderr,format,value), exit(0))

#endif	/* ! xalloc_conf_h */

