/*****************************************************************************\
*                                                                             *
*       			trace.c		   		              *
*									      *
\*****************************************************************************/
#include <stdio.h>
#include "xalloc_conf.h"
#include "xalloc_misc.h"

/*****************************************************************************/
/** some definitions only used by the collector -- instead of a header file **/
/*****************************************************************************/

static long gc_count = 0;
		/* at first some machine dependent definitions */
#define stack_grows_down

#ifdef	sparc

#define DATASTART	&etext
#define	STACKTOP	stacktop

#define	SAVE_REGS_ON_STACK()	asm("t	3")	/* ST_FLUSH_WINDOWS */	

#endif	sparc

#ifdef	__hp9000s700

#undef stack_grows_down
#define stack_grows_up

#define DATASTART	0x40001000
#define STACKTOP	stacktop

#define SAVE_REGS()	save_registers()	/* an assembler written func. */
#define NB_REGS		29
void * reg_safe[NB_REGS];	/* the space to put the register contents to */

#endif	__hp9000s700

#ifndef sparc
#ifndef __hp9000s700
	--> unsupported machine <--
#endif
#endif


#define	MS_MARK	0x80000000	/* is set in length word of MS-obj. to mark */

#define ms_ismarked(p)	(*(p) & MS_MARK)
#define ms_mark(p)	(*(p) |= MS_MARK)
#define ms_unmark(p)	(*(p) &= ~MS_MARK)


#define	stack_not_empty		(stkpointer != stktop)

#ifdef	STACK_ON_HEAP

#define	STKSIZE		CARDSIZE
#define	init_gc_stack()		{stkpointer = stktop = (long *) sbrk(STKSIZE); \
					endofstack = (long *) sbrk(0);}
#define	remove_gc_stack()	brk(stktop)
#define	inc_gc_stack(e)		{sbrk(STKSIZE); e = (long *) sbrk(0);}
#define	gcpop(p)		(long *)*(--p)
#define	gcpush(v,p,e)	{ if(p == e) inc_gc_stack(e);	\
				*p++ = (long)(v);}

#else		/* stack on machine stack */

#define	init_gc_stack()		{stktop = (long *)((long)&i - STACKGAP);\
					stkpointer = stktop;}
#define	remove_gc_stack()	{/* nothing to be removed */}
#define gcpop(p)		(long *)*(++p)
#define	gcpush(v,p,e)	{*p-- = (long)(v);}

#endif		/* STACK_ON_HEAP */

#define	itrace(v,p,e)	if(p_in_heap(v)) gcpush(v,p,e)

#define	mark_card(c)		(c)->root = NULL
#define card_marked(c)		((c)->root == NULL)

/*****************************************************************************/
/*******************************  rootset  ***********************************/
/*****************************************************************************/
#ifdef ROOT_SET_IN_USE

long	ROOTSET[MAX_ROOT_SET_ENTRIES];
long	*ROOTSETEND = ROOTSET;

void
initialize_root_set()
{
	ROOTSETEND = ROOTSET;
}

void
add_to_root_set(p)
	void	*p;
{
#ifdef SECURITY_FIRST
	if(ROOTSETEND >= &ROOTSET[MAX_ROOT_SET_ENTRIES])
		error("Unable to insert root address");
	else
#endif
		*ROOTSETEND++ = (long)p;
}

void
delete_from_root_set(p)
	void	*p;
{
	long	*l;
	for(l = ROOTSET; ((l<ROOTSETEND) && (*l!=(long)p)); l++);
	if(l<ROOTSETEND)
		*l = *(--ROOTSETEND);
}
#else

extern	end, etext;	/* all locations of static data */

#endif

/*****************************************************************************/
/********************************  trace  ************************************/
/*****************************************************************************/

long	*stktop, *stkpointer, *endofstack;

void trace_pointer(ptr)	/* to be called from user defined mark functions */
register long *ptr;
{ 
	itrace(ptr, stkpointer, endofstack);
}

/************************ predefined mark functions **************************/

void trace_all(ptr, length)
register long	**ptr;
register long	length;
{
	length>>=2;
	while(length > 0){
		length--;
		itrace(ptr[length],stkpointer,endofstack);
	}
}

void trace_nothing(ptr, length)
register long	**ptr;
register long	length;
{
	/* nothing to do */
}

void trace_first(ptr, length)
register long	**ptr;
register long	length;
{
	itrace(ptr[0],stkpointer,endofstack);
}

void trace_second(ptr, length)
register long	**ptr;
register long	length;
{
	itrace(ptr[1],stkpointer,endofstack);
}

void trace_pair(ptr, length)
register long	**ptr;
register long	length;
{
	itrace(ptr[0],stkpointer,endofstack);
	itrace(ptr[1],stkpointer,endofstack);
}

void
marking()		/* first phase of our mark/sweep - collector */
{
	register long *rsp;
	register long *reos;
	register long *p;
	register card *c;
	long i;


	/* The first function_call is used to put all registers onto the stack. 
	 * For Sparc_machines, this "function" is defined as an assembler
	 * statement above; it may be also defined for other machines.
	 */
	SAVE_REGS_ON_STACK();

	/* Now the stack is complete in any way, and we must get something
	 * like the stack pointer. Some bytes more or less doesn't matter,
	 * because we are at least two function calls deep in the memory
	 * management (our own values haven't to be traced from), and we leave
	 * a large gap when putting our mark stack below the stack_pointer.
	 * So we decide to use (&i) for this purpose.
	 */

	init_gc_stack();	

	/* We start marking with collecting all root addresses. They may be
	 * on the stack and on global variables, while we took our regs onto
	 * the stack before. We are trying to be faster when using two
	 * registers for the stackpointer and the (possible) end of stack area.
	 */
	rsp = stkpointer;
	reos = endofstack;

	/* trace from stack */
#ifdef stack_grows_down
	for(p = &i; p<(long *)STACKTOP; p++)
		itrace((long *)*p, rsp, reos);
#else
#ifdef stack_grows_up
	for(p = &i; p>(long *)STACKBOTTOM; p--)
		itrace((long *)*p, rsp, reos);
#else
	--> where else does the stack grow ??
#endif
#endif


	/* trace from root set or from all globals resp. data pages */
#ifdef	ROOT_SET_IN_USE
	for(p = ROOTSET; p < ROOTSETEND; p++){
		register long *g = (long *)*p;
#ifdef SECURITY_FIRST
		if(!is_pointer(g)) 	/* did the user add something wrong
					 * to the root set ?
					 */
			error("mark: wrong root in root set");
#endif
		itrace((long *)*g,rsp,reos);

	}
#ifdef __hp9000s700	/* possibly some additional roots on register-safe */
	for(i = NB_REGS; i != 0; i--)
		itrace(reg_safe[i], rsp, reos);
#endif
#else
	for(p = (long *)&etext; p < gcarraybegin; p++)
		itrace((long *)*p,rsp,reos);
	for(p = gcarrayend; p< (long *)&end; p++)
		itrace((long *)*p,rsp,reos);
	/* hp9000's register-safe is scanned through, too */
#endif
	stkpointer = rsp;
	endofstack = reos;

	/* trace from the just built gc_stack. unfortunately, we can't use
	 * registers to hold our markstackpointer, because it will be changed
	 * by called trace_functions, too */
	while(stack_not_empty){
		p = gcpop(stkpointer);
		c = CARD_ADDR(p);
		if(living_card(c)){	/* B/W - test */
#ifdef	USE_MTSS
		    if(mt_card(c)){
			long *fp = p-1;
			if(consistent_pointer(c,fp,get_size(c),get_mask(c)))
			  if(is_tdscr(*fp))
			    if(!ismarked(c,fp)){
				    mark(c,fp);
				    (get_mark_fcn(*fp)(p, get_real_size(c)));
				}
		    	continue;
		    }
#endif
#ifdef	USE_STMS
		    if(ms_card(c)){
			if(consistent_ms_pointer(c,p))
			  if(!ms_ismarked(p-1)){
			    ms_mark(p-1);
			    (get_mark_fcn(get_tdscr(c)))(p,get_ms_real_size(p));
			  }
		        continue;
		    }
#endif
#ifdef	USE_STSS
		    if(consistent_pointer(c,p,get_size(c),get_mask(c)))
			if(!ismarked(c,p)){
			    mark(c,p);
			    (get_mark_fcn(get_tdscr(c)))(p, get_real_size(c));
		    	}
#endif
		}
	}

	/* Now all locations reachable via registers, the stack or global
	 * variables are marked. We can remove our mark stack and return.
	 */
	remove_gc_stack();
}

/*****************************************************************************/
/********************************  sweep  ************************************/
/*****************************************************************************/

/* remove mark bits for objects in free list of card-descriptor cd */
void
clear_fsl_marks(cd)
	register CardDscr cd;
{
	register long *p = (long *)get_freept_addr(cd);
	register card *c;
	while(p = (long *) *p){
		c = CARD_ADDR(p);
		if(ismarked(c,p))
			unmark(c,p);
	}
}

long
ss_sweep(c, cd)
	register card  *c;
	register CardDscr cd;
{
	register long  step, used, *fsl;
	register long  *pt = c->mkarea;
	register long  *en = pt + NB_OF_MARK_WORDS;

	/* At first test, whether this card is empty. This works very fast by
	 * checking 32 bits at ones.
	 */
	for(; (pt < en) && (*pt == 0); pt++);
	if(pt == en)	return(0);

	/* There are some marked objects on this card, build a list of the 
	 * other ones
	 */
	step = get_size_d(cd);
	fsl = get_free_object(cd);
	used = 0;
	pt = (long *)c + byte2word(CARDSIZE) - step;
	en = c->userspace;

	while(pt >= en){
		if(ismarked(c,pt)){	/* skip all marked objects */
			pt -= step;
			used += step;
		} else {		/* connect the others */
			*pt = (long)fsl;
			fsl = pt;

#ifdef	OPTIMIZED_POINTER_TESTS
	/* we migth have increased the size of the objects, so the (possibly
	 * unused but traced) end of these objects must be set to zero */
			if(step == 4)
				pt[3] = 0;
			else 
				if(step == 8){ 
					pt[5] = 0;
					pt[6] = 0;
					pt[7] = 0;
				}
#endif

			pt -= step;
		}
	}
	store_free_object(cd,fsl);	/* write internal fsl to free list */
	clear_marks(c);
	return(word2byte(used));
}


#ifdef USE_STMS
long
ms_sweep(c,cd)	/* assumes c to be pointer to ms_card, sweeps card and builds a
		 * free list on it, storing its space to the free list of its
		 * card_dscr. if an unmarked large object is found on the card,
		 * and some small objects stay there, the 'continued' cards
		 * will be reclaimed explicitely, because clean_card_list is
		 * unable to do this job.
		 * function returns number of bytes still in use.
		 */
register card		*c;
register CardDscr	cd;
{
	register int		new = 1;
	register vobject	*ifsl = (vobject *)get_free_object(cd);
	register long		*ptr = c->userspace;
	register long		*e = (long *)(c + 1);
	register long		used = 0;

	while(ptr < e){
	    if(ismarked(c,ptr)){	/* begin of object */
		if(ms_ismarked(ptr)){	/* surviver */
		    ms_unmark(ptr);	/* reset mark bit */
		    new = 1;   		/* free space will start after this */
		    used += *ptr;	/* still in use */
		    ptr += *ptr;	/* behind this object */
		} else {		/* no pointer to this obj, reclaim it */
		    unmark(c,ptr);	/* no longer begin of obj */
#ifdef USE_LARGE
		    if(*ptr>USERSPACE){	/* large object found */
			/* as this is the last object on that card, we can
			 * test, whether we found any surviver before this
			 * and break otherwise
			 */
			if(used == 0) break;
			/* the card stays used, we must reclaim the tail of now
			 * unused 'continued' cards and decrement c->cardnum
			 */
			reclaim_card(e, get_cardnum(c) - 1);
			put_cardnum(c,1);
			/* the part of this object which is on the first card
			 * will become a part of the free list as below
			 */
			if(new){
			    ((vobject *)ptr)->vlength = e - ptr; /* length */
			    ((vobject *)ptr)->vnext = ifsl;
			    ifsl = (vobject *)ptr;	/* into free list */
			    ptr = e;			/* behind card */
			} else {		/* concat. with before space */
			    ifsl->vlength += (e - ptr);	/* increase before */
			    ptr = e;			/* behind card */
			}
		    } else
#endif 
		    {
			if(new){		/* start of space */
			    ((vobject *)ptr)->vlength = *ptr; /* length */
			    ((vobject *)ptr)->vnext = ifsl;
			    ifsl = (vobject *)ptr;	/* into free list */
			    ptr += ((vobject *)ptr)->vlength;/* behind this */
			    new = 0;
			} else {		/* connect with before space */
			    ifsl->vlength += *ptr; /* increase before space */
			    ptr += *ptr;	   /* behind this object */
			}
		    }
		}
	    } else {			/* found part of former free list */
		if(new){		/* start of space */
		    ((vobject *)ptr)->vnext = ifsl;
		    ifsl = (vobject *)ptr;
		    ptr += ((vobject *)ptr)->vlength;	/* behind this object */
		    new = 0;
		} else {		/* concat. with before space */
		    ifsl->vlength += ((vobject *)ptr)->vlength; /* inc before */
		    ptr += ((vobject *)ptr)->vlength;	/* behind this object */
		}
	    }
	}
	if(used > 0)		/* some bytes on that card are still in use */
		store_free_object(cd,(long *)ifsl);
	return(word2byte(used));
}
#endif

/************** remove marked cards, close holes in cardlist *****************/
void
clean_card_list()
{
	register card **ci = first_card_index;

	while(ci < last_card_index){
	    if(card_marked(*ci)){
#ifdef	USE_LARGE
		reclaim_card(*ci,get_cardnum(*ci)); /* call to heap.c */
#else
		reclaim_card(*ci);
#endif
		prev_card_index(last_card_index);
		while((ci < last_card_index) &&(card_marked(*last_card_index))){
#ifdef	USE_LARGE
		   reclaim_card(*last_card_index,get_cardnum(*last_card_index));
#else
		   reclaim_card(*last_card_index);
#endif
		   prev_card_index(last_card_index);
		}
		if(ci < last_card_index){
			*ci = *last_card_index;
			(*ci)->root = ci;
		}
	    }
	    next_card_index(ci);
	}
}


/*****************************************************************************/
/***************************  garbage collection  ****************************/
/*****************************************************************************/

void
force_garbage_collection()
{
	register card	**ci, *c;
	register CardDscr	cd;
	register long used;
	register long bytes_in_use = 0;

        ++gc_count;
#ifdef GCREPORTS
	fprintf(stderr, "GC %D:",gc_count);
	fflush(stderr);
#endif
	marking();	/* may be inlined */

			/* inspect all cdscr's to sweep all cards,
			 * mark empty cards for later being removed */
	for(cd = 0; cd < last_used_card; cd++){
		ci = &Cards[cd];
#ifdef	USE_STMS
		if(ms_card_d(cd)){
			store_free_object(cd,NULL);	/* end of free list */
			while(c = *ci){			/* c becomes *last */
				if(used = ms_sweep(c,cd)){	/* not empty */
					bytes_in_use += used;
					ci = &(c->next);
				} else {		/* empty */
					*ci = c->next;	/* off_crd_lst*/
					mark_card(c);
				}
			}
		} else 
#endif
		{	/* ss_card */
#ifdef	USE_LARGE
		    if(basiccards(get_size_d(cd)) == 1){
#endif
			/* clear mark bits for objects in free list because
			 * if any object in the free list has been marked by
			 * default, all objects behind this in free list
			 * will have been marked, too
			 */
			clear_fsl_marks(cd);	
			store_free_object(cd,NULL);	/* end of free list */
			while(c = *ci){
				if(used = ss_sweep(c,cd)){	/* not empty */
					bytes_in_use += used;
					ci = &(c->next);
				} else {		/* empty */
					*ci = c->next;	/* off_crd_lst*/
					mark_card(c);
				}
			}
#ifdef	USE_LARGE
		    } else {	/* large cards in use on this carddscr. */
			while(c = *ci){
				if(ismarked(c,c->userspace)){	/* surviver */
					large_unmark(c);
					bytes_in_use += get_real_size(c);
					ci = &(c->next);
				} else {
					*ci = c->next;	/* off_card_lst */
					mark_card(c);
				}
			} /* end while */
		    } /* end if basiccards(...)==1 */
#endif
		} /* end if ms_card ... else ss_card */
	} /* end for each carddescriptor */

	clean_card_list();	/* may be inlined */

#ifdef  GCREPORTS
	fprintf(stderr, " %i of %i bytes reclaimed\n",
			CARDSIZE*curnumcard-bytes_in_use, CARDSIZE*curnumcard);
#endif
	if((GCDIFF * bytes_in_use) > (GCMULT * CARDSIZE * curnumcard))
		/* to few of our storage has been reclaimed,
		 * try to get more
		 */
		inc_heap();
}


void xalloc_info()
{ /* print configuration and runtime info */
  fprintf(stderr,"\nNumber of Garbage Collections: %d",gc_count);
  fprintf(stderr,"\nInitial number of Cards %d",START_NUM_OF_CARDS);
  fprintf(stderr,"\nGCMULT %d GCDIFF %d HMULT %d HDIFF %d",GCMULT,GCDIFF,HMULT,HDIFF);
#ifdef ROOT_SET_IN_USE
  fprintf(stderr,"\nUserdefined root set was used");
#else
  fprintf(stderr,"\nAnonymous root set was used");
#endif
#ifdef STACK_ON_HEAP
  fprintf(stderr,"\nMarking stack was allocated on heap");
#else
  fprintf(stderr,"\nMarking stack was allocated on heap");
#endif
  fprintf(stderr,"\n");fflush(stderr);

}












