;;;-*- Mode: Lisp; Package: whc-classes -*-
#|
-----------------------------------------------------------------------------------
TITLE: definition of classes for the basic data types and implementation
-----------------------------------------------------------------------------------
File:    whc-classes.em
Version: 1.13 (last modification on Tue Oct 12 11:16:31 1993)
State:   proposed

DESCRIPTION:
macros and aux functions to read in the basic data types

DOCUMENTATION:
see in the APPLY-paper TAIL:eine getypte implementationssprache fuer APPLY

NOTES:
here with define-tail for the aux-data-types too

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 
Log for /tmp_mnt/home/saturn/akind/Lisp/Apply/whc-classes.em[1.0]
	Thu Mar  4 09:04:21 1993 wheick@isst proposed $
 class definitions
 
whc-classes.em[1.1] Tue Mar 16 08:40:26 1993 wheick@isst save $
 new tail types %pointer-to-struct .
 
whc-classes.em[1.2] Tue Mar 16 08:45:11 1993 wheick@isst save $
 new classes with %representation as mixin, new names, 
 %types = tail-class-def belongs to the lzs now (is to import)
 
whc-classes.em[1.3] Tue Mar 16 14:11:41 1993 wheick@isst save $
 new class names and exports
 
whc-classes.em[1.4] Tue Mar 23 11:18:43 1993 wheick@isst save $
 new classes like <%pointer-to-struct>
 
whc-classes.em[1.5] Wed Mar 24 16:44:57 1993 wheick@isst save $
 
whc-classes.em[1.6] Wed Mar 24 17:05:43 1993 wheick@isst save $
 
whc-classes.em[1.7] Mon Mar 29 16:43:42 1993 wheick@isst save $
 [Wed Mar 24 17:35:36 1993] Intention for change:
 
whc-classes.em[1.8] Tue Mar 30 17:09:47 1993 wheick@isst proposed $
 [Tue Mar 30 17:07:51 1993] Intention for change:
 fase class name
 
whc-classes.em[1.9] Wed Apr 14 15:23:29 1993 wheick@isst proposed $
 [Tue Apr 13 17:01:34 1993] Intention for change:
 representation is not subclass of defined-class
 remove superclass from representation
 
whc-classes.em[1.10] Mon Apr 19 12:02:00 1993 wheick@isst published $
 
whc-classes.em[1.11] Fri May 28 11:52:49 1993 wheick@isst save $
 [Wed May  5 08:07:24 1993] Intention for change:
 insert %string
 
whc-classes.em[1.12] Fri Oct  1 18:49:52 1993 imohr@isst proposed $
 [Fri Oct  1 14:06:00 1993] Intention for change:
 longjmp
 
whc-classes.em[1.13] Tue Oct 12 13:06:15 1993 ukriegel@isst proposed $
 [Tue Oct 12 11:10:38 1993] Intention for change:
 clean up
 cleaned
 

-----------------------------------------------------------------------------------
|#



#module-name whc-classes

#module-import
(level-1-eulisp
 lzs
 (only (<tail-class-def>) lzs-mop)
 accessors
 )

#module-syntax-import
(level-1-eulisp
class-ext 
(only (defstandardclass) apply-standard)
)

#module-syntax-definitions

#module-header-end

(export 

  <basic-class-def>
  <%integer>
  <%signed>
  <%unsigned>

  <%float> ;new name
  
  <%aux-type>
  <%representation>
  <%machine-type>
; to make all instances for %bit ...%quad-word
;  <%prestruct>

;  <%struct>
;  <%vector>
;  <%union>
  <%pointer> ;superclass of all pointer representations
  <%pointer-to-struct>
  <%pointer-to-vector>
  <%pointer-to-void>
  <%direct>
  <address-expr>
  )




(defstandardclass <%representation> ()
  :default-slot-options (:accessor :initarg)
  :slots
;   identifier   ;is needed to match the slot of define-tail
;   module-id    ;is needed to match the slot of define-tail
;   alignment    ;alignment (of all types)
   bit-length   ;length (in bits) of all types
   byte-length  ;length (in bytes) of all types

   allocation   ;slots
   mm-type      ;for the
   mm-card      ;memory management
   class        ;backpointer to the class

;new in %representation
   integer      ;T/NIL
   signed       ;T/NIL
   var-code     ;assembler code for generation
   const-code)  ;not used

;make a new class for %machine-type
;%bit ...%quad-word are instances from this class and are holded
;on the corresponding constants 
(defstandardclass <%machine-type> (<%representation>) ())


(defstandardclass <%aux-type> (<%representation>) ())

;;;the basic-data-type = basic-class-def takes informations 
;;;from %types = tail-class-def
;;;and from %representation
;;;!!!the old one!!!



;;;but I think it is better to cut the representation from the 
;;;eulisp hierarchy and take
;;;!!!the new one!!!

(defstandardclass <basic-class-def> (<tail-class-def>))

(defstandardclass <%integer> (<basic-class-def>) ())

(defstandardclass <%float> (<basic-class-def>) ())


;;; take <%signed> and <%unsigned> as mixin and not as subclass
;;; from <%integer-def>

;;; mixins for <%signed> and <%unsigned>
(defstandardclass <%signed> () ())

(defstandardclass <%unsigned> () ())


;(defstandardclass <%prestruct> (<%representation>)
;  :default-slot-options (:accessor :initarg)
;  :slots 
;  pre-names-and-pre-types  ;like an a-list ((slot type) ...)
;  type                     ;the rea type of prestruct
;  offset)                  ;not used


;(defstandardclass <%struct> (<%representation>)
;  :default-slot-options (:accessor :initarg)
;  :slots 
;  slot-and-type-names      ;like an a-list ((slot type) ...)
;  offset)                  ;not used


;(defstandardclass <%vector> (<%representation>)
;  :default-slot-options (:accessor :initarg)
;  :slots
;   type                    ;type of vector element
;   length-of-vector        ;length of whole vector
;   offset)                 ;not used


;(defstandardclass <%union> (<%representation>)
;  :default-slot-options (:accessor :initarg)
;  :slots 
;  variant-and-type-names   ;like an a-list ((variant type) ...)
;  max-type)                ;type of the variant with max length

(defstandardclass <%pointer> (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  type                     ;type of the data to which the pointer points
  offset)                  ;not used

(defstandardclass <%pointer-to-struct> (<%pointer>)
  ;;;the old one                       (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  slot-and-type-names  ; see %struct: like an a-list ((slot type) ...)
  label-for-struct  ; this is the label for the real struct
  offset)

(defstandardclass <%pointer-to-vector> (<%pointer>)
  ;;;the old one                       (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  type    ;type of the data to which the pointer points
  length-of-vector
  label-for-vector  ; this is the label for the real vector
  offset)

(defstandardclass <%pointer-to-void> (<%pointer>)
  ;;;the old one                     (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  (alignment :initform 4)
  (byte-length :initform 4)
  (bit-length :initform 32)
  slot1  
  slot2  
  offset)

(defstandardclass <%direct> (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  type) 






;;;class of address-expressions
(defstandardclass <address-expr> ()
  :default-slot-options (:accessor :initarg)
  :slots
  address         ;label
  offset          ;offset
  type            ;type of the data
  slot            ;used for intern usage
  top-type-name)  ;contains the (rest) ini-list

#module-end
;;;eof whc-classes.lisp