;;;-*- Mode: Lisp; Package: whc-aux -*-
#|
-----------------------------------------------------------------------------------
TITLE: auxiliary functions
-----------------------------------------------------------------------------------
File:    whc-aux.em
Version: 1.9 (last modification on Fri Apr 23 13:54:02 1993)
State:   proposed

DESCRIPTION:
the functions for generation of code

DOCUMENTATION:


NOTES:


REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 
-----------------------------------------------------------------------------------
|#

;;; begin whc-aux.em

#module-name whc-aux

#module-import
(level-0-eulisp
 level-1-eulisp
 expand-literal

 lzs mzs simple-programming
;for interface to rainer

 accessors
 whc-classes
; (only (generate-data-code-alltypes) whc-gen-code)
 (only (dolist assoc cerror subtypep type-of not expt) common-lisp)
 )

#module-syntax-import 
(level-1-eulisp apply-standard lzs-modules)


#module-syntax-definitions


#module-header-end


(export table-of-class-instances
  type-instance-put
  type-instance-put-with-test
  type-instance-get
  type-instance-rem
  give-data-type
  give-basic-data-type
  give-pointer-data-type
  give-prestruct-data-type
  give-union-data-type
  give-variable
  give-constant
  give-variable-or-constant
  basic-data-type-p
  data-type-p
  data-float-p
  data-integer-p
  )


;;; table-of-class-instances is the
;;; ------------------------
;;; Table for the class-instances of all TAIL data types
;;; TAIL variables, TAIL constants and Rainers TAIL functions
;;; (correspondence between name and instance)

(defconstant table-of-class-instances (make-table))

(defun type-instance-put (symbol value) 
  (setf (table-ref table-of-class-instances symbol) value))

(defun type-instance-put-with-test (symbol value)
  (if  (type-instance-get symbol)
    (cerror "" "Symbol ~S hat bereits Tabellen-Eintrag" symbol)
    (setf (table-ref table-of-class-instances symbol) value)))

(defun type-instance-get (symbol) 
  (table-ref table-of-class-instances symbol))

(defun type-instance-rem (symbol) 
  (table-delete table-of-class-instances symbol))



;;;-------------------------------------------------------------
;;;Test function for general data typ, %variables and %constants

(defmethod data-type-p ((type <class-def>))
  t)

(defmethod data-type-p ((type <number>))
  nil)

(defmethod data-type-p (type)
  nil)

(defun variable-p (var) 
 (subtypep (type-of var) <var>))

(defun constant-p (var) 
 (subtypep (type-of var) <named-const>))

(defun pointer-data-type-p (type)
  (subtypep (type-of type) <%pointer>))

(defun prestruct-data-type-p (type)
  (subtypep (type-of type) <%prestruct>))

(defun union-data-type-p (type)
  (subtypep (type-of type) <%union>))

(defmethod basic-data-type-p ((type <basic-class-def>))
  t)


(defmethod basic-data-type-p (type)
  nil)

;-----------------------------------------------------
;so I use the type instances as values in module tail
(defun give-data-type (symbol)
    (when (data-type-p symbol)
      symbol))


(defun give-basic-data-type (symbol)
  (when (basic-data-type-p symbol)
      symbol))


(defun give-pointer-data-type (symbol)
  (when (pointer-data-type-p symbol)
      symbol))

(defun give-prestruct-data-type (symbol)
  (when (prestruct-data-type-p symbol)
      symbol))

(defun give-union-data-type (symbol)
  (when (union-data-type-p symbol)
      symbol))

(defun give-variable (var)
  (when (variable-p var)
      var))

(defun give-constant (var)
  (when (constant-p var)
      var))

(defun give-variable-or-constant (var)
  (when (or (constant-p var)
            (variable-p var))
    var))

(defmethod data-integer-p ((instance <%integer>))
  t)

(defmethod data-integer-p (object)
  nil)

(defmethod data-float-p ((instance <%float>))
  t)

(defmethod data-float-p (object)
  nil)

#module-end
;;; eof whc-aux.lisp