;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti -*-
#|
-------------------------------------------------------------------------------
TITLE: Auxiliary Functions and Parameters for Type Inference
-------------------------------------------------------------------------------
File:    ti.em
Version: 1.29 (last modification on Wed Oct 13 17:14:39 1993)
State:   proposed

DESCRIPTION:
Auxiliary functions for formatting, error signaling, collections, and
statistics.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/net/saturn/apply/Lisp/Apply/ti.em[1.0]
	Wed Apr 21 16:49:05 1993 akind@isst save $
 
ti.em[1.1] Wed May  5 11:26:18 1993 akind@isst save $
 
ti.em[1.2] Thu May  6 17:28:22 1993 akind@isst save $
 
ti.em[1.3] Fri May  7 12:10:28 1993 akind@isst proposed $
 
ti.em[1.4] Fri May  7 21:23:01 1993 akind@isst proposed $
 
ti.em[1.5] Mon May 24 12:09:22 1993 akind@isst proposed $
 
ti.em[1.6] Tue May 25 11:08:48 1993 akind@isst proposed $
 
ti.em[1.7] Wed May 26 10:34:55 1993 akind@isst proposed $
 
ti.em[1.8] Tue Jul  6 16:13:43 1993 akind@isst proposed $
 
ti.em[1.9] Tue Jul  6 16:14:39 1993 akind@isst proposed $
 
ti.em[1.10] Wed Aug 11 10:04:53 1993 akind@isst proposed $
 
ti.em[1.11] Wed Aug 18 16:10:25 1993 akind@isst proposed $
 
ti.em[1.12] Thu Aug 19 10:20:23 1993 akind@isst proposed $
 
ti.em[1.13] Fri Aug 20 14:21:23 1993 akind@isst proposed $
 
ti.em[1.14] Tue Aug 24 16:26:20 1993 akind@isst proposed $
 
ti.em[1.15] Tue Aug 24 16:34:36 1993 akind@isst proposed $
 
ti.em[1.16] Tue Aug 24 17:10:00 1993 akind@isst proposed $
 
ti.em[1.17] Wed Aug 25 17:39:28 1993 akind@isst proposed $
 
ti.em[1.18] Fri Aug 27 17:30:21 1993 akind@isst published $
 
ti.em[1.19] Tue Sep 14 12:41:11 1993 akind@isst save $
 
ti.em[1.20] Thu Sep 23 14:34:08 1993 akind@isst proposed $
 
ti.em[1.21] Fri Sep 24 09:10:56 1993 akind@isst save $
 [Fri Sep 24 09:09:40 1993] Intention for change:
 
ti.em[1.22] Fri Sep 24 09:12:52 1993 akind@isst proposed $
 
ti.em[1.23] Fri Oct  1 14:42:29 1993 akind@isst save $
 
ti.em[1.24] Mon Oct 11 10:31:31 1993 akind@isst save $
 
ti.em[1.25] Tue Oct 12 10:32:59 1993 akind@isst proposed $
 
ti.em[1.26] Tue Oct 12 12:55:26 1993 akind@isst proposed $
 
ti.em[1.27] Tue Oct 12 17:15:59 1993 akind@isst proposed $
 
ti.em[1.28] Wed Oct 13 09:01:49 1993 akind@isst proposed $
 
ti.em[1.29] Wed Oct 13 17:15:09 1993 akind@isst proposed $
 

-------------------------------------------------------------------------------
|#


#module-name ti
#module-import
(level-0-eulisp level-1-eulisp apply-standard debugging
		(only (format error float member-if dotimes
			      clrhash gethash make-hash-table) common-lisp))
#module-syntax-import (level-0-eulisp level-1-eulisp debugging)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT member-with-args dovector
	ti-format ti-format2
	set-ti-verbose0 set-ti-verbose1 set-ti-verbose2
	ti-error ti-statistics initialize-ti-statistics ti-print-statistics
	*max-call-descrs* *max-signature-descrs* *use-compound-types*
	*ti-short-print*
	*fun-call-key* *inferred-signature-key* *inferred-classes-key*
	*joined-call-descrs-key* *joined-signature-descrs-key*
	*inferred-abstract-classes-key* *%setf-select-key*)

(EXPOSE level-0-eulisp
	level-1-eulisp
	accessors
	apply-standard
	simple-programming
	debugging
	(only (append dolist mapc mapcar maphash) common-lisp))

;;; ---------------------------------------------------------------------------
;;; TYPE INFERENCE PARAMETERS
;;; --------------------------------------------------------------------------

;; Determines whether a short output for error notification satisfies.
(DEFLOCAL *ti-short-print* t)

;; Maximal number of descriptors used for a function call; if acceeded 
;; descritors are joind.
(DEFLOCAL *max-call-descrs* 3)

;; Maximal number of descriptors used in function signatures; if acceeded 
;; descritors are joind.
(DEFLOCAL *max-signature-descrs* 3)

;; Flag that determines whether all compound types are converted to 
;; non-compound super types.
(DEFLOCAL *use-compound-types* ())

;; Format level; level 0: quiet mode; level 1: major warnings; level 2: all
;; outputs are displayed.
(setq *ti-verbose* 0)

;; Break level; level 0: ignore break points; level 1: stop at break points.
(setq *ti-break* ())

;;; ---------------------------------------------------------------------------
;;; BASIC COLLECTION FUNCTIONS
;;; ---------------------------------------------------------------------------

(DEFUN member-with-args (pred list . args)
  (member-if (lambda (x) (apply pred x args)) list))

;;; Same as dolist for vector objects.
(DEFMACRO dovector ((elem index vector-form) . body)
  `(dotimes (i (length ,vector-form) 1)
     (let ((,elem (vector-ref ,vector-form i))
	   (,index i))
       ,@body)))

;;; ---------------------------------------------------------------------------
;;; TYPE INFERENCE FORMAT/ERROR
;;; --------------------------------------------------------------------------

;;; Toggable format function for type-inference.
(DEFMACRO ti-format args
  (if (and (numberp *ti-verbose*)
	   (> *ti-verbose* 0))
      `(format ,@args)))
      
;;; Second toggable format function for type-inference.
(DEFMACRO ti-format2 args
  (if (and (numberp *ti-verbose*)
	   (> *ti-verbose* 1))
      `(format ,@args)))

(DEFUN set-ti-verbose0 ()
  (setq *ti-verbose* 0))

(DEFUN set-ti-verbose1 ()
  (setq *ti-verbose* 1))

(DEFUN set-ti-verbose2 ()
  (setq *ti-verbose* 2))

(DEFMACRO ti-error args
  (if *ti-break*
      `(error "Break from type inference! Try to continue with ':return'.")))

;;; ---------------------------------------------------------------------------
;;; TYPE INFERENCE STATISTICS
;;; --------------------------------------------------------------------------

(DEFLOCAL *the-statistics* (make-hash-table))

(DEFLOCAL *fun-call-key* 'fun-call)
(DEFLOCAL *inferred-signature-key* 'inferred-signature)
(DEFLOCAL *inferred-classes-key* 'inferred-classes)
(DEFLOCAL *joined-call-descrs-key* 'joined-call-descrs)
(DEFLOCAL *joined-signature-descrs-key* 'joined-signature-descrs)
(DEFLOCAL *inferred-abstract-classes-key* 'inferred-abstact-classes)

;; Interesting for treating compound lattice types thus %setf-select may 
;; destroy information about compound types.
(DEFLOCAL *%setf-select-key* '%setf-select)

(DEFUN initialize-ti-statistics ()
  (clrhash *the-statistics*))

(DEFUN ti-statistics (key)
  (if (null key) (ti-error))
  (let ((value (get-ti-statistics key)))
    (if value
	(setf (gethash key *the-statistics*) (+ value 1))
      (setf (gethash key *the-statistics*) 0))))

(DEFUN get-ti-statistics (key)
  (gethash key *the-statistics*))

(DEFUN ti-print-statistics ()
  (let ((classes (or (get-ti-statistics *inferred-classes-key*) 0))
	(abstract-classes (or (get-ti-statistics *inferred-abstract-classes-key*) 0))
	(calls (or (get-ti-statistics *fun-call-key*) 0))
	(joined-calls (or (get-ti-statistics *joined-call-descrs-key*) 0))
	(signatures (or (get-ti-statistics *inferred-signature-key*) 0))
	(joined-signatures (or (get-ti-statistics *joined-signature-descrs-key*) 0))
	(select (or (get-ti-statistics *%setf-select-key*) 0)))
    (format t "~%Total number of analysed function calls: ~A" calls)
    (format t "~%Total number of joined function call descriptors: ~A (~,2F %)"
	    joined-calls
	    (if (zerop calls) 0
	      (* (/ (float joined-calls) (float calls)) 100)))
    (ti-format t "~%Total number of analysed %setf-select calls: ~A" select)
    (format t "~2%Total number of inferred function type schemes: ~A" signatures)
    (format t "~%Total number of joined type scheme descriptors: ~A (~,2F %)"
	    joined-signatures
	    (if (zerop signatures) 0
	      (* (/ (float joined-signatures) (float signatures)) 100)))
    (format t "~2%Total number of inferred classes: ~A" classes)
    (format t "~%Total number of inferred abstract classes: ~A (~,2F %)"
	    abstract-classes
	    (if (zerop classes) 0
	      (* (/ (float abstract-classes) (float classes)) 100)))))

#module-end