;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-unify -*-
#|
-------------------------------------------------------------------------------
TITLE: A Modified Unification Algorithm for Type Inference
-------------------------------------------------------------------------------
File:    ti-unify.em
Version: 1.18 (last modification on Tue Oct 12 10:13:50 1993)
State:   proposed

DESCRIPTION:
Insert equations of type expressions into a given set of variable
substitutions.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
$__log

-------------------------------------------------------------------------------
|#

#module-name ti-unify
#module-import (lzs mzs ti ti-codes ti-lattice ti-exprs ti-meet-join ti-eqs
		    ti-write ti-copy)
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT unify)

;;; ---------------------------------------------------------------------------
;;; GENERAL UNIFICATION
;;; ---------------------------------------------------------------------------

(DEFGENERIC unify (stack subs))

(DEFMETHOD unify ((stack <null>)	;empty stack
		  (subs <type-var-substitutions>))
  subs)					;unification succeeded

(DEFMETHOD unify ((stack <pair>)	;stack not empty
		  (subs <type-var-substitutions>))
  (let* ((actual-equ (car stack))
	 (left-expr (?left-expr actual-equ))
	 (right-expr (?right-expr actual-equ)))
    (cond ((unify-exprs left-expr right-expr subs) ;unify first equation
	   (ti-format2 t "~%new subs ~A" (ti-print-string subs))
	   (unify (cdr stack) subs))	;unification goes ahead
	  (t nil))))			;unification failed

;;; ---------------------------------------------------------------------------
;;; UNIFICATION OF TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------
	    
(DEFGENERIC unify-exprs (expr1 expr2 subs))

(DEFMETHOD unify-exprs ((expr1 <atomic-type>)
			(expr2 <atomic-type>)
			(subs <type-var-substitutions>))
  (meet-type-exprs expr1 expr2))

(DEFMETHOD unify-exprs ((expr1 <slot-id>)
			(expr2 <slot-id>)
			(subs <type-var-substitutions>))
  (meet-type-exprs expr1 expr2))

(DEFMETHOD unify-exprs ((expr1 <slot-id>)
			(expr2 <atomic-type>)
			(subs <type-var-substitutions>))
  (meet-type-exprs expr1 expr2))

(DEFMETHOD unify-exprs ((expr1 <atomic-type>)
			(expr2 <slot-id>)
			(subs <type-var-substitutions>))
  (meet-type-exprs expr1 expr2))

;;; ---------------------------------------------------------------------------
(DEFMETHOD unify-exprs ((expr1 <type-var>)
			(expr2 <type-expr>)
			(subs <type-var-substitutions>))
  (add-unify-equation subs expr1 expr2))

(DEFMETHOD unify-exprs ((expr1 <type-expr>)
			(expr2 <type-var>)
			(subs <type-var-substitutions>))
  (add-unify-equation subs expr2 expr1))
 
;;; ---------------------------------------------------------------------------
(DEFGENERIC add-unify-equation (subs var expr))

(DEFMETHOD add-unify-equation ((subs <type-var-substitutions>)
			       (var <type-var>)
			       (expr <type-expr>))
  (let ((equ (get-last-substitution subs var)))
    (if equ
	(let ((new-expr (unify-exprs expr (?right-expr equ) subs)))
	  (if new-expr
	      (set-right-expr equ new-expr)
	    nil))
      (add-substitution subs var expr))))

(DEFMETHOD add-unify-equation ((subs <type-var-substitutions>)
			       (var <type-var>)
			       (expr <type-var>))
  (if (null (check-equality subs var expr))
      (let ((equ (get-last-substitution subs var)))
	(if equ
	    (let ((right-expr (?right-expr equ)))
	      (set-right-expr equ expr)
	      (add-unify-equation subs expr right-expr))
	  (add-substitution subs var expr)))
    t))


#module-end