;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-exprs -*-
#|
-------------------------------------------------------------------------------
TITLE: Type Expressions for Type Inference
-------------------------------------------------------------------------------
File:    ti-exprs.em
Version: 1.20 (last modification on Tue Oct 12 09:35:04 1993)
State:   proposed

DESCRIPTION:

Type expressions can be subdivided into atomic types, slot identifications, and type variables. Atomic types have a link to a lattice type or to a combinations of lattice types. A combination of lattice types can be created with lattice operations meet, join, and complement. 

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/wheick/Lisp/Apply/ti-exprs.em[1.0]
	Wed Apr 21 17:15:29 1993 akind@isst save $
 
ti-exprs.em[1.1] Fri Apr 23 09:52:36 1993 akind@isst proposed $
 
ti-exprs.em[1.2] Wed May  5 11:25:18 1993 akind@isst proposed $
 
ti-exprs.em[1.3] Wed May 12 14:17:44 1993 ukriegel@isst save $
 [Tue May 11 08:36:01 1993] Intention for change:
 slot-id-p
 done
 
ti-exprs.em[1.4] Wed May 12 16:11:47 1993 imohr@isst proposed $
 [Wed May 12 14:32:07 1993] Intention for change:
 delete method for slot-id-p
 ok
 
ti-exprs.em[1.5] Tue May 18 17:21:50 1993 akind@isst proposed $
 
ti-exprs.em[1.6] Mon May 24 12:08:24 1993 akind@isst proposed $
 
ti-exprs.em[1.7] Fri May 28 10:08:38 1993 akind@isst proposed $
 
ti-exprs.em[1.8] Tue Jun  1 15:22:08 1993 akind@isst proposed $
 
ti-exprs.em[1.9] Tue Aug  3 11:46:56 1993 akind@isst proposed $
 
ti-exprs.em[1.10] Wed Aug 11 13:34:50 1993 akind@isst proposed $
 
ti-exprs.em[1.11] Wed Aug 18 16:09:49 1993 akind@isst proposed $
 
ti-exprs.em[1.12] Thu Aug 19 09:02:51 1993 akind@isst proposed $
 
ti-exprs.em[1.13] Tue Aug 24 17:14:29 1993 akind@isst proposed $
 
ti-exprs.em[1.14] Wed Aug 25 17:38:52 1993 akind@isst proposed $
 
ti-exprs.em[1.15] Fri Aug 27 17:29:40 1993 akind@isst proposed $
 
ti-exprs.em[1.16] Mon Aug 30 09:13:03 1993 akind@isst published $
 
ti-exprs.em[1.17] Thu Sep 23 14:32:56 1993 akind@isst proposed $
 [Fri Sep  3 09:35:56 1993] Intention for change:
 type specification (%function return-class)
 
ti-exprs.em[1.18] Fri Oct  1 14:41:02 1993 akind@isst save $
 [Thu Sep 23 15:44:04 1993] Intention for change:
 
ti-exprs.em[1.19] Mon Oct 11 10:30:14 1993 akind@isst save $
 
ti-exprs.em[1.20] Tue Oct 12 10:32:09 1993 akind@isst proposed $
 

-------------------------------------------------------------------------------
|#


#module-name ti-exprs
#module-import (lzs-mop el2lzs-classes machine-description ti ti-codes
			ti-lattice
			(only (find) common-lisp))
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT <type-expr>
	<atomic-type> ?code ?name ?comp-name
	<type-var> ?id
	<slot-id> ?slot-name
	atomic-type-p type-var-p slot-id-p
	contains-type-var-p eq-type-var-p
	substitute-type-var
	new-type-var new-type-var-id reset-actual-type-var-id
	lattice-type-to-atomic-type lattice-type-to-atomic-types
	find-lattice-type find-lattice-code
	general-type general-type-p %object-type-p no-type-p %class-type-p
	<null>-type <function>-type <null>-type-p %object-type
	%function-type %void-type %void-type-p %integer-type
	%false-type %false-type-p)

;;; ---------------------------------------------------------------------------
;;; TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------

(DEFSTANDARDCLASS <type-expr> ())
  
(DEFSTANDARDCLASS <atomic-type> (<type-expr>)
  (code :accessor :initarg :initform nil)
  (name :accessor :initarg :initform nil)
  (comp-name :accessor :initarg :initform nil))
  
(DEFSTANDARDCLASS <type-var> (<type-expr>)
  (id :accessor :initarg :initform nil))
  
(DEFSTANDARDCLASS <slot-id> (<type-expr>)
  (slot-name :accessor :initarg :initform nil))

;;; ---------------------------------------------------------------------------
;;; TYPE EXPRESSION PREDICATES
;;; ---------------------------------------------------------------------------

(DEFGENERIC atomic-type-p (expr))

(DEFMETHOD atomic-type-p ((expr <type-expr>))
  #f)

(DEFMETHOD atomic-type-p ((expr <atomic-type>))
  #t)

;;; ---------------------------------------------------------------------------
(DEFGENERIC type-var-p (expr))

(DEFMETHOD type-var-p ((expr <type-expr>))
  #f)

(DEFMETHOD type-var-p ((expr <type-var>))
  #t)

;;; ---------------------------------------------------------------------------
(DEFGENERIC slot-id-p (expr))

(DEFMETHOD slot-id-p ((expr <slot-id>))
  #t)

(DEFMETHOD slot-id-p ((expr <type-expr>))
  #f)

;;; ---------------------------------------------------------------------------
;;; Answer whether an type expression contains a type varible.
(DEFGENERIC contains-type-var-p (obj var))

(DEFMETHOD contains-type-var-p ((expr <type-expr>)
				(var <type-var>))
  #f)

(DEFMETHOD contains-type-var-p ((expr <type-var>)
				(var <type-var>))
  (eq-type-var-p expr var))

(DEFMETHOD contains-type-var-p ((obj <pair>)
				(var <type-var>))
  (member-with-args #'contains-type-var-p obj var))

(DEFMETHOD contains-type-var-p ((vec <vector>)
				(var <type-var>))
  (find var vec :test #'eq-type-var-p))
 
;;; ---------------------------------------------------------------------------
;;; Answer whether two type varibles are equal.
(DEFGENERIC eq-type-var-p (var1 var2))

(DEFMETHOD eq-type-var-p (var1 var2)
  nil)

(DEFMETHOD eq-type-var-p ((var1 <type-var>)
			  (var2 <type-var>))
  (eq (?id var1) (?id var2)))

;;; ---------------------------------------------------------------------------
;;; TYPE VARIABLE IDENTIFICATION
;;; ---------------------------------------------------------------------------

(DEFLOCAL *actual-type-var-id* 0)

(DEFUN reset-actual-type-var-id ()
  (setq *actual-type-var-id* 0))

;;; Answer a new type variable identifier.
(DEFUN new-type-var-id ()
  (setq *actual-type-var-id* (+ *actual-type-var-id* 1))
  *actual-type-var-id*)

;;; Answer a new type variable.
(DEFUN new-type-var ()
  (make <type-var> :id (new-type-var-id)))

;;; ---------------------------------------------------------------------------
;;; TYPE EXPRESSION/LATTICE TYPE CONNECTION
;;; ---------------------------------------------------------------------------

(DEFUN lattice-type-to-atomic-type (lattice-type)
  (let ((expr (?atomic-expr lattice-type)))
    (if expr
	(if (?compound lattice-type)
	    (make <atomic-type>
		  :code (?code lattice-type)
		  :name lattice-type
		  :comp-name t)
	  expr)
      (let ((new-expr (make <atomic-type>
			    :code (?code lattice-type)
			    :name lattice-type
			    :comp-name (?compound lattice-type))))
	(setf (?atomic-expr lattice-type) new-expr)
	new-expr))))

(DEFUN lattice-types-to-atomic-types (lattice-types)
  (mapcar #'lattice-type-to-atomic-type lattice-types))

;;; Specialization of GF first defined in ti-lattice.
(DEFUN find-lattice-type (obj)
  (get-lattice-type (get-class-or-lattice-type obj)))

;;; Specialization of GF defined in ti-lattice.
(DEFUN find-lattice-code (name)
  (?code (get-lattice-type (get-class-or-lattice-type name))))

;;; Answer a type expression for the top of the lattice.
(DEFUN general-type ()
  (lattice-type-to-atomic-type *top*))

(DEFUN %object-type ()
  (lattice-type-to-atomic-type *%object*))

(DEFUN %void-type ()
  (lattice-type-to-atomic-type *%void*))

(DEFUN %integer-type ()
  (lattice-type-to-atomic-type *%integer*))

(DEFUN <null>-type ()
  (lattice-type-to-atomic-type *<null>*))

(DEFUN <function>-type ()
  (lattice-type-to-atomic-type *<function>*))

(DEFUN %false-type ()
  (lattice-type-to-atomic-type *%false*))

(DEFUN %function-type ()
  (lattice-type-to-atomic-type *%function*))

(DEFUN %class-type ()
  (lattice-type-to-atomic-type *%class*))

;;; Answer whether a type expression correspondes to the top of the lattice.
(DEFUN general-type-p (type-expr)
  (eq-code-p (?code type-expr) *top-code*))

;;; Answer whether a type expression correspondes to %object.
(DEFUN %object-type-p (type-expr)
  (eq-code-p (?code type-expr) *%object-code*))

;;; Answer whether a type expression correspondes to %false.
(DEFUN %false-type-p (type-expr)
  (eq-code-p (?code type-expr) *%false-code*))

;;; Answer whether a type expression correspondes to %void.
(DEFUN %void-type-p (type-expr)
  (and (atomic-type-p type-expr)
       (eq-code-p (?code type-expr) *%void-code*)))

;;; Answer whether a type expression correspondes to %class.
(DEFUN %class-type-p (type-expr)
  (and (atomic-type-p type-expr)
       (eq-code-p (?code type-expr) *%class-code*)))

;;; Answer whether a type expression correspondes to <null>.
(DEFUN <null>-type-p (type-expr)
  (eq-code-p (?code type-expr) *<null>-code*))

;;; Answer whether a type expression correspondes to the bottom of the lattice.
(DEFUN no-type-p (type-expr)
  (eq-code-p (?code type-expr) *bottom-code*))

#module-end