;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-descrs -*-
#|
-------------------------------------------------------------------------------
TITLE: Default Type Descriptors
-------------------------------------------------------------------------------
File:    ti-descrs.em
Version: 1.0 (last modification on Mon Sep 27 12:56:49 1993)
State:   save

DESCRIPTION:
Type schemes (signatures) describe the range and domain of a
function. Type schemes are generic, i.e. they may have more than one
line (descriptor). This file provides functions to create default type
descriptors.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/akind/Lisp/ti-descrs.em[1.0]
	Fri Oct  1 14:40:44 1993 akind@isst save $
 

-------------------------------------------------------------------------------
|#


#module-name ti-descrs
#module-import (mzs ti ti-exprs ti-eqs (only (make-array vector) common-lisp))
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT filled-formal-descr filled-recursive-descr filled-actual-descr
	general-var-formal-descr general-var-recursive-descr
	general-var-actual-descr
	empty-formal-descr empty-recursive-descr empty-actual-descr)
  
;;; ---------------------------------------------------------------------------
;;; DEFAULT TYPE DESCRIPTORS
;;; ---------------------------------------------------------------------------

;; Answer a formal type descriptor filled with the given expressions.
(DEFUN filled-formal-descr exprs
  (fill-descr (make <formal-type-descr>
		    :type-vars (make <type-var-substitutions>)
		    :type-vec (make-array (length exprs))
		    :stat nil
		    :t-descr-before nil
		    :type-spec 0)
	      exprs 0))

;; Answer a recursive type descriptor filled with the given expressions.
(DEFUN filled-recursive-descr exprs
  (fill-descr (make <recursive-type-descr>
		    :type-vars (make <type-var-substitutions>)
		    :type-vec (make-array (length exprs))
		    :stat nil
		    :t-descr-before nil
		    :type-spec 0)
	      exprs 0))

;; Answer an actual type descriptor filled with the given expressions.
(DEFUN filled-actual-descr exprs
  (fill-descr (make <act-type-descr>
		    :type-vars (make <type-var-substitutions>)
		    :type-vec (make-array (length exprs))
		    :stat nil
		    :t-descr-before nil
		    :type-spec 0)
	      exprs 0))

;;; Fill type vector and substitutions of a type descriptor.
(DEFGENERIC fill-descr (descr exprs index))

(DEFMETHOD fill-descr ((descr <type-descr>)
		       exprs
		       (index <spint>))
  (let ((vec (?type-vec descr))
	(subs (?type-vars descr)))
    (if (< index (length vec))
	(let* ((new-var (new-type-var))
	       (new-equ (new-type-equation new-var (car exprs))))
	  (setf (vector-ref vec index) new-var)
	  (push-type-equation subs new-equ)
	  (fill-descr descr (cdr exprs) (+ index 1)))
      descr)))

;; Fill a type descriptor up to arity with general types.
(DEFGENERIC fill-descr-to (descr arity))

(DEFMETHOD fill-descr-to ((descr <type-descr>)
			  (arity <single-precision-integer>))
  (let ((vec (?type-vec descr))
	(subs (?type-vars descr)))
    (if (>= arity 0)
	(let* ((new-var (new-type-var))
	       (new-equ (new-type-equation new-var (general-type))))
	  (setf (vector-ref vec arity) new-var)
	  (push-type-equation subs new-equ)
	  (fill-descr-to descr (- arity 1)))
      descr)))

;; Answer a formal type descriptor that is filled with general types.
(DEFUN general-var-formal-descr (arity)
  (let ((descr (make <formal-type-descr>
		     :type-vars (make <type-var-substitutions>)
		     :type-vec (make-array (+ arity 1))
		     :stat nil
		     :t-descr-before nil
		     :type-spec 0)))
    (fill-descr-to descr arity)))

;; Answer a recursive type descriptor that is filled with general types.
(DEFUN general-var-recursive-descr (arity)
  (let ((descr (make <recursive-type-descr>
		     :type-vars (make <type-var-substitutions>)
		     :type-vec (make-array (+ arity 1))
		     :stat nil
		     :t-descr-before nil
		     :type-spec 0)))
    (fill-descr-to descr arity)))

;; Answer an actual type descriptor that is filled with general types.
(DEFUN general-var-actual-descr (arity)
  (let ((descr (make <act-type-descr>
		     :type-vars (make <type-var-substitutions>)
		     :type-vec (make-array (+ arity 1))
		     :stat nil
		     :t-descr-before nil
		     :type-spec 0)))
    (fill-descr-to descr arity)))

;; Answer an empty formal type descriptor.
(DEFUN empty-formal-descr (arity)
  (make <formal-type-descr>
	:type-vars (make <type-var-substitutions>)
	:type-vec (make-array (+ arity 1))
	:stat nil
	:t-descr-before nil
	:type-spec 0))

;; Answer an empty recursive type descriptor.
(DEFUN empty-recursive-descr (arity)
  (make <recursive-type-descr>
	:type-vars (make <type-var-substitutions>)
	:type-vec (make-array (+ arity 1))
	:stat nil
	:t-descr-before nil
	:type-spec 0))

;; Answer an empty actual type descriptor.
(DEFUN empty-actual-descr (arity)
  (make <act-type-descr>
	:type-vars (make <type-var-substitutions>)
	:type-vec (make-array (+ arity 1))
	:stat nil
	:t-descr-before nil
	:type-spec 0))

#module-end