;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: register -*-
#|
-----------------------------------------------------------------------------------
TITLE: Register Allocator for SPARC
-----------------------------------------------------------------------------------
File:    register.em
Version: 1.19 (last modification on Thu Jun  3 10:43:32 1993)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:
Default usage of registers:
--------------------------
%r0        = %g0      = 0
%r1..%r7   = %g1..%g7
%r8..%r13  = %o0..%o5 = for called procedure: arguments and return values
%r14       = %o6      = %sp
%r15       = %o7      = address of CALL-instruction
%r16..%r23 = %l0..%l7
%r24..%r29 = %i0..%i5 = arguments and return values
%r30       = %i6      = %fp
%r31       = %i7      = address of CALL instruction in caller; used by RET

Stack frames:
------------
     %fp -> ?                           
            local variables             %fp-4 ..
            ?
            ?
            stack arguments (..6)       .. %sp+92
            register arguments (5..0)   %sp+88 .. %sp+68
            16?
%sp,%fp' ->

allocation of a new frame:
-------------------------
save %sp,-<4*<24+stackargs+locals+alignto8>>,%sp

Sun C
-----
procedure call arguments: 
double - 8 byte
float  - as doubles
others - 4 bytes

return values in %o0 (integer and float)
                 %f0 and %f1

REQUIRES:

PROBLEMS:

AUTHOR: Dr. Horst Firedrich, Ingo Mohr

CONTACT: horst.friedrich@isst.fhg.de, ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/register.em[1.0]
	Fri May 21 12:36:51 1993 hfried@isst save $
 to allocation of registers
 
register.em[1.1] Fri May 21 17:02:32 1993 imohr@isst save $
 [Fri May 21 12:49:26 1993] Intention for change:
 initial version
 tested by hand
 
register.em[1.2] Mon May 24 08:36:40 1993 imohr@isst save $
 ok
 
register.em[1.3] Mon May 24 08:40:39 1993 imohr@isst save $
 init-allocation with make
 
register.em[1.4] Mon May 24 09:04:15 1993 imohr@isst save $
 
register.em[1.5] Mon May 24 09:11:26 1993 imohr@isst save $
 
register.em[1.6] Mon May 24 09:13:52 1993 imohr@isst save $
 load without errors
 
register.em[1.7] Mon May 24 10:39:50 1993 imohr@isst save $
 clear-arguments-and-allocate-result with right parameters
 
register.em[1.8] Mon May 24 13:14:01 1993 imohr@isst save $
 is-a-place-for-operation now defined
 
register.em[1.9] Mon May 24 14:16:56 1993 imohr@isst save $
 is-place-allocated takes out-registers into account
 
register.em[1.10] Tue May 25 13:41:21 1993 imohr@isst save $
 allocate-place-4-first/next-argument now returning alloc
 
register.em[1.11] Wed May 26 13:19:50 1993 imohr@isst save $
 + global registers
 
register.em[1.12] Wed May 26 13:43:42 1993 imohr@isst save $
 
register.em[1.13] Wed May 26 13:50:01 1993 imohr@isst save $
 
register.em[1.14] Wed May 26 14:14:19 1993 imohr@isst save $
 with some error detection
 
register.em[1.15] Thu May 27 08:46:44 1993 imohr@isst proposed $
 + is-glob-register
 
register.em[1.16] Fri May 28 16:58:50 1993 imohr@isst proposed $
 changes in handling of places for operations
 
register.em[1.17] Wed Jun  2 14:38:31 1993 imohr@isst proposed $
 0 in %g0
 
register.em[1.18] Wed Jun  2 16:02:28 1993 imohr@isst proposed $
 
register.em[1.19] Thu Jun  3 11:16:50 1993 imohr@isst published $
 error removed for is-place-a-register (%g0)
 

-----------------------------------------------------------------------------------
|#
#module-name register

#module-import
 (level-1-eulisp
  ;apply-standard
  class-ext
  (only (incf svref vector prog1 find mapcar make-instance format some char string)
    common-lisp)
  (rename ((map cl:map)) common-lisp)
  )
; (rename ((name-from-module new-name) ...) module)
; (only (name ...) module)
#module-syntax-import
 (level-1-eulisp)    
#module-syntax-definitions

#module-header-end

;export
;------
(export 
  ; initialization
  ; --------------
  init-register-allocation ; () -> alloc
  init-leaf-register-allocation ; () -> alloc in-regs = #(%o0...),
                                ;             locals and outs = #()
  new-register-allocation ; () -> alloc
  new-last-call-register-allocation ; () -> alloc out-regs = #(%i0...)
                                    ;             locals and ins = #()
  ; handle the formal arguments and return of the function
  ; ------------------------------------------------------
  allocate-place-4-first-argument ; (type value alloc) -> alloc
  allocate-place-4-next-argument ; (type value alloc) -> alloc
  get-place-4-return ; (type alloc) -> place
  ; handle the actual arguemnts of a function call
  ; ----------------------------------------------
  get-first-place-4-function-call ; (type alloc) -> place
  get-next-place-4-function-call ; (type alloc) -> place
  get-nth-place-4-function-call ; (type alloc) -> place
  ; not used  get-result-place-4-function-call ; (type value alloc) -> place
  ; handle the arguments of an arithmetic/logic operation
  ; -----------------------------------------------------
  get-first-place-4-operation ; (type alloc) -> place/()
  get-second-place-4-operation ; (first-place type alloc) -> place/()
  get-result-place-4-operation ; (first-place second-place type alloc) -> place/()
  get-place-of-value ; (value alloc) -> place
  get-values-of-places-for-operation ; (type alloc) -> (value ...)
  ; get free places
  ; ---------------
  get-a-new-place-and-alloc ; (place alloc) -> place
  get-a-free-register ; (type alloc) -> place 
  get-a-free-temp-register ; (type alloc) -> place
  ; tests
  ; -----
  is-value-in-place-4-operation ; (type value alloc) -> place/()
  is-a-place-4-operation ; (type place alloc) -> t/()
  is-value-in-place ; (type value place alloc) -> t/()
  is-place-allocated ; (place alloc) -> () / place (with is not free)
  ; and the value is not in other places so one
  ; must remove this value
  is-a-register-free ; (type alloc) -> t/()
  is-place-a-register ; (place/car-of-place) -> t/()
  is-out-register ; (place) -> t/()
  is-glob-register ; (place) -> t/()
  
  ; allocations and give free (clear)
  ; ---------------------------------
  allocate-place ; (type place value alloc) -> alloc
  clear-arguments-and-allocate-result 
  ; (type value alloc) -> alloc
  free-place ; (place alloc) -> alloc
  free-value ; (value alloc) -> alloc
  ; copy
  copy-allocation ; (alloc) -> new-alloc
  free-allocation ; (alloc) - the alloc will not used more
  ; build a place
  ; ------------
  make-place ; (label offset) -> place
  ; printing
  ; --------
  print-allocation
  )


;;; -----------------------------------------------------------------------------------
;;; initialization
;;; -----------------------------------------------------------------------------------

(defun init-register-allocation () ; -> alloc
  ; the first allocation, older allocations may be recycled
  (make <allocation>))

(defun init-leaf-register-allocation () ; -> alloc
  ; the first allocation, older allocations may be recycled
  ; in-regs = #(%o0...),
  ; locals and outs = #()
  (let ((alloc (make <allocation>)))
    (setf (?in-registers alloc) (?out-registers alloc))
    (setf (?local-registers alloc) (make-register-set))
    (setf (?out-registers alloc) (make-register-set))
    alloc))

(defun new-register-allocation () ; -> alloc
  (make <allocation>))

(defun new-last-call-register-allocation () ; -> alloc
  ; out-regs = #(%i0...),
  ; locals and ins = #()
  (let ((alloc (make <allocation>)))
    (setf (?out-registers alloc) (?in-registers alloc))
    (setf (?local-registers alloc) (make-register-set))
    (setf (?in-registers alloc) (make-register-set))
    alloc))

;;; -----------------------------------------------------------------------------------
;;; handle the formal arguments and return of the function
;;; -----------------------------------------------------------------------------------

(defun allocate-place-4-first-argument (type value alloc) ; -> alloc
  (setf (?free-in alloc) 1)
  (place (alloc-register-n (?in-registers alloc) 0
                           value))
  alloc)

(defun allocate-place-4-next-argument (type value alloc) ; -> alloc
  (alloc-register-n (?in-registers alloc) (?free-in alloc)
                    value)
  (incf (?free-in alloc))
  alloc)

(defun get-place-4-return (type alloc) ; -> place
  (place (get-register-n (?in-registers alloc) 0)))

;;; -----------------------------------------------------------------------------------
;;; handle the actual arguments of a function call
;;; -----------------------------------------------------------------------------------

(defun get-first-place-4-function-call (type alloc) ; -> place
  (setf (?free-out alloc) 1)
  (place (get-register-n (?out-registers alloc) 0)))

(defun get-next-place-4-function-call (type alloc) ; -> place
  (prog1
    (place (get-register-n (?out-registers alloc) (?free-out alloc)))
    (incf (?free-out alloc))))

(defun get-nth-place-4-function-call (type n alloc) ; -> place
  ; n=1 for the first argument of a function call
  (place (get-register-n (?out-registers alloc) (- n 1))))

; not used
;(defun get-result-place-4-function-call (type value alloc) ; -> place
;)

(defun allocate-result-place-4-function-call (type value alloc) ; -> place
  (place (alloc-register-n (?out-registers alloc) 0
                           value)))

;; -----------------------------------------------------------------------------------
;;; handle the arguments of an arithmetic/logic operation
;;; -----------------------------------------------------------------------------------
 
(defun get-first-place-4-operation (type alloc) ; -> place/()
  (let ((reg (get-free-reg alloc
                           (?local-registers alloc)
                           (?in-registers alloc))))
    (if (null reg)
      ; look for a free general register
      (setq reg (get-free-reg alloc (?global-registers alloc)))
      (progn
        (set-register reg ^operand) ; to simulate allocation for
                                    ; get-result-place-4-operation 
        (unless (get-result-place-4-operation reg reg type alloc)
          ; then there is no register available for the result of operation
          ; look for a free general register
          (setq reg (get-free-reg alloc (?global-registers alloc))))))
    (if reg
      (place reg)
      nil)))

(defun get-second-place-4-operation (first-place type alloc) ; -> place
  ; first-place must be already allocated
  (get-first-place-4-operation type alloc))

(defun get-result-place-4-operation 
       (first-place second-place type alloc) ; -> place/()
  ; first-place and second-place must be already allocated
  (let ((reg (get-free-reg alloc
                           (?local-registers alloc)
                           (?in-registers alloc))))
    (if reg
      (place reg)
      nil)))

(defun get-place-of-value (value alloc) ; -> place/()
  (place
   (or (find-register-of-value value $special-registers)
       (find-register-of-value value (?in-registers alloc))
       (find-register-of-value value (?local-registers alloc))
       (find-register-of-value value (?out-registers alloc))
       (find-register-of-value value (?global-registers alloc))
       (progn 
         (format t "~%Error: value ~A has no place" value)
         (print-allocation alloc t)
         %g0))))

(defun get-values-of-places-for-operation (type alloc) ; -> (value ...)
  )
;;; -----------------------------------------------------------------------------------
;;; get free places
;;; -----------------------------------------------------------------------------------

(defun get-a-new-place-and-alloc (place alloc) ; -> place
  (let ((reg (get-free-reg alloc
                           (?local-registers alloc) 
                           (?in-registers alloc))))
    (setf (?value reg)
          (?value (find-register-of-place place alloc)))
    (place reg)))

(defun get-a-free-register (type alloc) ; -> place 
  ; to temporary store/load a value
  (place (get-free-reg alloc
                       (?local-registers alloc) 
                       (?in-registers alloc))))

(defun get-a-free-temp-register (type alloc) ; place
  ; returns a register which must not survive a function call and which is not
  ; used as an argument during its validity (get-next-place-4-function-call may
  ; destroy its value!)
  (place (get-free-reg alloc
                       (?global-registers alloc)
                       (?out-registers alloc) 
                       (?local-registers alloc) 
                       (?in-registers alloc))))

;;; -----------------------------------------------------------------------------------
;;; tests
;;; -----------------------------------------------------------------------------------

(defun is-value-in-place-4-operation (type value alloc) ; -> place/()
 (place
   (or (find-register-of-value value $special-registers)
       (find-register-of-value value (?in-registers alloc))
       (find-register-of-value value (?local-registers alloc))
       (find-register-of-value value (?out-registers alloc))
       (find-register-of-value value (?global-registers alloc)))))

(defun is-a-place-4-operation (type place alloc) ; -> t/()
  (find-register-of-place place alloc))

(defun is-value-in-place (type value place alloc) ; -> t/()
  (eq value 
      (?value 
       (find-register-of-place place alloc))))
  
(defun is-place-allocated (place alloc) ; -> () / place (which is not free)
  ; returns place if place has a value and if this value is not located in
  ; another place (not a global- or out-register)
  ; in the other case () is returned
  (let* ((reg (find-register-of-place place alloc))
         (value (and reg (?value reg))))
    (cond ((null reg) place)
          ((eq value ^free) nil)
          (t (setf (?value reg) ^free)
             (if (or (find-register-of-value value (?in-registers alloc))
                     (find-register-of-value value (?local-registers alloc)))
               nil ; value found on another place
               (progn
                 (setf (?value reg) value)
                 place))))))

(defun is-a-register-free (type alloc) ; -> t/()
  (or (find-register-of-value ^free (?in-registers alloc))
      (find-register-of-value ^free (?local-registers alloc))
      (find-register-of-value ^free (?out-registers alloc)) ;????
      ))

(defun is-place-a-register (place) ; -> t/()
  (find-register-of-place place *aux-alloc*))

(defun is-out-register (place) ; -> t/()
  (find-register-of-place place (?out-registers *aux-alloc*)))
  
(defun is-glob-register (place) ; -> t/()
  (find-register-of-place place (?global-registers *aux-alloc*)))
  
;;; -----------------------------------------------------------------------------------
;;; allocations and give free (clear)
;;; -----------------------------------------------------------------------------------
 
(defun allocate-place (type place value alloc) ; -> alloc
  (setf (?value (find-register-of-place place alloc))
        value)
  alloc)

(defun clear-arguments-and-allocate-result 
               (type value alloc) ; -> alloc
  (cl:map nil 
          (lambda (register) (setf (?value register) 'es::free))
          (?out-registers alloc))
  (cl:map nil 
          (lambda (register) (setf (?value register) 'es::free))
          (?global-registers alloc))
  (allocate-result-place-4-function-call type value alloc)
  alloc)

(defun free-place (place alloc) ; -> alloc
  (let ((reg (or (find-register-of-place place (?in-registers alloc))
                 (find-register-of-place place (?local-registers alloc))
                 (find-register-of-place place (?out-registers alloc))
                 (find-register-of-place place (?global-registers alloc)))))
    (setf (?value reg) ^free)
    alloc))

(defun free-value (value alloc) ; -> alloc
  (let ((reg (or (find-register-of-value value (?in-registers alloc))
                 (find-register-of-value value (?local-registers alloc))
                 (find-register-of-value value (?out-registers alloc))
                 (find-register-of-value value (?global-registers alloc)))))
    (if (null reg)
      alloc
      (progn (setf (?value reg) ^free)
             (free-value value alloc)))))

;;; -----------------------------------------------------------------------------------
;;; copy
;;; -----------------------------------------------------------------------------------

(defun copy-allocation (alloc) ; -> new-alloc
  (make <allocation>
        :free-in (?free-in alloc)
        :free-out (?free-out alloc)
        :in-registers (copy-register-set (?in-registers alloc))
        :local-registers (copy-register-set (?local-registers alloc))
        :out-registers (copy-register-set (?out-registers alloc))
        :global-registers (copy-register-set (?global-registers alloc))
    ))

(defun free-allocation (alloc) ; - the alloc will not used more
)

;;; -----------------------------------------------------------------------------------
;;; build a place
;;; -----------------------------------------------------------------------------------

(defun make-place (label/register offset) ; -> place
  (format t "~%!!! make-place not yet implemented"))         

;;; -----------------------------------------------------------------------------------
;;; eulisp-make
;;; -----------------------------------------------------------------------------------

(defun make args (apply #'make-instance args))

;;; -----------------------------------------------------------------------------------
;;; allocations, registers and places
;;; -----------------------------------------------------------------------------------

(defstandardclass <register> ()
  (name :reader :initarg)
  (value :accessor :initarg))

(defun make-register (name)
  (if (consp name)
    (make <register> 
          :name (car name)
          :value (car (cdr name)))
    (make <register> 
          :name name
          :value ^free)))

(defun make-register-set register-names
  (apply #'vector
         (mapcar #'make-register 
                 register-names)))

(defconstant $special-registers
  (make-register-set `(,^|%g0| 0)))

(deflocal %g0 (svref $special-registers 0))

(defstandardclass <allocation> ()
  (free-in :accessor
           :initarg
           :initform 0)
  (free-out :accessor
            :initarg
            :initform 0)
  (global-registers :accessor
                    :initarg
                    :initform 
                    (make-register-set ^|%g1| ^|%g2| ^|%g3| 
                                       ^|%g4| ^|%g5| ^|%g6| ^|%g7|
                                       ^|%o7| ; because it is used only by CALL
                                              ; to transmit the return address
                                       ))
  (in-registers :accessor
                :initarg
                :initform 
                (make-register-set ^|%i0| ^|%i1| ^|%i2| ^|%i3| 
                                   ^|%i4| ^|%i5|))
  (local-registers :accessor
                   :initarg
                   :initform 
                   (make-register-set ^|%l0| ^|%l1| ^|%l2| ^|%l3| 
                                      ^|%l4| ^|%l5| ^|%l6| ^|%l7|))
  (out-registers :accessor
                 :initarg
                 :initform 
                 (make-register-set ^|%o0| ^|%o1| ^|%o2| ^|%o3| 
                                    ^|%o4| ^|%o5|)))

(defun get-register-n (register-set n)
  (if (< n (length register-set))
    (svref register-set n)
    (progn
      (format t "~%Error: register %~A~D not available" 
              (char (string (svref register-set 0)) 1))
      %g0)))

(defun alloc-register-n (register-set n value)
  (let ((r (get-register-n register-set n)))
    (setf (?value r) value)
    r))

(defun get-free-reg (alloc . registers)
  ; the pareter alloc only for debugging purposes
  (or (some (lambda (register-set)
              (find-register-of-value ^free register-set))
            registers)
      (progn (format t "~%Error: no register free for allocation")
             (print-allocation alloc t)
             %g0)))

(defun place (register)
  (if (null register) nil
      (?name register)))

(defun find-register-of-value (value register-set)
  (find value register-set :key #'?value))

(defgeneric find-register-of-place (place where))

(defmethod find-register-of-place (place (register-set <vector>))
  (find place register-set :key #'?name))

(defmethod find-register-of-place (place (alloc <allocation>))
  (or (find-register-of-place place (?in-registers alloc))
      (find-register-of-place place (?local-registers alloc))
      (find-register-of-place place (?out-registers alloc))
      (find-register-of-place place (?global-registers alloc))
      (find-register-of-place place $special-registers)))

(defun is-free (register)
  (eq (?value register) ^free))

(defun set-register (reg value)
  (setf (?value reg) value))

(defun copy-register-set (registers)
  (cl:map 'vector 
       (lambda (reg)
         (make <register> 
               :name (?name reg)
               :value (?value reg)))
       registers))

;;; -----------------------------------------------------------------------------------
;;; an dummy allocation used for some tests
;;; -----------------------------------------------------------------------------------

(deflocal *aux-alloc* (new-register-allocation))

;;; -----------------------------------------------------------------------------------
;;; printing register allocations
;;; -----------------------------------------------------------------------------------

(defun print-registers (register-set stream)
  (cl:map nil 
       (lambda (reg) 
         (unless (is-free reg)
           (format stream "~%!~A: ~A" (?name reg) (?value reg))))
       register-set))

(defun print-allocation (alloc stream)
  (print-registers (?global-registers alloc) stream)
  (print-registers (?in-registers alloc) stream)
  (print-registers (?local-registers alloc) stream)
  (print-registers (?out-registers alloc) stream)
  )

#|
;;; -----------------------------------------------------------------------------------
;;; for testing
;;; -----------------------------------------------------------------------------------

(cl:import (el-modules::module-exports 
            (el-modules::find-eulisp-module ^register))
           (cl:find-package ^user))

(defun user::pa (alloc)
  (print-allocation alloc t))

|#
#module-end
