;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: LZS -*-
#|
;;; -----------------------------------------------------------------------------------
;;; TITLE: 
;;; -----------------------------------------------------------------------------------
;;;
;;; DESCRIPTION: 
;;;
;;; REQUIRES: 
;;; 
;;; NOTES: 
;;;
;;; PROBLEMS: 
;;;
;;; CONTACT:  
;;;
;;; HISTORY:
;;; REVISED: 26/11/1992 by *hf*
;;; REVISED: 05/08/1992 by *uk*
;;; CREATED: 15/07/1992 by *uk* 
;;;
;;;
;;; END OF HISTORY
;;; -----------------------------------------------------------------------------------


;;;-----------------------------------------------------------------------------
;;; Projekt  : CLICC - ein Common Lisp nach C Compiler
;;;            ---------------------------------------
;;; Dateiname: zwsdef.lisp
;;; Funktion : Definition der Zwischensprache
;;; Autor    : Heinz Knutzen
;;;
;;; $Log: lzs.lisp,v $
;;; Revision 1.1  1992/08/07  14:07:10  ukriegel
;;; Initial revision
;;;
;;; Revision 1.1  1992/08/06  10:05:11  ukriegel
;;; Initial revision
;;;

;;; HISTORY:
;;; *ak* 4.2.93 Annotation (type-expr) bei class-def angefuegt
;;; *ak* 2.2.93 Annotation (signature) bei fun angefuegt
;;; *rr* 1.2.93 init fr place
;;; *rr* 26.1.93
;;; - ein slot statement-status in fun
;;; *rr* 22.1.93 
;;; - einige neue slots in <special-sys-fun>
;;; *hf* 26.11.92
;;; - in den Funktionen Annotationen f"ur die Typinferenz (var-descr,
;;; type-descr, type-descr-s, actual, applications) , Seiteneffektanalyse
;;; (used-gvars set-gvars), lokale Optimierungen (function-label, calls,
;;; rec-calls) und Codegenerierung (place closure-place function-type
;;; closure-vars) eingef"ugt.
;;; - Bei globalen Variablen und Konstanten (defined-named-const,
;;; imported-named-const, defined-sys, imported-sym, structured-literal,
;;; defined-class, imported-class, literal-instance) die Annotation type (Typinferenz)
;;; und die Annotation place (Codegenerierung) hinzugef"ugt. 
;;; - bei local-stativc Variablen die Annotation link und place eingef"uhrt. 
;;; *im* 18.06.92
;;; - Mixin GLOBAL for all global defined lzs-objects (global in module)
;;; - Mixin IMPORTED for all imported lzs-objects           
;;; - classes are now global and may be exported
;;; - require/provide removed
;;; - annotations of the CLICC-compiler commented out
;;;
;;; *im* 10.06.92
;;; - Superklasse LZS-OBJECT fuer alle lzs-Objekte, fuer Standardeigenschaften 
;;; - Mixin NAMED fuer benannte Objekte mit Slot IDENTIFIER (explizite Definition
;;; des identifier-slots gestrichen), Accessor ist ?IDENTIFIER
;;;
;;; *im* 09.06.92
;;; Klassen var, named-const, module, class-def, slot-descr, fun, cont:
;;; +  (identifier :type symbol)  
;;;
;;; Revision 1.20  1992/06/04  16:15:30  hk
;;; Defaultwert fuer mv-spec von importierten Fkt. auf 1 gesetzt.
;;;
;;; Revision 1.19  1992/06/04  12:45:17  hk
;;; In sym den Slot ?const in ?constant-value umbenannt.
;;;
;;; Revision 1.18  1992/06/04  12:10:19  hk
;;; Den Slot mv-spec von cont mit nil initialisiert.
;;;
;;; Revision 1.17  1992/06/03  17:18:33  hk
;;; In defined-fun wurden deeper-level-calls in higher-level-calls umbenannt.
;;;
;;; Revision 1.16  1992/06/03  16:42:19  hk
;;; Schreibfehler
;;;
;;; Revision 1.15  1992/06/03  14:20:48  hk
;;; In setq-form Slot var-ref in location umbenannt, wg. named-const.
;;;
;;; Revision 1.14  1992/06/03  13:46:39  hk
;;; Slots in special-sys-fun mit nil vorbelegt.
;;;
;;; Revision 1.13  1992/06/03  13:39:34  hk
;;; In defined-sym im Slot package gibt es den ausgezeichneten Wert 'uninterned.
;;;
;;; Revision 1.12  1992/06/03  08:29:55  hk
;;; In named-const Slot const in value umbenannt.
;;;
;;; Revision 1.11.1.1  1992/06/03  08:13:13  hk
;;; In named-const Slot const in value umbenannt.
;;;
;;; Revision 1.11  1992/06/03  07:21:32  hk
;;; Annotation read bei named-const hinzugefuegt.
;;;
;;; Revision 1.10  1992/06/02  14:24:08  hk
;;; In literal-instance slot-value-list durch value-list ersetzt.
;;;
;;; Revision 1.9  1992/05/31  19:54:18  hk
;;; package-list ist nur Annotation von module, toplevel-forms hat Typ fun.
;;;
;;; Revision 1.8  1992/05/27  15:27:56  hk
;;; Package Slot eines Symbols ist nil, falls uninterned, d.h. #:symbol.
;;;
;;; Revision 1.7  1992/05/27  14:25:08  hk
;;; Fuer die Klassen wird automatisch ein Praedikat <name>-p definiert.
;;; Module haben eine Komponente package-list (nur fuer CL).
;;; mv-app und apply-app gestrichen, dafuer mv-lambda neu hinzu.
;;; einge Umbenennungen: method -> method-def,
;;;                      struct-literal -> structured-literal.
;;; In Instanzen von params haben Slots den Defaultwert (); eine nicht weiter
;;; initialisierte Instanz entspricht damit einer leeren Lambda-Liste.
;;;
;;; Revision 1.6  1992/05/07  12:43:38  hk
;;; Slots 'symbol', 'initform' und 'initargs' zu 'class-def'
;;; hinzugefuegt. Nach Bonn geschickt.
;;;
;;; Revision 1.5  1992/04/30  12:38:22  hk
;;; Nach Berlin geschickt, nach Durchsicht der Bezeichner und
;;; Definition mittels 'deflzs'
;;;
;;; Revision 1.4  1992/04/29  13:08:18  hk
;;; Zwischenversion vor der Umstellung auf Defclass.
;;;
;;; Revision 1.3  1992/04/24  09:42:57  hk
;;; Slot argument-precedence-order in generic-fun eingefuegt
;;;
;;; Revision 1.1  1992/04/24  07:16:06  hk
;;; Initial revision
;;;

Log for /tmp_mnt/net/saturn/apply/Lisp/Apply/lzs.lisp[1.0]
	Fri Mar  5 11:30:34 1993 imohr@isst save $
 LZS: class definitions
 
lzs.lisp[1.1] Fri Mar  5 12:38:12 1993 imohr@isst proposed $
 [Fri Mar  5 12:32:45 1993] Intention for change:
 + annotation "type" for <static> and <named-const>
 needed by %define-variable,. and by code generation for data
 annotation "type" was already present in <named-const>, a conflict
 with type-inference?
 
lzs.lisp[1.2] Thu Mar 11 11:20:26 1993 wheick@isst proposed $
 [Thu Mar 11 11:07:07 1993] Intention for change:
 slot code-identifier in global mixin inserted
 
lzs.lisp[1.3] Mon Mar 15 09:40:11 1993 hfried@isst proposed $
 [Fri Mar 12 17:29:00 1993] Intention for change:
 add inline 
 inline eingefuegt
 
lzs.lisp[1.4] Mon Mar 15 15:52:15 1993 imohr@isst save $
 [Mon Mar 15 09:50:52 1993] Intention for change:
 + annotations for <class-def>, <slot-desc>
 + slots setter and converter into the structure part of <fun>
 new annotations not yet tested
 
lzs.lisp[1.5] Mon Mar 15 16:45:16 1993 hfried@isst save $
 [Mon Mar 15 16:37:35 1993] Intention for change:
 add divide-slot
 not done
 
lzs.lisp[1.6] Mon Mar 22 16:35:13 1993 imohr@isst save $
 [Mon Mar 22 14:42:16 1993] Intention for change:
 + initarg-options for some slots of <slot-desc>
 ok
 
lzs.lisp[1.7] Mon Mar 22 17:29:33 1993 hfried@isst proposed $
 [Mon Mar 22 16:57:50 1993] Intention for change:
 annotation for side-effects
 
lzs.lisp[1.8] Wed Mar 24 11:01:08 1993 imohr@isst proposed $
 [Tue Mar 23 11:35:54 1993] Intention for change:
 + initargs for some slots of function definitions
 annotation renamed: result-arg-types -> range-and-domain
 + :initarg for range-and-domain
 
lzs.lisp[1.9] Mon Mar 29 13:40:50 1993 imohr@isst proposed $
 [Mon Mar 29 13:37:15 1993] Intention for change:
  + annotation initialization for defined-class
 ok
 
lzs.lisp[1.10] Mon Mar 29 18:20:00 1993 imohr@isst save $
 [Mon Mar 29 18:15:40 1993] Intention for change:
 + annotation expanded for literal-instance
 ok
 
lzs.lisp[1.11] Tue Mar 30 15:10:41 1993 imohr@isst proposed $
 [Tue Mar 30 09:27:19 1993] Intention for change:
 + annotation expanded-literal for structured-literal
 ok
 
lzs.lisp[1.12] Thu Apr  1 13:49:24 1993 imohr@isst save $
 [Thu Apr  1 13:47:45 1993] Intention for change:
 - annotations allocation and mm-type from <class-def>
 (removed from <defined-class>)
 
lzs.lisp[1.13] Fri Apr  2 15:55:35 1993 imohr@isst proposed $
 [Fri Apr  2 12:54:30 1993] Intention for change:
 + annotation expanded-literal for class-def and fun
 also introduced for sym
 
lzs.lisp[1.14] Fri Apr  2 17:04:28 1993 imohr@isst proposed $
 [Fri Apr  2 17:01:21 1993] Intention for change:
 + annotation identifier for <local-fun>
 
lzs.lisp[1.15] Tue Apr  6 09:28:18 1993 wheick@isst proposed $
 [Mon Apr  5 17:28:55 1993] Intention for change:
 +annotation code-identifier for literal-instance
 code-identifier for literals
 
lzs.lisp[1.16] Tue Apr  6 12:24:50 1993 akind@isst proposed $
 [Tue Apr  6 12:22:08 1993] Intention for change:
 Changing <fun> slot type-expr to lattice-type (*ak*).
 Left <fun> untouched. Changed <class-def> slot type-expr to lattice-type.
 
lzs.lisp[1.17] Tue Apr 13 07:58:28 1993 hfried@isst proposed $
 [Tue Apr 13 07:56:46 1993] Intention for change:
 + closure
 + closure
 
lzs.lisp[1.18] Tue Apr 27 17:21:37 1993 imohr@isst proposed $
 
lzs.lisp[1.19] Thu Apr 29 09:11:56 1993 imohr@isst proposed $
 [Thu Apr 29 09:01:37 1993] Intention for change:
 + initvalue ^unknown for annotation initial-value for global-static
 ok
 
lzs.lisp[1.20] Tue May  4 14:37:09 1993 imohr@isst proposed $
 [Tue May  4 11:02:56 1993] Intention for change:
 initial value for identifier () instead of (gensym)
 ok
 
lzs.lisp[1.21] Wed May 19 15:48:06 1993 imohr@isst save $
 [Tue May 18 15:21:01 1993] Intention for change:
 + annotation offset for slot-desc
 
lzs.lisp[1.22] Wed May 19 15:51:55 1993 imohr@isst proposed $
 [Wed May 19 15:49:05 1993] Intention for change:
 'unknown -> ^unknown
 ok
 
lzs.lisp[1.23] Mon May 24 15:45:30 1993 imohr@isst proposed $
 [Mon May 24 11:45:21 1993] Intention for change:
 + annotations used-syntax-modules and used-runtime-modules for module
 ok
 
lzs.lisp[1.24] Tue May 25 13:51:24 1993 akind@isst proposed $
 [Tue May 25 13:42:25 1993] Intention for change:
 Set defaut value of slot arg-num of <fun> to nil.
 
lzs.lisp[1.25] Thu Jun 17 08:59:49 1993 imohr@isst proposed $
 [Wed Jun 16 10:40:49 1993] Intention for change:
 embed export, use-package and friends in eval-when for compilation
 compilation ok
 
lzs.lisp[1.26] Fri Jun 25 08:28:56 1993 hfried@isst proposed $
 [Wed Jun 23 15:39:43 1993] Intention for change:
 add type-descr
 + typedescr
 
lzs.lisp[1.27] Mon Jul 19 16:32:07 1993 imohr@isst proposed $
 [Mon Jul 19 11:59:38 1993] Intention for change:
 + type-identifier for class-def
 
lzs.lisp[1.28] Wed Jul 21 09:09:10 1993 imohr@isst proposed $
 [Wed Jul 21 09:04:30 1993] Intention for change:
 + annotation label for tagged-form
 
lzs.lisp[1.29] Mon Aug 30 15:25:11 1993 imohr@isst proposed $
 [Mon Aug 30 14:01:33 1993] Intention for change:
 collecting subclasses in a class
 
lzs.lisp[1.30] Wed Sep  1 10:40:12 1993 ukriegel@isst save $
 [Wed Sep  1 10:38:22 1993] Intention for change:
 cmu
 done
 
lzs.lisp[1.31] Thu Sep  2 13:38:52 1993 ukriegel@isst published $
 [Thu Sep  2 12:48:56 1993] Intention for change:
 eval-when
 eval-when from el-modules imported
 
lzs.lisp[1.32] Mon Sep 13 10:57:43 1993 hfried@isst save $
 [Wed Sep  8 08:04:31 1993] Intention for change:
 add pass to generic-function and methods
 
lzs.lisp[1.33] Wed Sep 15 11:58:06 1993 imohr@isst save $
 [Mon Sep 13 10:59:19 1993] Intention for change:
 completion of generic functions
 
lzs.lisp[1.34] Wed Sep 15 16:58:31 1993 imohr@isst proposed $
 [Wed Sep 15 14:43:15 1993] Intention for change:
 + discrimination-depth
 
lzs.lisp[1.35] Tue Sep 21 14:51:13 1993 imohr@isst proposed $
 [Mon Sep 20 14:33:22 1993] Intention for change:
 moving annotation converter from fun to class-def
 
lzs.lisp[1.36] Tue Sep 28 08:14:54 1993 hfried@isst proposed $
 [Mon Sep 27 14:13:56 1993] Intention for change:
 add descrimination-argumewnts
 
lzs.lisp[1.37] Thu Sep 30 10:28:17 1993 imohr@isst proposed $
 [Wed Sep 29 08:20:42 1993] Intention for change:
 + initarg for slot-desc
 
lzs.lisp[1.38] Thu Sep 30 12:50:17 1993 imohr@isst proposed $
 [Thu Sep 30 12:45:02 1993] Intention for change:
 + <module-init-function>
 
lzs.lisp[1.39] Mon Oct 11 08:47:00 1993 hfried@isst proposed $
 [Fri Oct  8 14:01:37 1993] Intention for change:
 add reduce for fun-objects
 
lzs.lisp[1.40] Thu Oct 14 14:38:23 1993 imohr@isst proposed $
 [Thu Oct 14 12:07:34 1993] Intention for change:
 annotation c-import for modules
 

-----------------------------------------------------------------------------
|#

;;------------------------------------------------------------------------------
;; deflzs stuetzt sich nicht auf defstruct sondern auf defclass, weil
;; - in defclass fuer Slots eine Typspezifikation angegeben werden kann,
;;   ohne dass eine Initform angegeben werden muss,
;; - die Accessor-Funktionen generisch sind, und somit fuer verschiedene
;;   Klassen gleiche Namen haben koennen.
;;------------------------------------------------------------------------------

(defpackage "LZS"
  (:shadowing-import-from el-modules eval-when))
(in-package "LZS")

(eval-when 
   (:compile-toplevel :load-toplevel :execute)
  (use-package "SIMPLE-PROGRAMMING")
  (use-package "ACCESSORS")
  (export 'def-lzs-object))

(defmacro def-zs (name supers &rest slots)
    (make-class-definition name supers slots))

(defmacro def-lzs-object (name supers &rest slots)
(make-class-definition name
   (or supers '(lzs-object))
   slots))

;;------------------------------------------------------------------------------
;; Definition der Strukturen, die die Knoten der Zwischensprache
;; repraesentieren.
;; Zuerst werden die Slots genannt, die den Strukturteil des Knotens beschreiben
;; und dann, gefolgt von dem Kommentar ``;; Annotation'' der Annotationsteil.
;;------------------------------------------------------------------------------

(def-zs lzs-object ()                   ; the top node
  :Annotations
  (source))                             ; the position in the source code

(def-zs named ()                        ; mixin for named lzs-objects
  :Annotations
  ;;-----------
  (identifier :initform ())
  (module-id :initform nil)
  (code-identifier :initform nil)       ; slot for label
)

(def-zs global (named)                  ; mixin for all global defined lzs-objects
  (exported  :initform nil              ; which are all named and may be all
             :initarg  :exported        ; exported 
;            :type     bool
)

)

(def-zs imported ()                     ; mixin for imported lzs-objects
  :Annotations
  ;;-----------
  (definition :initarg :definition 
              :initform ()))

;;------------------------------------------------------------------------------
(def-lzs-object module (named lzs-object)
  (fun-list :type list :initform ())
  (class-def-list :type list :initform ())
  (named-const-list :type list :initform ())
  (var-list :type list :initform ())
  (sym-list :type list :initform ())
  (toplevel-forms :type <fun> :initform ())
  :Annotations
  ;;-----------
  (lex-env :type list :initform ())
  (syntax-env :type list :initform ())
  (exports :type list :initform ())
  (syntax-exports :type list :initform ())
  (used-runtime-modules :initform ())
  (used-syntax-modules :initform ())
  (c-imports :initform ())
  ) 


;;------------------------------------------------------------------------------
;; Superklasse aller Variablen.
;;------------------------------------------------------------------------------
(def-lzs-object var (named lzs-object)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; Statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object static (var)
  :Annotations
  ;;-----------
  (type :initform ())
  )
;;------------------------------------------------------------------------------
;; Definierte statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object defined-static (static))

;;------------------------------------------------------------------------------
;; Lokal definierte statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object local-static (defined-static)
  :Annotations
  ;;-----------
   (link :type list :initform '())       ; Verbindung zur Verwendung der
                                         ; Variablen
   (place :initform ())                  ; Adressausdruck                                  
  (closure                              ; Kommt frei in einer Closure vor
   :initform nil #| :type bool |#)
  )

;;------------------------------------------------------------------------------
;; Global definierte statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object global-static (global defined-static)
  :Annotations
  ;;-----------
   (read-stats :initform ())            ; Lesen von dieser glob. Variablen
   (write-stats :initform ())           ; Beschreiben dieser glob. Variablen
   type                                 ; Typausdruck
   (place :initform ())                  ; Adressausdruck
   (initial-value :initform ^unknown)
  )

;;------------------------------------------------------------------------------
;; Importierte statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object imported-static (global imported static)
  :Annotations
  ;;-----------
   (read-stats :initform ())            ; Lesen von dieser glob. Variablen
   (write-stats :initform ())           ; Beschreiben dieser glob. Variablen
   type                                 ; Typausdruck
   (place :initform ())                 ; Adressausdruck
  )
;;------------------------------------------------------------------------------
;; Dynamische Variable.
;; Die Information, ob es sich um eine importierte und/oder exportierte Variable
;; handelt, kann aus dem Symbol ersehen werden.
;;------------------------------------------------------------------------------
(def-lzs-object dynamic (var)
  (sym :type <sym>)                       ; das zugehoerige Symbol
  :Annotations
  ;;-----------
   (read-stats :initform ())            ; Lesen von dieser glob. Variablen
   (write-stats :initform ())           ; Beschreiben dieser glob. Variablen
   type                                 ; Typausdruck
   (place :initform ())                 ; Adressausdruck
)                      

;;------------------------------------------------------------------------------
;; Variablen Referenz
;;------------------------------------------------------------------------------
(def-lzs-object var-ref ()
  (var :type <var>)
  :Annotations
  ;;----------
  (read-gloc :initform ())              ; access to a dynamic variable
   )


;;------------------------------------------------------------------------------
;; Benannte Konstanten von Eulisp
;;------------------------------------------------------------------------------
(def-lzs-object named-const (global lzs-object)
  (value                                ; self-evaluating || 'unknown
   :initform ^unknown)
  :Annotations
  ;;-----------
  (type :initform ())
  (place :initform ())                 ; Adressausdruck
  eval-value                           ; value for compiletime evaluation
  )
;;------------------------------------------------------------------------------
(def-lzs-object defined-named-const (named-const))

;;------------------------------------------------------------------------------
(def-lzs-object imported-named-const (imported named-const))


;;------------------------------------------------------------------------------
;; Symbol
;; der Typ 'symbol' ist in CL reserviert.
;;------------------------------------------------------------------------------
(def-lzs-object sym (global lzs-object)
  (constant-value                       ; Fuer 'defconstant' in Common Lisp
   :initform ^no-const)                 ; self-evaluating | 'unknown | 'no-const
  :Annotations
  ;;-----------
   type                                 ; Typausdruck
   (place :initform ())                 ; Adressausdruck
   (expanded-literal :initform nil)     ; instance of <literal-instance>
  )
;;------------------------------------------------------------------------------
;; Im Modul definiertes Symbol.
;; Der Slot 'package' ist notwendig, wenn mehrere Packages als ein Modul
;; uebersetzt werden.
;;------------------------------------------------------------------------------
(def-lzs-object defined-sym (sym)
  (name :type string)
  package)                              ; Package-Name oder 'uninterned

;;------------------------------------------------------------------------------
;; Importiertes Symbol
;;------------------------------------------------------------------------------
(def-lzs-object imported-sym (imported sym))


;;------------------------------------------------------------------------------
(def-lzs-object structured-literal ()
  (value
   :type (or array cons string <literal-instance>))
  :Annotations
  ;;-----------
   type                                 ; Typausdruck
   (place :initform ())                  ; Adressausdruck
   (expanded-literal :initform nil)     ; instance of <literal-instance>
  )
;;------------------------------------------------------------------------------
;; Eine zur Ubersetzungszeit bekannte Instanz einer Klasse.
;; Wird benoetigt zur Darstellung von #s(struct-name ..) in Common Lisp.
;;------------------------------------------------------------------------------
(def-lzs-object literal-instance (named lzs-object)
  (class :type <class-def>)
  (value-list :type list)               ; Werte der Slots als Liste von Literals
  :Annotations
  ;;-----------
   type                                 ; Typausdruck
   (place :initform ())                 ; Adressausdruck
   (expanded :initform ())
)   

;;------------------------------------------------------------------------------
;; Knoten zur Darstellung von definierenden und angewandten Vorkommen von
;; Klassen.
;; Die Klasse 'class' ist in CLOS schon vergeben, deshalb 'class-def'.
;;------------------------------------------------------------------------------
(def-lzs-object class-def (global lzs-object)
  (supers :type list :initform ())      ; list of class-def's
  (direct-slots :type list :initform ()); list of slot-desc's
  (options :type list :initform ())
  (converter :initform nil)             ; a generic-fun
  class                                 ; a metaclass
  :Annotations
  ;;-----------
   type                                 ; Typausdruck
   (lattice-type :initform ())		; lattice type for type inference
   (place :initform ())                 ; Adressausdruck
   (effective-slots :initform nil)
   (class-precedence-list :initform nil)
   (expanded-literal :initform nil)     ; instance of <literal-instance>
   (equal-pred :initform nil)
   (copy-fun :initform nil)
   (allocator :initform ^unknown)       ; fun which allocates instances
  )

;;------------------------------------------------------------------------------
(def-lzs-object defined-class (class-def)

  :Annotations
  ;;----------
  representation
  gc-tracer
  (initargs :initform nil)
  (constructors :initform nil)
  (predicate :initform nil)
  (initialization :initform nil) ; list of initialization forms
  (type-identifier :initform ())
  (subclasses :initform ())
)

;;------------------------------------------------------------------------------
(def-lzs-object imported-class (imported class-def))

;;------------------------------------------------------------------------------
(def-lzs-object slot-desc (named lzs-object)
  (initfunction :initform nil           ; the function returning the initial
                :initarg :initfunction) ; value 
  (initarg :initform nil
           :initarg :initarg)
;  (initargs :type list)       only for CL!!          ; List of sym
;  allocation
  :Annotations
  ;;----------
  (initvalue :initform ^unknown)        ; set if the initform is a constant
                                        ; expression 
  (reader :initform nil)
  (writer :initform nil)
  (accessor :initform nil)
  (slot-of :initform nil                ; the class which defines the slot
           :initarg :slot-of)
  (type :initform nil                   ; the class for slot values
        :initarg :type)
  (specializes :initform nil            ; a slot-desc if the slot specializes
               :initarg :specializes)   ; another one inherited from a
                                        ; superclass 
  offset
  )

;;------------------------------------------------------------------------------
;; Die formale Parameterliste einer Funktionsdefinition.
;; Dieser Knoten taucht nur als Slot in einer Funktionsdefinition auf, seine
;; Slots koennten also auch direkt in dem Knoten 'fun' angegeben werden.
;;------------------------------------------------------------------------------
(def-lzs-object params ()
  (var-list                             ; required Parameters
    :initform () :type list) 
  (opt-list                             ; Liste von Instanzen von 'opt'
    :initform () :type list) 
  (rest                                 ; &Rest Variable oder nil
   :initform nil :type (or null <var>)) 
  (key-list                             ; Liste von Instanzen von 'key'
   :initform () :type list) 
  (allow-other-keys
   :initform nil #| :type bool |# )
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object opt ()
  (var :type var)
  init                                  ; Init Value
  (suppl                                ; Supplied-p Variable oder nil
   :initform nil :type (or null <var>)))

;;------------------------------------------------------------------------------
(def-lzs-object key (opt)
  (sym :type <sym>))                      ; Keyword Symbol


;;------------------------------------------------------------------------------
;; Funktion
;; Der Typ 'function' ist in CL reserviert.
;;------------------------------------------------------------------------------
(def-lzs-object fun ()
  (params #|:type params ; *im* 09.06.92|#)

  (setter :initform nil)                ; the setter function
      
  :Annotations
  ;;-----------
  (range-and-domain                     ; types of result and arguments
       :initform ()                     ; a vector #(result-type argtype...)
       :initarg :range-and-domain)
  (arg-num :initform ())                 ; Argumentanzahl
  (var-descr :initform ())               ; Variablendeskriptor
  (type-descr :initform ())              ; formaler Typedeskriptor
  (type-descr-s :initform ())            ; tmp formale Signatur
  (signature :initform ())               ; formale Signatur
  (actual  :initform 0)                  ; aktualitaet der Signatur
 ; used-gvars                             
 ; set-gvars                              
  (pass :initform 0)                     ; Bearbeitungszustand der Funktion
  (applications :initform ())            ; alle Aufrufe von fun
  (place :initform ())                   ; Aufrufadresse von fun
  (reduce :initform ())                  ; zum Vereinfachen von Funkt.aufr.
  (function-type :initform 0)            ; ist fun ein closure ?
  (read-glocs :initform ())              ; Lesen von glob. Variablen
  (write-glocs :initform ())             ; Schreiben von glob. Variablen
  (fread-gloc :initform ())              ; the result of all read-glocs
  (fwrite-gloc :initform ())             ; the result of all write-glocs
  (sys-glocs :initform ())               ; are fread-gloc and fwrite-gloc
                                         ; changeable
  (inline :initform ())                  ; value: nil, test or value
  statement-status                       ; *rr* status for mzs2asm 

  (interpreter :initform () )           ; function in the compilation
                                        ; environment to interpret calls of fun
   (expanded-literal :initform nil)     ; instance of <literal-instance>
  )

;;------------------------------------------------------------------------------
;; Einfache Funktion (nicht generisch)
;;------------------------------------------------------------------------------
(def-lzs-object simple-fun (fun)
  body
  :Annotations
  ;;-----------
  function-label                         ; zum Einsammeln der MZS-Bloecke
  calls                                  ; alle Funktionsaufrufe in fun
  rec-calls                              ; alle rekursiven Funktionsaufrufe von
                                         ; fun
  tests
  moves
)

;;------------------------------------------------------------------------------
;; Definierte einfache Funktion
;;------------------------------------------------------------------------------
(def-lzs-object defined-fun (simple-fun))

;;------------------------------------------------------------------------------
;; Globale definierte einfache Funktion
;;------------------------------------------------------------------------------
(def-lzs-object global-fun (global defined-fun))

;;------------------------------------------------------------------------------
;; module initializing function
;;------------------------------------------------------------------------------
(def-lzs-object module-init-fun (global-fun))

;;------------------------------------------------------------------------------
;; lokale einfache Funktion
;; (Kann nicht importiert sein, das ist syntaktisch nicht moeglich.)
;;------------------------------------------------------------------------------
(def-lzs-object local-fun (named defined-fun)
  :Annotations
  ;;-----------
  closure-vars                           ; closure-Variablen
  )

;;------------------------------------------------------------------------------
;; importierte einfache Funktion
;;------------------------------------------------------------------------------
(def-lzs-object imported-fun (global imported simple-fun)
  (body :initform ^unknown)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; Systemfunktion, die in gewissen Phasen des Compilers einer speziellen
;; Behandlung beduerfen.
;;------------------------------------------------------------------------------
(def-lzs-object special-sys-fun (imported-fun)
  :Annotations
  ;;-----------
; *rr* neue slots ?annotations?
  protocol-type
;  arg-count == arg-num of <fun>
  match-list
  inline
  )

;;------------------------------------------------------------------------------
(def-lzs-object generic-fun (fun)
  (method-list :initform () :type list)
  (domain :type list)                 ; list of <class-def>
  (class :type <class-def>)
  (method-class :type <class-def>)
  
  :Annotations
  ;;-----------
  (discriminating-fun :type <simple-fun>)
  (method-lookup-fun :type <simple-fun>)
  discrimination-depth
  discrimination-arguments
  )

;;------------------------------------------------------------------------------
(def-lzs-object defined-generic-fun (generic-fun))

;;------------------------------------------------------------------------------
(def-lzs-object global-generic-fun (global defined-generic-fun))

;;------------------------------------------------------------------------------
(def-lzs-object local-generic-fun (defined-generic-fun)
  :Annotations
  ;;-----------
  closure-vars                           ; closure-Variablen
)

;;------------------------------------------------------------------------------
(def-lzs-object imported-generic-fun (global imported generic-fun))

;;------------------------------------------------------------------------------
(def-lzs-object method-def ()
  (fun :type <fun>)                     ; the working function
  (domain                               ; list of <class-def>
   :initform () :type list)
  (class :type <class-def>)
  :Annotations
  ;;-----------
  (generic-fun :type <generic-fun>)     ; the methods generic function
  )

;;------------------------------------------------------------------------------
;; Eine Funktions-Anwendung;
;; 'form' ist ein 'fun' oder evaluiert zur Laufzeit zu einer Funktion.
;;------------------------------------------------------------------------------
(def-lzs-object app ()
; form                                  ; called function now (IM)
  function
  (arg-list
   :initform () :type list)
  :Annotations
  ;;-----------
  (read-glocs :initform ())              ; all global-reads in the arguments
  type-descr
  )

;;------------------------------------------------------------------------------
(def-lzs-object setq-form ()
  (location :type (or <var-ref> <named-const>))
  form
  :Annotations
  ;;-----------
  type-descr
  (write-gloc :initform ())              ; setq to a global variable
  (read-gloc :initform ())               ; a read of a global variable
)

;;------------------------------------------------------------------------------
(def-lzs-object progn-form ()
  (form-list :type list))

;;------------------------------------------------------------------------------
(def-lzs-object if-form ()
  pred
  then
  else
  :Annotations
  ;;-----------
  (read-gloc :initform ())                ; pred is an read access to a global
                                          ; variable 
  )

;;------------------------------------------------------------------------------
(def-lzs-object switch-form ()
  form
  (case-list :type list)                ; Liste von labeled-form
  otherwise)                            ; Eine 'form'

;;------------------------------------------------------------------------------
(def-lzs-object labeled-form ()
  value                                 ; sym oder simple-literal
  form)

;;------------------------------------------------------------------------------
(def-lzs-object let*-form ()
  (var-list                             ; List of var
   :initform () :type list) 
  (init-list                            ; List of initial values
   :initform () :type list)
  body
  :Annotations
  ;;-----------
  (type-list
   :initform () :type list)
  read-gloc-list                         ; all read-glocs of the init-list
  write-gloc-list                        ; all write-glocs of the var-list
)

;;------------------------------------------------------------------------------
(def-lzs-object labels-form ()
  (fun-list                             ; List of fun
   :initform () :type list)
  body)

;;------------------------------------------------------------------------------
(def-lzs-object let/cc-form ()
  (cont :type <cont>)
  body)

;;------------------------------------------------------------------------------
(def-lzs-object cont (local-static)
  :Annotations
  ;;------------
  (link :initform ())
  )

;;------------------------------------------------------------------------------
(def-lzs-object tagbody-form ()
  first-form                            ; Ausdruck vor dem 1. Tag, evtl. nil
  (tagged-form-list :type list)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; tagged-form repraesentiert zugleich das Tag und
;; alle zugehoerigen Go Ausdruecke
;;------------------------------------------------------------------------------
(def-lzs-object tagged-form ()
  form
  (tagbody :type <tagbody-form>)
  :Annotations
  ;;-----------
  label
  )
;;------------------------------------------------------------------------------
;; Konstrukt zum Ausdruecken der Special Forms multiple-value-call und
;; multiple-value-prog1 in der Zwischensprache.
;; Dieses Konstrukt ist sehr aehnlich zu dem Makro multiple-value-bind mit
;; der Ausnahme, dass eine beliebige Lambda-Liste angegeben werden kann.
;;------------------------------------------------------------------------------
(def-lzs-object mv-lambda ()
  (params :type <params>)
  body
  arg)                                  ; generiert evtl. multiple Werte
;;------------------------------------------------------------------------------