;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: generate-header-file -*-
#|
-----------------------------------------------------------------------------------
TITLE: generation of header files
-----------------------------------------------------------------------------------
File:    generate-header-file.em
Version: 1.20 (last modification on Mon Jul 26 11:40:50 1993)
State:   published

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/generate-header-file.em[1.0]
	Tue Apr 27 14:32:07 1993 ukriegel@isst proposed $
 generation of header file for top module - a nice hack
 
generate-header-file.em[1.1] Wed Apr 28 13:32:52 1993 ukriegel@isst proposed $
 [Wed Apr 28 13:21:12 1993] Intention for change:
 :if-does-not-exist
 done
 
generate-header-file.em[1.2] Wed Apr 28 16:39:38 1993 ukriegel@isst proposed $
 [Wed Apr 28 16:34:29 1993] Intention for change:
 defined-named-const
 done
 
generate-header-file.em[1.3] Thu Apr 29 08:54:39 1993 ukriegel@isst proposed $
 [Thu Apr 29 08:50:08 1993] Intention for change:
 
generate-header-file.em[1.4] Mon May  3 12:13:44 1993 ukriegel@isst save $
 [Mon May  3 10:46:19 1993] Intention for change:
 add declarations
 c declarations added - a hack 
 
generate-header-file.em[1.5] Tue May  4 14:13:53 1993 ukriegel@isst proposed $
 [Tue May  4 13:00:18 1993] Intention for change:
 discard underscore if any
 done
 
generate-header-file.em[1.6] Thu May  6 09:46:55 1993 ukriegel@isst proposed $
 [Thu May  6 09:41:21 1993] Intention for change:
 
generate-header-file.em[1.7] Fri May  7 08:51:33 1993 ukriegel@isst proposed $
 generates extern in front of lisp
 still to do is cooorect c type
 
generate-header-file.em[1.8] Fri May  7 12:31:41 1993 ukriegel@isst proposed $
 [Fri May  7 11:04:24 1993] Intention for change:
 --- no intent expressed ---c declarations removed
 
generate-header-file.em[1.9] Tue May 11 14:28:30 1993 ukriegel@isst proposed $
 [Tue May 11 10:41:02 1993] Intention for change:
 export module-init-fun
 rename taken into account
 
generate-header-file.em[1.10] Wed May 12 17:32:14 1993 ukriegel@isst proposed $
 [Wed May 12 17:32:04 1993] Intention for change:
 --- no intent expressed ---
generate-header-file.em[1.11] Wed May 12 18:11:13 1993 ukriegel@isst proposed $
 [Wed May 12 17:42:20 1993] Intention for change:
 reset minus in identifiers by underscores
 done
 
generate-header-file.em[1.12] Thu May 27 10:27:40 1993 ukriegel@isst save $
 [Thu May 27 10:26:00 1993] Intention for change:
 lowecase file names
 done
 
generate-header-file.em[1.13] Thu May 27 13:24:16 1993 ukriegel@isst proposed $
 [Thu May 27 12:55:50 1993] Intention for change:
 
generate-header-file.em[1.14] Fri May 28 11:09:57 1993 ukriegel@isst proposed $
 done
 
generate-header-file.em[1.15] Tue Jun  1 06:37:36 1993 ukriegel@isst proposed $
 [Tue Jun  1 06:31:12 1993] Intention for change:
  typedef *double double-float
 done
 
generate-header-file.em[1.16] Tue Jun  1 09:43:19 1993 ukriegel@isst save $
 [Tue Jun  1 09:40:36 1993] Intention for change:
 
generate-header-file.em[1.17] Wed Jun  2 12:30:36 1993 ukriegel@isst proposed $
 [Wed Jun  2 12:28:39 1993] Intention for change:
 add empty line to make unix happy
 done
 
generate-header-file.em[1.18] Wed Jun  2 15:14:37 1993 ukriegel@isst proposed $
 [Wed Jun  2 15:13:32 1993] Intention for change:
 
generate-header-file.em[1.19] Fri Jul  9 15:47:43 1993 ukriegel@isst proposed $
 [Fri Jul  9 13:16:53 1993] Intention for change:
 add strings
 <name> is named in header file as NAME_CLASS
 
generate-header-file.em[1.20] Thu Aug  5 09:37:09 1993 imohr@isst published $
 [Mon Jul 26 11:25:15 1993] Intention for change:
 new code identifiers
 C-code generation
 

-----------------------------------------------------------------------------------
|#

#module-name generate-header-file
#module-import
(level-1-eulisp
 accessors
 el2lzs
 lzs
 tail-module
 (only (c-identifier) code-identifier)
 (rename ((format cl:format)
          (string cl:string)
          (eql cl:eql)
          (schar cl:schar)
          ) common-lisp))
#module-syntax-import 
(level-1-eulisp
 (rename ((with-open-file cl:with-open-file)
          (dolist cl:dolist)
          (setf cl:setf)
          (null cl:null)
          (nsubstitute cl:nsubstitute)
          (concatenate cl:concatenate)
          (alphanumericp cl:alphanumericp)
          (remove-if-not cl:remove-if-not)
          (string cl:string)) 
   (only (with-open-file dolist setf null nsubstitute 
                         remove-if-not string
                         concatenate alphanumericp)common-lisp)))
#module-syntax-definitions

;; local macro definitions

#module-header-end
(deflocal define-format "~%#define ~a  ~a")
(deflocal extern-function-format "~%extern ~a ~a();")
(deflocal extern-format "~%extern ~a ~a;")

;;exports
(export generate-header-file generate-header-file-for-module) 
;;definitions and init-forms

;;requires a module-name
(defun generate-header-file-for-module (module)
  (generate-header-file (find-module module)))

;;requires a module

(defun generate-header-file (main)
  (let ((exports (?exports main))
        (id (?identifier main)))
    (cl:with-open-file (out (cl:format nil "~(~a~).h" id)
                            :direction :output 
                            :if-exists :supersede
                            :if-does-not-exist :create
                            )
      (cl:format out "/*Header File for module ~a */~2%" id)
      (cl:format out "~%typedef void* lisp ;/* the general lisp type */~%")
      (cl:format out "~%typedef char** symbol ;/* the lisp type symbol*/~%")
      (cl:format out "~%typedef char** string ;/* the lisp type string*/~%")(cl:format out "~%typedef lisp integer ;/* the general lisp type */~%")
      (cl:format out "~%typedef double* double_float ;/* the general double_float type */~%")
      ;;export init-module
      (decode-object-and-dispatch (?toplevel-forms main) out)
      (cl:dolist (el exports)
        (decode-object-and-dispatch  el out))
      (cl:format out "~2%/*End Header File for module ~a  */~2%" id))))

(defun kill-underscore
       (val)
  (cl:nsubstitute #\_ #\- 
                  (cl:nsubstitute #\Space #\_ (cl:string val) :end 1)))

(defun decode-object-and-dispatch 
       (object stream)
  ;;decodes object into exported name and lzs-object
  (let* ((id-and-object (get-identifier-and-object object))
         (id (kill-underscore (car id-and-object))))
        (write-header-entry (cdr id-and-object) id stream)))

(defgeneric write-header-entry 
  (form identifier stream))

(defmethod write-header-entry
           ((form <global-static>) id stream )
  (comment stream "<global-static>")
  (cl:format stream define-format  id (c-identifier form))
  ;(cl:format stream extern-format (decode-type form) (c-identifier form))
  )

(defmethod write-header-entry
           ((form <global-fun>) id stream )
  (comment stream "<global-fun>")
  (cl:format stream define-format  id (c-identifier form))
  ;(cl:format stream extern-function-format (decode-type form) (c-identifier form))
  )

(defmethod write-header-entry
           ((form <imported-fun>) id stream )
  (comment stream "<imported-fun>")
  (cl:format stream define-format id (c-identifier form))
  ;(cl:format stream extern-function-format (decode-type form) (c-identifier form))
  )

(defmethod write-header-entry
           ((form <class-def>) id stream )
  (comment stream "<class-def>")
  (cl:format stream define-format (c-class-name id) (c-identifier form))
  ;(cl:format stream extern-function-format (decode-type form) (c-identifier form))
  )

(defmethod write-header-entry
           ((form <defined-named-const>) id stream )
  (comment stream "<defined-named-const>")
  (handle-const-value (?value form) form id stream))
  
  
  
(defmethod write-header-entry (form id stream)
  (comment stream "???error???")
  (cl:format stream "~%/* form: ~s id: ~s*/" form id))

(defgeneric handle-const-value (value form id stream))
(defmethod handle-const-value 
           ((value <fun>) form id stream)
  (cl:format stream define-format id (c-identifier value))
  ;(cl:format stream extern-function-format (decode-type value) (c-identifier value))
  )


(defmethod handle-const-value
           (value form id stream)
  (cl:format stream define-format id (c-identifier form))
  ;(cl:format stream extern-format (decode-type form) (c-identifier form))
  )

(defun comment (stream arg)
  (cl:format stream "~%~30T/* ~a  */" arg))

(defun c-class-name
       (name)
  (cl:concatenate 'cl:string (cl:delete-if-not  #'cl:alphanumericp (cl:string name))"_CLASS"))
#module-end