;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: generate-def-file -*-
#|
-----------------------------------------------------------------------------------
TITLE: generation of interface files
-----------------------------------------------------------------------------------
File:    generate-def-file.em
Version: 
State: 

DESCRIPTION:
the description of the content

DOCUMENTATION:

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
e.u.kriegel

CONTACT: 
a.kind

HISTORY: 

-----------------------------------------------------------------------------------
|#

#module-name generate-def-file
#module-import (level-1-eulisp
		accessors
		el2lzs
		lzs
		tail-module
		type-inference
		(only (format dolist) common-lisp))
#module-syntax-import (level-1-eulisp
		       (only (with-open-file) common-lisp))
#module-syntax-definitions
#module-header-end

;;exports
(export generate-def-file generate-def-file-for-module) 

;;requires a module-name
(defun generate-def-file-for-module (module)
  (generate-def-file (find-module module)))

;;requires a module
(defun generate-def-file (main)
  (let ((exports (?exports main))
        (id (?identifier main)))
    (with-open-file (out (format nil "~(~a~).def" id)
		     :direction :output :if-exists :supersede
		     :if-does-not-exist :create)
      (format out "\;\;\;-*- Mode: Lisp\; Syntax: Common-Lisp\; Base: 10\; ")
      (format out "Package: ~a-DEF -*-" id)
      (format out "~2%(defmodule ~a-DEF" id)
      (format out "~%  (tail)")
      (format out "~%  (syntax (tail))")
      (format out "~2%\;\;\; Type schemes of exported identifiers of module ~a." id)
      (dolist (obj exports) (ti-def-write out obj))
      (format out "~2%) \;end of module~%"))))

#module-end