;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: EL2LZS-MAIN -*-
#|
-----------------------------------------------------------------------------------
TITLE: EuLisp-to-LZS-Transformer: the common parts
-----------------------------------------------------------------------------------
File:    el2lzs-main.em
Version: 1.23 (last modification on Wed Oct 20 16:47:21 1993)
State:   proposed

DESCRIPTION:
This module contains all things which are needed for the implementation of
transformation rules (implemented in EL2LZS-RULES) and for the work with
LZS-modules. It provides also the function TRANS-MODULE which transforms an
EuLisp-Module in list-representation into an LZS-module.

DOCUMENTATION:

NOTES:
Up to now no error-checking or error-handling takes places. This means, that
the incoming EuLisp-module must be in correct syntax.

REQUIRES:

PROBLEMS:
To avoid module dependency cycles type-inference::set-signature-from-classes was
used with explicit package qualifier. In the future el2lzs-main should be
divided into 2 modules.

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 

 10.06.1992 Ingo Mohr
 initial version
 
 11.06.1992 Ingo Mohr
 - tested and debugged
 - function-objects with body=UNDEFINED are now created if an unbound lexical
 variable appears in functional position

 15.06.1992 Ingo Mohr
 bug in creation of defined-sym removed (the name-slot is now set) 

 16.06.1992 Ingo Mohr
 all slots of undefined functions are set 

 17.06.1992 Ingo Mohr
 - require/provide removed because of incompatibility and loading problems
 - added: handling of export

Log for /tmp_mnt/net/saturn/apply/Dist/Apply/el2lzs-main.em[1.0]
	Fri Feb 26 16:56:52 1993 imohr@isst proposed $
 Main part of the frontend.
 
el2lzs-main.em[1.1] Wed Mar 17 08:55:50 1993 imohr@isst proposed $
 Transmod can now return a list of bindings.
 
el2lzs-main.em[1.2] Wed Mar 31 10:38:59 1993 imohr@isst proposed $
 literals for structures, literal expanders and expose ok
 
el2lzs-main.em[1.3] Mon Apr 19 15:44:05 1993 imohr@isst proposed $
 without warning when searching for a class binding for lattice-types
 
el2lzs-main.em[1.4] Mon Apr 19 18:54:53 1993 imohr@isst save $
 now message _whole-form_ not used is avoided
 
el2lzs-main.em[1.5] Tue Apr 20 16:05:45 1993 imohr@isst proposed $
 format instead of warn for lexical binding not found
 
el2lzs-main.em[1.6] Tue Apr 27 17:30:04 1993 imohr@isst proposed $
 initfunction of module now calls initialization of used modules
 
el2lzs-main.em[1.7] Thu May  6 11:11:09 1993 imohr@isst save $
 ignore bad exports (no lexical binding for an exported identifier)
 
el2lzs-main.em[1.8] Fri May  7 13:41:00 1993 imohr@isst save $
 result-type for module-init-functions
 
el2lzs-main.em[1.9] Fri May  7 14:41:33 1993 imohr@isst proposed $
 
el2lzs-main.em[1.10] Tue May 11 13:41:38 1993 imohr@isst save $
 error when marking exported things removed
 
el2lzs-main.em[1.11] Tue May 11 14:46:52 1993 imohr@isst save $
 error in mark-as-exported
 
el2lzs-main.em[1.12] Wed May 12 12:33:02 1993 imohr@isst proposed $
 
el2lzs-main.em[1.13] Mon May 24 16:27:05 1993 imohr@isst save $
 * initfunctions are calling only needed other initfunctions
 * checking for name clashes during import and expose
 * reverse the lists of objects in a module
 
el2lzs-main.em[1.14] Tue May 25 10:59:43 1993 imohr@isst proposed $
 error messages more beautiful
 
el2lzs-main.em[1.15] Thu Jun  3 17:39:05 1993 imohr@isst proposed $
 symbols
 
el2lzs-main.em[1.16] Thu Jul 15 15:42:24 1993 ukriegel@isst proposed $
 [Thu Jul 15 15:13:06 1993] Intention for change:
 replace $
 done
 
el2lzs-main.em[1.17] Thu Aug 26 15:03:02 1993 imohr@isst published $
 [Thu Aug 26 11:01:07 1993] Intention for change:
 add signature in init-functions for TI
 using symbol-function and find-symbol to avoid recursive modules
 
el2lzs-main.em[1.18] Mon Sep 27 11:08:52 1993 imohr@isst proposed $
 [Fri Sep 24 11:34:48 1993] Intention for change:
 error when compiling this module
 defclass (CL) -> defstandardclass
 
el2lzs-main.em[1.19] Thu Sep 30 12:50:22 1993 imohr@isst proposed $
 [Thu Sep 30 12:45:14 1993] Intention for change:
 + <module-init-function>
 
el2lzs-main.em[1.20] Fri Oct 15 17:34:12 1993 imohr@isst proposed $
 [Thu Oct 14 08:17:50 1993] Intention for change:
 new style module syntax
 
el2lzs-main.em[1.21] Mon Oct 18 16:55:54 1993 imohr@isst save $
 [Mon Oct 18 09:28:08 1993] Intention for change:
 correct syntax error messages
 
el2lzs-main.em[1.22] Wed Oct 20 14:03:25 1993 imohr@isst proposed $
 errors
 
el2lzs-main.em[1.23] Wed Oct 20 18:44:47 1993 imohr@isst proposed $
 [Wed Oct 20 14:04:05 1993] Intention for change:
 --- no intent expressed ---

-----------------------------------------------------------------------------------
|#

#module-name el2lzs-main
#module-import
((except (member) level-1-eulisp)
 class-ext
 (only (FIRST SECOND THIRD FOURTH NTHCDR CAAR
        CONCATENATE INTERN
        PUSH pushnew STRING MAKE-INSTANCE DELETE-IF DELETE-IF-NOT
        CLASS-OF FIND-IF
        DELETE delete-duplicates REMOVE-IF-NOT CDDR NSUBST
        APPEND MAPCAR ASSOC MAPC MAPCAN MEMBER REVERSE SUBCLASSP NCONC GET
        listp stringp
        initialize-instance vector) 
   common-lisp)
 lzs
 el2lzs-load
 el2lzs-error)
#module-syntax-import 
(level-1-eulisp
 class-ext
 (only (CASE
        declare ignore) 
   common-lisp))
#module-syntax-definitions
  (defmacro define-transformation (name)
    `(progn 
       (defgeneric ,name (source))
       (export ,name)
       (defmethod ,name ((expr <pair>))
         (if (check-syntax (get-trans-pattern ',(make-eulisp-symbol name) (car expr))
                           expr)
           (apply (get-trans-function ',(make-eulisp-symbol name) 
                                      (car expr)) 
                  expr expr)              ; first expr is for _whole-form_
           nil))
       (defmacro ,(make-identifier (string-append "DEF" (symbol-name name)))
                 (pattern result)
         (define-trans ',name pattern result))))
#module-header-end

(expose lzs)
(expose (only (FIRST REST CADAR CAAR
               MAKE-INSTANCE
               IGNORE DECLARE
               CASE)
          common-lisp))

;;; -----------------------------------------------------------------------------------
;;;  deftrans: defines a transformation for list-expressions
;;; -----------------------------------------------------------------------------------
(export-syntax _whole-form_)

(defun define-trans (trans-function pattern result) 
(let ((trans-function (make-eulisp-symbol trans-function)) 
      (form-keyword (first pattern)))
  (if (symbolp form-keyword)
    (progn
      (setq form-keyword (make-eulisp-symbol (car pattern))) 
      `(progn (setf (get ',form-keyword ',trans-function) 
                    (cons
                     (lambda (_whole-form_ form-keyword ,@(cdr pattern)) 
                       (declare (ignore form-keyword))
                       _whole-form_ ; to avoid warnings by the CL compiler
                       ,result)
                     ',pattern))
              (cons ',trans-function ',pattern)))
    `(progn (setf (get ^t ',trans-function) 
                  (cons
                   (lambda (_whole-form_ ,(first form-keyword) ,@(cdr pattern)) 
                     _whole-form_ ; to avoid error messages by the compiler
                     ,result)
                   nil))
            (cons ',trans-function ',pattern)))))

(defun get-trans-function (trans-function key)
  (car (or (and (symbolp key)
	        (get key trans-function))
           (get ^t trans-function))))

(defun get-trans-pattern (trans-function key)
  (cdr (or (and (symbolp key)
	        (get key trans-function))
           (get ^t trans-function))))

;;; -----------------------------------------------------------------------------------
;;; check syntax
;;; -----------------------------------------------------------------------------------

(defun check-syntax (pattern expr)
  (if (or (null pattern
                )(and (consp expr)
                      (check-syntax-components pattern expr)))
    t
    (progn (error-invalid-syntax pattern expr)
           nil)))

(defun check-syntax-components (pattern expr)
  (cond ((null pattern)
         (null expr))
        ((atom pattern) 
         (true-list-p expr))
        ((null expr)
         nil)
        ((atom expr)
         nil)
        (t
         (check-syntax-components (cdr pattern) (cdr expr)))))

(defun true-list-p (l)
  (cond ((consp l) (true-list-p (cdr l)))
        ((null l) t)
        (t nil)))

;;; -----------------------------------------------------------------------------------
;;; For debugging and error messages
;;; -----------------------------------------------------------------------------------
(export-syntax with-defining-form)

(defmacro with-defining-form body
  `(dynamic-let ((current-defining-form 
                  (or (dynamic current-defining-form) ;to shadow mapping of def-forms
                      _whole-form_)))
     ,@body))

;;; -----------------------------------------------------------------------------------
;;; initialization of transformations
;;; -----------------------------------------------------------------------------------

(define-transformation trans)

(define-transformation transmod)

(define-transformation transdef)

(define-transformation transsyn)

;;; -----------------------------------------------------------------------------------
;;; objects referring to lzs-objects
;;; -----------------------------------------------------------------------------------
;;; this kind of objects is needed for imports with rename

(export <binding>)

#| now defined in el2lzs-error to avoid module dependency circles
(defstandardclass <binding> ()
  (identifier :reader :initarg)
  (refers-to :reader :initarg)
  (refers-finally-to :accessor)
  :predicate)

(defmethod initialize-instance ((ref <binding>) . more)
  (call-next-method)
  (setf (?refers-finally-to ref) 
        (finally-refered-object (?refers-to ref)))
  ref)

(defgeneric finally-refered-object (obj))
(defmethod finally-refered-object (obj) obj)
(defmethod finally-refered-object ((obj <binding>))
  (?refers-to obj))

(defmethod ?exported ((ref <binding>))
  (?exported (?refers-finally-to ref)))

(defun get-lzs-object (object)
  ;; get-lzs-object returns the object finally refered to if object is a
  ;; renamed object or otherwise returns its argument 
  (if (binding-p object)
    (?refers-finally-to object)
    object))
|#

;;; -----------------------------------------------------------------------------------
;;;  some environments for transformations
;;; -----------------------------------------------------------------------------------

(export find-in-env 
        find-in-lex-env find-in-symbol-env find-in-dynamic-env find-in-mac-env
        make-undefined-function
        add-to-lex-env add-to-lex-env* in-lex-env
        find-module
        module-env
        env-plus
        reset-environments
        )

(export-syntax lex-env ; only an identifier, nesseciary when using in-lex-env
  )

;ATTENTION: the environments are not handled right, the lex must be
;module-specific and the dynamic and the symbol must be global!!! ?????

(defun find-in-env (env id)
  (get-lzs-object
   (find-if (lambda (el)
              (eq id (?identifier el)))
            env)))

; adds one new element to an environment if it is not NIL
; in the cases when this element cannot be NIL cons is used for efficiency 
(defun env-plus (new env)
  (if (null new)
    env
    (cons new env)))

;;; -----------------------------------------------------------------------------------
(defvar lex-env ())                     ; the lexical environment
                                        ; which can grow and shrink

(defun find-in-lex-env (id)
  (or (find-in-env (dynamic lex-env) id)
      (error-no-lexical-binding id)))

(defun add-to-lex-env (obj)
  (push obj (dynamic lex-env)))

(defun add-to-lex-env* (objects)
  (dynamic-setq lex-env
                (append objects (dynamic lex-env))))

(defmacro in-lex-env (new-env . forms)
  `(let ((lex-env (dynamic lex-env)))
     (dynamic-let ((lex-env ,new-env))
                  ,@forms)))

;;; -----------------------------------------------------------------------------------
(defvar mac-env ())                     ; the lexical environment for syntax expansion

(defun find-in-mac-env (id)
  (find-in-env (dynamic mac-env) id))

(defun add-to-mac-env (obj)
  (push obj (dynamic mac-env)))

;;; -----------------------------------------------------------------------------------
(defvar symbol-env ())                  ; the set of used symbols

(defun find-in-symbol-env (id)
  (find-in-env (dynamic symbol-env) id))

(defmacro add-to-symbol-env (obj)
  `(push ,obj (dynamic symbol-env)))

;;; -----------------------------------------------------------------------------------
(defvar dynamic-env ())                 ; the set of dynamic variables
; (all are viewed as global ones)
(defun find-in-dynamic-env (id)
  (find-in-env (dynamic dynamic-env) id))

(defmacro add-to-dynamic-env (obj)
  `(push ,obj (dynamic dynamic-env)))

(defvar undefined-functions () )

(defun make-undefined-function (fun)
  (let ((undefined-fun (find-in-env (dynamic undefined-functions) fun)))
    (unless undefined-fun
      (setq undefined-fun
            (make-instance <global-fun>
              :identifier fun
              :params ()
              :body 'undefined))
      (dynamic-setq undefined-functions
                    (nconc (dynamic undefined-functions) (list undefined-fun))))
    undefined-fun))

;;; -----------------------------------------------------------------------------------
(deflocal module-env ())                  ; the set of modules 

(defun find-module (id)
(find-in-env module-env id))

(defmacro add-to-module-env (mod)
`(let ((mod ,mod))
   (push mod module-env)
   mod))

;;; -----------------------------------------------------------------------------------

(defun reset-environments ()
  (setq module-env (list (find-module ^%tail)))
  (dynamic-setq dynamic-env nil)
  (dynamic-setq symbol-env nil))

;;; -----------------------------------------------------------------------------------
;;; %TAIL: the basic module
;;; -----------------------------------------------------------------------------------
(export $tail-module)

(defconstant $tail-module (make-instance <module> :identifier ^%tail))

(add-to-module-env $tail-module)

;;; -----------------------------------------------------------------------------------
;;;  auxilliary functions
;;; -----------------------------------------------------------------------------------

(export instance-of-p find-instances-of make-defined-sym)

(defun instance-of-p (instance class)
(subclassp (class-of instance) class))

(defun find-instances-of (zws-class environment)
(remove-if-not (lambda (obj)
                   (instance-of-p obj zws-class))
               environment))

(defun make-defined-sym (id)
; creates a <defined symbol> in package "eulisp" and adds it to the global symbol
; environment 
  (let ((sym (find-in-symbol-env id)))
    (unless sym
      (setq sym (make-instance <defined-sym>
                  :name (string id)
                  :package "eulisp"
                  :identifier id))
      (add-to-symbol-env sym))
    sym))

;;; -----------------------------------------------------------------------------------
;;; transformation of a module definition: the main function
;;; -----------------------------------------------------------------------------------

(export trans-module)

(defvar *current-module* nil)

(defun trans-module (module-def)
(let* ((name (second module-def))
       body
       (%unsigned-word-integer           ; to avoid recursive modules
        (find-in-env (?lex-env (find-module 'es::%tail))
                     'es::%unsigned-word-integer))
       (%eq                             ; to avoid recursive modules
        (find-in-env (?lex-env (find-module 'es::%tail))
                     'es::%eq))
       ($unsigned-0 (make-instance <literal-instance> 
                    :class %unsigned-word-integer
                    :value-list '(0)))
       ($unsigned-1 (make-instance <literal-instance> 
                    :class %unsigned-word-integer
                    :value-list '(1)))
       (initflag (make-instance <global-static> 
                   :identifier (list ^init name ^done)
                   :module-id ()
                   :type %unsigned-word-integer
                   :initial-value $unsigned-0)))
(dynamic-let ((*current-module* (make-instance <module> :identifier name))
              (waiting-export-directives nil))
  (setq body (trans-module-header module-def))

  (dynamic-let ((mac-env (?syntax-env (dynamic *current-module*))))
    (setq body 
         (transsyn (cons 'es::progn body)))); syntaxexpands the forms and
                                        ; simplifies syntax as embedded progn's
                                        ; and implicit progn's

  (setq body                            ; this is neccesary because of the
                                        ; progn-simplification 
        (cond ((null body) nil)         ; no expressions?
              ((and (consp body)        ; more than 1 expression?
                    (eq (first body) 'es::progn))
               (cdr body))
              (t (list body))))         ; exactly 1 expression

  (dynamic-let ((lex-env (nconc
                          (splice-lists (mapcar #'transmod body)) ;top level bindings
                          (?lex-env (dynamic *current-module*)))) ;imported bindings
                (dynamic-env (remove-if-not #'dynamic-p 
                                            (?var-list (dynamic *current-module*))))
                #|(symbol-env (?sym-list (dynamic *current-module*)))|#
                (undefined-functions ()))
    (setf (?lex-env (dynamic *current-module*)) (dynamic lex-env))

    ; now the module holds its top-level lexical environment and the object-lists
    ; are filled with the global defined objects with empty structure part 

    ;now handle the collected export-directives from the module header
    (trans-export-directives (dynamic waiting-export-directives))

    (setq body (mapcan #'transdef body)); transforms bodies of defs, handles
                                        ; exports and collects top-level forms
    ;  (make-interface-file (dynamic lex-env)
    ;                       (dynamic symbol-env))

    (push initflag (?var-list (dynamic *current-module*)))
    (setq body 
          (make-instance <if-form>
            :pred
            (make-instance <app>
              :function %eq
              :arg-list (list (make-instance <var-ref> :var initflag)
                              $unsigned-0))
            :then
            (make-instance <progn-form> 
              :form-list (append (used-modules-initialization 
                                  (?used-runtime-modules (dynamic *current-module*))) 
                                 body
                                 (list (make-instance <setq-form>
                                         :location (make-instance <var-ref> 
                                                     :var initflag)
                                         :form $unsigned-1))))
            :else
            $unsigned-1))
    
    (setf (?toplevel-forms (dynamic *current-module*))
          (make-instance <module-init-fun>
            :range-and-domain (vector %unsigned-word-integer)
            :params (make-instance <params>)
            :body body                
            :exported () 
            :identifier (module-init-function-name name)
            :module-id (?identifier (dynamic *current-module*))))
    (cl:funcall (cl:symbol-function
                 (cl:find-symbol (string 'set-signature-from-classes)
                                 "TI-SIGNATURE"))
     (?toplevel-forms (dynamic *current-module*))
     (list %unsigned-word-integer))

    ; the extension of the module list was placed here to guarantee that all
    ; modules which are needed by import or by expose are already in the module
    ; environment 
    (add-to-module-env (dynamic *current-module*))

    ; reverse the collected objects in the module such that the order of
    ; definitions in the generated code is the same as in the source
    (setf (?fun-list (dynamic *current-module*)) 
          (reverse (?fun-list (dynamic *current-module*))))
    (setf (?class-def-list (dynamic *current-module*)) 
          (reverse (?class-def-list (dynamic *current-module*))))
    (setf (?named-const-list (dynamic *current-module*)) 
          (reverse (?named-const-list (dynamic *current-module*))))
    (setf (?var-list (dynamic *current-module*)) 
          (reverse (?var-list (dynamic *current-module*))))
    (setf (?sym-list (dynamic *current-module*)) 
          (reverse (?sym-list (dynamic *current-module*))))

    (dynamic *current-module*)
    ))))

(defun module-init-function-name (module-name)
  (list ^init module-name))

(defun used-modules-initialization (modules)
  (if (null modules) nil
      (let ((initfun (?toplevel-forms (car modules))))
        (if (null initfun)
          (used-modules-initialization (cdr modules))
          (cons (make-instance <app> :function initfun :arg-list () )
                (used-modules-initialization (cdr modules)))))))

(defun splice-lists (l)
  (cond ((null l) nil)
        ((listp (car l))
         (nconc (car l) (splice-lists (cdr l))))
        ((null (cdr l)) l)
        (t (splice-lists-1 l))))

(defun splice-lists-1 (l)
  ;l has at least 2 elements andits first one isn't a list
  (cond ((null (cdr l)) 
         (if (listp (car l)) (car l) l))
        ((listp (second l))
         (setf (cdr l)
               (nconc (second l) (splice-lists (cddr l))))
         l)
        ((null (cddr l)) l)
        (t (splice-lists (cdr l))
           l)))

;;; -----------------------------------------------------------------------------------
;;; transformation of module header
;;; -----------------------------------------------------------------------------------

(defun trans-module-header (module-def)
  (if (has-old-style-module-header module-def)
    (trans-old-style-module-header module-def)
    (progn (trans-directives (third module-def))
           (cdr (cddr module-def)))))

(defun has-old-style-module-header (module-def)
  (and (>= (length module-def) 4)
       (consp (fourth module-def))
       (eq ^syntax (car (fourth module-def)))))

(defun trans-old-style-module-header (module-def)
  (info-old-style-module-header module-def)
  (trans-imports (third module-def))    ; creates the imported lexical
                                        ; environment
  (trans-old-style-syntax-imports (fourth module-def))
  (trans-old-style-local-syntax-definitions (cddr (fourth module-def)))
  (cddr (cddr module-def)))

(defun trans-directives (module-directives)
  (cond ((null module-directives) nil)
        ((null (consp module-directives))
         (error-bad-module-directive module-directives nil))
        ((null (cdr module-directives))
         (error-bad-module-directive (car module-directives) nil))
        ((null (member (first module-directives)
                       ^(import syntax expose export c-import)))
         (error-bad-module-directive (first module-directives)
                                     (second module-directives))
         (trans-directives (cddr module-directives)))
        ((null (listp (second module-directives)))
         (error-bad-module-directive (first module-directives)
                                     (second module-directives))
         (trans-directives (cddr module-directives)))
        (t
         (trans-directive (first module-directives)
                          (second module-directives))
         (trans-directives (cddr module-directives)))))

(defun trans-directive (key value)
  (cond ((eq key ^export)
         ; this must wait until all imports and all global
         ; lexicals are collected
         (dynamic-setq waiting-export-directives
                       (cons value (dynamic waiting-export-directives))))
        ((eq key ^expose)
         ;this is done using transdef because of the support of old style
         ;modules, it should replaced by a specific function and the
         ;transdef-rule should be deleted in el2lzs-rules
         (transdef (cons key value)))
        ((eq key ^import)
         (trans-imports value))
        ((eq key ^syntax)
         (trans-syntax-imports value))
        ((eq key ^c-import)
         (trans-c-imports value))
        ))

(defun trans-c-imports (file-spec-list)
  (mapc (lambda (file)
          (if (or (symbolp file)
                  (stringp file))
            (setf (?c-imports (dynamic *current-module*))
                  (cons file (?c-imports (dynamic *current-module*))))
            (error-bad-c-import-spec file)))
        file-spec-list))

(defun trans-export-directives (export-directives)
  (mapc (lambda (export-spec)
          (transdef (cons ^export export-spec)))
        export-directives))

;;; -----------------------------------------------------------------------------------
;;; analyzing import specification
;;; -----------------------------------------------------------------------------------

(export compute-runtime-interface compute-syntax-interface)

(defun compute-runtime-interface (import-specs)
  (compute-interface import-specs #'module-runtime-interface))

(defun compute-syntax-interface (import-specs)
  (compute-interface import-specs #'module-syntax-interface))

(defun trans-imports (import-specs)
  (setf (?lex-env (dynamic *current-module*))
        (append
         (compute-runtime-interface import-specs)
         (?lex-env (dynamic *current-module*)))))

(defun trans-syntax-imports (import-specs)
  (setf (?syntax-env (dynamic *current-module*))
        (append
         (compute-syntax-interface import-specs)
         (?syntax-env (dynamic *current-module*)))))

(defgeneric trans-old-style-syntax-imports (import-specs))

(defmethod trans-old-style-syntax-imports ((import-specs <null>))
  nil)

(defmethod trans-old-style-syntax-imports ((import-specs <pair>))
  (if (and (eq (first import-specs) ^syntax)
           (cdr import-specs)
           (listp (second import-specs)))
    (setf (?syntax-env (dynamic *current-module*))
          (append
           (compute-syntax-interface (second import-specs))
           (?syntax-env (dynamic *current-module*))))
    (error-bad-old-style-syntax-import import-specs)
    ))

(defmethod trans-old-style-syntax-imports (import-specs)
  (error-bad-old-style-syntax-import import-specs))




(defun compute-interface (import-specs interface-supplier)
  (delete-duplicates
   (compute-interface-without-check import-specs interface-supplier)
   :test (lambda (binding1 binding2)
           (cond ((eq binding1 binding2) ; a shortcut for the following test
                  t)
                 ((eq (?identifier binding1)
                      (?identifier binding2))
                  (unless (eq (get-lzs-object binding1)
                              (get-lzs-object binding2))
                    (error-name-clash binding1 
                                      binding2))
                  t)
                 (t nil)))))

(defun compute-interface-without-check (import-specs interface-supplier)
  (mapcan (lambda (import-spec) 
                 (compute-interface-1 import-spec interface-supplier))
               import-specs))

(defun compute-interface-1 (import-spec interface-supplier)
  (if (symbolp import-spec)            ; a module name
    (funcall interface-supplier import-spec)
    (let ((interface (compute-interface-without-check (cddr import-spec)
                                                      interface-supplier)))
      (case (car import-spec)
        (ES::except (delete-if 
                     (lambda (obj)
                       (member (?identifier obj) (second import-spec)))
                     interface))
        (ES::only (delete-if-not 
                   (lambda (obj)
                     (member (?identifier obj) (second import-spec)))
                   interface))
        (ES::rename (mapcar (lambda (obj)
                              (import-rename obj (second import-spec)))
                            interface))))))

(defmethod import-rename ((obj <named>) rename-spec)
  (let ((old-new (assoc (?identifier obj) rename-spec)))
    (if old-new 
      (make-instance <binding> 
        :identifier (second old-new)
        :refers-to obj)
      obj)))

(defmethod import-rename ((obj <binding>) rename-spec)
  (let ((old-new (assoc (?identifier obj) rename-spec)))
    (if old-new 
      (make-instance <binding> 
        :identifier (second old-new)
        :refers-to obj)
      obj)))

(defun module-runtime-interface (module-id)
  (let ((module (find-or-load-module module-id)))
    (if module
      (progn
        (pushnew module (?used-runtime-modules (dynamic *current-module*))
                 :key #'?identifier)
        (copy-list (?exports module)))
      nil)))

(defun module-syntax-interface (module-id)
  (let ((module (find-or-load-module module-id)))
    (if module
      (progn
        (pushnew module (?used-syntax-modules (dynamic *current-module*))
                 :key #'?identifier)
        (copy-list (?syntax-exports module)))
      nil)))

;;; -----------------------------------------------------------------------------------
;;; loading module files
;;; -----------------------------------------------------------------------------------

(export load-module)

(defun find-or-load-module (module-id)
(or (find-module module-id) (load-module module-id)))

(defun load-module (module-id)
(load-apply-module module-id #'trans-module))

;;; -----------------------------------------------------------------------------------
;;; installing local syntax definitions
;;; -----------------------------------------------------------------------------------

(defun trans-old-style-local-syntax-definitions (defmacro-forms)
  (dynamic-let ((mac-env (?syntax-env (dynamic *current-module*)))
                (lex-env (?lex-env (dynamic *current-module*))))
     (setf (?syntax-env (dynamic *current-module*))
           (nconc (mapcar #'transmod defmacro-forms)
                  (?syntax-env (dynamic *current-module*))))))

;;; -----------------------------------------------------------------------------------
;;; handling of annotation "exported" 
;;; -----------------------------------------------------------------------------------

(export mark-as-exported get-identifier-and-object)

(defun mark-as-exported (objects)
  (mapc (lambda (object)
            (mark-object-as-exported object))
          objects))

(defgeneric mark-object-as-exported (object))

(defmethod mark-object-as-exported ((object <global>))
  (setf (?exported object) t))

(defmethod mark-object-as-exported ((object <binding>))
  (mark-object-as-exported (finally-refered-object object)))

(defun get-identifier-and-object (object)
  (cons (?identifier object) (finally-refered-object object)))

#module-end
