;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-literals -*-
#|
-----------------------------------------------------------------------------------
TITLE: Transformation of Literals into LZS
-----------------------------------------------------------------------------------
File:    el2lzs-literals.em
Version: 1.35 (last modification on Tue Oct 19 08:58:40 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:
expand-literal for <standard-class-def> should use the slot descriptions of the
class and not explicitely an explicit slot order and explicit slot types.

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/hfried/Lisp/Apply/el2lzs-literals.em[1.0]
	Fri Mar 26 17:53:57 1993 imohr@isst save $
 transformation of %literal
 
el2lzs-literals.em[1.1] Mon Mar 29 16:58:38 1993 imohr@isst save $
 
 positional values for slot values in literal-instances
 
el2lzs-literals.em[1.2] Wed Mar 31 10:38:17 1993 imohr@isst proposed $
 literals for structures, literal expanders and expose ok
 
el2lzs-literals.em[1.3] Thu Apr  1 12:03:21 1993 imohr@isst save $
 literal expansion for special markers like UNKNOWN
 
el2lzs-literals.em[1.4] Fri Apr  2 16:00:26 1993 imohr@isst proposed $
 literal expansion for classes
 
el2lzs-literals.em[1.5] Mon Apr  5 16:24:05 1993 imohr@isst save $
 defgeneric for expand-literal placed into expand-literal.em
 to avoid cycles in the module dependency graph
 
el2lzs-literals.em[1.6] Tue Apr  6 09:15:16 1993 imohr@isst proposed $
 a more efficient solution for literal expansion of ()
 
el2lzs-literals.em[1.7] Wed Apr  7 17:06:53 1993 imohr@isst save $
 
el2lzs-literals.em[1.8] Wed Apr  7 17:53:17 1993 imohr@isst proposed $
 
el2lzs-literals.em[1.9] Thu Apr  8 15:20:44 1993 imohr@isst proposed $
 code generation for classes ok
 
el2lzs-literals.em[1.10] Mon Apr 19 15:42:50 1993 imohr@isst proposed $
 %function
 
el2lzs-literals.em[1.11] Mon Apr 19 18:59:21 1993 imohr@isst proposed $
 + other representations than pointer-to-struct
 
el2lzs-literals.em[1.12] Mon May  3 13:28:39 1993 imohr@isst proposed $
 expander for pairs changed to an eq-cache
 
el2lzs-literals.em[1.13] Wed May 12 16:34:49 1993 imohr@isst proposed $
 expansion of nested literals ok
 
el2lzs-literals.em[1.14] Fri May 21 12:46:39 1993 imohr@isst proposed $
 expansion of basic tail classes was cleaned up
 
el2lzs-literals.em[1.15] Tue May 25 16:28:04 1993 imohr@isst proposed $
 error in literal expansion for structured literals removed
 
el2lzs-literals.em[1.16] Wed Jun  2 09:11:25 1993 imohr@isst proposed $
 
el2lzs-literals.em[1.17] Tue Jun 15 08:45:20 1993 imohr@isst save $
 some more literal classes: vector, float, ratio, complex, string
 
el2lzs-literals.em[1.18] Tue Jun 15 09:07:55 1993 imohr@isst save $
 literal classes complex and ratio deactivated because they are not yet
 implemented in the EL-compatibility package
 
el2lzs-literals.em[1.19] Wed Jun 16 11:37:53 1993 imohr@isst save $
 expansion of vector literals with listed elements
 
el2lzs-literals.em[1.20] Wed Jun 16 14:15:29 1993 imohr@isst save $
 
el2lzs-literals.em[1.21] Wed Jun 16 15:16:22 1993 imohr@isst save $
 
el2lzs-literals.em[1.22] Wed Jun 16 16:03:22 1993 imohr@isst proposed $
 handling of %literal for vectors
 
el2lzs-literals.em[1.23] Wed Jul 14 15:50:50 1993 imohr@isst proposed $
 
el2lzs-literals.em[1.24] Thu Aug  5 09:31:50 1993 imohr@isst proposed $
 [Thu Jul 22 08:34:07 1993] Intention for change:
 --- no intent expressed ---literal expansion for basic classes corrected
 
el2lzs-literals.em[1.25] Fri Aug 27 17:07:27 1993 imohr@isst save $
 [Thu Aug 26 15:25:35 1993] Intention for change:
 extensions for function classes
 
el2lzs-literals.em[1.26] Wed Sep  1 18:08:04 1993 imohr@isst proposed $
 [Tue Aug 31 12:02:26 1993] Intention for change:
 static initialization of basic classes
 
el2lzs-literals.em[1.27] Tue Sep  7 17:13:56 1993 imohr@isst proposed $
 [Tue Sep  7 12:45:25 1993] Intention for change:
 implementing setter
 
el2lzs-literals.em[1.28] Wed Sep  8 16:35:29 1993 imohr@isst published $
 [Wed Sep  8 15:54:57 1993] Intention for change:
 el-map -> cl-map in list-of-vector-elements
 
el2lzs-literals.em[1.29] Wed Sep 15 16:58:46 1993 imohr@isst save $
 [Wed Sep 15 14:03:39 1993] Intention for change:
 completing generic functions
 
el2lzs-literals.em[1.30] Thu Sep 16 11:13:25 1993 imohr@isst save $
 [Thu Sep 16 11:08:10 1993] Intention for change:
 
el2lzs-literals.em[1.31] Thu Sep 16 16:41:26 1993 imohr@isst proposed $
 [Thu Sep 16 15:06:33 1993] Intention for change:
 bug in expansion of vector literals
 
el2lzs-literals.em[1.32] Tue Sep 21 14:52:04 1993 imohr@isst proposed $
 [Tue Sep 21 09:26:40 1993] Intention for change:
 classes with equal-predicate and copy-function
 ?identifier with list-value
 
el2lzs-literals.em[1.33] Thu Sep 30 16:16:37 1993 imohr@isst proposed $
 [Thu Sep 23 08:12:21 1993] Intention for change:
 + converter
 
el2lzs-literals.em[1.34] Tue Oct 12 13:03:06 1993 ukriegel@isst proposed $
 [Tue Oct 12 12:49:31 1993] Intention for change:
 comment <%struct>
 <%struct> commented
 
el2lzs-literals.em[1.35] Tue Oct 19 08:59:08 1993 hfried@isst proposed $
 [Tue Oct 19 08:56:13 1993] Intention for change:
 ausschriften
 

-----------------------------------------------------------------------------------
|#

#module-name el2lzs-literals
#module-import
(level-0-eulisp 
 apply-standard
 option-lists
; el2lzs-main
 el2lzs-rules
 expand-literal
 lzs
 accessors
 lzs-mop
 eval
 list-ext
 tail-module
 whc-classes                            ;representations and some superclasses
 (only (mapcar mapc make-instance find identity ASSOC WARN format string) 
   common-lisp))
#module-syntax-import 
(level-1-eulisp
 el2lzs-rules
 (only (push) common-lisp))
#module-syntax-definitions

(defmacro def-literal-class (literal-class class . slots)
  ;expansion-type: single, multiple
  `(progn
     (push (make-instance <literal-expansion>
             :literal-class ',(make-eulisp-symbol literal-class)
             :class ,class
             :slots (list ,@(mapcar (lambda (slot)
                                      `(cons ',(make-eulisp-symbol (car slot))
                                             ,(cdr slot)))
                                    slots)))
           *literal-expanders*)
     (defmethod expand-literal ((literal ,class))
       (expand-literal-using-desc literal 
                                  (find ,class *literal-expanders* :key #'?class)))))

#module-header-end

(export expand-literal literal-type reset-literal-expanders)

;;; -----------------------------------------------------------------------------------
;;; %literal
;;; -----------------------------------------------------------------------------------

(deftranssyn (%literal class . values)
  _whole-form_)

(deftrans (%literal class . values)
  (let ((class-def (trans class)))
    (make-literal-instance 
     class-def
     (deftrans-literal-values class-def 
       (~class-representation class-def) 
       values))))

(defgeneric deftrans-literal-values (class representation values))

(defmethod deftrans-literal-values (class-def 
                                    representation
                                    values)
  ;the default case: return the value list as it is
  ; this is used for the following representations:
  ; direct, vector, pointer-to-vector
  values)

(defmethod deftrans-literal-values
           ((class-def <standard-class-def>) 
            (representation <%pointer-to-struct>) 
            values)
  (mapcar (lambda (slot)
            (let ((entry (find-option (~slot-description-name slot) values nil)))
              (if entry (lzslit (car entry)) ;formerly: (trans (car entry))
                  ^unknown)))
          (~class-slot-descriptions class-def)))

;(defmethod deftrans-literal-values
;           ((class-def <standard-class-def>) 
;            (representation <%struct>) 
;            values)
;  (mapcar (lambda (slot)
;            (let ((entry (find-option (~slot-description-name slot) values nil)))
;              (if entry (lzslit (car entry)) ;formerly: (trans (car entry))
;                  ^unknown)))
;          (~class-slot-descriptions class-def)))

(defmethod deftrans-literal-values
           ((class-def <standard-class-def>) 
            (representation <%pointer-to-vector>) 
            values)
  (list (car values) ; the length specification
        (cond ((consp (car (cdr values)))
               (mapcar #'lzslit (car (cdr values))))
              (t (car (cdr values))))))

;;; -----------------------------------------------------------------------------------
;;; %function
;;; -----------------------------------------------------------------------------------
;;; (%function fun)
;;; usable in the same places as quote
;;; fun must be a constant binding created by defun, defgeneric, %define-function
;;; or %declare-external-function

(deftranssyn (%function function)
  _whole-form_)

(deftrans (%function function)
  (%function-literal (trans function)))

;;; -----------------------------------------------------------------------------------
;;; %define-literal-expansion
;;; -----------------------------------------------------------------------------------

(deftranssyn (%define-literal-expansion literal-class expander)
  (progn (setf (third _whole-form_)
               (transsyn (third _whole-form_)))
         _whole-form_))

;TM (transmod): not necessary, because no global lexical binding is defined

(deftransdef (%define-literal-expansion literal-class expander)
  (progn
    (add-literal-expander 
     literal-class
     (complete-function (make-instance <global-fun>)
                        (get-literal-expander-arguments literal-class)
                        expander
                        (dynamic lex-env)))
    nil))

;;; -----------------------------------------------------------------------------------
;;; Literal Expanders
;;; -----------------------------------------------------------------------------------
(deflocal *literal-expanders* nil)      ;list of literal-expansion

(defstandardclass <literal-expansion> ()
  (literal-class :initarg :reader)
  (class :initarg :reader)
  (expander :accessor :initform nil)
  (module :accessor :initarg)
  (expansions :accessor :initform nil)
  (slots :initarg :reader))

(defun get-literal-expander-arguments (literal-class)
  (let ((exp-desc (find literal-class *literal-expanders* :key #'?literal-class)))
    (if (null exp-desc)
      (warn "invalid literal class: ~A" literal-class)
      (mapcar #'car (?slots exp-desc)))))

(defun add-literal-expander (literal-class expander)
  (let ((exp-desc (find literal-class *literal-expanders* :key #'?literal-class)))
    (if (null exp-desc)
      (warn "invalid literal class: ~A" literal-class)
      (progn (setf (?expander exp-desc) expander)
             (setf (?module exp-desc) (dynamic *current-module*))))))

(defun reset-literal-expanders ()
  (mapc (lambda (exp-desc)
          (setf (?expander exp-desc) nil)
          (setf (?module exp-desc) nil)
          (setf (?expansions exp-desc) nil))
        *literal-expanders*)
  (setq expanded-empty-list ()))

;;; -----------------------------------------------------------------------------------
;;; Definitions of Literal Classes
;;; -----------------------------------------------------------------------------------

(defun list-of-vector-elements (vector)
  (cl:map 'cl:list #'identity vector))

(def-literal-class null <null>)

(def-literal-class integer <integer> 
  (value . #'identity))

(def-literal-class character <character> 
  (value . #'identity))

(def-literal-class float <float> 
  (value . #'identity))
#|
(def-literal-class ratio <ratio> 
  (nominator . #'nominator)
  (denominator . #'denominator))

(def-literal-class complex <complex> 
  (realpart . #'realpart)
  (imagpart . #'imagpart))
|#
(def-literal-class symbol <defined-sym> 
  (name . #'?name))

(def-literal-class pair <pair> 
  (car . #'car) 
  (cdr . #'cdr))

(def-literal-class string <string> 
  (elements . #'identity))

(def-literal-class vector <vector> 
  (elements . #'list-of-vector-elements))
#|
(def-literal-class array <array> 
  (elements . ???))
|#
(def-literal-class function <defined-fun>
  (argument-descriptor . #'?arg-num)
  (function-pointer . #'%function-literal)
  (setter . #'?setter)
  (name . (lambda (fun) (format nil "~A" (?identifier fun)))))

(def-literal-class generic-function <defined-generic-fun>
  (argument-descriptor . (lambda (gf)
                           (?arg-num
                            (~generic-function-discriminating-function gf))))
  (function-pointer . #'%function-literal)
  (setter . #'?setter)
  (methods . #'~generic-function-methods)
  (name . (lambda (fun) (format nil "~A" (?identifier fun))))
  (discrimination-depth . #'~generic-function-discrimination-depth))

(def-literal-class method <method-def>
  (domain . #'~method-domain)
  (function . #'~method-function)
  (function-pointer . (lambda (m)
                        (%function-literal (~method-function m))))
  (generic-function . #'~method-generic-function))

;;; classes are handled directly, because <class> & co. are defined as part of
;;; the compiler

(def-literal-class slot-description <slot-desc>
  (name . (lambda (sd) (format nil "~A" (?identifier sd))))
  (initfunction . #'~slot-description-initfunction)
  (initarg . #'~slot-description-initarg)
  (reader . #'~slot-description-slot-reader)
  (writer . #'~slot-description-slot-writer)
  )

;;; -----------------------------------------------------------------------------------
;;; expand-literal
;;; -----------------------------------------------------------------------------------
;expand-literal is defined in expand-literal.em to avoid cyclic dependencies in the
;module-dependency-graph 
;(defgeneric expand-literal (literal))

(defmethod expand-literal ((literal <literal-instance>))
  (unless (?expanded literal)
    (setf (?expanded literal) t)        ; to avoid infinite expansion loops this
                                        ; flag must be set before expanding the
                                        ; slots 
    (setf (?value-list literal)
          (expand-slot-values literal (?class literal) 
                              (?representation (?class literal)) (?value-list literal)))
    (setf (?expanded literal) t))
  literal)

(defmethod expand-literal ((literal <structured-literal>))
  (or (?expanded-literal literal)
      (progn (setf (?expanded-literal literal)
                   (expand-literal (?value literal)))
             (?expanded-literal literal))))

(defmethod expand-literal ((literal <symbol>))
  ; if a special marker like UNKNOWN was found return this
  literal)

;NOTE: More methods for expand-literal are defined by def-literal-class. These
;methods call expand-literal-using-desc.

(defmethod expand-literal (literal)
  ; The default case: no special expander defined
  (error-invalid-literal literal))

(defun error-invalid-literal (literal)
  (format t "~%!!! Invalid literal ~A (a literal class doesn't exist for this)~%" 
          literal))

(defun error-literal-expander-not-defined (literal exp-desc)
  (format t "~%!!! No literal expander defined for literal class ~A during
expansion of ~A~%"
          (?literal-class exp-desc) literal))

(defun check-exp-desc (literal exp-desc)
  (cond ((null exp-desc) 
         (error-invalid-literal literal)
         nil)
        ((null (?expander exp-desc))
         (error-literal-expander-not-defined literal exp-desc)
         nil)
        (t t)))

(defgeneric expand-literal-using-desc (literal exp-desc))

(defmethod expand-literal-using-desc (literal exp-desc)
  ; the standard mechanism for expanding literals
  ; a cache is used which guarantees that eql-equal objects have exactly one
  ; literal instance object
  (when (check-exp-desc literal exp-desc)
    (let ((entry (assoc literal (?expansions exp-desc))))
      (if entry 
        (cdr entry)
        (let ((exp (expand-literal-first-time literal exp-desc)))
          (push (cons literal exp) (?expansions exp-desc))
          exp)))))

(defun expand-literal-first-time (literal exp-desc)
  (expand-literal
   (expand-literal-first-time-incomplete literal exp-desc)))

(defun expand-literal-first-time-incomplete (literal exp-desc)
  (dynamic-let ((lex-env (?lex-env (?module exp-desc))))
                (trans
                (call (?expander exp-desc)
                      (mapcar (lambda (slot)
                                 (funcall (cdr slot) literal))
                              (?slots exp-desc))))))

(deflocal expanded-empty-list nil)

(defmethod expand-literal-using-desc ((literal <null>) exp-desc)
  ;this is an optimization for the empty list which uses a private cache - the
  ;variable expanded-empty-list - to avoid the search in the standard cache with
  ;assoc 
  (unless expanded-empty-list
    (when (check-exp-desc literal exp-desc)
      (setq expanded-empty-list
            (dynamic-let ((lex-env (?lex-env (?module exp-desc))))
                         (trans
                          (call (?expander exp-desc) nil))))
      (expand-literal expanded-empty-list)))
  expanded-empty-list)

(defmethod expand-literal-using-desc ((literal <fun>) exp-desc)
  ;this is an optimization for functions. The use of the standard cache can be
  ;avoided because the annotation expanded-literal can be used to store the
  ;expanded literal
  (or (?expanded-literal literal)
      (when (check-exp-desc literal exp-desc)
        (let ((exp (expand-literal-first-time-incomplete literal exp-desc)))
          (setf (?expanded-literal literal) exp)
          (expand-literal exp)))))

;(defmethod expand-literal-using-desc ((literal <pair>) exp-desc)
;  ; an optimization of the standard case for conses which don't look in the
;  ; cache of the expander description, because conses should be different when
;  ; appearing at different places in the application
;  (let ((expanded-literal
;         (dynamic-let ((lex-env (?lex-env (?module exp-desc))))
;            (trans
;             (call (?expander exp-desc)
;                   (list (expand-pair-component (car literal))
;                         (expand-pair-component (cdr literal))))))))
;    (setf (?expanded expanded-literal) t)
;    (push (cons literal exp) (?expansions exp-desc))
;    expanded-literal))
;
;(defgeneric expand-pair-component (literal pair-exp-desc))
;(defmethod expand-pair-component (literal pair-exp-desc)
;  (expand-literal literal))
;(defmethod expand-pair-component ((literal <pair>) pair-exp-desc)
;  (let ((expanded-literal
;         (dynamic-let ((lex-env (?lex-env (?module pair-exp-desc))))
;            (trans
;             (call (?expander pair-exp-desc)
;                   (list (expand-pair-component (car literal) pair-exp-desc)
;                         (expand-pair-component (cdr literal) pair-exp-desc)))))))
;    (setf (?expanded expanded-literal) t)
;    expanded-literal))

(defgeneric expand-slot-values (literal class representation values))

(defmethod expand-slot-values (literal (class <basic-class-def>)
                               representation values)
  values)

(defmethod expand-slot-values (literal class representation values)
  (mapcar (lambda (literal)
            (if (and (consp literal)
                     (eq (car literal) ^%literal))
              (expand-literal (trans literal))
              (expand-literal literal)))
          values))

(defmethod expand-slot-values (literal class
                               (representation <%direct>) values)
  (setq class (~slot-description-type (car (~class-slot-descriptions class))))
  (expand-slot-values literal 
                      class 
                      (~class-representation class) 
                      values))

(defmethod expand-slot-values (literal class
                               (representation <%pointer-to-vector>) values)
  (list (car values)
        (expand-vector-elements (car (cdr values)))))

(defgeneric expand-vector-elements (elements))
(defmethod expand-vector-elements ((elements <string>))
  elements)
(defmethod expand-vector-elements ((elements <null>))
  elements)
(defmethod expand-vector-elements ((elements <pair>))
  (mapcar #'expand-literal
          elements))

(defun literal-type (literal)
  (?class (expand-literal literal)))

;;; -----------------------------------------------------------------------------------
;;; Expansion for Standard Classes
;;; -----------------------------------------------------------------------------------

(defmethod expand-literal ((class <class-def>))
  (expand-class class (~class-representation class)))

(defgeneric expand-class (class representation))

(defmethod expand-class ((class <standard-class-def>) representation)
  ;slots of classes are (in this order):
  ;class-precedence-list 
  ;slot-descriptions
  ;mm-type 
  ;mm-card 
  ;gc-tracer
  ;converter
  ;allocator
  (or (?expanded-literal class)
      (progn
        (setf (?expanded-literal class)
              (make-literal-instance 
                (~class-of class)
                (list (~class-precedence-list class)
                      (~class-slot-descriptions class)
                      (?mm-type representation)
                      (?mm-card representation)
                      (?gc-tracer class)
                      (?converter class)
                      (%function-literal (?allocator class))
                      )))
        (expand-literal (?expanded-literal class))
        (?expanded-literal class))))

(defmethod expand-class ((class <tail-class-def>) representation)
  ;don't write out slot-descriptions
  (or (?expanded-literal class)
      (progn
        (setf (?expanded-literal class)
              (make-literal-instance 
                (~class-of class)
                (list (~class-precedence-list class)
                      ()
                      (?mm-type representation)
                      (?mm-card representation)
                      (?gc-tracer class)
                      (?converter class)
                      (%function-literal (?allocator class))
                      )))
        (expand-literal (?expanded-literal class))
        (?expanded-literal class))))

(defmethod expand-class ((class <abstract-class-def>) representation)
  ;don't write out slot-descriptions
  (or (?expanded-literal class)
      (progn
        (setf (?expanded-literal class)
              (make-literal-instance 
                (~class-of class)
                (list (~class-precedence-list class)
                      ()
                      (?mm-type representation)
                      (?mm-card representation)
                      (?gc-tracer class)
                      (?converter class)
                      (%function-literal (?allocator class))
                      )))
        (expand-literal (?expanded-literal class))
        (?expanded-literal class))))

(defmethod expand-class ((class <standard-class-def>) (representation <%direct>))
  (expand-class class (~class-representation
                       (~slot-description-type
                        (car (~class-slot-descriptions class))))))

#module-end
